/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.wbem.sblim.cimclient.internal.cimxml.sax.node;

import org.sentrysoftware.wbem.javax.cim.CIMObjectPath;
import org.sentrysoftware.wbem.javax.cim.CIMProperty;
import org.sentrysoftware.wbem.sblim.cimclient.internal.cimxml.LocalPathBuilder;
import org.sentrysoftware.wbem.sblim.cimclient.internal.cimxml.sax.SAXSession;
import org.sentrysoftware.wbem.sblim.cimclient.internal.cimxml.sax.node.AbstractObjectPathNode;
import org.sentrysoftware.wbem.sblim.cimclient.internal.cimxml.sax.node.InstanceNameNode;
import org.sentrysoftware.wbem.sblim.cimclient.internal.cimxml.sax.node.LocalNameSpacePathNode;
import org.sentrysoftware.wbem.sblim.cimclient.internal.cimxml.sax.node.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class LocalInstancePathNode
extends AbstractObjectPathNode {
    private boolean iHasLocalNameSpacePath;
    private String iNameSpaceStr;
    private boolean iHasInstanceName;
    private String iClassNameStr;
    private CIMProperty<?>[] iKeys;
    private CIMObjectPath iLocalPath;

    public LocalInstancePathNode() {
        super("LOCALINSTANCEPATH");
    }

    @Override
    public void init(Attributes pAttribs, SAXSession pSession) {
        this.iLocalPath = pSession.getDefLocalPath();
        this.iHasInstanceName = false;
        this.iHasLocalNameSpacePath = false;
        this.iClassNameStr = null;
        this.iNameSpaceStr = null;
        this.iKeys = null;
    }

    @Override
    public void parseData(String pData) {
    }

    @Override
    public void testChild(String pNodeNameEnum) throws SAXException {
        if (pNodeNameEnum == "LOCALNAMESPACEPATH") {
            if (this.iHasLocalNameSpacePath) {
                throw new SAXException(this.getNodeName() + " node can have only one LOCALNAMESPACEPATH child node!");
            }
        } else if (pNodeNameEnum == "INSTANCENAME") {
            if (this.iHasInstanceName) {
                throw new SAXException(this.getNodeName() + " node can have only one INSTANCENAME child node!");
            }
        } else {
            throw new SAXException(this.getNodeName() + " node cannot have " + pNodeNameEnum + " child node!");
        }
    }

    @Override
    public void childParsed(Node pChild) {
        if (pChild instanceof LocalNameSpacePathNode) {
            this.iHasLocalNameSpacePath = true;
            this.iNameSpaceStr = ((LocalNameSpacePathNode)pChild).getNameSpace();
        } else {
            this.iHasInstanceName = true;
            InstanceNameNode instNameNode = (InstanceNameNode)pChild;
            this.iClassNameStr = instNameNode.getClassName();
            this.iKeys = instNameNode.getKeys();
        }
    }

    @Override
    public void testCompletness() throws SAXException {
        if (!this.iHasLocalNameSpacePath) {
            throw new SAXException(this.getNodeName() + " node must have a LOCALNAMESPACEPATH child node!");
        }
        if (!this.iHasInstanceName) {
            throw new SAXException(this.getNodeName() + " node must have a INSTANCENAME child node!");
        }
    }

    @Override
    public CIMObjectPath getCIMObjectPath() {
        return LocalPathBuilder.build(this.iLocalPath, this.iClassNameStr, this.iNameSpaceStr, this.iKeys);
    }
}

