/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.wbem.sblim.cimclient.internal.cimxml.sax.node;

import org.sentrysoftware.wbem.javax.cim.CIMDataType;
import org.sentrysoftware.wbem.javax.cim.CIMDateTimeAbsolute;
import org.sentrysoftware.wbem.javax.cim.CIMDateTimeInterval;
import org.sentrysoftware.wbem.javax.cim.UnsignedInteger64;
import org.sentrysoftware.wbem.sblim.cimclient.internal.cimxml.sax.CIMObjectFactory;
import org.sentrysoftware.wbem.sblim.cimclient.internal.cimxml.sax.SAXSession;
import org.sentrysoftware.wbem.sblim.cimclient.internal.cimxml.sax.node.AbstractScalarValueNode;
import org.sentrysoftware.wbem.sblim.cimclient.internal.cimxml.sax.node.Node;
import org.sentrysoftware.wbem.sblim.cimclient.internal.util.Util;
import org.sentrysoftware.wbem.sblim.cimclient.internal.util.WBEMConfiguration;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class KeyValueNode
extends AbstractScalarValueNode {
    private CIMDataType iType;
    private String iValueTypeStr;
    private Object iValue;

    public KeyValueNode() {
        super("KEYVALUE");
    }

    @Override
    public void init(Attributes pAttribs, SAXSession pSession) throws SAXException {
        this.iType = KeyValueNode.getCIMType(pAttribs, true);
        this.iValue = null;
        if (this.iType != null) {
            if (this.iType.isArray()) {
                throw new SAXException("KEYVALUE node cannot be array typed!");
            }
            return;
        }
        this.iValueTypeStr = pAttribs.getValue("VALUETYPE");
        if (this.iValueTypeStr == null) {
            this.iValueTypeStr = "string";
        }
    }

    @Override
    public void parseData(String pData) throws SAXException {
        if (this.iType == null) {
            this.setTypeAndValue(pData);
        } else {
            this.iValue = CIMObjectFactory.getObject(this.iType, pData);
        }
    }

    @Override
    public void testChild(String pNodeNameEnum) throws SAXException {
        throw new SAXException("KEYVALUE node cannot have any child nodes!");
    }

    @Override
    public void childParsed(Node pChild) {
    }

    @Override
    public void testCompletness() {
    }

    @Override
    public Object getValue() {
        return this.iValue == null ? "" : this.iValue;
    }

    @Override
    public CIMDataType getType() {
        return this.iType;
    }

    private void setTypeAndValue(String pValue) throws SAXException {
        if (this.iType != null) {
            return;
        }
        if (this.iValueTypeStr.equals("numeric")) {
            if (!(this.setUInt64(pValue) || this.setSInt64(pValue) || this.setReal64(pValue))) {
                throw new SAXException("Unparseable \"number\" value in " + this.getNodeName() + " node: " + pValue + "!");
            }
        } else if (this.iValueTypeStr.equals("string")) {
            if (!this.setDTAbsolute(pValue) && !this.setDTInterval(pValue)) {
                this.iValue = pValue;
                this.iType = CIMDataType.STRING_T;
            }
        } else if (this.iValueTypeStr.equals("boolean")) {
            if (!this.setBoolean(pValue)) {
                throw new SAXException("Unparseable \"boolean\" value in " + this.getNodeName() + " node: " + pValue + "!");
            }
        } else {
            throw new SAXException("KEYVALUE node's VALUETYPE attribute must be string, boolean or numeric! " + pValue + " is not allowed!");
        }
    }

    private boolean setUInt64(String pValue) {
        try {
            this.iValue = new UnsignedInteger64(pValue);
        }
        catch (NumberFormatException e) {
            return false;
        }
        this.iType = CIMDataType.UINT64_T;
        return true;
    }

    private boolean setSInt64(String pValue) {
        try {
            this.iValue = new Long(pValue);
        }
        catch (NumberFormatException e) {
            return false;
        }
        this.iType = CIMDataType.SINT64_T;
        return true;
    }

    private boolean setReal64(String pValue) {
        try {
            if (WBEMConfiguration.getGlobalConfiguration().verifyJavaLangDoubleStrings() && Util.isBadDoubleString(pValue)) {
                return false;
            }
            this.iValue = new Double(pValue);
        }
        catch (NumberFormatException e) {
            return false;
        }
        this.iType = CIMDataType.REAL64_T;
        return true;
    }

    private boolean setBoolean(String pValue) {
        this.iValue = Boolean.valueOf(pValue);
        this.iType = CIMDataType.BOOLEAN_T;
        return true;
    }

    private boolean setDTAbsolute(String pValue) {
        try {
            this.iValue = new CIMDateTimeAbsolute(pValue);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        this.iType = CIMDataType.DATETIME_T;
        return true;
    }

    private boolean setDTInterval(String pValue) {
        try {
            this.iValue = new CIMDateTimeInterval(pValue);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        this.iType = CIMDataType.DATETIME_T;
        return true;
    }
}

