/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.wbem.sblim.cimclient.internal.cimxml.sax.node;

import org.sentrysoftware.wbem.sblim.cimclient.internal.cimxml.sax.SAXSession;
import org.sentrysoftware.wbem.sblim.cimclient.internal.cimxml.sax.node.MessageNode;
import org.sentrysoftware.wbem.sblim.cimclient.internal.cimxml.sax.node.Node;
import org.sentrysoftware.wbem.sblim.cimclient.internal.cimxml.sax.node.NonVolatileIf;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class CIMNode
extends Node
implements NonVolatileIf {
    private Node iContent;
    private String iCimVersion;
    private String iDtdVersion;

    public CIMNode() {
        super("CIM");
    }

    @Override
    public void addChild(Node pChild) {
        this.iContent = pChild;
    }

    @Override
    public void init(Attributes pAttribs, SAXSession pSession) throws SAXException {
        this.iCimVersion = pAttribs.getValue("CIMVERSION");
        if (this.iCimVersion == null) {
            throw new SAXException("CIMVERSION attribute is mandatory for " + this.getNodeName() + " node!");
        }
        this.iDtdVersion = pAttribs.getValue("DTDVERSION");
        if (this.iDtdVersion == null) {
            throw new SAXException("DTDVERSION attribute is mandatory for " + this.getNodeName() + " node!");
        }
        this.iContent = null;
    }

    @Override
    public void parseData(String pData) {
    }

    @Override
    public void testChild(String pNodeNameEnum) throws SAXException {
        if (this.iContent != null) {
            String msg = "CIM node also has a " + this.iContent.getNodeName() + " child node!";
            throw new SAXException(msg);
        }
        if (pNodeNameEnum == "MESSAGE") {
            return;
        }
        String msg = pNodeNameEnum == "DECLARATION" ? "DECLARATION child node not supported by CIM node!" : pNodeNameEnum + " cannot be a child node of CIM node!";
        throw new SAXException(msg);
    }

    @Override
    public void testCompletness() throws SAXException {
        if (this.iContent == null) {
            throw new SAXException("CIM node must have a MESSAGE or a DECLARATION child!");
        }
    }

    @Override
    public void childParsed(Node pChild) {
    }

    public String getCimVersion() {
        return this.iCimVersion;
    }

    public String getDtdVersion() {
        return this.iDtdVersion;
    }

    public MessageNode getMessageNode() {
        return this.iContent instanceof MessageNode ? (MessageNode)this.iContent : null;
    }
}

