/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.wbem.sblim.cimclient.internal.cimxml.sax;

import java.util.ArrayList;
import java.util.logging.Level;
import org.sentrysoftware.wbem.javax.cim.CIMObjectPath;
import org.sentrysoftware.wbem.sblim.cimclient.internal.cimxml.sax.NodeFactory;
import org.sentrysoftware.wbem.sblim.cimclient.internal.cimxml.sax.NodePool;
import org.sentrysoftware.wbem.sblim.cimclient.internal.cimxml.sax.SAXSession;
import org.sentrysoftware.wbem.sblim.cimclient.internal.cimxml.sax.node.CIMNode;
import org.sentrysoftware.wbem.sblim.cimclient.internal.cimxml.sax.node.Node;
import org.sentrysoftware.wbem.sblim.cimclient.internal.cimxml.sax.node.NonVolatileIf;
import org.sentrysoftware.wbem.sblim.cimclient.internal.logging.LogAndTraceBroker;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLDefaultHandlerImpl
extends DefaultHandler {
    private Node iRootNode;
    private NodeStack iNodeStack = new NodeStack();
    private NodePool iNodePool = new NodePool();
    private StringBuffer iStrBuf;
    private SAXSession iSession;
    private boolean iAnyRoot;

    public XMLDefaultHandlerImpl(SAXSession pSession, boolean pAnyRoot) {
        this.iSession = pSession;
        this.iAnyRoot = pAnyRoot;
    }

    public XMLDefaultHandlerImpl(CIMObjectPath pLocalPath, boolean pAnyRoot) {
        this(new SAXSession(pLocalPath), pAnyRoot);
    }

    public XMLDefaultHandlerImpl(CIMObjectPath pLocalPath) {
        this(pLocalPath, false);
    }

    public XMLDefaultHandlerImpl() {
        this((CIMObjectPath)null, false);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        Node node;
        this.iStrBuf = null;
        String nodeNameEnum = NodeFactory.getEnum(qName);
        if (nodeNameEnum == null) {
            LogAndTraceBroker.getBroker().trace(Level.FINEST, "Ignoring unrecognized starting CIM-XML element found during parsing: " + qName);
            return;
        }
        Node parentNode = this.getPeekNode();
        if (parentNode == null && !this.iAnyRoot && nodeNameEnum != "CIM") {
            throw new SAXException("First node of CIM-XML document must be CIM! " + nodeNameEnum + " is invalid!");
        }
        if (parentNode != null) {
            parentNode.testChild(nodeNameEnum);
        }
        if ((node = this.iNodePool.getNode(nodeNameEnum)) == null) {
            node = NodeFactory.getNodeInstance(nodeNameEnum);
        }
        if (parentNode != null) {
            if (parentNode instanceof NonVolatileIf) {
                ((NonVolatileIf)((Object)parentNode)).addChild(node);
            }
        } else {
            this.iRootNode = node;
        }
        this.iNodeStack.push(node);
        node.init(attributes, this.iSession);
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        String str = new String(ch, start, length);
        if (this.iStrBuf == null) {
            this.iStrBuf = new StringBuffer(str);
        } else {
            this.iStrBuf.append(str);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        String nodeNameEnum = NodeFactory.getEnum(qName);
        if (nodeNameEnum == null) {
            LogAndTraceBroker.getBroker().trace(Level.FINEST, "Ignoring unrecognized ending CIM-XML element found during parsing: " + qName);
            return;
        }
        Node peekNode = this.iNodeStack.pop();
        try {
            if (this.iStrBuf != null) {
                peekNode.parseData(this.iStrBuf.toString());
                this.iStrBuf = null;
            }
            peekNode.testCompletness();
            Node parentNode = this.iNodeStack.peek();
            if (parentNode != null) {
                parentNode.childParsed(peekNode);
            }
        }
        finally {
            peekNode.setCompleted();
            if (!(peekNode instanceof NonVolatileIf)) {
                this.iNodePool.addNode(peekNode);
            }
        }
    }

    @Override
    public void endDocument() {
        String msg = "hits   : " + this.getNodePoolHits() + "\nmisses : " + this.getNodePoolMisses();
        LogAndTraceBroker.getBroker().trace(Level.FINE, msg);
    }

    public CIMNode getCIMNode() {
        return this.iRootNode instanceof CIMNode ? (CIMNode)this.iRootNode : null;
    }

    public Node getRootNode() {
        return this.iRootNode;
    }

    public int getNodePoolHits() {
        return this.iNodePool.getHitCnt();
    }

    public int getNodePoolMisses() {
        return this.iNodePool.getMissCnt();
    }

    private Node getPeekNode() {
        return this.iNodeStack.peek();
    }

    static class NodeStack {
        private ArrayList<Node> iAL = new ArrayList();

        NodeStack() {
        }

        public void push(Node pNode) {
            this.iAL.add(pNode);
        }

        public Node pop() {
            if (this.iAL.size() == 0) {
                return null;
            }
            return this.iAL.remove(this.iAL.size() - 1);
        }

        public Node peek() {
            if (this.iAL.size() == 0) {
                return null;
            }
            return this.iAL.get(this.iAL.size() - 1);
        }
    }
}

