/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.wbem.client;

import java.net.URL;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.sentrysoftware.wbem.client.Utils;
import org.sentrysoftware.wbem.client.WbemClient;
import org.sentrysoftware.wbem.client.WbemQueryResult;
import org.sentrysoftware.wbem.client.WqlQuery;
import org.sentrysoftware.wbem.client.exceptions.WqlQuerySyntaxException;
import org.sentrysoftware.wbem.javax.wbem.WBEMException;

public class WbemExecutor {
    private WbemExecutor() {
    }

    public static WbemQueryResult executeWql(URL url, String namespace, String username, char[] password, String query, int timeout, String arraySeparator) throws WqlQuerySyntaxException, WBEMException, TimeoutException, InterruptedException {
        return WbemExecutor.executeMethod(url, namespace, username, password, query, null, timeout, arraySeparator);
    }

    public static WbemQueryResult getAssociators(URL url, String username, char[] password, String query, String objectPathAssociators, int timeout, String arraySeparator) throws WqlQuerySyntaxException, WBEMException, TimeoutException, InterruptedException {
        return WbemExecutor.executeMethod(url, null, username, password, query, objectPathAssociators, timeout, arraySeparator);
    }

    private static WbemQueryResult executeMethod(URL url, String namespace, String username, char[] password, String query, String objectPathAssociators, int timeout, String arraySeparator) throws InterruptedException, TimeoutException, WBEMException, WqlQuerySyntaxException {
        Utils.checkNonNull(url, "url");
        Utils.checkNonNull(username, "username");
        Utils.checkNonNull(password, "password");
        WqlQuery wqlQuery = WqlQuery.parseQuery(query);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<WbemQueryResult> future = executor.submit(() -> {
            try (WbemClient matsyaWbemClient = new WbemClient();){
                matsyaWbemClient.connect(url, username, password, timeout);
                WbemQueryResult wbemQueryResult = objectPathAssociators == null ? matsyaWbemClient.executeWql(wqlQuery, namespace, arraySeparator) : matsyaWbemClient.getAssociators(wqlQuery, objectPathAssociators, arraySeparator);
                return wbemQueryResult;
            }
        });
        try {
            WbemQueryResult wbemQueryResult = future.get(timeout, TimeUnit.MILLISECONDS);
            return wbemQueryResult;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw e;
        }
        catch (TimeoutException e) {
            future.cancel(true);
            throw e;
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof WBEMException) {
                throw (WBEMException)e.getCause();
            }
            throw (RuntimeException)e.getCause();
        }
        finally {
            executor.shutdownNow();
        }
    }
}

