/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.telemetry;

import io.opentelemetry.instrumentation.annotations.WithSpan;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.common.helpers.JsonHelper;
import org.sentrysoftware.metricshub.engine.common.helpers.KnownMonitorType;
import org.sentrysoftware.metricshub.engine.configuration.HostConfiguration;
import org.sentrysoftware.metricshub.engine.configuration.IWinConfiguration;
import org.sentrysoftware.metricshub.engine.connector.model.ConnectorStore;
import org.sentrysoftware.metricshub.engine.strategy.ContextExecutor;
import org.sentrysoftware.metricshub.engine.strategy.IStrategy;
import org.sentrysoftware.metricshub.engine.telemetry.HostProperties;
import org.sentrysoftware.metricshub.engine.telemetry.Monitor;
import org.sentrysoftware.metricshub.engine.telemetry.MonitorsVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TelemetryManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TelemetryManager.class);
    private Map<String, Map<String, Monitor>> monitors;
    private HostProperties hostProperties;
    private HostConfiguration hostConfiguration;
    private ConnectorStore connectorStore;
    private Long strategyTime;

    @WithSpan
    public synchronized void run(IStrategy ... strategies) {
        String hostname = this.hostConfiguration.getHostname();
        log.trace("Hostname {} - Engine called for thread {}.", (Object)hostname, (Object)Thread.currentThread().getName());
        for (IStrategy strategy : strategies) {
            String strategyType = strategy.getClass().getSimpleName();
            log.trace("Hostname {} - Calling strategy {}.", (Object)hostname, (Object)strategyType);
            this.runStrategy(strategy);
            log.info("Hostname {} - End of strategy {}.", (Object)hostname, (Object)strategyType);
            if (!log.isDebugEnabled()) continue;
            log.debug("Hostname {} - >>> {} >>>\n{}", new Object[]{hostname, strategy.getClass().getSimpleName(), this.toJson()});
        }
    }

    void runStrategy(IStrategy strategy) {
        String hostname = this.hostConfiguration.getHostname();
        this.strategyTime = strategy.getStrategyTime();
        try {
            new ContextExecutor(strategy).execute();
        }
        catch (ExecutionException e) {
            log.error("Hostname {} - {} operation failed: {}: {}.", new Object[]{hostname, strategy.getClass().getSimpleName(), e.getClass().getSimpleName(), e.getMessage()});
            log.debug("Hostname {} - Operation failed with ExecutionException.", (Object)hostname, (Object)e);
        }
        catch (TimeoutException e) {
            log.error("Hostname {} - {} operation timed out.", (Object)hostname, (Object)strategy.getClass().getSimpleName());
            log.debug("Hostname {} - Operation failed with TimeoutException: ", (Object)hostname, (Object)e);
        }
        catch (InterruptedException e) {
            log.error("Hostname {} - {} operation interrupted.", (Object)hostname, (Object)strategy.getClass().getSimpleName());
            log.debug("Hostname {} - Operation failed with InterruptedException: ", (Object)hostname, (Object)e);
            Thread.currentThread().interrupt();
        }
        catch (Throwable e) {
            log.error("Hostname {} - {} operation failed with {}.", new Object[]{hostname, strategy.getClass().getSimpleName(), e.getClass().getSimpleName()});
            log.debug("Hostname {} - Operation failed with exception: ", (Object)hostname, (Object)e);
        }
    }

    public String toJson() {
        MonitorsVo hostMonitoringVo = this.getVo();
        return JsonHelper.serialize(hostMonitoringVo);
    }

    public MonitorsVo getVo() {
        MonitorsVo monitorsVo = new MonitorsVo();
        ArrayList<String> monitorTypes = new ArrayList<String>(this.monitors.keySet());
        monitorTypes.stream().sorted().filter(monitorType -> {
            Map<String, Monitor> monitorsMap = this.monitors.get(monitorType);
            return monitorsMap != null && monitorsMap.values() != null;
        }).forEach(monitorType -> {
            ArrayList<Monitor> monitorList = new ArrayList<Monitor>(this.monitors.get(monitorType).values());
            Collections.sort(monitorList, Comparator.comparing(Monitor::getId));
            monitorsVo.addAll(monitorList);
        });
        return monitorsVo;
    }

    public IWinConfiguration getWinConfiguration() {
        return this.hostConfiguration.getWinConfiguration();
    }

    public Monitor findMonitorByTypeAndId(String type, String id) {
        Map<String, Monitor> findMonitorByTypeResult = this.findMonitorsByType(type);
        if (findMonitorByTypeResult != null) {
            return this.findMonitorById(id, findMonitorByTypeResult);
        }
        return null;
    }

    public Monitor findMonitorById(String id, Map<String, Monitor> monitorsMap) {
        return monitorsMap.get(id);
    }

    public Map<String, Monitor> findMonitorsByType(String type) {
        return this.getMonitors() == null ? null : this.getMonitors().get(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Monitor addNewMonitor(@NonNull Monitor monitor, @NonNull String monitorType, @NonNull String id) {
        if (monitor == null) {
            throw new IllegalArgumentException("monitor is marked non-null but is null");
        }
        if (monitorType == null) {
            throw new IllegalArgumentException("monitorType is marked non-null but is null");
        }
        if (id == null) {
            throw new IllegalArgumentException("id is marked non-null but is null");
        }
        Map<String, Map<String, Monitor>> map = this.monitors;
        synchronized (map) {
            this.monitors.computeIfAbsent(monitorType, t -> new HashMap()).put(id, monitor);
            return monitor;
        }
    }

    public Monitor getEndpointHostMonitor() {
        Map<String, Monitor> hostMonitors = this.findMonitorsByType(KnownMonitorType.HOST.getKey());
        if (hostMonitors == null) {
            return null;
        }
        return hostMonitors.values().stream().filter(Monitor::isEndpoint).findFirst().orElse(null);
    }

    public String getHostname() {
        return this.hostConfiguration.getHostname();
    }

    public Monitor findParentMonitor(Monitor monitor) {
        Optional<Monitor> parentMonitor;
        Optional<Map<String, Monitor>> sameTypeMonitors;
        String hwParentId = monitor.getAttribute("hw.parent.id");
        String hwParentType = monitor.getAttribute("hw.parent.type");
        if (hwParentType != null && hwParentId != null && (sameTypeMonitors = Optional.ofNullable(this.findMonitorsByType(hwParentType))).isPresent() && (parentMonitor = sameTypeMonitors.get().entrySet().stream().filter(entry -> hwParentId.equals(((Monitor)entry.getValue()).getAttribute("id"))).map(Map.Entry::getValue).findFirst()).isPresent()) {
            return parentMonitor.get();
        }
        log.warn("Monitor {} does not have a parent on Host {}", (Object)monitor.getId(), (Object)this.getHostname());
        return null;
    }

    public Monitor findMonitorById(String monitorId) {
        return this.getMonitors().values().stream().map(monitorsMap -> (Monitor)monitorsMap.get(monitorId)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public boolean isConnectorStatusOk(Monitor currentMonitor) {
        if (currentMonitor.isEndpointHost()) {
            return true;
        }
        String connectorId = currentMonitor.getAttribute("connector_id");
        return null != connectorId && this.hostProperties.getConnectorNamespace(connectorId).isStatusOk();
    }

    @Generated
    private static Map<String, Map<String, Monitor>> $default$monitors() {
        return new HashMap<String, Map<String, Monitor>>();
    }

    @Generated
    private static HostProperties $default$hostProperties() {
        return new HostProperties();
    }

    @Generated
    public static TelemetryManagerBuilder builder() {
        return new TelemetryManagerBuilder();
    }

    @Generated
    public Map<String, Map<String, Monitor>> getMonitors() {
        return this.monitors;
    }

    @Generated
    public HostProperties getHostProperties() {
        return this.hostProperties;
    }

    @Generated
    public HostConfiguration getHostConfiguration() {
        return this.hostConfiguration;
    }

    @Generated
    public ConnectorStore getConnectorStore() {
        return this.connectorStore;
    }

    @Generated
    public Long getStrategyTime() {
        return this.strategyTime;
    }

    @Generated
    public void setMonitors(Map<String, Map<String, Monitor>> monitors) {
        this.monitors = monitors;
    }

    @Generated
    public void setHostProperties(HostProperties hostProperties) {
        this.hostProperties = hostProperties;
    }

    @Generated
    public void setHostConfiguration(HostConfiguration hostConfiguration) {
        this.hostConfiguration = hostConfiguration;
    }

    @Generated
    public void setConnectorStore(ConnectorStore connectorStore) {
        this.connectorStore = connectorStore;
    }

    @Generated
    public void setStrategyTime(Long strategyTime) {
        this.strategyTime = strategyTime;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TelemetryManager)) {
            return false;
        }
        TelemetryManager other = (TelemetryManager)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$strategyTime = this.getStrategyTime();
        Long other$strategyTime = other.getStrategyTime();
        if (this$strategyTime == null ? other$strategyTime != null : !((Object)this$strategyTime).equals(other$strategyTime)) {
            return false;
        }
        Map<String, Map<String, Monitor>> this$monitors = this.getMonitors();
        Map<String, Map<String, Monitor>> other$monitors = other.getMonitors();
        if (this$monitors == null ? other$monitors != null : !((Object)this$monitors).equals(other$monitors)) {
            return false;
        }
        HostProperties this$hostProperties = this.getHostProperties();
        HostProperties other$hostProperties = other.getHostProperties();
        if (this$hostProperties == null ? other$hostProperties != null : !((Object)this$hostProperties).equals(other$hostProperties)) {
            return false;
        }
        HostConfiguration this$hostConfiguration = this.getHostConfiguration();
        HostConfiguration other$hostConfiguration = other.getHostConfiguration();
        if (this$hostConfiguration == null ? other$hostConfiguration != null : !((Object)this$hostConfiguration).equals(other$hostConfiguration)) {
            return false;
        }
        ConnectorStore this$connectorStore = this.getConnectorStore();
        ConnectorStore other$connectorStore = other.getConnectorStore();
        return !(this$connectorStore == null ? other$connectorStore != null : !this$connectorStore.equals(other$connectorStore));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TelemetryManager;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $strategyTime = this.getStrategyTime();
        result = result * 59 + ($strategyTime == null ? 43 : ((Object)$strategyTime).hashCode());
        Map<String, Map<String, Monitor>> $monitors = this.getMonitors();
        result = result * 59 + ($monitors == null ? 43 : ((Object)$monitors).hashCode());
        HostProperties $hostProperties = this.getHostProperties();
        result = result * 59 + ($hostProperties == null ? 43 : ((Object)$hostProperties).hashCode());
        HostConfiguration $hostConfiguration = this.getHostConfiguration();
        result = result * 59 + ($hostConfiguration == null ? 43 : ((Object)$hostConfiguration).hashCode());
        ConnectorStore $connectorStore = this.getConnectorStore();
        result = result * 59 + ($connectorStore == null ? 43 : $connectorStore.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TelemetryManager(monitors=" + String.valueOf(this.getMonitors()) + ", hostProperties=" + String.valueOf(this.getHostProperties()) + ", hostConfiguration=" + String.valueOf(this.getHostConfiguration()) + ", connectorStore=" + String.valueOf(this.getConnectorStore()) + ", strategyTime=" + this.getStrategyTime() + ")";
    }

    @Generated
    public TelemetryManager(Map<String, Map<String, Monitor>> monitors, HostProperties hostProperties, HostConfiguration hostConfiguration, ConnectorStore connectorStore, Long strategyTime) {
        this.monitors = monitors;
        this.hostProperties = hostProperties;
        this.hostConfiguration = hostConfiguration;
        this.connectorStore = connectorStore;
        this.strategyTime = strategyTime;
    }

    @Generated
    public TelemetryManager() {
        this.monitors = TelemetryManager.$default$monitors();
        this.hostProperties = TelemetryManager.$default$hostProperties();
    }

    @Generated
    public static class TelemetryManagerBuilder {
        @Generated
        private boolean monitors$set;
        @Generated
        private Map<String, Map<String, Monitor>> monitors$value;
        @Generated
        private boolean hostProperties$set;
        @Generated
        private HostProperties hostProperties$value;
        @Generated
        private HostConfiguration hostConfiguration;
        @Generated
        private ConnectorStore connectorStore;
        @Generated
        private Long strategyTime;

        @Generated
        TelemetryManagerBuilder() {
        }

        @Generated
        public TelemetryManagerBuilder monitors(Map<String, Map<String, Monitor>> monitors) {
            this.monitors$value = monitors;
            this.monitors$set = true;
            return this;
        }

        @Generated
        public TelemetryManagerBuilder hostProperties(HostProperties hostProperties) {
            this.hostProperties$value = hostProperties;
            this.hostProperties$set = true;
            return this;
        }

        @Generated
        public TelemetryManagerBuilder hostConfiguration(HostConfiguration hostConfiguration) {
            this.hostConfiguration = hostConfiguration;
            return this;
        }

        @Generated
        public TelemetryManagerBuilder connectorStore(ConnectorStore connectorStore) {
            this.connectorStore = connectorStore;
            return this;
        }

        @Generated
        public TelemetryManagerBuilder strategyTime(Long strategyTime) {
            this.strategyTime = strategyTime;
            return this;
        }

        @Generated
        public TelemetryManager build() {
            Map<String, Map<String, Monitor>> monitors$value = this.monitors$value;
            if (!this.monitors$set) {
                monitors$value = TelemetryManager.$default$monitors();
            }
            HostProperties hostProperties$value = this.hostProperties$value;
            if (!this.hostProperties$set) {
                hostProperties$value = TelemetryManager.$default$hostProperties();
            }
            return new TelemetryManager(monitors$value, hostProperties$value, this.hostConfiguration, this.connectorStore, this.strategyTime);
        }

        @Generated
        public String toString() {
            return "TelemetryManager.TelemetryManagerBuilder(monitors$value=" + String.valueOf(this.monitors$value) + ", hostProperties$value=" + String.valueOf(this.hostProperties$value) + ", hostConfiguration=" + String.valueOf(this.hostConfiguration) + ", connectorStore=" + String.valueOf(this.connectorStore) + ", strategyTime=" + this.strategyTime + ")";
        }
    }
}

