/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.strategy.utils;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.telemetry.TelemetryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForceSerializationHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ForceSerializationHelper.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T forceSerialization(@NonNull Supplier<T> executable, @NonNull TelemetryManager telemetryManager, @NonNull String connectorId, Object objToProcess, @NonNull String description, @NonNull T defaultValue) {
        boolean isLockAcquired;
        if (executable == null) {
            throw new IllegalArgumentException("executable is marked non-null but is null");
        }
        if (telemetryManager == null) {
            throw new IllegalArgumentException("telemetryManager is marked non-null but is null");
        }
        if (connectorId == null) {
            throw new IllegalArgumentException("connectorId is marked non-null but is null");
        }
        if (description == null) {
            throw new IllegalArgumentException("description is marked non-null but is null");
        }
        if (defaultValue == null) {
            throw new IllegalArgumentException("defaultValue is marked non-null but is null");
        }
        ReentrantLock forceSerializationLock = ForceSerializationHelper.getForceSerializationLock(telemetryManager, connectorId);
        String hostname = telemetryManager.getHostConfiguration().getHostname();
        try {
            isLockAcquired = forceSerializationLock.tryLock(120L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            log.error("Hostname {} - Interrupted exception detected when trying to acquire the force serialization lock to process {} {}. Connector: {}.", new Object[]{hostname, description, objToProcess, connectorId});
            log.debug("Hostname {} - Exception: ", (Object)hostname, (Object)e);
            Thread.currentThread().interrupt();
            return defaultValue;
        }
        if (isLockAcquired) {
            try {
                T t = executable.get();
                return t;
            }
            finally {
                forceSerializationLock.unlock();
            }
        }
        log.error("Hostname {} - Could not acquire the force serialization lock to process {} {}. Connector: {}.", new Object[]{hostname, description, objToProcess, connectorId});
        return defaultValue;
    }

    static ReentrantLock getForceSerializationLock(TelemetryManager telemetryManager, String connectorId) {
        return telemetryManager.getHostProperties().getConnectorNamespace(connectorId).getForceSerializationLock();
    }

    @Generated
    private ForceSerializationHelper() {
    }
}

