/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.strategy.source;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.common.helpers.MetricsHubConstants;
import org.sentrysoftware.metricshub.engine.connector.model.common.EntryConcatMethod;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.CopySource;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.HttpSource;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.IpmiSource;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.OsCommandSource;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.SnmpGetSource;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.SnmpTableSource;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.Source;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.StaticSource;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.TableJoinSource;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.TableUnionSource;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.WbemSource;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.WmiSource;
import org.sentrysoftware.metricshub.engine.strategy.source.ISourceProcessor;
import org.sentrysoftware.metricshub.engine.strategy.source.SourceTable;
import org.sentrysoftware.metricshub.engine.strategy.utils.PslUtils;
import org.sentrysoftware.metricshub.engine.telemetry.TelemetryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceUpdaterProcessor
implements ISourceProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SourceUpdaterProcessor.class);
    private static final Pattern COLUMN_REF_PATTERN = Pattern.compile("(?<!\\$)\\$([1-9]\\d*)", 2);
    private static final Pattern MONO_INSTANCE_REPLACEMENT_PATTERN = Pattern.compile("\\$\\{attribute::(\\w+)\\}", 2);
    private ISourceProcessor sourceProcessor;
    private TelemetryManager telemetryManager;
    private String connectorId;
    private Map<String, String> attributes;

    @Override
    public SourceTable process(HttpSource httpSource) {
        HttpSource copy = httpSource.copy();
        copy.setAuthenticationToken(this.extractHttpTokenFromSource(copy.getKey(), copy.getAuthenticationToken(), "authenticationToken"));
        return this.processSource(copy);
    }

    @Override
    public SourceTable process(CopySource copySource) {
        return this.processSource(copySource.copy());
    }

    @Override
    public SourceTable process(IpmiSource ipmiSource) {
        return this.processSource(ipmiSource.copy());
    }

    @Override
    public SourceTable process(OsCommandSource osCommandSource) {
        return this.processSource(osCommandSource.copy());
    }

    @Override
    public SourceTable process(SnmpGetSource snmpGetSource) {
        return this.processSource(snmpGetSource.copy());
    }

    @Override
    public SourceTable process(SnmpTableSource snmpTableSource) {
        return this.processSource(snmpTableSource.copy());
    }

    @Override
    public SourceTable process(StaticSource staticSource) {
        return this.processSource(staticSource.copy());
    }

    @Override
    public SourceTable process(TableJoinSource tableJoinSource) {
        return this.processSource(tableJoinSource.copy());
    }

    @Override
    public SourceTable process(TableUnionSource tableUnionSource) {
        return this.processSource(tableUnionSource.copy());
    }

    @Override
    public SourceTable process(WbemSource wbemSource) {
        return this.processSource(wbemSource.copy());
    }

    @Override
    public SourceTable process(WmiSource wmiSource) {
        return this.processSource(wmiSource.copy());
    }

    private SourceTable processSource(Source copy) {
        if (copy.isExecuteForEachEntryOf()) {
            return this.runExecuteForEachEntryOf(copy);
        }
        copy.update(value -> SourceUpdaterProcessor.replaceAttributeReferences(value, this.attributes));
        copy.update(value -> this.replaceSourceReference((String)value, copy));
        copy.update(value -> value == null ? value : value.replace("$$", "$"));
        return copy.accept(this.sourceProcessor);
    }

    public String extractHttpTokenFromSource(String originalSourceKey, String foreignSourceKey, String fieldLabel) {
        if (foreignSourceKey == null) {
            return null;
        }
        if (foreignSourceKey.isEmpty()) {
            return "";
        }
        Optional<SourceTable> maybeSourceTable = SourceTable.lookupSourceTable(foreignSourceKey, this.connectorId, this.telemetryManager);
        String hostname = this.telemetryManager.getHostConfiguration().getHostname();
        if (maybeSourceTable.isEmpty()) {
            log.error("Hostname {} - Could not extract the foreign source table identified by {} and defined in original source {} to set the {} field.", new Object[]{hostname, foreignSourceKey, originalSourceKey, fieldLabel});
            return null;
        }
        SourceTable sourceTable = maybeSourceTable.get();
        List<List<String>> table = sourceTable.getTable();
        String value = null;
        if (table != null && !table.isEmpty()) {
            log.debug("Hostname {} - Get {} defined in source {} from list table.", new Object[]{hostname, fieldLabel, foreignSourceKey});
            List<String> firstRow = table.get(0);
            if (firstRow != null && !firstRow.isEmpty()) {
                value = firstRow.get(0);
            }
        }
        String rawData = sourceTable.getRawData();
        if (value == null && rawData != null) {
            log.debug("Hostname {} - Get {} defined in source {} from raw data.", new Object[]{hostname, fieldLabel, foreignSourceKey});
            value = rawData.split(";")[0];
        }
        if (value == null) {
            log.error("Hostname {} - Couldn't extract the {} defined in source {}.", new Object[]{hostname, fieldLabel, originalSourceKey});
        }
        return value;
    }

    private SourceTable runExecuteForEachEntryOf(Source copy) {
        SourceTable result = this.processExecuteForEachEntryOf(copy, copy.getExecuteForEachEntryOf());
        if (result != null && this.isEntryConcatMethodJsonArrayOrExtended(copy)) {
            result.setRawData(String.format("[%s]", result.getRawData()));
        }
        return result;
    }

    private boolean isEntryConcatMethodJsonArrayOrExtended(Source copy) {
        return EntryConcatMethod.JSON_ARRAY_EXTENDED.equals(copy.getEntryConcatMethod()) || EntryConcatMethod.JSON_ARRAY.equals(copy.getEntryConcatMethod());
    }

    public static String replaceAttributeReferences(String key, Map<String, String> attributes) {
        if (attributes == null || key == null) {
            return key;
        }
        Matcher matcher = MONO_INSTANCE_REPLACEMENT_PATTERN.matcher(key);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String attributesValue = attributes.get(matcher.group(1));
            if (attributesValue == null) continue;
            matcher.appendReplacement(sb, Matcher.quoteReplacement(attributesValue));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    String replaceSourceReference(String value, Source source) {
        if (value == null || this.isSourceWithProtectedReferences(source)) {
            return value;
        }
        return SourceUpdaterProcessor.replaceSourceReferenceContent(value, this.telemetryManager, this.connectorId, source.getClass().getSimpleName(), source.getKey());
    }

    private boolean isSourceWithProtectedReferences(Source source) {
        return source instanceof CopySource || source instanceof StaticSource || source instanceof TableUnionSource || source instanceof TableJoinSource;
    }

    public static String replaceSourceReferenceContent(String value, TelemetryManager telemetryManager, String connectorId, String operationType, Object operationKey) {
        Matcher matcher = MetricsHubConstants.SOURCE_REF_PATTERN.matcher(value);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String sourceKey = matcher.group();
            String sourceReferenceContent = SourceUpdaterProcessor.extractSourceReferenceContent(telemetryManager, connectorId, operationType, operationKey, sourceKey);
            matcher.appendReplacement(sb, Matcher.quoteReplacement(sourceReferenceContent));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    static String extractSourceReferenceContent(TelemetryManager telemetryManager, String connectorId, String operationType, Object operationKey, String sourceRefKey) {
        SourceTable sourceTable = telemetryManager.getHostProperties().getConnectorNamespace(connectorId).getSourceTables().get(sourceRefKey);
        String hostname = telemetryManager.getHostConfiguration().getHostname();
        if (sourceTable == null) {
            log.error("Hostname {} - The source table is not available. Couldn't extract {} referenced in {} ({}). The source reference will be replaced with an empty value.", new Object[]{hostname, sourceRefKey, operationType, operationKey});
            return "";
        }
        String sourceReferenceContent = null;
        List<List<String>> table = sourceTable.getTable();
        if (table != null && !table.isEmpty()) {
            log.debug("Hostname {} - Get {} referenced in {} ({}) from list table.", new Object[]{hostname, sourceRefKey, operationType, operationKey});
            sourceReferenceContent = SourceTable.tableToCsv(table, ";", false);
        }
        String rawData = sourceTable.getRawData();
        if (sourceReferenceContent == null && rawData != null) {
            log.debug("Hostname {} - Get {} referenced in {} ({}) from raw data.", new Object[]{hostname, sourceRefKey, operationType, operationKey});
            sourceReferenceContent = rawData;
        }
        if (sourceReferenceContent != null) {
            return Stream.of(sourceReferenceContent.split("\n")).map(val2 -> {
                int indexOfSemicolon = val2.indexOf(";");
                if (indexOfSemicolon == val2.length() - 1) {
                    return val2.replace(";", "");
                }
                return val2;
            }).collect(Collectors.joining("\n"));
        }
        log.error("Hostname {} - Neither the raw data nor the table is available. Couldn't extract {} referenced in {} ({}). The source reference will be replaced with an empty value.", new Object[]{hostname, sourceRefKey, operationType, operationKey});
        return "";
    }

    private SourceTable processExecuteForEachEntryOf(Source source, String sourceTableKey) {
        Optional<SourceTable> maybeSourceTable = SourceTable.lookupSourceTable(sourceTableKey, this.connectorId, this.telemetryManager);
        String hostname = this.telemetryManager.getHostConfiguration().getHostname();
        if (maybeSourceTable.isEmpty()) {
            log.error("Hostname {} - The SourceTable referenced in the ExecuteForEachEntryOf field cannot be found : {}.", (Object)hostname, (Object)sourceTableKey);
            return SourceTable.empty();
        }
        SourceTable result = SourceTable.builder().rawData("").build();
        for (List<String> row : maybeSourceTable.get().getTable()) {
            Source copy = source.copy();
            try {
                copy.update(dataValue -> SourceUpdaterProcessor.replaceDynamicEntry(dataValue, row));
            }
            catch (NumberFormatException e) {
                log.warn("Hostname {} - The dynamic key from Source is incorrectly formatted : {}.", (Object)hostname, (Object)copy);
                continue;
            }
            copy.update(dataValue -> SourceUpdaterProcessor.replaceAttributeReferences(dataValue, this.attributes));
            copy.update(value -> this.replaceSourceReference((String)value, copy));
            this.concatEntryResult(source, result, row, copy.accept(this.sourceProcessor));
        }
        return result;
    }

    static String replaceDynamicEntry(String dataValue, @NonNull List<String> row) throws NumberFormatException {
        if (row == null) {
            throw new IllegalArgumentException("row is marked non-null but is null");
        }
        if (dataValue == null) {
            return null;
        }
        Matcher matcher = COLUMN_REF_PATTERN.matcher(dataValue);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String value = row.get(Integer.parseInt(matcher.group(1)) - 1);
            matcher.appendReplacement(sb, Matcher.quoteReplacement(value));
        }
        matcher.appendTail(sb);
        return sb.toString().replace("$$", "$");
    }

    private void concatEntryResult(Source source, SourceTable currentResult, List<String> row, SourceTable sourceTableToConcat) {
        EntryConcatMethod entryConcatMethod = source.getEntryConcatMethod() != null ? (EntryConcatMethod)source.getEntryConcatMethod() : EntryConcatMethod.LIST;
        String rawData = sourceTableToConcat.getRawData();
        switch (entryConcatMethod) {
            case JSON_ARRAY: {
                this.appendJsonToArray(currentResult, rawData);
                break;
            }
            case JSON_ARRAY_EXTENDED: {
                this.appendExtendedJsonToArray(currentResult, row, sourceTableToConcat);
                break;
            }
            default: {
                List<List<String>> table;
                if (rawData != null && !rawData.isBlank()) {
                    this.joinStringValue(currentResult, rawData, "\n");
                }
                if ((table = sourceTableToConcat.getTable()) == null || table.isEmpty()) break;
                currentResult.getTable().addAll(table.stream().filter(line -> !line.isEmpty()).collect(Collectors.toCollection(ArrayList::new)));
            }
        }
    }

    private void appendExtendedJsonToArray(SourceTable currentResult, List<String> row, SourceTable sourceTableToConcat) {
        String formattedExtendedJSON = PslUtils.formatExtendedJSON(SourceUpdaterProcessor.rowToCsv(row, ","), sourceTableToConcat);
        if (formattedExtendedJSON.isBlank()) {
            return;
        }
        this.joinStringValue(currentResult, formattedExtendedJSON, ",\n");
    }

    private void appendJsonToArray(SourceTable currentResult, String json) {
        if (json == null || json.isBlank()) {
            return;
        }
        this.joinStringValue(currentResult, json, ",\n");
    }

    private void joinStringValue(SourceTable currentResult, String string, @NonNull String separator) {
        if (separator == null) {
            throw new IllegalArgumentException("separator is marked non-null but is null");
        }
        currentResult.setRawData((currentResult.getRawData().isBlank() ? "" : currentResult.getRawData().concat(separator)).concat(string));
    }

    public static String rowToCsv(List<String> row, String separator) {
        if (row != null) {
            return row.stream().filter(Objects::nonNull).collect(Collectors.joining(separator));
        }
        return "";
    }

    @Generated
    public static SourceUpdaterProcessorBuilder builder() {
        return new SourceUpdaterProcessorBuilder();
    }

    @Generated
    public ISourceProcessor getSourceProcessor() {
        return this.sourceProcessor;
    }

    @Generated
    public TelemetryManager getTelemetryManager() {
        return this.telemetryManager;
    }

    @Generated
    public String getConnectorId() {
        return this.connectorId;
    }

    @Generated
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    @Generated
    public void setSourceProcessor(ISourceProcessor sourceProcessor) {
        this.sourceProcessor = sourceProcessor;
    }

    @Generated
    public void setTelemetryManager(TelemetryManager telemetryManager) {
        this.telemetryManager = telemetryManager;
    }

    @Generated
    public void setConnectorId(String connectorId) {
        this.connectorId = connectorId;
    }

    @Generated
    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SourceUpdaterProcessor)) {
            return false;
        }
        SourceUpdaterProcessor other = (SourceUpdaterProcessor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ISourceProcessor this$sourceProcessor = this.getSourceProcessor();
        ISourceProcessor other$sourceProcessor = other.getSourceProcessor();
        if (this$sourceProcessor == null ? other$sourceProcessor != null : !this$sourceProcessor.equals(other$sourceProcessor)) {
            return false;
        }
        TelemetryManager this$telemetryManager = this.getTelemetryManager();
        TelemetryManager other$telemetryManager = other.getTelemetryManager();
        if (this$telemetryManager == null ? other$telemetryManager != null : !((Object)this$telemetryManager).equals(other$telemetryManager)) {
            return false;
        }
        String this$connectorId = this.getConnectorId();
        String other$connectorId = other.getConnectorId();
        if (this$connectorId == null ? other$connectorId != null : !this$connectorId.equals(other$connectorId)) {
            return false;
        }
        Map<String, String> this$attributes = this.getAttributes();
        Map<String, String> other$attributes = other.getAttributes();
        return !(this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SourceUpdaterProcessor;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ISourceProcessor $sourceProcessor = this.getSourceProcessor();
        result = result * 59 + ($sourceProcessor == null ? 43 : $sourceProcessor.hashCode());
        TelemetryManager $telemetryManager = this.getTelemetryManager();
        result = result * 59 + ($telemetryManager == null ? 43 : ((Object)$telemetryManager).hashCode());
        String $connectorId = this.getConnectorId();
        result = result * 59 + ($connectorId == null ? 43 : $connectorId.hashCode());
        Map<String, String> $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SourceUpdaterProcessor(sourceProcessor=" + String.valueOf(this.getSourceProcessor()) + ", telemetryManager=" + String.valueOf(this.getTelemetryManager()) + ", connectorId=" + this.getConnectorId() + ", attributes=" + String.valueOf(this.getAttributes()) + ")";
    }

    @Generated
    public SourceUpdaterProcessor(ISourceProcessor sourceProcessor, TelemetryManager telemetryManager, String connectorId, Map<String, String> attributes) {
        this.sourceProcessor = sourceProcessor;
        this.telemetryManager = telemetryManager;
        this.connectorId = connectorId;
        this.attributes = attributes;
    }

    @Generated
    public SourceUpdaterProcessor() {
    }

    @Generated
    public static class SourceUpdaterProcessorBuilder {
        @Generated
        private ISourceProcessor sourceProcessor;
        @Generated
        private TelemetryManager telemetryManager;
        @Generated
        private String connectorId;
        @Generated
        private Map<String, String> attributes;

        @Generated
        SourceUpdaterProcessorBuilder() {
        }

        @Generated
        public SourceUpdaterProcessorBuilder sourceProcessor(ISourceProcessor sourceProcessor) {
            this.sourceProcessor = sourceProcessor;
            return this;
        }

        @Generated
        public SourceUpdaterProcessorBuilder telemetryManager(TelemetryManager telemetryManager) {
            this.telemetryManager = telemetryManager;
            return this;
        }

        @Generated
        public SourceUpdaterProcessorBuilder connectorId(String connectorId) {
            this.connectorId = connectorId;
            return this;
        }

        @Generated
        public SourceUpdaterProcessorBuilder attributes(Map<String, String> attributes) {
            this.attributes = attributes;
            return this;
        }

        @Generated
        public SourceUpdaterProcessor build() {
            return new SourceUpdaterProcessor(this.sourceProcessor, this.telemetryManager, this.connectorId, this.attributes);
        }

        @Generated
        public String toString() {
            return "SourceUpdaterProcessor.SourceUpdaterProcessorBuilder(sourceProcessor=" + String.valueOf(this.sourceProcessor) + ", telemetryManager=" + String.valueOf(this.telemetryManager) + ", connectorId=" + this.connectorId + ", attributes=" + String.valueOf(this.attributes) + ")";
        }
    }
}

