/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.strategy.source;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.sentrysoftware.metricshub.engine.common.helpers.MetricsHubConstants;
import org.sentrysoftware.metricshub.engine.telemetry.TelemetryManager;

public class SourceTable {
    private static final String ALTERNATE_COLUMN_SEPARATOR = ",";
    private List<List<String>> table;
    private List<String> headers;
    private String rawData;

    public static String tableToCsv(List<List<String>> table, String separator, boolean replaceSeparator) {
        if (table != null) {
            return table.stream().filter(Objects::nonNull).map(line -> replaceSeparator ? line.stream().map(val2 -> val2.replace(separator, ALTERNATE_COLUMN_SEPARATOR)).collect(Collectors.toList()) : line).map(line -> String.join((CharSequence)separator, line) + separator).collect(Collectors.joining("\n"));
        }
        return "";
    }

    public static List<List<String>> csvToTable(String csvTable, String separator) {
        if (csvTable != null) {
            return Stream.of(csvTable.split("\n")).map(line -> SourceTable.lineToList(line, separator)).filter(line -> !line.isEmpty()).collect(Collectors.toList());
        }
        return new ArrayList<List<String>>();
    }

    public static List<String> lineToList(String line, String separator) {
        if (line != null && !line.isEmpty()) {
            line = !line.endsWith(separator) ? line + separator : line;
            String[] split = line.split(separator, -1);
            return Stream.of(split).limit((long)split.length - 1L).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    public static SourceTable empty() {
        return SourceTable.builder().build();
    }

    public boolean isEmpty() {
        return !(this.rawData != null && !this.rawData.isEmpty() || this.table != null && !this.table.isEmpty());
    }

    public static Optional<SourceTable> lookupSourceTable(String sourceKey, String connectorId, TelemetryManager telemetryManager) {
        Matcher matcher = MetricsHubConstants.SOURCE_REF_PATTERN.matcher(sourceKey);
        if (matcher.find()) {
            return Optional.ofNullable(telemetryManager.getHostProperties().getConnectorNamespace(connectorId).getSourceTable(matcher.group()));
        }
        return Optional.of(SourceTable.builder().table(SourceTable.csvToTable(sourceKey, ";")).build());
    }

    @Generated
    private static List<List<String>> $default$table() {
        return new ArrayList<List<String>>();
    }

    @Generated
    private static List<String> $default$headers() {
        return new ArrayList<String>();
    }

    @Generated
    public static SourceTableBuilder builder() {
        return new SourceTableBuilder();
    }

    @Generated
    public List<List<String>> getTable() {
        return this.table;
    }

    @Generated
    public List<String> getHeaders() {
        return this.headers;
    }

    @Generated
    public String getRawData() {
        return this.rawData;
    }

    @Generated
    public void setTable(List<List<String>> table) {
        this.table = table;
    }

    @Generated
    public void setHeaders(List<String> headers) {
        this.headers = headers;
    }

    @Generated
    public void setRawData(String rawData) {
        this.rawData = rawData;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SourceTable)) {
            return false;
        }
        SourceTable other = (SourceTable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<List<String>> this$table = this.getTable();
        List<List<String>> other$table = other.getTable();
        if (this$table == null ? other$table != null : !((Object)this$table).equals(other$table)) {
            return false;
        }
        List<String> this$headers = this.getHeaders();
        List<String> other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        String this$rawData = this.getRawData();
        String other$rawData = other.getRawData();
        return !(this$rawData == null ? other$rawData != null : !this$rawData.equals(other$rawData));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SourceTable;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<List<String>> $table = this.getTable();
        result = result * 59 + ($table == null ? 43 : ((Object)$table).hashCode());
        List<String> $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        String $rawData = this.getRawData();
        result = result * 59 + ($rawData == null ? 43 : $rawData.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SourceTable(table=" + String.valueOf(this.getTable()) + ", headers=" + String.valueOf(this.getHeaders()) + ", rawData=" + this.getRawData() + ")";
    }

    @Generated
    public SourceTable(List<List<String>> table, List<String> headers, String rawData) {
        this.table = table;
        this.headers = headers;
        this.rawData = rawData;
    }

    @Generated
    public SourceTable() {
        this.table = SourceTable.$default$table();
        this.headers = SourceTable.$default$headers();
    }

    @Generated
    public static class SourceTableBuilder {
        @Generated
        private boolean table$set;
        @Generated
        private List<List<String>> table$value;
        @Generated
        private boolean headers$set;
        @Generated
        private List<String> headers$value;
        @Generated
        private String rawData;

        @Generated
        SourceTableBuilder() {
        }

        @Generated
        public SourceTableBuilder table(List<List<String>> table) {
            this.table$value = table;
            this.table$set = true;
            return this;
        }

        @Generated
        public SourceTableBuilder headers(List<String> headers) {
            this.headers$value = headers;
            this.headers$set = true;
            return this;
        }

        @Generated
        public SourceTableBuilder rawData(String rawData) {
            this.rawData = rawData;
            return this;
        }

        @Generated
        public SourceTable build() {
            List<List<String>> table$value = this.table$value;
            if (!this.table$set) {
                table$value = SourceTable.$default$table();
            }
            List<String> headers$value = this.headers$value;
            if (!this.headers$set) {
                headers$value = SourceTable.$default$headers();
            }
            return new SourceTable(table$value, headers$value, this.rawData);
        }

        @Generated
        public String toString() {
            return "SourceTable.SourceTableBuilder(table$value=" + String.valueOf(this.table$value) + ", headers$value=" + String.valueOf(this.headers$value) + ", rawData=" + this.rawData + ")";
        }
    }
}

