/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.strategy.source;

import io.opentelemetry.instrumentation.annotations.SpanAttribute;
import io.opentelemetry.instrumentation.annotations.WithSpan;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.sentrysoftware.metricshub.engine.client.ClientsExecutor;
import org.sentrysoftware.metricshub.engine.client.http.HttpRequest;
import org.sentrysoftware.metricshub.engine.common.helpers.FilterResultHelper;
import org.sentrysoftware.metricshub.engine.common.helpers.StringHelper;
import org.sentrysoftware.metricshub.engine.common.helpers.TextTableHelper;
import org.sentrysoftware.metricshub.engine.configuration.HttpConfiguration;
import org.sentrysoftware.metricshub.engine.configuration.IWinConfiguration;
import org.sentrysoftware.metricshub.engine.configuration.IpmiConfiguration;
import org.sentrysoftware.metricshub.engine.configuration.OsCommandConfiguration;
import org.sentrysoftware.metricshub.engine.configuration.SnmpConfiguration;
import org.sentrysoftware.metricshub.engine.configuration.SshConfiguration;
import org.sentrysoftware.metricshub.engine.configuration.WbemConfiguration;
import org.sentrysoftware.metricshub.engine.connector.model.common.DeviceKind;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.CopySource;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.HttpSource;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.IpmiSource;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.OsCommandSource;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.SnmpGetSource;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.SnmpTableSource;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.StaticSource;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.TableJoinSource;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.TableUnionSource;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.WbemSource;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.WmiSource;
import org.sentrysoftware.metricshub.engine.strategy.source.ISourceProcessor;
import org.sentrysoftware.metricshub.engine.strategy.source.SourceTable;
import org.sentrysoftware.metricshub.engine.strategy.utils.IpmiHelper;
import org.sentrysoftware.metricshub.engine.strategy.utils.OsCommandHelper;
import org.sentrysoftware.metricshub.engine.strategy.utils.OsCommandResult;
import org.sentrysoftware.metricshub.engine.telemetry.TelemetryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceProcessor
implements ISourceProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SourceProcessor.class);
    private TelemetryManager telemetryManager;
    private String connectorId;
    private ClientsExecutor clientsExecutor;

    @Override
    @WithSpan(value="Source Copy Exec")
    public SourceTable process(@SpanAttribute(value="source.definition") CopySource copySource) {
        String hostname = this.telemetryManager.getHostConfiguration().getHostname();
        if (copySource == null) {
            log.error("Hostname {} - CopySource cannot be null, the CopySource operation will return an empty result.", (Object)hostname);
            return SourceTable.empty();
        }
        String copyFrom = copySource.getFrom();
        if (copyFrom == null || copyFrom.isEmpty()) {
            log.error("Hostname {} - CopySource reference cannot be null. Returning an empty table for source {}.", (Object)hostname, (Object)copySource);
            return SourceTable.empty();
        }
        SourceTable sourceTable = new SourceTable();
        Optional<SourceTable> maybeOrigin = SourceTable.lookupSourceTable(copyFrom, this.connectorId, this.telemetryManager);
        if (maybeOrigin.isEmpty()) {
            return SourceTable.empty();
        }
        SourceTable origin = maybeOrigin.get();
        List<List<String>> table = origin.getTable().stream().map(ArrayList::new).filter(row -> !row.isEmpty()).collect(Collectors.toList());
        sourceTable.setTable(table);
        if (origin.getRawData() != null) {
            sourceTable.setRawData(origin.getRawData());
        }
        SourceProcessor.logSourceCopy(this.connectorId, copyFrom, copySource.getKey(), sourceTable, hostname);
        return sourceTable;
    }

    @Override
    @WithSpan(value="Source HTTP Exec")
    public SourceTable process(@SpanAttribute(value="source.definition") HttpSource httpSource) {
        String hostname = this.telemetryManager.getHostConfiguration().getHostname();
        if (httpSource == null) {
            log.error("Hostname {} - HttpSource cannot be null, the HttpSource operation will return an empty result.", (Object)hostname);
            return SourceTable.empty();
        }
        HttpConfiguration httpConfiguration = (HttpConfiguration)this.telemetryManager.getHostConfiguration().getConfigurations().get(HttpConfiguration.class);
        if (httpConfiguration == null) {
            log.debug("Hostname {} - The HTTP credentials are not configured. Returning an empty table for HttpSource {}.", (Object)hostname, (Object)httpSource);
            return SourceTable.empty();
        }
        try {
            String result = this.clientsExecutor.executeHttp(HttpRequest.builder().hostname(hostname).method(httpSource.getMethod().toString()).url(httpSource.getUrl()).path(httpSource.getPath()).header(httpSource.getHeader(), this.connectorId, hostname).body(httpSource.getBody(), this.connectorId, hostname).resultContent(httpSource.getResultContent()).authenticationToken(httpSource.getAuthenticationToken()).httpConfiguration(httpConfiguration).build(), true);
            if (result != null && !result.isEmpty()) {
                return SourceTable.builder().rawData(result).build();
            }
        }
        catch (Exception e) {
            SourceProcessor.logSourceError(this.connectorId, httpSource.getKey(), String.format("HTTP %s %s", new Object[]{httpSource.getMethod(), httpSource.getUrl()}), hostname, e);
        }
        return SourceTable.empty();
    }

    @Override
    @WithSpan(value="Source IPMI Exec")
    public SourceTable process(@SpanAttribute(value="source.definition") IpmiSource ipmiSource) {
        String hostname = this.telemetryManager.getHostConfiguration().getHostname();
        if (ipmiSource == null) {
            log.error("Hostname {} - IPMI Source cannot be null, the IPMI operation will return an empty result.", (Object)hostname);
            return SourceTable.empty();
        }
        String sourceKey = ipmiSource.getKey();
        DeviceKind hostType = this.telemetryManager.getHostConfiguration().getHostType();
        if (DeviceKind.WINDOWS.equals((Object)hostType)) {
            return this.processWindowsIpmiSource(sourceKey);
        }
        if (DeviceKind.LINUX.equals((Object)hostType) || DeviceKind.SOLARIS.equals((Object)hostType)) {
            return this.processUnixIpmiSource(sourceKey);
        }
        if (DeviceKind.OOB.equals((Object)hostType)) {
            return this.processOutOfBandIpmiSource(sourceKey);
        }
        log.info("Hostname {} - Failed to process IPMI source. {} is an unsupported OS for IPMI. Returning an empty table.", (Object)hostname, (Object)hostType.name());
        return SourceTable.empty();
    }

    SourceTable processOutOfBandIpmiSource(String sourceKey) {
        IpmiConfiguration ipmiConfiguration = (IpmiConfiguration)this.telemetryManager.getHostConfiguration().getConfigurations().get(IpmiConfiguration.class);
        String hostname = this.telemetryManager.getHostConfiguration().getHostname();
        if (ipmiConfiguration == null) {
            log.warn("Hostname {} - The IPMI credentials are not configured. Cannot process IPMI-over-LAN source.", (Object)hostname);
            return SourceTable.empty();
        }
        try {
            String result = this.clientsExecutor.executeIpmiGetSensors(hostname, ipmiConfiguration);
            if (result != null) {
                return SourceTable.builder().rawData(result).build();
            }
            log.error("Hostname {} - IPMI-over-LAN request returned <null> result. Returning an empty table.", (Object)hostname);
        }
        catch (Exception e) {
            SourceProcessor.logSourceError(this.connectorId, sourceKey, "IPMI-over-LAN", hostname, e);
        }
        return SourceTable.empty();
    }

    SourceTable processUnixIpmiSource(String sourceKey) {
        String sensorResult;
        String fruResult;
        String hostname = this.telemetryManager.getHostConfiguration().getHostname();
        String ipmitoolCommand = this.telemetryManager.getHostProperties().getIpmitoolCommand();
        if (ipmitoolCommand == null || ipmitoolCommand.isEmpty()) {
            String message = String.format("Hostname %s - IPMI tool command cannot be found. Returning an empty result.", hostname);
            log.error(message);
            return SourceTable.empty();
        }
        boolean isLocalHost = this.telemetryManager.getHostProperties().isLocalhost();
        SshConfiguration sshConfiguration = (SshConfiguration)this.telemetryManager.getHostConfiguration().getConfigurations().get(SshConfiguration.class);
        OsCommandConfiguration osCommandConfiguration = (OsCommandConfiguration)this.telemetryManager.getHostConfiguration().getConfigurations().get(OsCommandConfiguration.class);
        int defaultTimeout = osCommandConfiguration != null ? osCommandConfiguration.getTimeout().intValue() : OsCommandConfiguration.DEFAULT_TIMEOUT.intValue();
        String fruCommand = ipmitoolCommand + "fru";
        try {
            if (isLocalHost) {
                fruResult = OsCommandHelper.runLocalCommand(fruCommand, defaultTimeout, null);
            } else if (sshConfiguration != null) {
                fruResult = OsCommandHelper.runSshCommand(fruCommand, hostname, sshConfiguration, defaultTimeout, null, null);
            } else {
                log.warn("Hostname {} - Could not process UNIX IPMI Source. SSH protocol credentials are missing.", (Object)hostname);
                return SourceTable.empty();
            }
            log.debug("Hostname {} - IPMI OS command: {}:\n{}", new Object[]{hostname, fruCommand, fruResult});
        }
        catch (Exception e) {
            SourceProcessor.logSourceError(this.connectorId, sourceKey, String.format("IPMI OS command: %s.", fruCommand), hostname, e);
            Thread.currentThread().interrupt();
            return SourceTable.empty();
        }
        String sdrCommand = ipmitoolCommand + "-v sdr elist all";
        try {
            sensorResult = isLocalHost ? OsCommandHelper.runLocalCommand(sdrCommand, defaultTimeout, null) : OsCommandHelper.runSshCommand(sdrCommand, hostname, sshConfiguration, defaultTimeout, null, null);
            log.debug("Hostname {} - IPMI OS command: {}:\n{}", new Object[]{hostname, sdrCommand, sensorResult});
        }
        catch (Exception e) {
            SourceProcessor.logSourceError(this.connectorId, sourceKey, String.format("IPMI OS command: %s.", sdrCommand), hostname, e);
            Thread.currentThread().interrupt();
            return SourceTable.empty();
        }
        return SourceTable.builder().table(IpmiHelper.ipmiTranslateFromIpmitool(fruResult, sensorResult)).build();
    }

    SourceTable processWindowsIpmiSource(String sourceKey) {
        IWinConfiguration winConfiguration = this.telemetryManager.getHostConfiguration().getWinConfiguration();
        String hostname = this.telemetryManager.getHostConfiguration().getHostname();
        if (winConfiguration == null) {
            log.warn("Hostname {} - The Windows protocols credentials are not configured. Cannot process Windows IPMI source.", (Object)hostname);
            return SourceTable.empty();
        }
        String nameSpaceRootCimv2 = "root/cimv2";
        String nameSpaceRootHardware = "root/hardware";
        String wmiQuery = "SELECT IdentifyingNumber,Name,Vendor FROM Win32_ComputerSystemProduct";
        List<List<String>> wmiCollection1 = this.executeIpmiWmiRequest(hostname, winConfiguration, wmiQuery, "root/cimv2", sourceKey);
        wmiQuery = "SELECT BaseUnits,CurrentReading,Description,LowerThresholdCritical,LowerThresholdNonCritical,SensorType,UnitModifier,UpperThresholdCritical,UpperThresholdNonCritical FROM NumericSensor";
        List<List<String>> wmiCollection2 = this.executeIpmiWmiRequest(hostname, winConfiguration, wmiQuery, "root/hardware", sourceKey);
        wmiQuery = "SELECT CurrentState,Description FROM Sensor";
        List<List<String>> wmiCollection3 = this.executeIpmiWmiRequest(hostname, winConfiguration, wmiQuery, "root/hardware", sourceKey);
        return SourceTable.builder().table(IpmiHelper.ipmiTranslateFromWmi(wmiCollection1, wmiCollection2, wmiCollection3)).build();
    }

    private List<List<String>> executeIpmiWmiRequest(String hostname, IWinConfiguration winConfiguration, String wmiQuery, String namespace, String sourceKey) {
        List<List<String>> result;
        log.info("Hostname {} - Executing IPMI Query for source [{}]:\nWMI Query: {}:\n", new Object[]{hostname, sourceKey, wmiQuery});
        try {
            result = this.clientsExecutor.executeWql(hostname, winConfiguration, wmiQuery, namespace);
        }
        catch (Exception exception) {
            SourceProcessor.logSourceError(this.connectorId, sourceKey, String.format("IPMI WMI query=%s, Hostname=%s, Username=%s, Timeout=%d, Namespace=%s", wmiQuery, hostname, winConfiguration.getUsername(), winConfiguration.getTimeout(), namespace), hostname, exception);
            result = Collections.emptyList();
        }
        log.info("Hostname {} - IPMI query for [{}] result:\n{}\n", new Object[]{hostname, sourceKey, TextTableHelper.generateTextTable(result)});
        return result;
    }

    @Override
    @WithSpan(value="Source OS Command Exec")
    public SourceTable process(@SpanAttribute(value="source.definition") OsCommandSource osCommandSource) {
        String hostname = this.telemetryManager.getHostConfiguration().getHostname();
        if (osCommandSource == null || osCommandSource.getCommandLine() == null || osCommandSource.getCommandLine().isEmpty()) {
            log.error("Hostname {} - Malformed OS command source.", (Object)hostname);
            return SourceTable.empty();
        }
        try {
            OsCommandResult osCommandResult = OsCommandHelper.runOsCommand(osCommandSource.getCommandLine(), this.telemetryManager, osCommandSource.getTimeout(), osCommandSource.getExecuteLocally(), this.telemetryManager.getHostProperties().isLocalhost());
            List<String> resultLines = SourceTable.lineToList(osCommandResult.getResult(), "\n");
            List<String> filteredLines = FilterResultHelper.filterLines(resultLines, osCommandSource.getBeginAtLineNumber(), osCommandSource.getEndAtLineNumber(), osCommandSource.getExclude(), osCommandSource.getKeep());
            List<String> selectedColumnsLines = FilterResultHelper.selectedColumns(filteredLines, osCommandSource.getSeparators(), osCommandSource.getSelectColumns());
            return SourceTable.builder().rawData(selectedColumnsLines.stream().collect(Collectors.joining("\n"))).table(selectedColumnsLines.stream().map(line -> Stream.of(line.split(";")).collect(Collectors.toList())).collect(Collectors.toList())).build();
        }
        catch (Exception e) {
            SourceProcessor.logSourceError(this.connectorId, osCommandSource.getKey(), String.format("OS command: %s.", osCommandSource.getCommandLine()), hostname, e);
            return SourceTable.empty();
        }
    }

    @Override
    @WithSpan(value="Source SNMP Get Exec")
    public SourceTable process(@SpanAttribute(value="source.definition") SnmpGetSource snmpGetSource) {
        String hostname = this.telemetryManager.getHostConfiguration().getHostname();
        if (snmpGetSource == null) {
            log.error("Hostname {} - SNMP Get Source cannot be null, the SNMP Get operation will return an empty result.", (Object)hostname);
            return SourceTable.empty();
        }
        SnmpConfiguration snmpConfiguration = (SnmpConfiguration)this.telemetryManager.getHostConfiguration().getConfigurations().get(SnmpConfiguration.class);
        if (snmpConfiguration == null) {
            log.debug("Hostname {} - The SNMP credentials are not configured. Returning an empty table for SNMP Get Source {}.", (Object)hostname, (Object)snmpGetSource);
            return SourceTable.empty();
        }
        try {
            String result = this.clientsExecutor.executeSNMPGet(snmpGetSource.getOid(), snmpConfiguration, hostname, true);
            if (result != null) {
                return SourceTable.builder().table(Stream.of(Stream.of(result).collect(Collectors.toList())).collect(Collectors.toList())).build();
            }
        }
        catch (Exception e) {
            SourceProcessor.logSourceError(this.connectorId, snmpGetSource.getKey(), String.format("SNMP Get: %s.", snmpGetSource.getOid()), hostname, e);
        }
        return SourceTable.empty();
    }

    @Override
    @WithSpan(value="Source SNMP Table Exec")
    public SourceTable process(@SpanAttribute(value="source.definition") SnmpTableSource snmpTableSource) {
        String hostname = this.telemetryManager.getHostConfiguration().getHostname();
        if (snmpTableSource == null) {
            log.error("Hostname {} - SNMP Get Table Source cannot be null, the SNMP Get Table operation will return an empty result.", (Object)hostname);
            return SourceTable.empty();
        }
        SourceTable sourceTable = new SourceTable();
        String selectedColumns = snmpTableSource.getSelectColumns();
        if (selectedColumns.isBlank()) {
            return SourceTable.empty();
        }
        String[] selectedColumnArray = selectedColumns.split("\\s*,\\s*");
        SnmpConfiguration protocol = (SnmpConfiguration)this.telemetryManager.getHostConfiguration().getConfigurations().get(SnmpConfiguration.class);
        if (protocol == null) {
            log.debug("Hostname {} - The SNMP credentials are not configured. Returning an empty table for SNMP Get Table Source {}.", (Object)hostname, (Object)snmpTableSource);
            return SourceTable.empty();
        }
        try {
            List<List<String>> result = this.clientsExecutor.executeSNMPTable(snmpTableSource.getOid(), selectedColumnArray, protocol, hostname, true);
            sourceTable.setHeaders(Arrays.asList(selectedColumnArray));
            sourceTable.setTable(result);
            return sourceTable;
        }
        catch (Exception e) {
            SourceProcessor.logSourceError(this.connectorId, snmpTableSource.getKey(), String.format("SNMP Table: %s", snmpTableSource.getOid()), hostname, e);
            return SourceTable.empty();
        }
    }

    @Override
    @WithSpan(value="Source Static Exec")
    public SourceTable process(@SpanAttribute(value="source.definition") StaticSource staticSource) {
        String hostname = this.telemetryManager.getHostConfiguration().getHostname();
        if (staticSource == null) {
            log.error("Hostname {} - Static Source cannot be null, the StaticSource operation will return an empty result.", (Object)hostname);
            return SourceTable.empty();
        }
        String staticValue = staticSource.getValue();
        if (staticValue == null || staticValue.isEmpty()) {
            log.error("Hostname {} - Static Source reference cannot be null. Returning an empty table for source {}.", (Object)hostname, (Object)staticSource);
            return SourceTable.empty();
        }
        log.debug("Hostname {} - Got Static Source value [{}] referenced in source [{}].", new Object[]{hostname, staticValue, staticSource.getKey()});
        SourceTable sourceTable = new SourceTable();
        Optional<SourceTable> maybeStaticTable = SourceTable.lookupSourceTable(staticValue, this.connectorId, this.telemetryManager);
        if (maybeStaticTable.isEmpty()) {
            return SourceTable.empty();
        }
        List<List<String>> table = maybeStaticTable.get().getTable().stream().map(ArrayList::new).filter(row -> !row.isEmpty()).collect(Collectors.toList());
        sourceTable.setTable(table);
        sourceTable.setRawData(SourceTable.tableToCsv(sourceTable.getTable(), ";", false));
        return sourceTable;
    }

    @Override
    @WithSpan(value="Source TableJoin Exec")
    public SourceTable process(@SpanAttribute(value="source.definition") TableJoinSource tableJoinSource) {
        String hostname = this.telemetryManager.getHostConfiguration().getHostname();
        if (tableJoinSource == null) {
            log.error("Hostname {} - Table Join Source cannot be null, the Table Join will return an empty result.", (Object)hostname);
            return SourceTable.empty();
        }
        if (tableJoinSource.getLeftTable() == null) {
            log.debug("Hostname {} - Left table cannot be null, the Join {} will return an empty result.", (Object)hostname, (Object)tableJoinSource);
            return SourceTable.empty();
        }
        Optional<SourceTable> maybeLeftTable = SourceTable.lookupSourceTable(tableJoinSource.getLeftTable(), this.connectorId, this.telemetryManager);
        if (maybeLeftTable.isEmpty()) {
            log.debug("Hostname {} - Reference to Left table cannot be found, the Join {} will return an empty result.", (Object)hostname, (Object)tableJoinSource);
            return SourceTable.empty();
        }
        if (tableJoinSource.getRightTable() == null) {
            log.debug("Hostname {} - Right table cannot be null, the Join {} will return an empty result.", (Object)hostname, (Object)tableJoinSource);
            return SourceTable.empty();
        }
        Optional<SourceTable> maybeRightTable = SourceTable.lookupSourceTable(tableJoinSource.getRightTable(), this.connectorId, this.telemetryManager);
        if (maybeRightTable.isEmpty()) {
            log.debug("Hostname {} - Reference to Right table cannot be found, the Join {} will return an empty result.", (Object)hostname, (Object)tableJoinSource);
            return SourceTable.empty();
        }
        if (tableJoinSource.getLeftKeyColumn() < 1 || tableJoinSource.getRightKeyColumn() < 1) {
            log.error("Hostname {} - Invalid key column number (leftKeyColumnNumber={}, rightKeyColumnNumber={}).", new Object[]{tableJoinSource.getLeftKeyColumn(), tableJoinSource.getDefaultRightLine(), hostname});
            return SourceTable.empty();
        }
        SourceTable leftTable = maybeLeftTable.get();
        SourceTable rightTable = maybeRightTable.get();
        SourceProcessor.logTableJoin(tableJoinSource.getKey(), tableJoinSource.getLeftTable(), tableJoinSource.getRightTable(), leftTable, rightTable, hostname);
        String defaultRightLine = tableJoinSource.getDefaultRightLine();
        List<List<String>> executeTableJoin = this.clientsExecutor.executeTableJoin(leftTable.getTable(), rightTable.getTable(), tableJoinSource.getLeftKeyColumn(), tableJoinSource.getRightKeyColumn(), defaultRightLine != null ? Arrays.asList(defaultRightLine.split(";")) : null, "wbem".equalsIgnoreCase(tableJoinSource.getKeyType()), true);
        SourceTable sourceTable = new SourceTable();
        if (executeTableJoin != null) {
            sourceTable.setTable(executeTableJoin);
        }
        return sourceTable;
    }

    private static void logTableJoin(String sourceKey, String leftSourceKey, String rightSourceKey, SourceTable leftTable, SourceTable rightTable, String hostname) {
        if (!log.isDebugEnabled()) {
            return;
        }
        log.debug("Hostname {} - Table Join Source [{}]:\nLeft table [{}]:\n{}\nRight table [{}]:\n{}\n", new Object[]{hostname, sourceKey, leftSourceKey, TextTableHelper.generateTextTable(leftTable.getHeaders(), leftTable.getTable()), rightSourceKey, TextTableHelper.generateTextTable(rightTable.getHeaders(), rightTable.getTable())});
    }

    @Override
    @WithSpan(value="Source TableUnion Exec")
    public SourceTable process(@SpanAttribute(value="source.definition") TableUnionSource tableUnionSource) {
        String hostname = this.telemetryManager.getHostConfiguration().getHostname();
        if (tableUnionSource == null) {
            log.warn("Hostname {} - Table Union Source cannot be null, the Table Union operation will return an empty result.", (Object)hostname);
            return SourceTable.empty();
        }
        List<String> unionTables = tableUnionSource.getTables();
        if (unionTables == null) {
            log.debug("Hostname {} - Table list in the Union cannot be null, the Union operation {} will return an empty result.", (Object)hostname, (Object)tableUnionSource);
            return SourceTable.empty();
        }
        List sourceTablesToConcat = unionTables.stream().map(key -> SourceTable.lookupSourceTable(key, this.connectorId, this.telemetryManager)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        SourceTable sourceTable = new SourceTable();
        List<List<String>> executeTableUnion = sourceTablesToConcat.stream().map(SourceTable::getTable).flatMap(Collection::stream).collect(Collectors.toList());
        sourceTable.setTable(executeTableUnion);
        String rawData = sourceTablesToConcat.stream().map(SourceTable::getRawData).filter(Objects::nonNull).collect(Collectors.joining("\n")).replace("\n\n", "\n");
        sourceTable.setRawData(rawData);
        return sourceTable;
    }

    @Override
    @WithSpan(value="Source WBEM HTTP Exec")
    public SourceTable process(@SpanAttribute(value="source.definition") WbemSource wbemSource) {
        String hostname = this.telemetryManager.getHostConfiguration().getHostname();
        if (wbemSource == null || wbemSource.getQuery() == null) {
            log.error("Hostname {} - Malformed WBEM Source {}. Returning an empty table.", (Object)hostname, (Object)wbemSource);
            return SourceTable.empty();
        }
        WbemConfiguration wbemConfiguration = (WbemConfiguration)this.telemetryManager.getHostConfiguration().getConfigurations().get(WbemConfiguration.class);
        if (wbemConfiguration == null) {
            log.debug("Hostname {} - The WBEM credentials are not configured. Returning an empty table for WBEM source {}.", (Object)hostname, (Object)wbemSource.getKey());
            return SourceTable.empty();
        }
        String namespace = this.getNamespace(wbemSource);
        try {
            if (hostname == null) {
                log.error("Hostname {} - No hostname indicated, the URL cannot be built.", (Object)hostname);
                return SourceTable.empty();
            }
            if (wbemConfiguration.getPort() == null || wbemConfiguration.getPort() == 0) {
                log.error("Hostname {} - No port indicated to connect to the host", (Object)hostname);
                return SourceTable.empty();
            }
            List<List<String>> table = this.clientsExecutor.executeWbem(hostname, wbemConfiguration, wbemSource.getQuery(), namespace);
            return SourceTable.builder().table(table).build();
        }
        catch (Exception e) {
            SourceProcessor.logSourceError(this.connectorId, wbemSource.getKey(), String.format("WBEM query=%s, Username=%s, Timeout=%d, Namespace=%s", wbemSource.getQuery(), wbemConfiguration.getUsername(), wbemConfiguration.getTimeout(), namespace), hostname, e);
            return SourceTable.empty();
        }
    }

    String getNamespace(WmiSource wmiSource) {
        String sourceNamespace = wmiSource.getNamespace();
        if (sourceNamespace == null) {
            return "root\\cimv2";
        }
        if ("automatic".equalsIgnoreCase(sourceNamespace)) {
            return this.telemetryManager.getHostProperties().getConnectorNamespace(this.connectorId).getAutomaticWmiNamespace();
        }
        return sourceNamespace;
    }

    @Override
    @WithSpan(value="Source WMI Exec")
    public SourceTable process(@SpanAttribute(value="source.definition") WmiSource wmiSource) {
        String hostname = this.telemetryManager.getHostConfiguration().getHostname();
        if (wmiSource == null || wmiSource.getQuery() == null) {
            log.warn("Hostname {} - Malformed WMI source {}. Returning an empty table.", (Object)hostname, (Object)wmiSource);
            return SourceTable.empty();
        }
        IWinConfiguration winConfiguration = this.telemetryManager.getWinConfiguration();
        if (winConfiguration == null) {
            log.debug("Hostname {} - Neither WMI nor WinRM credentials are configured for this host. Returning an empty table for WMI source {}.", (Object)hostname, (Object)wmiSource.getKey());
            return SourceTable.empty();
        }
        String namespace = this.getNamespace(wmiSource);
        if (namespace == null) {
            log.error("Hostname {} - Failed to retrieve the WMI namespace to run the WMI source {}. Returning an empty table.", (Object)hostname, (Object)wmiSource.getKey());
            return SourceTable.empty();
        }
        try {
            List<List<String>> table = this.clientsExecutor.executeWql(hostname, winConfiguration, wmiSource.getQuery(), namespace);
            return SourceTable.builder().table(table).build();
        }
        catch (Exception e) {
            SourceProcessor.logSourceError(this.connectorId, wmiSource.getKey(), String.format("WMI query=%s, Username=%s, Timeout=%d, Namespace=%s", wmiSource.getQuery(), winConfiguration.getUsername(), winConfiguration.getTimeout(), namespace), hostname, e);
            return SourceTable.empty();
        }
    }

    private static void logSourceError(String connectorId, String sourceKey, String context, String hostname, Throwable throwable) {
        if (log.isErrorEnabled()) {
            log.error("Hostname {} - Source [{}] was unsuccessful due to an exception. Context [{}]. Connector: [{}]. Returning an empty table. Errors:\n{}\n", new Object[]{hostname, sourceKey, context, connectorId, StringHelper.getStackMessages(throwable)});
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format("Hostname %s - Source [%s] was unsuccessful due to an exception. Context [%s]. Connector: [%s]. Returning an empty table. Stack trace:", hostname, sourceKey, context, connectorId), throwable);
        }
    }

    private static void logSourceCopy(String connectorId, String parentSourceKey, String childSourceKey, SourceTable sourceTable, String hostname) {
        if (!log.isDebugEnabled()) {
            return;
        }
        if (sourceTable.getRawData() != null && (sourceTable.getTable() == null || sourceTable.getTable().isEmpty())) {
            log.debug("Hostname {} - Got Source [{}] referenced in Source [{}]. Connector: [{}].\nRaw result:\n{}\n", new Object[]{hostname, parentSourceKey, childSourceKey, connectorId, sourceTable.getRawData()});
            return;
        }
        if (sourceTable.getRawData() == null) {
            log.debug("Hostname {} - Got Source [{}] referenced in Source [{}]. Connector: [{}].\nTable result:\n{}\n", new Object[]{hostname, parentSourceKey, childSourceKey, connectorId, TextTableHelper.generateTextTable(sourceTable.getHeaders(), sourceTable.getTable())});
            return;
        }
        log.debug("Hostname {} - Got Source [{}] referenced in Source [{}]. Connector: [{}].\nRaw result:\n{}\nTable result:\n{}\n", new Object[]{hostname, parentSourceKey, childSourceKey, connectorId, sourceTable.getRawData(), TextTableHelper.generateTextTable(sourceTable.getHeaders(), sourceTable.getTable())});
    }

    String getNamespace(WbemSource wbemSource) {
        String namespace = wbemSource.getNamespace();
        if (namespace == null) {
            namespace = "root\\cimv2";
        } else if ("automatic".equalsIgnoreCase(namespace)) {
            namespace = this.telemetryManager.getHostProperties().getConnectorNamespace(this.connectorId).getAutomaticWbemNamespace();
        }
        return namespace;
    }

    @Generated
    public static SourceProcessorBuilder builder() {
        return new SourceProcessorBuilder();
    }

    @Generated
    public TelemetryManager getTelemetryManager() {
        return this.telemetryManager;
    }

    @Generated
    public String getConnectorId() {
        return this.connectorId;
    }

    @Generated
    public ClientsExecutor getClientsExecutor() {
        return this.clientsExecutor;
    }

    @Generated
    public void setTelemetryManager(TelemetryManager telemetryManager) {
        this.telemetryManager = telemetryManager;
    }

    @Generated
    public void setConnectorId(String connectorId) {
        this.connectorId = connectorId;
    }

    @Generated
    public void setClientsExecutor(ClientsExecutor clientsExecutor) {
        this.clientsExecutor = clientsExecutor;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SourceProcessor)) {
            return false;
        }
        SourceProcessor other = (SourceProcessor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TelemetryManager this$telemetryManager = this.getTelemetryManager();
        TelemetryManager other$telemetryManager = other.getTelemetryManager();
        if (this$telemetryManager == null ? other$telemetryManager != null : !((Object)this$telemetryManager).equals(other$telemetryManager)) {
            return false;
        }
        String this$connectorId = this.getConnectorId();
        String other$connectorId = other.getConnectorId();
        if (this$connectorId == null ? other$connectorId != null : !this$connectorId.equals(other$connectorId)) {
            return false;
        }
        ClientsExecutor this$clientsExecutor = this.getClientsExecutor();
        ClientsExecutor other$clientsExecutor = other.getClientsExecutor();
        return !(this$clientsExecutor == null ? other$clientsExecutor != null : !((Object)this$clientsExecutor).equals(other$clientsExecutor));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SourceProcessor;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TelemetryManager $telemetryManager = this.getTelemetryManager();
        result = result * 59 + ($telemetryManager == null ? 43 : ((Object)$telemetryManager).hashCode());
        String $connectorId = this.getConnectorId();
        result = result * 59 + ($connectorId == null ? 43 : $connectorId.hashCode());
        ClientsExecutor $clientsExecutor = this.getClientsExecutor();
        result = result * 59 + ($clientsExecutor == null ? 43 : ((Object)$clientsExecutor).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SourceProcessor(telemetryManager=" + String.valueOf(this.getTelemetryManager()) + ", connectorId=" + this.getConnectorId() + ", clientsExecutor=" + String.valueOf(this.getClientsExecutor()) + ")";
    }

    @Generated
    public SourceProcessor(TelemetryManager telemetryManager, String connectorId, ClientsExecutor clientsExecutor) {
        this.telemetryManager = telemetryManager;
        this.connectorId = connectorId;
        this.clientsExecutor = clientsExecutor;
    }

    @Generated
    public SourceProcessor() {
    }

    @Generated
    public static class SourceProcessorBuilder {
        @Generated
        private TelemetryManager telemetryManager;
        @Generated
        private String connectorId;
        @Generated
        private ClientsExecutor clientsExecutor;

        @Generated
        SourceProcessorBuilder() {
        }

        @Generated
        public SourceProcessorBuilder telemetryManager(TelemetryManager telemetryManager) {
            this.telemetryManager = telemetryManager;
            return this;
        }

        @Generated
        public SourceProcessorBuilder connectorId(String connectorId) {
            this.connectorId = connectorId;
            return this;
        }

        @Generated
        public SourceProcessorBuilder clientsExecutor(ClientsExecutor clientsExecutor) {
            this.clientsExecutor = clientsExecutor;
            return this;
        }

        @Generated
        public SourceProcessor build() {
            return new SourceProcessor(this.telemetryManager, this.connectorId, this.clientsExecutor);
        }

        @Generated
        public String toString() {
            return "SourceProcessor.SourceProcessorBuilder(telemetryManager=" + String.valueOf(this.telemetryManager) + ", connectorId=" + this.connectorId + ", clientsExecutor=" + String.valueOf(this.clientsExecutor) + ")";
        }
    }
}

