/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.strategy.detection;

import io.opentelemetry.instrumentation.annotations.SpanAttribute;
import io.opentelemetry.instrumentation.annotations.WithSpan;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.sentrysoftware.metricshub.engine.client.ClientsExecutor;
import org.sentrysoftware.metricshub.engine.client.http.HttpRequest;
import org.sentrysoftware.metricshub.engine.common.exception.ClientException;
import org.sentrysoftware.metricshub.engine.common.exception.ControlledSshException;
import org.sentrysoftware.metricshub.engine.common.exception.IpmiCommandForSolarisException;
import org.sentrysoftware.metricshub.engine.common.exception.NoCredentialProvidedException;
import org.sentrysoftware.metricshub.engine.common.helpers.LocalOsHandler;
import org.sentrysoftware.metricshub.engine.common.helpers.VersionHelper;
import org.sentrysoftware.metricshub.engine.configuration.HostConfiguration;
import org.sentrysoftware.metricshub.engine.configuration.HttpConfiguration;
import org.sentrysoftware.metricshub.engine.configuration.IWinConfiguration;
import org.sentrysoftware.metricshub.engine.configuration.IpmiConfiguration;
import org.sentrysoftware.metricshub.engine.configuration.OsCommandConfiguration;
import org.sentrysoftware.metricshub.engine.configuration.SnmpConfiguration;
import org.sentrysoftware.metricshub.engine.configuration.SshConfiguration;
import org.sentrysoftware.metricshub.engine.configuration.WbemConfiguration;
import org.sentrysoftware.metricshub.engine.connector.model.common.DeviceKind;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.Criterion;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.DeviceTypeCriterion;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.HttpCriterion;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.IpmiCriterion;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.OsCommandCriterion;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.ProcessCriterion;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.ProductRequirementsCriterion;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.ServiceCriterion;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.SnmpGetCriterion;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.SnmpGetNextCriterion;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.WbemCriterion;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.WmiCriterion;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.WqlCriterion;
import org.sentrysoftware.metricshub.engine.strategy.detection.CriterionTestResult;
import org.sentrysoftware.metricshub.engine.strategy.detection.ICriterionProcessor;
import org.sentrysoftware.metricshub.engine.strategy.utils.CriterionProcessVisitor;
import org.sentrysoftware.metricshub.engine.strategy.utils.OsCommandHelper;
import org.sentrysoftware.metricshub.engine.strategy.utils.OsCommandResult;
import org.sentrysoftware.metricshub.engine.strategy.utils.PslUtils;
import org.sentrysoftware.metricshub.engine.strategy.utils.WqlDetectionHelper;
import org.sentrysoftware.metricshub.engine.telemetry.TelemetryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CriterionProcessor
implements ICriterionProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CriterionProcessor.class);
    private static final String NEITHER_WMI_NOR_WINRM_ERROR = "Neither WMI nor WinRM credentials are configured for this host.";
    private static final String WMI_QUERY = "SELECT Description FROM ComputerSystem";
    private static final String WMI_NAMESPACE = "root\\hardware";
    private static final String EXPECTED_VALUE_RETURNED_VALUE = "Expected value: %s - returned value %s.";
    private static final String CONFIGURE_OS_TYPE_MESSAGE = "Configured OS type : ";
    private static final String IPMI_SOLARIS_VERSION_NOT_IDENTIFIED = "Hostname %s - Could not identify Solaris version %s. Exception: %s";
    private static final String SNMP_CREDENTIALS_NOT_CONFIGURED_MESSAGE = "Hostname {} - The SNMP credentials are not configured. Cannot process SNMP detection {}.";
    private static final String SNMP_GETNEXT_SUCCESSFUL_MESSAGE = "Hostname %s - Successful SNMP GetNext of %s. Returned result: %s.";
    private static final String HTTP_TEST_SUCCESS = "Hostname %s - HTTP test succeeded. Returned result: %s.";
    private static final Pattern SNMP_GET_NEXT_VALUE_PATTERN = Pattern.compile("\\w+\\s+\\w+\\s+(.*)");
    private ClientsExecutor clientsExecutor;
    private TelemetryManager telemetryManager;
    private String connectorId;
    private WqlDetectionHelper wqlDetectionHelper;

    public CriterionProcessor(ClientsExecutor clientsExecutor, TelemetryManager telemetryManager, String connectorId) {
        this.clientsExecutor = clientsExecutor;
        this.telemetryManager = telemetryManager;
        this.connectorId = connectorId;
        this.wqlDetectionHelper = new WqlDetectionHelper(clientsExecutor);
    }

    @Override
    @WithSpan(value="Criterion DeviceType Exec")
    public CriterionTestResult process(@SpanAttribute(value="criterion.definition") DeviceTypeCriterion deviceTypeCriterion) {
        if (deviceTypeCriterion == null) {
            log.error("Hostname {} - Malformed DeviceType criterion {}. Cannot process DeviceType criterion detection.", (Object)this.telemetryManager.getHostConfiguration().getHostname(), (Object)deviceTypeCriterion);
            return CriterionTestResult.empty();
        }
        DeviceKind deviceKind = this.telemetryManager.getHostConfiguration().getHostType();
        if (!this.isDeviceKindIncluded(Collections.singletonList(deviceKind), deviceTypeCriterion)) {
            return CriterionTestResult.builder().message("Failed OS detection operation").result(CONFIGURE_OS_TYPE_MESSAGE + deviceKind.name()).success(false).build();
        }
        return CriterionTestResult.builder().message("Successful OS detection operation").result(CONFIGURE_OS_TYPE_MESSAGE + deviceKind.name()).success(true).build();
    }

    public boolean isDeviceKindIncluded(List<DeviceKind> deviceKindList, DeviceTypeCriterion deviceTypeCriterion) {
        Set<DeviceKind> keepOnly = deviceTypeCriterion.getKeep();
        Set<DeviceKind> exclude = deviceTypeCriterion.getExclude();
        if (keepOnly != null) {
            if (deviceKindList.stream().anyMatch(keepOnly::contains)) {
                return true;
            }
        }
        if (exclude != null) {
            if (deviceKindList.stream().anyMatch(exclude::contains)) {
                return false;
            }
        }
        return keepOnly == null || keepOnly.isEmpty();
    }

    @Override
    @WithSpan(value="Criterion HTTP Exec")
    public CriterionTestResult process(@SpanAttribute(value="criterion.definition") HttpCriterion httpCriterion) {
        if (httpCriterion == null) {
            return CriterionTestResult.empty();
        }
        HostConfiguration hostConfiguration = this.telemetryManager.getHostConfiguration();
        if (hostConfiguration == null) {
            log.debug("There is no host configuration. Cannot process HTTP detection {}.", (Object)httpCriterion);
            return CriterionTestResult.empty();
        }
        String hostname = hostConfiguration.getHostname();
        HttpConfiguration httpConfiguration = (HttpConfiguration)hostConfiguration.getConfigurations().get(HttpConfiguration.class);
        if (httpConfiguration == null) {
            log.debug("Hostname {} - The HTTP credentials are not configured for this host. Cannot process HTTP detection {}.", (Object)hostname, (Object)httpCriterion);
            return CriterionTestResult.empty();
        }
        try {
            String result = this.clientsExecutor.executeHttp(HttpRequest.builder().hostname(hostname).method(httpCriterion.getMethod().toString()).url(httpCriterion.getUrl()).path(httpCriterion.getPath()).header(httpCriterion.getHeader(), this.connectorId, hostname).body(httpCriterion.getBody(), this.connectorId, hostname).httpConfiguration(httpConfiguration).resultContent(httpCriterion.getResultContent()).authenticationToken(httpCriterion.getAuthenticationToken()).build(), false);
            return this.checkHttpResult(hostname, result, httpCriterion.getExpectedResult());
        }
        catch (Exception e) {
            return CriterionTestResult.error((Criterion)httpCriterion, e);
        }
    }

    @Override
    @WithSpan(value="Criterion IPMI Exec")
    public CriterionTestResult process(@SpanAttribute(value="criterion.definition") IpmiCriterion ipmiCriterion) {
        DeviceKind hostType = this.telemetryManager.getHostConfiguration().getHostType();
        if (DeviceKind.WINDOWS.equals((Object)hostType)) {
            return this.processWindowsIpmiDetection(ipmiCriterion);
        }
        if (DeviceKind.LINUX.equals((Object)hostType) || DeviceKind.SOLARIS.equals((Object)hostType)) {
            return this.processUnixIpmiDetection(hostType);
        }
        if (DeviceKind.OOB.equals((Object)hostType)) {
            return this.processOutOfBandIpmiDetection();
        }
        return CriterionTestResult.builder().message(String.format("Hostname %s - Failed to perform IPMI detection. %s is an unsupported OS for IPMI.", this.telemetryManager.getHostConfiguration().getHostname(), hostType.name())).success(false).build();
    }

    private CriterionTestResult processWindowsIpmiDetection(IpmiCriterion ipmiCriterion) {
        String hostname = this.telemetryManager.getHostConfiguration().getHostname();
        IWinConfiguration configuration = this.telemetryManager.getWinConfiguration();
        if (configuration == null) {
            return CriterionTestResult.error((Criterion)ipmiCriterion, NEITHER_WMI_NOR_WINRM_ERROR);
        }
        WmiCriterion ipmiWmiCriterion = WmiCriterion.builder().query(WMI_QUERY).namespace(WMI_NAMESPACE).build();
        return this.wqlDetectionHelper.performDetectionTest(hostname, configuration, ipmiWmiCriterion);
    }

    private CriterionTestResult processUnixIpmiDetection(DeviceKind hostType) {
        SshConfiguration osCommandConfiguration;
        String ipmitoolCommand = this.telemetryManager.getHostProperties().getIpmitoolCommand();
        String hostname = this.telemetryManager.getHostConfiguration().getHostname();
        SshConfiguration sshConfiguration = (SshConfiguration)this.telemetryManager.getHostConfiguration().getConfigurations().get(SshConfiguration.class);
        OsCommandConfiguration osCommandConfiguration2 = osCommandConfiguration = this.telemetryManager.getHostProperties().isLocalhost() ? (OsCommandConfiguration)this.telemetryManager.getHostConfiguration().getConfigurations().get(OsCommandConfiguration.class) : sshConfiguration;
        if (osCommandConfiguration == null) {
            String message = String.format("Hostname %s - No OS command configuration for this host. Returning an empty result", hostname);
            log.warn(message);
            return CriterionTestResult.builder().success(false).result("").message(message).build();
        }
        int defaultTimeout = osCommandConfiguration.getTimeout().intValue();
        if (ipmitoolCommand == null || ipmitoolCommand.isEmpty()) {
            ipmitoolCommand = this.buildIpmiCommand(hostType, hostname, sshConfiguration, osCommandConfiguration, defaultTimeout);
        }
        if (!ipmitoolCommand.startsWith("PATH=")) {
            return CriterionTestResult.builder().success(false).result("").message(ipmitoolCommand).build();
        }
        try {
            String result = null;
            result = this.runOsCommand(ipmitoolCommand, hostname, sshConfiguration, defaultTimeout);
            if (result != null && !result.contains("IPMI Version")) {
                return CriterionTestResult.builder().success(false).result(result).message("Did not get the expected result from the IPMI tool command: " + ipmitoolCommand).build();
            }
            this.telemetryManager.getHostProperties().setIpmiExecutionCount(this.telemetryManager.getHostProperties().getIpmiExecutionCount() + 1);
            return CriterionTestResult.builder().success(true).result(result).message("Successfully connected to the IPMI BMC chip with the in-band driver interface.").build();
        }
        catch (Exception e) {
            String message = String.format("Hostname %s - Cannot execute the IPMI tool command %s. Exception: %s.", hostname, ipmitoolCommand, e.getMessage());
            log.debug(message, (Throwable)e);
            return CriterionTestResult.builder().success(false).message(message).build();
        }
    }

    private CriterionTestResult processOutOfBandIpmiDetection() {
        IpmiConfiguration configuration = (IpmiConfiguration)this.telemetryManager.getHostConfiguration().getConfigurations().get(IpmiConfiguration.class);
        String hostname = this.telemetryManager.getHostConfiguration().getHostname();
        if (configuration == null) {
            log.debug("Hostname {} - The IPMI credentials are not configured for this host. Cannot process IPMI-over-LAN detection.", (Object)hostname);
            return CriterionTestResult.empty();
        }
        try {
            String result = this.clientsExecutor.executeIpmiDetection(hostname, configuration);
            if (result == null) {
                return CriterionTestResult.builder().message("Received <null> result after connecting to the IPMI BMC chip with the IPMI-over-LAN interface.").build();
            }
            return CriterionTestResult.builder().result(result).message("Successfully connected to the IPMI BMC chip with the IPMI-over-LAN interface.").success(true).build();
        }
        catch (Exception e) {
            String message = String.format("Hostname %s - Cannot execute IPMI-over-LAN command to get the chassis status. Exception: %s", hostname, e.getMessage());
            log.debug(message, (Throwable)e);
            return CriterionTestResult.builder().message(message).build();
        }
    }

    public String buildIpmiCommand(DeviceKind hostType, String hostname, SshConfiguration sshConfiguration, OsCommandConfiguration osCommandConfiguration, int defaultTimeout) {
        Object ipmitoolCommand = this.doesIpmitoolRequireSudo(osCommandConfiguration) ? "PATH=$PATH:/usr/local/bin:/usr/sfw/bin;export PATH;%{SUDO:ipmitool}ipmitool -I ".replace("%{SUDO:ipmitool}", osCommandConfiguration.getSudoCommand()) : "PATH=$PATH:/usr/local/bin:/usr/sfw/bin;export PATH;ipmitool -I ";
        if (DeviceKind.SOLARIS.equals((Object)hostType)) {
            String solarisOsVersion = null;
            try {
                solarisOsVersion = this.runOsCommand("/usr/bin/uname -r", hostname, sshConfiguration, defaultTimeout);
            }
            catch (Exception e) {
                String message = String.format(IPMI_SOLARIS_VERSION_NOT_IDENTIFIED, hostname, ipmitoolCommand, e.getMessage());
                log.debug(message, (Throwable)e);
                return message;
            }
            if (solarisOsVersion != null) {
                try {
                    ipmitoolCommand = this.getIpmiCommandForSolaris((String)ipmitoolCommand, hostname, solarisOsVersion);
                }
                catch (IpmiCommandForSolarisException e) {
                    String message = String.format(IPMI_SOLARIS_VERSION_NOT_IDENTIFIED, hostname, ipmitoolCommand, e.getMessage());
                    log.debug(message, (Throwable)e);
                    return message;
                }
            }
        } else {
            ipmitoolCommand = (String)ipmitoolCommand + "open";
        }
        this.telemetryManager.getHostProperties().setIpmitoolCommand((String)ipmitoolCommand);
        ipmitoolCommand = (String)ipmitoolCommand + " bmc info";
        return ipmitoolCommand;
    }

    private boolean doesIpmitoolRequireSudo(OsCommandConfiguration osCommandConfiguration) {
        return osCommandConfiguration.isUseSudo() || osCommandConfiguration.getUseSudoCommands() != null && osCommandConfiguration.getUseSudoCommands().contains("ipmitool");
    }

    public String getIpmiCommandForSolaris(String ipmitoolCommand, String hostname, String solarisOsVersion) throws IpmiCommandForSolarisException {
        String[] split = solarisOsVersion.split("\\.");
        if (split.length < 2) {
            throw new IpmiCommandForSolarisException(String.format("Unknown Solaris version (%s) for host: %s IPMI cannot be executed. Returning an empty result.", solarisOsVersion, hostname));
        }
        String solarisVersion = split[1];
        try {
            int versionInt = Integer.parseInt(solarisVersion);
            if (versionInt == 9) {
                ipmitoolCommand = (String)ipmitoolCommand + "lipmi";
            } else {
                if (versionInt < 9) {
                    throw new IpmiCommandForSolarisException(String.format("Solaris version (%s) is too old for the host: %s IPMI cannot be executed. Returning an empty result.", solarisOsVersion, hostname));
                }
                ipmitoolCommand = (String)ipmitoolCommand + "bmc";
            }
        }
        catch (NumberFormatException e) {
            throw new IpmiCommandForSolarisException("Could not identify Solaris version as a valid one.\nThe 'uname -r' command returned: " + solarisOsVersion + ".");
        }
        return ipmitoolCommand;
    }

    String runOsCommand(String ipmitoolCommand, String hostname, SshConfiguration sshConfiguration, int timeout) throws InterruptedException, IOException, TimeoutException, ClientException, ControlledSshException {
        return this.telemetryManager.getHostProperties().isLocalhost() ? OsCommandHelper.runLocalCommand(ipmitoolCommand, timeout, null) : OsCommandHelper.runSshCommand(ipmitoolCommand, hostname, sshConfiguration, timeout, null, null);
    }

    @Override
    @WithSpan(value="Criterion OS Command Exec")
    public CriterionTestResult process(@SpanAttribute(value="criterion.definition") OsCommandCriterion osCommandCriterion) {
        if (osCommandCriterion == null) {
            return CriterionTestResult.error((Criterion)osCommandCriterion, "Malformed OSCommand criterion.");
        }
        if (osCommandCriterion.getCommandLine().isEmpty() || osCommandCriterion.getExpectedResult() == null || osCommandCriterion.getExpectedResult().isEmpty()) {
            return CriterionTestResult.success(osCommandCriterion, "CommandLine or ExpectedResult are empty. Skipping this test.");
        }
        try {
            OsCommandResult osCommandResult = OsCommandHelper.runOsCommand(osCommandCriterion.getCommandLine(), this.telemetryManager, osCommandCriterion.getTimeout(), osCommandCriterion.getExecuteLocally(), this.telemetryManager.getHostProperties().isLocalhost());
            OsCommandCriterion osCommandNoPassword = OsCommandCriterion.builder().commandLine(osCommandResult.getNoPasswordCommand()).executeLocally(osCommandCriterion.getExecuteLocally()).timeout(osCommandCriterion.getTimeout()).expectedResult(osCommandCriterion.getExpectedResult()).build();
            Matcher matcher = Pattern.compile(PslUtils.psl2JavaRegex(osCommandCriterion.getExpectedResult()), 10).matcher(osCommandResult.getResult());
            return matcher.find() ? CriterionTestResult.success(osCommandNoPassword, osCommandResult.getResult()) : CriterionTestResult.failure(osCommandNoPassword, osCommandResult.getResult());
        }
        catch (NoCredentialProvidedException noCredentialProvidedException) {
            return CriterionTestResult.error((Criterion)osCommandCriterion, noCredentialProvidedException.getMessage());
        }
        catch (Exception exception) {
            return CriterionTestResult.error((Criterion)osCommandCriterion, exception);
        }
    }

    @Override
    @WithSpan(value="Criterion Process Exec")
    public CriterionTestResult process(@SpanAttribute(value="criterion.definition") ProcessCriterion processCriterion) {
        String hostname = this.telemetryManager.getHostConfiguration().getHostname();
        if (processCriterion == null) {
            log.error("Hostname {} - Malformed process criterion {}. Cannot process process detection.", (Object)hostname, (Object)processCriterion);
            return CriterionTestResult.empty();
        }
        if (processCriterion.getCommandLine().isEmpty()) {
            log.debug("Hostname {} - Process Criterion, Process Command Line is empty.", (Object)hostname);
            return CriterionTestResult.builder().success(true).message("Process presence check: No test will be performed.").result(null).build();
        }
        if (!this.telemetryManager.getHostProperties().isLocalhost()) {
            log.debug("Hostname {} - Process criterion, not localhost.", (Object)hostname);
            return CriterionTestResult.builder().success(true).message("Process presence check: No test will be performed remotely.").result(null).build();
        }
        Optional<LocalOsHandler.ILocalOs> maybeLocalOS = LocalOsHandler.getOS();
        if (maybeLocalOS.isEmpty()) {
            log.debug("Hostname {} - Process criterion, unknown local OS.", (Object)hostname);
            return CriterionTestResult.builder().success(true).message("Process presence check: OS unknown, no test will be performed.").result(null).build();
        }
        CriterionProcessVisitor localOSVisitor = new CriterionProcessVisitor(processCriterion.getCommandLine(), this.wqlDetectionHelper, hostname);
        maybeLocalOS.get().accept(localOSVisitor);
        return localOSVisitor.getCriterionTestResult();
    }

    @Override
    @WithSpan(value="Criterion ProductRequirements Exec")
    public CriterionTestResult process(@SpanAttribute(value="criterion.definition") ProductRequirementsCriterion productRequirementsCriterion) {
        if (productRequirementsCriterion == null || productRequirementsCriterion.getEngineVersion() == null || productRequirementsCriterion.getEngineVersion().isBlank()) {
            return CriterionTestResult.builder().success(true).build();
        }
        return CriterionTestResult.builder().success(VersionHelper.isVersionLessThanOtherVersion(productRequirementsCriterion.getEngineVersion(), VersionHelper.getClassVersion())).build();
    }

    @Override
    @WithSpan(value="Criterion Service Exec")
    public CriterionTestResult process(@SpanAttribute(value="criterion.definition") ServiceCriterion serviceCriterion) {
        WmiCriterion serviceWmiCriterion;
        if (serviceCriterion == null) {
            return CriterionTestResult.error((Criterion)serviceCriterion, "Malformed Service criterion.");
        }
        IWinConfiguration winConfiguration = this.telemetryManager.getWinConfiguration();
        if (winConfiguration == null) {
            return CriterionTestResult.error((Criterion)serviceCriterion, NEITHER_WMI_NOR_WINRM_ERROR);
        }
        if (!DeviceKind.WINDOWS.equals((Object)this.telemetryManager.getHostConfiguration().getHostType())) {
            return CriterionTestResult.error((Criterion)serviceCriterion, "Host OS is not Windows. Skipping this test.");
        }
        if (!LocalOsHandler.isWindows()) {
            return CriterionTestResult.success(serviceCriterion, "Local OS is not Windows. Skipping this test.");
        }
        String serviceName = serviceCriterion.getName();
        if (serviceName.isBlank()) {
            return CriterionTestResult.success(serviceCriterion, "Service name is not specified. Skipping this test.");
        }
        String hostname = this.telemetryManager.getHostConfiguration().getHostname();
        CriterionTestResult wmiTestResult = this.wqlDetectionHelper.performDetectionTest(hostname, winConfiguration, serviceWmiCriterion = WmiCriterion.builder().query(String.format("SELECT Name, State FROM Win32_Service WHERE Name = '%s'", serviceName)).namespace(WMI_NAMESPACE).build());
        if (!wmiTestResult.isSuccess()) {
            return wmiTestResult;
        }
        String result = wmiTestResult.getResult();
        if (result != null && result.toLowerCase().contains(";running")) {
            return CriterionTestResult.success(serviceCriterion, String.format("The %s Windows Service is currently running.", serviceName));
        }
        return CriterionTestResult.failure(serviceWmiCriterion, String.format("The %s Windows Service is not reported as running:\n%s", serviceName, result));
    }

    private TestResult checkSNMPGetValue(String hostname, String oid, String result) {
        String message;
        boolean success = false;
        if (result == null) {
            message = String.format("Hostname %s - SNMP test failed - SNMP Get of %s was unsuccessful due to a null result", hostname, oid);
        } else if (result.isBlank()) {
            message = String.format("Hostname %s - SNMP test failed - SNMP Get of %s was unsuccessful due to an empty result.", hostname, oid);
        } else {
            message = String.format("Hostname %s - Successful SNMP Get of %s. Returned result: %s.", hostname, oid, result);
            success = true;
        }
        log.debug(message);
        return TestResult.builder().message(message).success(success).build();
    }

    private TestResult checkSNMPGetResult(String hostname, String oid, String expected, String result) {
        if (expected == null) {
            return this.checkSNMPGetValue(hostname, oid, result);
        }
        return this.checkSNMPGetExpectedValue(hostname, oid, expected, result);
    }

    private TestResult checkSNMPGetExpectedValue(String hostname, String oid, String expected, String result) {
        Object message;
        boolean success = false;
        Pattern pattern = Pattern.compile(PslUtils.psl2JavaRegex(expected), 10);
        if (result == null || !pattern.matcher(result).find()) {
            message = String.format("Hostname %s - SNMP test failed - SNMP Get of %s was successful but the value of the returned OID did not match with the expected result. ", hostname, oid);
            message = (String)message + String.format(EXPECTED_VALUE_RETURNED_VALUE, expected, result);
        } else {
            message = String.format("Hostname %s - Successful SNMP Get of %s. Returned result: %s", hostname, oid, result);
            success = true;
        }
        log.debug((String)message);
        return TestResult.builder().message((String)message).success(success).build();
    }

    @Override
    @WithSpan(value="Criterion SNMP Get Exec")
    public CriterionTestResult process(@SpanAttribute(value="criterion.definition") SnmpGetCriterion snmpGetCriterion) {
        String hostname = this.telemetryManager.getHostConfiguration().getHostname();
        if (snmpGetCriterion == null) {
            log.error("Hostname {} - Malformed SNMP Get criterion {}. Cannot process SNMP Get detection.", (Object)hostname, (Object)snmpGetCriterion);
            return CriterionTestResult.empty();
        }
        SnmpConfiguration protocol = (SnmpConfiguration)this.telemetryManager.getHostConfiguration().getConfigurations().get(SnmpConfiguration.class);
        if (protocol == null) {
            log.debug(SNMP_CREDENTIALS_NOT_CONFIGURED_MESSAGE, (Object)hostname, (Object)snmpGetCriterion);
            return CriterionTestResult.empty();
        }
        try {
            String result = this.clientsExecutor.executeSNMPGet(snmpGetCriterion.getOid(), protocol, hostname, false);
            TestResult testResult = this.checkSNMPGetResult(hostname, snmpGetCriterion.getOid(), snmpGetCriterion.getExpectedResult(), result);
            return CriterionTestResult.builder().result(result).success(testResult.isSuccess()).message(testResult.getMessage()).build();
        }
        catch (Exception e) {
            String message = String.format("Hostname %s - SNMP test failed - SNMP Get of %s was unsuccessful due to an exception. Message: %s", hostname, snmpGetCriterion.getOid(), e.getMessage());
            log.debug(message, (Throwable)e);
            return CriterionTestResult.builder().message(message).build();
        }
    }

    private TestResult checkSNMPGetNextValue(String hostname, String oid, String result) {
        String message;
        boolean success = false;
        if (result == null) {
            message = String.format("Hostname %s - SNMP test failed - SNMP GetNext of %s was unsuccessful due to a null result.", hostname, oid);
        } else if (result.isBlank()) {
            message = String.format("Hostname %s - SNMP test failed - SNMP GetNext of %s was unsuccessful due to an empty result.", hostname, oid);
        } else if (!result.startsWith(oid)) {
            message = String.format("Hostname %s - SNMP test failed - SNMP GetNext of %s was successful but the returned OID is not under the same tree. Returned OID: %s.", hostname, oid, result.split("\\s")[0]);
        } else {
            message = String.format(SNMP_GETNEXT_SUCCESSFUL_MESSAGE, hostname, oid, result);
            success = true;
        }
        log.debug(message);
        return TestResult.builder().message(message).success(success).build();
    }

    private TestResult checkSNMPGetNextExpectedValue(String hostname, String oid, String expected, String result) {
        Object message;
        boolean success = true;
        Matcher matcher = SNMP_GET_NEXT_VALUE_PATTERN.matcher(result);
        if (matcher.find()) {
            String value = matcher.group(1);
            Pattern pattern = Pattern.compile(PslUtils.psl2JavaRegex(expected), 10);
            if (!pattern.matcher(value).find()) {
                message = String.format("Hostname %s - SNMP test failed - SNMP GetNext of %s was successful but the value of the returned OID did not match with the expected result. ", hostname, oid);
                message = (String)message + String.format(EXPECTED_VALUE_RETURNED_VALUE, expected, value);
                success = false;
            } else {
                message = String.format(SNMP_GETNEXT_SUCCESSFUL_MESSAGE, hostname, oid, result);
            }
        } else {
            message = String.format("Hostname %s - SNMP test failed - SNMP GetNext of %s was successful but the value cannot be extracted. ", hostname, oid);
            message = (String)message + String.format("Returned result: %s.", result);
            success = false;
        }
        log.debug((String)message);
        return TestResult.builder().message((String)message).success(success).build();
    }

    private TestResult checkSNMPGetNextResult(String hostname, String oid, String expected, String result) {
        if (expected == null) {
            return this.checkSNMPGetNextValue(hostname, oid, result);
        }
        return this.checkSNMPGetNextExpectedValue(hostname, oid, expected, result);
    }

    @Override
    @WithSpan(value="Criterion SNMP GetNext Exec")
    public CriterionTestResult process(@SpanAttribute(value="criterion.definition") SnmpGetNextCriterion snmpGetNextCriterion) {
        String hostname = this.telemetryManager.getHostConfiguration().getHostname();
        if (snmpGetNextCriterion == null) {
            log.error("Hostname {} - Malformed SNMP GetNext criterion {}. Cannot process SNMP GetNext detection.", (Object)hostname, (Object)snmpGetNextCriterion);
            return CriterionTestResult.empty();
        }
        SnmpConfiguration snmpConfiguration = (SnmpConfiguration)this.telemetryManager.getHostConfiguration().getConfigurations().get(SnmpConfiguration.class);
        if (snmpConfiguration == null) {
            log.debug(SNMP_CREDENTIALS_NOT_CONFIGURED_MESSAGE, (Object)hostname, (Object)snmpGetNextCriterion);
            return CriterionTestResult.empty();
        }
        try {
            String result = this.clientsExecutor.executeSNMPGetNext(snmpGetNextCriterion.getOid(), snmpConfiguration, hostname, false);
            TestResult testResult = this.checkSNMPGetNextResult(hostname, snmpGetNextCriterion.getOid(), snmpGetNextCriterion.getExpectedResult(), result);
            return CriterionTestResult.builder().result(result).success(testResult.isSuccess()).message(testResult.getMessage()).build();
        }
        catch (Exception e) {
            String message = String.format("Hostname %s - SNMP test failed - SNMP GetNext of %s was unsuccessful due to an exception. Message: %s", hostname, snmpGetNextCriterion.getOid(), e.getMessage());
            log.debug(message, (Throwable)e);
            return CriterionTestResult.builder().message(message).build();
        }
    }

    @Override
    @WithSpan(value="Criterion WMI Exec")
    public CriterionTestResult process(@SpanAttribute(value="criterion.definition") WmiCriterion wmiCriterion) {
        if (wmiCriterion == null) {
            return CriterionTestResult.error((Criterion)wmiCriterion, "Malformed criterion. Cannot perform detection.");
        }
        String hostname = this.telemetryManager.getHostConfiguration().getHostname();
        IWinConfiguration winConfiguration = this.telemetryManager.getWinConfiguration();
        if (winConfiguration == null) {
            return CriterionTestResult.error((Criterion)wmiCriterion, NEITHER_WMI_NOR_WINRM_ERROR);
        }
        if ("automatic".equalsIgnoreCase(wmiCriterion.getNamespace())) {
            String cachedNamespace = this.telemetryManager.getHostProperties().getConnectorNamespace(this.connectorId).getAutomaticWmiNamespace();
            if (cachedNamespace == null) {
                return this.findNamespace(hostname, winConfiguration, wmiCriterion);
            }
            WmiCriterion cachedNamespaceCriterion = wmiCriterion.copy();
            cachedNamespaceCriterion.setNamespace(cachedNamespace);
            return this.wqlDetectionHelper.performDetectionTest(hostname, winConfiguration, cachedNamespaceCriterion);
        }
        return this.wqlDetectionHelper.performDetectionTest(hostname, winConfiguration, wmiCriterion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CriterionTestResult findNamespace(String hostname, IWinConfiguration winConfiguration, WqlCriterion wqlCriterion) {
        Set<String> possibleWmiNamespaces;
        Set<String> set = possibleWmiNamespaces = this.telemetryManager.getHostProperties().getPossibleWmiNamespaces();
        synchronized (set) {
            if (possibleWmiNamespaces.isEmpty()) {
                WqlDetectionHelper.PossibleNamespacesResult possibleWmiNamespacesResult = this.wqlDetectionHelper.findPossibleNamespaces(hostname, winConfiguration);
                if (!possibleWmiNamespacesResult.isSuccess()) {
                    return CriterionTestResult.error((Criterion)wqlCriterion, possibleWmiNamespacesResult.getErrorMessage());
                }
                possibleWmiNamespaces.clear();
                possibleWmiNamespaces.addAll(possibleWmiNamespacesResult.getPossibleNamespaces());
            }
        }
        WqlDetectionHelper.NamespaceResult namespaceResult = this.wqlDetectionHelper.detectNamespace(hostname, winConfiguration, wqlCriterion, Collections.unmodifiableSet(possibleWmiNamespaces));
        if (namespaceResult.getResult().isSuccess()) {
            if (wqlCriterion instanceof WmiCriterion) {
                this.telemetryManager.getHostProperties().getConnectorNamespace(this.connectorId).setAutomaticWmiNamespace(namespaceResult.getNamespace());
            } else {
                this.telemetryManager.getHostProperties().getConnectorNamespace(this.connectorId).setAutomaticWbemNamespace(namespaceResult.getNamespace());
            }
        }
        return namespaceResult.getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CriterionTestResult findNamespace(String hostname, WbemConfiguration wbemConfiguration, WbemCriterion wbemCriterion) {
        Set<String> possibleWbemNamespaces;
        Set<String> set = possibleWbemNamespaces = this.telemetryManager.getHostProperties().getPossibleWbemNamespaces();
        synchronized (set) {
            if (possibleWbemNamespaces.isEmpty()) {
                WqlDetectionHelper.PossibleNamespacesResult possibleWbemNamespacesResult = this.wqlDetectionHelper.findPossibleNamespaces(hostname, wbemConfiguration);
                if (!possibleWbemNamespacesResult.isSuccess()) {
                    return CriterionTestResult.error((Criterion)wbemCriterion, possibleWbemNamespacesResult.getErrorMessage());
                }
                possibleWbemNamespaces.clear();
                possibleWbemNamespaces.addAll(possibleWbemNamespacesResult.getPossibleNamespaces());
            }
        }
        WqlDetectionHelper.NamespaceResult namespaceResult = this.wqlDetectionHelper.detectNamespace(hostname, wbemConfiguration, wbemCriterion, Collections.unmodifiableSet(possibleWbemNamespaces));
        if (namespaceResult.getResult().isSuccess()) {
            this.telemetryManager.getHostProperties().getConnectorNamespace(this.connectorId).setAutomaticWbemNamespace(namespaceResult.getNamespace());
        }
        return namespaceResult.getResult();
    }

    @Override
    @WithSpan(value="Criterion WBEM Exec")
    public CriterionTestResult process(@SpanAttribute(value="criterion.definition") WbemCriterion wbemCriterion) {
        if (wbemCriterion == null) {
            return CriterionTestResult.error((Criterion)wbemCriterion, "Malformed criterion. Cannot perform detection.");
        }
        String hostname = this.telemetryManager.getHostConfiguration().getHostname();
        WbemConfiguration wbemConfiguration = (WbemConfiguration)this.telemetryManager.getHostConfiguration().getConfigurations().get(WbemConfiguration.class);
        if (wbemConfiguration == null) {
            return CriterionTestResult.error((Criterion)wbemCriterion, "The WBEM credentials are not configured for this host.");
        }
        if ("automatic".equalsIgnoreCase(wbemCriterion.getNamespace())) {
            String cachedNamespace = this.telemetryManager.getHostProperties().getConnectorNamespace(this.connectorId).getAutomaticWbemNamespace();
            if (cachedNamespace == null) {
                return this.findNamespace(hostname, wbemConfiguration, wbemCriterion);
            }
            WbemCriterion cachedNamespaceCriterion = wbemCriterion.copy();
            cachedNamespaceCriterion.setNamespace(cachedNamespace);
            return this.wqlDetectionHelper.performDetectionTest(hostname, wbemConfiguration, cachedNamespaceCriterion);
        }
        return this.wqlDetectionHelper.performDetectionTest(hostname, wbemConfiguration, wbemCriterion);
    }

    private CriterionTestResult checkHttpResult(String hostname, String result, String expectedResult) {
        Object message;
        boolean success = false;
        if (expectedResult == null) {
            if (result == null || result.isEmpty()) {
                message = String.format("Hostname %s - HTTP test failed - The HTTP test did not return any result.", hostname);
            } else {
                message = String.format(HTTP_TEST_SUCCESS, hostname, result);
                success = true;
            }
        } else {
            Pattern pattern = Pattern.compile(PslUtils.psl2JavaRegex(expectedResult), 2);
            if (result != null && pattern.matcher(result).find()) {
                message = String.format(HTTP_TEST_SUCCESS, hostname, result);
                success = true;
            } else {
                message = String.format("Hostname %s - HTTP test failed - The result (%s) returned by the HTTP test did not match the expected result (%s).", hostname, result, expectedResult);
                message = (String)message + String.format(EXPECTED_VALUE_RETURNED_VALUE, expectedResult, result);
            }
        }
        log.debug((String)message);
        return CriterionTestResult.builder().result(result).message((String)message).success(success).build();
    }

    @Generated
    public ClientsExecutor getClientsExecutor() {
        return this.clientsExecutor;
    }

    @Generated
    public TelemetryManager getTelemetryManager() {
        return this.telemetryManager;
    }

    @Generated
    public String getConnectorId() {
        return this.connectorId;
    }

    @Generated
    public WqlDetectionHelper getWqlDetectionHelper() {
        return this.wqlDetectionHelper;
    }

    @Generated
    public void setClientsExecutor(ClientsExecutor clientsExecutor) {
        this.clientsExecutor = clientsExecutor;
    }

    @Generated
    public void setTelemetryManager(TelemetryManager telemetryManager) {
        this.telemetryManager = telemetryManager;
    }

    @Generated
    public void setConnectorId(String connectorId) {
        this.connectorId = connectorId;
    }

    @Generated
    public void setWqlDetectionHelper(WqlDetectionHelper wqlDetectionHelper) {
        this.wqlDetectionHelper = wqlDetectionHelper;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CriterionProcessor)) {
            return false;
        }
        CriterionProcessor other = (CriterionProcessor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ClientsExecutor this$clientsExecutor = this.getClientsExecutor();
        ClientsExecutor other$clientsExecutor = other.getClientsExecutor();
        if (this$clientsExecutor == null ? other$clientsExecutor != null : !((Object)this$clientsExecutor).equals(other$clientsExecutor)) {
            return false;
        }
        TelemetryManager this$telemetryManager = this.getTelemetryManager();
        TelemetryManager other$telemetryManager = other.getTelemetryManager();
        if (this$telemetryManager == null ? other$telemetryManager != null : !((Object)this$telemetryManager).equals(other$telemetryManager)) {
            return false;
        }
        String this$connectorId = this.getConnectorId();
        String other$connectorId = other.getConnectorId();
        if (this$connectorId == null ? other$connectorId != null : !this$connectorId.equals(other$connectorId)) {
            return false;
        }
        WqlDetectionHelper this$wqlDetectionHelper = this.getWqlDetectionHelper();
        WqlDetectionHelper other$wqlDetectionHelper = other.getWqlDetectionHelper();
        return !(this$wqlDetectionHelper == null ? other$wqlDetectionHelper != null : !this$wqlDetectionHelper.equals(other$wqlDetectionHelper));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CriterionProcessor;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ClientsExecutor $clientsExecutor = this.getClientsExecutor();
        result = result * 59 + ($clientsExecutor == null ? 43 : ((Object)$clientsExecutor).hashCode());
        TelemetryManager $telemetryManager = this.getTelemetryManager();
        result = result * 59 + ($telemetryManager == null ? 43 : ((Object)$telemetryManager).hashCode());
        String $connectorId = this.getConnectorId();
        result = result * 59 + ($connectorId == null ? 43 : $connectorId.hashCode());
        WqlDetectionHelper $wqlDetectionHelper = this.getWqlDetectionHelper();
        result = result * 59 + ($wqlDetectionHelper == null ? 43 : $wqlDetectionHelper.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CriterionProcessor(clientsExecutor=" + String.valueOf(this.getClientsExecutor()) + ", telemetryManager=" + String.valueOf(this.getTelemetryManager()) + ", connectorId=" + this.getConnectorId() + ", wqlDetectionHelper=" + String.valueOf(this.getWqlDetectionHelper()) + ")";
    }

    @Generated
    public CriterionProcessor() {
    }

    public static class TestResult {
        private String message;
        private boolean success;
        private String csvTable;

        @Generated
        TestResult(String message, boolean success, String csvTable) {
            this.message = message;
            this.success = success;
            this.csvTable = csvTable;
        }

        @Generated
        public static TestResultBuilder builder() {
            return new TestResultBuilder();
        }

        @Generated
        public String getMessage() {
            return this.message;
        }

        @Generated
        public boolean isSuccess() {
            return this.success;
        }

        @Generated
        public String getCsvTable() {
            return this.csvTable;
        }

        @Generated
        public void setMessage(String message) {
            this.message = message;
        }

        @Generated
        public void setSuccess(boolean success) {
            this.success = success;
        }

        @Generated
        public void setCsvTable(String csvTable) {
            this.csvTable = csvTable;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TestResult)) {
                return false;
            }
            TestResult other = (TestResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isSuccess() != other.isSuccess()) {
                return false;
            }
            String this$message = this.getMessage();
            String other$message = other.getMessage();
            if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
                return false;
            }
            String this$csvTable = this.getCsvTable();
            String other$csvTable = other.getCsvTable();
            return !(this$csvTable == null ? other$csvTable != null : !this$csvTable.equals(other$csvTable));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TestResult;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isSuccess() ? 79 : 97);
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            String $csvTable = this.getCsvTable();
            result = result * 59 + ($csvTable == null ? 43 : $csvTable.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "CriterionProcessor.TestResult(message=" + this.getMessage() + ", success=" + this.isSuccess() + ", csvTable=" + this.getCsvTable() + ")";
        }

        @Generated
        public static class TestResultBuilder {
            @Generated
            private String message;
            @Generated
            private boolean success;
            @Generated
            private String csvTable;

            @Generated
            TestResultBuilder() {
            }

            @Generated
            public TestResultBuilder message(String message) {
                this.message = message;
                return this;
            }

            @Generated
            public TestResultBuilder success(boolean success) {
                this.success = success;
                return this;
            }

            @Generated
            public TestResultBuilder csvTable(String csvTable) {
                this.csvTable = csvTable;
                return this;
            }

            @Generated
            public TestResult build() {
                return new TestResult(this.message, this.success, this.csvTable);
            }

            @Generated
            public String toString() {
                return "CriterionProcessor.TestResult.TestResultBuilder(message=" + this.message + ", success=" + this.success + ", csvTable=" + this.csvTable + ")";
            }
        }
    }
}

