/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.strategy.detection;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.connector.model.Connector;
import org.sentrysoftware.metricshub.engine.connector.model.ConnectorStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectorStagingManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConnectorStagingManager.class);
    private static final Pattern CONFIGURED_CONNECTOR_PATTERN = Pattern.compile("^((?!-#)([#\\+-]?)|((-#)?))(.+)$");
    private static final Pattern INCLUDED_CONNECTORS_PATTERN = Pattern.compile("^(?![+-])(#?)(.+)$");
    private String hostname;
    private boolean isLoggingEnabled;

    private ConnectorStagingManager(String hostname, boolean isLoggingEnabled) {
        this.hostname = hostname;
        this.isLoggingEnabled = isLoggingEnabled;
    }

    public ConnectorStagingManager(String hostname) {
        this(hostname, true);
    }

    public ConnectorStagingManager() {
        this(null, false);
    }

    public StagedConnectorIdentifiers stage(@NonNull ConnectorStore connectorStore, Set<String> configuredConnectorDirectives) {
        if (connectorStore == null) {
            throw new IllegalArgumentException("connectorStore is marked non-null but is null");
        }
        Map<String, Connector> store = connectorStore.getStore();
        if (store == null || store.isEmpty()) {
            this.logIfEnabled(() -> log.error("Hostname {} - No connector available in the store. Detection will stop.", (Object)this.hostname));
            return StagedConnectorIdentifiers.empty();
        }
        Set<String> connectorIdentifiers = store.keySet();
        TreeSet<String> autoDetectionConnectorIds = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        TreeSet<String> forcedConnectorIds = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        TreeSet<String> excludedAutoDetectionConnectorIds = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        if (configuredConnectorDirectives == null || configuredConnectorDirectives.isEmpty()) {
            autoDetectionConnectorIds.addAll(connectorIdentifiers);
        } else {
            boolean isIncludedConnectors = configuredConnectorDirectives.stream().anyMatch(directive -> INCLUDED_CONNECTORS_PATTERN.matcher((CharSequence)directive).matches());
            for (String directive2 : configuredConnectorDirectives) {
                Matcher matcher = CONFIGURED_CONNECTOR_PATTERN.matcher(directive2);
                if (!matcher.matches()) continue;
                String prefix = matcher.group(1);
                String configuredConnectorIdOrTag = matcher.group(5);
                excludedAutoDetectionConnectorIds.addAll(this.stageConnectorIdsAndGetRemovals(store, autoDetectionConnectorIds, forcedConnectorIds, prefix, configuredConnectorIdOrTag, isIncludedConnectors));
            }
        }
        autoDetectionConnectorIds.removeAll(excludedAutoDetectionConnectorIds);
        return new StagedConnectorIdentifiers(autoDetectionConnectorIds, forcedConnectorIds);
    }

    private Set<String> stageConnectorIdsAndGetRemovals(Map<String, Connector> store, Set<String> autoDetectionConnectorIds, Set<String> forcedConnectorIds, String prefix, String configuredConnectorIdOrTag, boolean isIncludedConnectors) {
        if (prefix.isEmpty()) {
            this.addConnectorIdToSet(store, autoDetectionConnectorIds, configuredConnectorIdOrTag);
        } else if ("#".equals(prefix)) {
            autoDetectionConnectorIds.addAll(this.fetchConnectorIdsUsingPredicate(store, connectorEntry -> ((Connector)connectorEntry.getValue()).hasTag(configuredConnectorIdOrTag)));
        } else {
            if ("-#".equals(prefix)) {
                if (!isIncludedConnectors) {
                    autoDetectionConnectorIds.addAll(this.fetchConnectorIdsUsingPredicate(store, connectorEntry -> !((Connector)connectorEntry.getValue()).hasTag(configuredConnectorIdOrTag)));
                }
                return this.fetchConnectorIdsUsingPredicate(store, connectorEntry -> ((Connector)connectorEntry.getValue()).hasTag(configuredConnectorIdOrTag));
            }
            if ("+".equals(prefix)) {
                this.addConnectorIdToSet(store, forcedConnectorIds, configuredConnectorIdOrTag);
                return Set.of(configuredConnectorIdOrTag);
            }
            if ("-".equals(prefix)) {
                if (!isIncludedConnectors) {
                    autoDetectionConnectorIds.addAll(this.fetchConnectorIdsUsingPredicate(store, connectorEntry -> !((String)connectorEntry.getKey()).equalsIgnoreCase(configuredConnectorIdOrTag)));
                }
                return Set.of(configuredConnectorIdOrTag);
            }
        }
        return Collections.emptySet();
    }

    private Set<String> fetchConnectorIdsUsingPredicate(Map<String, Connector> store, Predicate<Map.Entry<String, Connector>> predicate) {
        return store.entrySet().stream().filter(predicate::test).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    private void addConnectorIdToSet(Map<String, Connector> store, Set<String> connectorSet, String connectorId) {
        if (store.containsKey(connectorId)) {
            connectorSet.add(connectorId);
        } else {
            this.logIfEnabled(() -> log.warn("Hostname {} - The connector associated with {} is not present in the store. Detection will skip this connector.", (Object)this.hostname, (Object)connectorId));
        }
    }

    private void logIfEnabled(LoggingTask loggingTask) {
        if (this.isLoggingEnabled) {
            loggingTask.log();
        }
    }

    @FunctionalInterface
    private static interface LoggingTask {
        public void log();
    }

    public static class StagedConnectorIdentifiers {
        private Set<String> autoDetectionConnectorIds;
        private Set<String> forcedConnectorIds;

        private static StagedConnectorIdentifiers empty() {
            return new StagedConnectorIdentifiers(Collections.emptySet(), Collections.emptySet());
        }

        public boolean isAutoDetectionStaged() {
            return !this.autoDetectionConnectorIds.isEmpty();
        }

        public boolean isForcedStaging() {
            return !this.forcedConnectorIds.isEmpty();
        }

        @Generated
        public Set<String> getAutoDetectionConnectorIds() {
            return this.autoDetectionConnectorIds;
        }

        @Generated
        public Set<String> getForcedConnectorIds() {
            return this.forcedConnectorIds;
        }

        @Generated
        public void setAutoDetectionConnectorIds(Set<String> autoDetectionConnectorIds) {
            this.autoDetectionConnectorIds = autoDetectionConnectorIds;
        }

        @Generated
        public void setForcedConnectorIds(Set<String> forcedConnectorIds) {
            this.forcedConnectorIds = forcedConnectorIds;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StagedConnectorIdentifiers)) {
                return false;
            }
            StagedConnectorIdentifiers other = (StagedConnectorIdentifiers)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Set<String> this$autoDetectionConnectorIds = this.getAutoDetectionConnectorIds();
            Set<String> other$autoDetectionConnectorIds = other.getAutoDetectionConnectorIds();
            if (this$autoDetectionConnectorIds == null ? other$autoDetectionConnectorIds != null : !((Object)this$autoDetectionConnectorIds).equals(other$autoDetectionConnectorIds)) {
                return false;
            }
            Set<String> this$forcedConnectorIds = this.getForcedConnectorIds();
            Set<String> other$forcedConnectorIds = other.getForcedConnectorIds();
            return !(this$forcedConnectorIds == null ? other$forcedConnectorIds != null : !((Object)this$forcedConnectorIds).equals(other$forcedConnectorIds));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof StagedConnectorIdentifiers;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Set<String> $autoDetectionConnectorIds = this.getAutoDetectionConnectorIds();
            result = result * 59 + ($autoDetectionConnectorIds == null ? 43 : ((Object)$autoDetectionConnectorIds).hashCode());
            Set<String> $forcedConnectorIds = this.getForcedConnectorIds();
            result = result * 59 + ($forcedConnectorIds == null ? 43 : ((Object)$forcedConnectorIds).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ConnectorStagingManager.StagedConnectorIdentifiers(autoDetectionConnectorIds=" + String.valueOf(this.getAutoDetectionConnectorIds()) + ", forcedConnectorIds=" + String.valueOf(this.getForcedConnectorIds()) + ")";
        }

        @Generated
        public StagedConnectorIdentifiers(Set<String> autoDetectionConnectorIds, Set<String> forcedConnectorIds) {
            this.autoDetectionConnectorIds = autoDetectionConnectorIds;
            this.forcedConnectorIds = forcedConnectorIds;
        }
    }
}

