/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.strategy.detection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.client.ClientsExecutor;
import org.sentrysoftware.metricshub.engine.configuration.HostConfiguration;
import org.sentrysoftware.metricshub.engine.connector.model.Connector;
import org.sentrysoftware.metricshub.engine.connector.model.ConnectorStore;
import org.sentrysoftware.metricshub.engine.connector.model.common.DeviceKind;
import org.sentrysoftware.metricshub.engine.connector.model.identity.ConnectionType;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.Source;
import org.sentrysoftware.metricshub.engine.strategy.detection.AbstractConnectorProcessor;
import org.sentrysoftware.metricshub.engine.strategy.detection.ConnectorTestResult;
import org.sentrysoftware.metricshub.engine.telemetry.TelemetryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutomaticDetection
extends AbstractConnectorProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AutomaticDetection.class);

    public AutomaticDetection(@NonNull TelemetryManager telemetryManager, @NonNull ClientsExecutor clientsExecutor, @NonNull Set<String> connectorIds) {
        super(telemetryManager, clientsExecutor, connectorIds);
        if (telemetryManager == null) {
            throw new IllegalArgumentException("telemetryManager is marked non-null but is null");
        }
        if (clientsExecutor == null) {
            throw new IllegalArgumentException("clientsExecutor is marked non-null but is null");
        }
        if (connectorIds == null) {
            throw new IllegalArgumentException("connectorIds is marked non-null but is null");
        }
    }

    @Override
    public List<ConnectorTestResult> run() {
        HostConfiguration hostConfiguration = this.telemetryManager.getHostConfiguration();
        if (hostConfiguration == null) {
            log.error("Empty host configuration, aborting detection job.");
            return Collections.emptyList();
        }
        String hostname = hostConfiguration.getHostname();
        log.debug("Hostname {} - Start automatic detection.", (Object)hostname);
        ConnectorStore telemetryManagerConnectorStore = this.telemetryManager.getConnectorStore();
        if (telemetryManagerConnectorStore == null) {
            log.error("Hostname {} - No connectorStore found. Stopping detection operation.", (Object)hostname);
            return Collections.emptyList();
        }
        Map<String, Connector> connectorStore = telemetryManagerConnectorStore.getStore();
        if (connectorStore == null) {
            log.error("Hostname {} - No connectorStore found. Stopping detection operation.", (Object)hostname);
            return Collections.emptyList();
        }
        DeviceKind deviceKind = hostConfiguration.getHostType();
        boolean isLocalhost = this.telemetryManager.getHostProperties().isLocalhost();
        Set<Class<? extends Source>> acceptedSources = hostConfiguration.determineAcceptedSources(isLocalhost);
        if (connectorStore.isEmpty()) {
            log.error("Hostname {} - No connector to detect. Stopping detection operation.", (Object)hostname);
            return new ArrayList<ConnectorTestResult>();
        }
        List connectors = connectorStore.entrySet().stream().filter(connectorEntry -> this.connectorIds.contains(connectorEntry.getKey())).map(Map.Entry::getValue).filter(connector -> connector.getConnectorIdentity().getDetection() != null).filter(connector -> !connector.getConnectorIdentity().getDetection().isDisableAutoDetection()).filter(connector -> connector.getConnectorIdentity().getDetection().getAppliesTo().contains((Object)deviceKind)).filter(connector -> this.hasSameConnectionTypeAsHost((Connector)connector, isLocalhost)).filter(connector -> this.hasMatchingSourceTypeInAcceptedSources(connector.getSourceTypes(), acceptedSources)).collect(Collectors.toList());
        HashSet supersedes = new HashSet();
        List<ConnectorTestResult> connectorTestResults = this.runAllConnectorsDetectionCriteria(connectors.stream(), hostConfiguration).filter(ConnectorTestResult::isSuccess).collect(Collectors.toList());
        connectorTestResults.forEach(connectorTestResult -> this.updateSupersedes(supersedes, (ConnectorTestResult)connectorTestResult));
        connectorTestResults = connectorTestResults.stream().filter(connectorTestResult -> !supersedes.contains(connectorTestResult.getConnector().getConnectorIdentity().getCompiledFilename().toLowerCase())).collect(Collectors.toList());
        this.filterLastResortConnectors(connectorTestResults, hostname);
        return connectorTestResults;
    }

    private boolean hasSameConnectionTypeAsHost(Connector connector, boolean isLocalhost) {
        return connector.getConnectorIdentity().getDetection().getConnectionTypes().contains((Object)(isLocalhost ? ConnectionType.LOCAL : ConnectionType.REMOTE));
    }

    private boolean hasMatchingSourceTypeInAcceptedSources(Set<Class<? extends Source>> connectorSourceTypes, Set<Class<? extends Source>> acceptedSources) {
        return acceptedSources.stream().anyMatch(connectorSourceTypes::contains);
    }

    @Generated
    public AutomaticDetection() {
    }
}

