/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.connector.parser;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.ArrayList;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.connector.parser.AbstractJsonNodeUpdater;

public class JsonNodeUpdater
extends AbstractJsonNodeUpdater {
    @NonNull
    private final UnaryOperator<String> updater;

    public JsonNodeUpdater(@NonNull JsonNode jsonNode, @NonNull Predicate<String> predicate, @NonNull UnaryOperator<String> updater) {
        super(jsonNode, predicate);
        if (jsonNode == null) {
            throw new IllegalArgumentException("jsonNode is marked non-null but is null");
        }
        if (predicate == null) {
            throw new IllegalArgumentException("predicate is marked non-null but is null");
        }
        if (updater == null) {
            throw new IllegalArgumentException("updater is marked non-null but is null");
        }
        this.updater = updater;
    }

    @Override
    public void update() {
        this.update(this.jsonNode);
    }

    private void update(JsonNode node) {
        block6: {
            block5: {
                if (node == null) {
                    return;
                }
                if (!node.isObject()) break block5;
                ArrayList fieldNames = new ArrayList(node.size());
                node.fieldNames().forEachRemaining(fieldNames::add);
                for (String fieldName : fieldNames) {
                    JsonNode child = node.get(fieldName);
                    if (child.isContainerNode()) {
                        this.update(child);
                        continue;
                    }
                    if (child.isNull()) continue;
                    String oldValue = child.asText();
                    this.runUpdate(() -> ((ObjectNode)node).set(fieldName, new TextNode((String)this.updater.apply(oldValue))), oldValue);
                }
                break block6;
            }
            if (!node.isArray()) break block6;
            for (int i = 0; i < node.size(); ++i) {
                JsonNode child = node.get(i);
                if (child.isContainerNode()) {
                    this.update(child);
                    continue;
                }
                if (child.isNull()) continue;
                String oldValue = child.asText();
                int index = i;
                this.runUpdate(() -> ((ArrayNode)node).set(index, new TextNode((String)this.updater.apply(oldValue))), oldValue);
            }
        }
    }

    @Generated
    public static JsonNodeUpdaterBuilder jsonNodeUpdaterBuilder() {
        return new JsonNodeUpdaterBuilder();
    }

    @NonNull
    @Generated
    public UnaryOperator<String> getUpdater() {
        return this.updater;
    }

    @Override
    @Generated
    public String toString() {
        return "JsonNodeUpdater(updater=" + String.valueOf(this.getUpdater()) + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JsonNodeUpdater)) {
            return false;
        }
        JsonNodeUpdater other = (JsonNodeUpdater)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UnaryOperator<String> this$updater = this.getUpdater();
        UnaryOperator<String> other$updater = other.getUpdater();
        return !(this$updater == null ? other$updater != null : !this$updater.equals(other$updater));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof JsonNodeUpdater;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        UnaryOperator<String> $updater = this.getUpdater();
        result = result * 59 + ($updater == null ? 43 : $updater.hashCode());
        return result;
    }

    @Generated
    public static class JsonNodeUpdaterBuilder {
        @Generated
        private JsonNode jsonNode;
        @Generated
        private Predicate<String> predicate;
        @Generated
        private UnaryOperator<String> updater;

        @Generated
        JsonNodeUpdaterBuilder() {
        }

        @Generated
        public JsonNodeUpdaterBuilder withJsonNode(@NonNull JsonNode jsonNode) {
            if (jsonNode == null) {
                throw new IllegalArgumentException("jsonNode is marked non-null but is null");
            }
            this.jsonNode = jsonNode;
            return this;
        }

        @Generated
        public JsonNodeUpdaterBuilder withPredicate(@NonNull Predicate<String> predicate) {
            if (predicate == null) {
                throw new IllegalArgumentException("predicate is marked non-null but is null");
            }
            this.predicate = predicate;
            return this;
        }

        @Generated
        public JsonNodeUpdaterBuilder withUpdater(@NonNull UnaryOperator<String> updater) {
            if (updater == null) {
                throw new IllegalArgumentException("updater is marked non-null but is null");
            }
            this.updater = updater;
            return this;
        }

        @Generated
        public JsonNodeUpdater build() {
            return new JsonNodeUpdater(this.jsonNode, this.predicate, this.updater);
        }

        @Generated
        public String toString() {
            return "JsonNodeUpdater.JsonNodeUpdaterBuilder(jsonNode=" + String.valueOf(this.jsonNode) + ", predicate=" + String.valueOf(this.predicate) + ", updater=" + String.valueOf(this.updater) + ")";
        }
    }
}

