/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.configuration;

import java.io.File;
import java.util.Arrays;
import java.util.Set;
import lombok.Generated;
import org.sentrysoftware.metricshub.engine.configuration.OsCommandConfiguration;

public class SshConfiguration
extends OsCommandConfiguration {
    private String username;
    private char[] password;
    private File privateKey;

    public SshConfiguration(boolean useSudo, Set<String> useSudoCommands, String sudoCommand, Long timeout, String username, char[] password, File privateKey) {
        super(useSudo, useSudoCommands, sudoCommand, timeout);
        this.username = username;
        this.password = password;
        this.privateKey = privateKey;
    }

    @Override
    public String toString() {
        Object description = "SSH";
        if (this.username != null) {
            description = (String)description + " as " + this.username;
        }
        return description;
    }

    @Generated
    public static SshConfigurationBuilder sshConfigurationBuilder() {
        return new SshConfigurationBuilder();
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public char[] getPassword() {
        return this.password;
    }

    @Generated
    public File getPrivateKey() {
        return this.privateKey;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setPassword(char[] password) {
        this.password = password;
    }

    @Generated
    public void setPrivateKey(File privateKey) {
        this.privateKey = privateKey;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SshConfiguration)) {
            return false;
        }
        SshConfiguration other = (SshConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        if (!Arrays.equals(this.getPassword(), other.getPassword())) {
            return false;
        }
        File this$privateKey = this.getPrivateKey();
        File other$privateKey = other.getPrivateKey();
        return !(this$privateKey == null ? other$privateKey != null : !((Object)this$privateKey).equals(other$privateKey));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SshConfiguration;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        result = result * 59 + Arrays.hashCode(this.getPassword());
        File $privateKey = this.getPrivateKey();
        result = result * 59 + ($privateKey == null ? 43 : ((Object)$privateKey).hashCode());
        return result;
    }

    @Generated
    public SshConfiguration() {
    }

    @Generated
    public static class SshConfigurationBuilder {
        @Generated
        private boolean useSudo;
        @Generated
        private Set<String> useSudoCommands;
        @Generated
        private String sudoCommand;
        @Generated
        private Long timeout;
        @Generated
        private String username;
        @Generated
        private char[] password;
        @Generated
        private File privateKey;

        @Generated
        SshConfigurationBuilder() {
        }

        @Generated
        public SshConfigurationBuilder useSudo(boolean useSudo) {
            this.useSudo = useSudo;
            return this;
        }

        @Generated
        public SshConfigurationBuilder useSudoCommands(Set<String> useSudoCommands) {
            this.useSudoCommands = useSudoCommands;
            return this;
        }

        @Generated
        public SshConfigurationBuilder sudoCommand(String sudoCommand) {
            this.sudoCommand = sudoCommand;
            return this;
        }

        @Generated
        public SshConfigurationBuilder timeout(Long timeout) {
            this.timeout = timeout;
            return this;
        }

        @Generated
        public SshConfigurationBuilder username(String username) {
            this.username = username;
            return this;
        }

        @Generated
        public SshConfigurationBuilder password(char[] password) {
            this.password = password;
            return this;
        }

        @Generated
        public SshConfigurationBuilder privateKey(File privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        @Generated
        public SshConfiguration build() {
            return new SshConfiguration(this.useSudo, this.useSudoCommands, this.sudoCommand, this.timeout, this.username, this.password, this.privateKey);
        }

        @Generated
        public String toString() {
            return "SshConfiguration.SshConfigurationBuilder(useSudo=" + this.useSudo + ", useSudoCommands=" + String.valueOf(this.useSudoCommands) + ", sudoCommand=" + this.sudoCommand + ", timeout=" + this.timeout + ", username=" + this.username + ", password=" + Arrays.toString(this.password) + ", privateKey=" + String.valueOf(this.privateKey) + ")";
        }
    }
}

