/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.common.helpers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.sentrysoftware.metricshub.engine.common.helpers.TableHeader;
import org.sentrysoftware.metricshub.engine.common.helpers.TextDataType;
import org.springframework.util.Assert;

public class TextTableHelper {
    private static final String N_A = "N/A";
    private static final int PADDING_SIZE = 1;
    private static final String NEW_LINE = "\n";
    private static final String TABLE_JOINT_SYMBOL = "+";
    private static final String TABLE_VALUE_SPLIT_SYMBOL = "|";
    private static final String TABLE_BORDER_SYMBOL = "-";

    private TextTableHelper() {
    }

    public static String generateTextTable(List<List<String>> rows) {
        if (rows == null || rows.isEmpty()) {
            return "<empty>";
        }
        List longestRow = null;
        for (List list : rows) {
            longestRow = longestRow == null || list != null && list.size() > longestRow.size() ? list : longestRow;
        }
        if (longestRow == null || longestRow.isEmpty()) {
            return "<empty>";
        }
        List<TableHeader> headers = IntStream.range(1, longestRow.size() + 1).mapToObj(index -> new TableHeader(String.format("Column %d", index), TextDataType.STRING)).collect(Collectors.toList());
        return TextTableHelper.generateTextTable(headers, rows);
    }

    public static String generateTextTable(String semiColonSeparatedColumns, List<List<String>> rows) {
        return semiColonSeparatedColumns == null || semiColonSeparatedColumns.isBlank() ? TextTableHelper.generateTextTable(rows) : TextTableHelper.generateTextTable(semiColonSeparatedColumns.split(";"), rows);
    }

    public static String generateTextTable(String[] columns, List<List<String>> rows) {
        if (columns == null || columns.length == 0) {
            return TextTableHelper.generateTextTable(rows);
        }
        List<TableHeader> headers = Arrays.stream(columns).map(columnName -> new TableHeader((String)columnName, TextDataType.STRING)).collect(Collectors.toList());
        return TextTableHelper.generateTextTable(headers, rows);
    }

    public static String generateTextTable(Collection<String> columns, List<List<String>> rows) {
        if (columns == null || columns.isEmpty()) {
            return TextTableHelper.generateTextTable(rows);
        }
        List<TableHeader> headers = columns.stream().map(columnName -> new TableHeader((String)columnName, TextDataType.STRING)).collect(Collectors.toList());
        return TextTableHelper.generateTextTable(headers, rows);
    }

    public static String generateTextTable(List<TableHeader> headers, List<List<String>> rows) {
        TextTableHelper.checkArguments(headers, rows);
        rows = TextTableHelper.cleanRows(rows, headers.size());
        StringBuilder stringBuilder = new StringBuilder();
        Map<Integer, Integer> columnMaxWidthMapping = TextTableHelper.getMaximumWidthOfTable(headers, rows);
        TextTableHelper.createRowLine(stringBuilder, headers.size(), columnMaxWidthMapping);
        stringBuilder.append(NEW_LINE);
        for (int headerIndex = 0; headerIndex < headers.size(); ++headerIndex) {
            TextTableHelper.fillCell(stringBuilder, headers.get(headerIndex).getTitle(), headerIndex, columnMaxWidthMapping, headers.get(headerIndex).getType());
        }
        stringBuilder.append(NEW_LINE);
        TextTableHelper.createRowLine(stringBuilder, headers.size(), columnMaxWidthMapping);
        for (List<String> row : rows) {
            stringBuilder.append(NEW_LINE);
            for (int cellIndex = 0; cellIndex < row.size(); ++cellIndex) {
                TextTableHelper.fillCell(stringBuilder, row.get(cellIndex), cellIndex, columnMaxWidthMapping, headers.get(cellIndex).getType());
            }
        }
        stringBuilder.append(NEW_LINE);
        TextTableHelper.createRowLine(stringBuilder, headers.size(), columnMaxWidthMapping);
        return stringBuilder.toString();
    }

    private static List<List<String>> cleanRows(List<List<String>> rows, int headersSize) {
        return rows.stream().filter(Objects::nonNull).map(row -> TextTableHelper.cleanRow(row, headersSize)).collect(Collectors.toList());
    }

    private static List<String> cleanRow(List<String> row, int headersSize) {
        ArrayList<String> result = new ArrayList<String>(row);
        Collections.replaceAll(result, null, N_A);
        if (result.size() < headersSize) {
            return Stream.concat(result.stream(), Stream.generate(() -> N_A).limit((long)headersSize - (long)result.size())).collect(Collectors.toList());
        }
        if (result.size() > headersSize) {
            return result.stream().limit(headersSize).collect(Collectors.toList());
        }
        return result;
    }

    private static void checkArguments(List<TableHeader> headers, List<List<String>> rows) {
        Assert.notNull(headers, "headers cannot be null.");
        Assert.notNull(rows, "rows cannot be null.");
        int indexOfNull = headers.indexOf(null);
        Assert.isTrue(indexOfNull == -1, () -> String.format("Header at index '%d' cannot be null.", indexOfNull));
    }

    private static void createRowLine(StringBuilder stringBuilder, int headersSize, Map<Integer, Integer> columnMaxWidthMapping) {
        for (int i = 0; i < headersSize; ++i) {
            if (i == 0) {
                stringBuilder.append(TABLE_JOINT_SYMBOL);
            }
            stringBuilder.append(TABLE_BORDER_SYMBOL.repeat(columnMaxWidthMapping.get(i) + 2));
            stringBuilder.append(TABLE_JOINT_SYMBOL);
        }
    }

    private static Map<Integer, Integer> getMaximumWidthOfTable(List<TableHeader> headers, List<List<String>> rows) {
        HashMap<Integer, Integer> columnMaxWidthMapping = new HashMap<Integer, Integer>();
        for (int columnIndex = 0; columnIndex < headers.size(); ++columnIndex) {
            columnMaxWidthMapping.put(columnIndex, headers.get(columnIndex).getTitle().length());
        }
        for (List<String> row : rows) {
            for (int columnIndex = 0; columnIndex < row.size(); ++columnIndex) {
                if (row.get(columnIndex).length() <= (Integer)columnMaxWidthMapping.get(columnIndex)) continue;
                columnMaxWidthMapping.put(columnIndex, row.get(columnIndex).length());
            }
        }
        return columnMaxWidthMapping;
    }

    private static int getOptimumCellPadding(int cellIndex, int dataLength, Map<Integer, Integer> columnMaxWidthMapping) {
        int cellPaddingSize = 1;
        if (dataLength < columnMaxWidthMapping.get(cellIndex)) {
            cellPaddingSize = 1 + columnMaxWidthMapping.get(cellIndex) - dataLength;
        }
        return cellPaddingSize;
    }

    private static void fillSpace(StringBuilder stringBuilder, int times) {
        stringBuilder.append(" ".repeat(times));
    }

    private static void fillCell(StringBuilder stringBuilder, String cell, int cellIndex, Map<Integer, Integer> columnMaxWidthMapping, TextDataType textDataType) {
        int cellPaddingSize = TextTableHelper.getOptimumCellPadding(cellIndex, cell.length(), columnMaxWidthMapping);
        if (cellIndex == 0) {
            stringBuilder.append(TABLE_VALUE_SPLIT_SYMBOL);
        }
        int rightPadding = 1;
        int leftPadding = 1;
        if (TextDataType.STRING.equals((Object)textDataType)) {
            rightPadding = cellPaddingSize;
        } else if (TextDataType.NUMBER.equals((Object)textDataType)) {
            leftPadding = cellPaddingSize;
        } else {
            throw new IllegalStateException(String.format("Unsupported TextDataType: %s", textDataType.name()));
        }
        TextTableHelper.fillSpace(stringBuilder, leftPadding);
        stringBuilder.append(cell);
        TextTableHelper.fillSpace(stringBuilder, rightPadding);
        stringBuilder.append(TABLE_VALUE_SPLIT_SYMBOL);
    }
}

