/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.client.http;

import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.client.http.Body;
import org.sentrysoftware.metricshub.engine.client.http.EmbeddedFileBody;
import org.sentrysoftware.metricshub.engine.client.http.EmbeddedFileHeader;
import org.sentrysoftware.metricshub.engine.client.http.Header;
import org.sentrysoftware.metricshub.engine.client.http.StringBody;
import org.sentrysoftware.metricshub.engine.client.http.StringHeader;
import org.sentrysoftware.metricshub.engine.configuration.HttpConfiguration;
import org.sentrysoftware.metricshub.engine.connector.model.common.EmbeddedFile;
import org.sentrysoftware.metricshub.engine.connector.model.common.ResultContent;
import org.sentrysoftware.metricshub.engine.strategy.utils.EmbeddedFileHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequest {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpRequest.class);
    @NonNull
    private HttpConfiguration httpConfiguration;
    @NonNull
    private String hostname;
    private String method;
    private String path;
    private String url;
    private Header header;
    private Body body;
    @NonNull
    private ResultContent resultContent;
    private String authenticationToken;

    @Generated
    private static ResultContent $default$resultContent() {
        return ResultContent.BODY;
    }

    @Generated
    public static HttpRequestBuilder builder() {
        return new HttpRequestBuilder();
    }

    @NonNull
    @Generated
    public HttpConfiguration getHttpConfiguration() {
        return this.httpConfiguration;
    }

    @NonNull
    @Generated
    public String getHostname() {
        return this.hostname;
    }

    @Generated
    public String getMethod() {
        return this.method;
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public Header getHeader() {
        return this.header;
    }

    @Generated
    public Body getBody() {
        return this.body;
    }

    @NonNull
    @Generated
    public ResultContent getResultContent() {
        return this.resultContent;
    }

    @Generated
    public String getAuthenticationToken() {
        return this.authenticationToken;
    }

    @Generated
    public void setHttpConfiguration(@NonNull HttpConfiguration httpConfiguration) {
        if (httpConfiguration == null) {
            throw new IllegalArgumentException("httpConfiguration is marked non-null but is null");
        }
        this.httpConfiguration = httpConfiguration;
    }

    @Generated
    public void setHostname(@NonNull String hostname) {
        if (hostname == null) {
            throw new IllegalArgumentException("hostname is marked non-null but is null");
        }
        this.hostname = hostname;
    }

    @Generated
    public void setMethod(String method) {
        this.method = method;
    }

    @Generated
    public void setPath(String path) {
        this.path = path;
    }

    @Generated
    public void setUrl(String url) {
        this.url = url;
    }

    @Generated
    public void setHeader(Header header) {
        this.header = header;
    }

    @Generated
    public void setBody(Body body) {
        this.body = body;
    }

    @Generated
    public void setResultContent(@NonNull ResultContent resultContent) {
        if (resultContent == null) {
            throw new IllegalArgumentException("resultContent is marked non-null but is null");
        }
        this.resultContent = resultContent;
    }

    @Generated
    public void setAuthenticationToken(String authenticationToken) {
        this.authenticationToken = authenticationToken;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpRequest)) {
            return false;
        }
        HttpRequest other = (HttpRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        HttpConfiguration this$httpConfiguration = this.getHttpConfiguration();
        HttpConfiguration other$httpConfiguration = other.getHttpConfiguration();
        if (this$httpConfiguration == null ? other$httpConfiguration != null : !((Object)this$httpConfiguration).equals(other$httpConfiguration)) {
            return false;
        }
        String this$hostname = this.getHostname();
        String other$hostname = other.getHostname();
        if (this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname)) {
            return false;
        }
        String this$method = this.getMethod();
        String other$method = other.getMethod();
        if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        Header this$header = this.getHeader();
        Header other$header = other.getHeader();
        if (this$header == null ? other$header != null : !this$header.equals(other$header)) {
            return false;
        }
        Body this$body = this.getBody();
        Body other$body = other.getBody();
        if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
            return false;
        }
        ResultContent this$resultContent = this.getResultContent();
        ResultContent other$resultContent = other.getResultContent();
        if (this$resultContent == null ? other$resultContent != null : !((Object)((Object)this$resultContent)).equals((Object)other$resultContent)) {
            return false;
        }
        String this$authenticationToken = this.getAuthenticationToken();
        String other$authenticationToken = other.getAuthenticationToken();
        return !(this$authenticationToken == null ? other$authenticationToken != null : !this$authenticationToken.equals(other$authenticationToken));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HttpRequest;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        HttpConfiguration $httpConfiguration = this.getHttpConfiguration();
        result = result * 59 + ($httpConfiguration == null ? 43 : ((Object)$httpConfiguration).hashCode());
        String $hostname = this.getHostname();
        result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
        String $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : $method.hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        Header $header = this.getHeader();
        result = result * 59 + ($header == null ? 43 : $header.hashCode());
        Body $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : $body.hashCode());
        ResultContent $resultContent = this.getResultContent();
        result = result * 59 + ($resultContent == null ? 43 : ((Object)((Object)$resultContent)).hashCode());
        String $authenticationToken = this.getAuthenticationToken();
        result = result * 59 + ($authenticationToken == null ? 43 : $authenticationToken.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "HttpRequest(httpConfiguration=" + String.valueOf(this.getHttpConfiguration()) + ", hostname=" + this.getHostname() + ", method=" + this.getMethod() + ", path=" + this.getPath() + ", url=" + this.getUrl() + ", header=" + String.valueOf(this.getHeader()) + ", body=" + String.valueOf(this.getBody()) + ", resultContent=" + String.valueOf((Object)this.getResultContent()) + ", authenticationToken=" + this.getAuthenticationToken() + ")";
    }

    @Generated
    public HttpRequest(@NonNull HttpConfiguration httpConfiguration, @NonNull String hostname, String method, String path, String url, Header header, Body body, @NonNull ResultContent resultContent, String authenticationToken) {
        if (httpConfiguration == null) {
            throw new IllegalArgumentException("httpConfiguration is marked non-null but is null");
        }
        if (hostname == null) {
            throw new IllegalArgumentException("hostname is marked non-null but is null");
        }
        if (resultContent == null) {
            throw new IllegalArgumentException("resultContent is marked non-null but is null");
        }
        this.httpConfiguration = httpConfiguration;
        this.hostname = hostname;
        this.method = method;
        this.path = path;
        this.url = url;
        this.header = header;
        this.body = body;
        this.resultContent = resultContent;
        this.authenticationToken = authenticationToken;
    }

    @Generated
    public HttpRequest() {
        this.resultContent = HttpRequest.$default$resultContent();
    }

    public static class HttpRequestBuilder {
        @Generated
        private HttpConfiguration httpConfiguration;
        @Generated
        private String hostname;
        @Generated
        private String method;
        @Generated
        private String path;
        @Generated
        private String url;
        @Generated
        private Header header;
        @Generated
        private Body body;
        @Generated
        private boolean resultContent$set;
        @Generated
        private ResultContent resultContent$value;
        @Generated
        private String authenticationToken;

        public HttpRequestBuilder header(String value, String connectorId, String hostname) throws IOException {
            if (value != null) {
                Optional<EmbeddedFile> maybeEmbeddedFile = HttpRequestBuilder.getHttpEmbeddedFile(value, "header", connectorId, hostname);
                this.header = maybeEmbeddedFile.isPresent() ? new EmbeddedFileHeader(maybeEmbeddedFile.get()) : new StringHeader(value);
            }
            return this;
        }

        public HttpRequestBuilder body(String value, String connectorId, String hostname) throws IOException {
            if (value != null) {
                Optional<EmbeddedFile> maybeEmbeddedFile = HttpRequestBuilder.getHttpEmbeddedFile(value, "body", connectorId, hostname);
                this.body = maybeEmbeddedFile.isPresent() ? new EmbeddedFileBody(maybeEmbeddedFile.get()) : new StringBody(value);
            }
            return this;
        }

        public static Optional<EmbeddedFile> getHttpEmbeddedFile(String value, String context, String connectorId, String hostname) throws IOException {
            Map<String, EmbeddedFile> embeddedFiles = EmbeddedFileHelper.findEmbeddedFiles(value);
            if (embeddedFiles.size() > 1) {
                String message = String.format("Hostname %s - Many embedded files are referenced in HTTP %s '%s'. Connector: %s.", hostname, context, value, connectorId);
                log.error(message);
                throw new IllegalStateException(hostname);
            }
            return embeddedFiles.values().stream().findAny();
        }

        @Generated
        HttpRequestBuilder() {
        }

        @Generated
        public HttpRequestBuilder httpConfiguration(@NonNull HttpConfiguration httpConfiguration) {
            if (httpConfiguration == null) {
                throw new IllegalArgumentException("httpConfiguration is marked non-null but is null");
            }
            this.httpConfiguration = httpConfiguration;
            return this;
        }

        @Generated
        public HttpRequestBuilder hostname(@NonNull String hostname) {
            if (hostname == null) {
                throw new IllegalArgumentException("hostname is marked non-null but is null");
            }
            this.hostname = hostname;
            return this;
        }

        @Generated
        public HttpRequestBuilder method(String method) {
            this.method = method;
            return this;
        }

        @Generated
        public HttpRequestBuilder path(String path) {
            this.path = path;
            return this;
        }

        @Generated
        public HttpRequestBuilder url(String url) {
            this.url = url;
            return this;
        }

        @Generated
        public HttpRequestBuilder resultContent(@NonNull ResultContent resultContent) {
            if (resultContent == null) {
                throw new IllegalArgumentException("resultContent is marked non-null but is null");
            }
            this.resultContent$value = resultContent;
            this.resultContent$set = true;
            return this;
        }

        @Generated
        public HttpRequestBuilder authenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
            return this;
        }

        @Generated
        public HttpRequest build() {
            ResultContent resultContent$value = this.resultContent$value;
            if (!this.resultContent$set) {
                resultContent$value = HttpRequest.$default$resultContent();
            }
            return new HttpRequest(this.httpConfiguration, this.hostname, this.method, this.path, this.url, this.header, this.body, resultContent$value, this.authenticationToken);
        }

        @Generated
        public String toString() {
            return "HttpRequest.HttpRequestBuilder(httpConfiguration=" + String.valueOf(this.httpConfiguration) + ", hostname=" + this.hostname + ", method=" + this.method + ", path=" + this.path + ", url=" + this.url + ", header=" + String.valueOf(this.header) + ", body=" + String.valueOf(this.body) + ", resultContent$value=" + String.valueOf((Object)this.resultContent$value) + ", authenticationToken=" + this.authenticationToken + ")";
        }
    }
}

