/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.client;

import io.opentelemetry.instrumentation.annotations.SpanAttribute;
import io.opentelemetry.instrumentation.annotations.WithSpan;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.http.HttpClient;
import org.sentrysoftware.http.HttpResponse;
import org.sentrysoftware.ipmi.client.IpmiClient;
import org.sentrysoftware.ipmi.client.IpmiClientConfiguration;
import org.sentrysoftware.jflat.JFlat;
import org.sentrysoftware.metricshub.engine.awk.AwkException;
import org.sentrysoftware.metricshub.engine.awk.AwkExecutor;
import org.sentrysoftware.metricshub.engine.client.http.Body;
import org.sentrysoftware.metricshub.engine.client.http.Header;
import org.sentrysoftware.metricshub.engine.client.http.HttpMacrosUpdater;
import org.sentrysoftware.metricshub.engine.client.http.HttpRequest;
import org.sentrysoftware.metricshub.engine.client.http.Url;
import org.sentrysoftware.metricshub.engine.common.exception.ClientException;
import org.sentrysoftware.metricshub.engine.common.exception.RetryableException;
import org.sentrysoftware.metricshub.engine.common.helpers.NetworkHelper;
import org.sentrysoftware.metricshub.engine.common.helpers.StringHelper;
import org.sentrysoftware.metricshub.engine.common.helpers.TextTableHelper;
import org.sentrysoftware.metricshub.engine.configuration.HttpConfiguration;
import org.sentrysoftware.metricshub.engine.configuration.IConfiguration;
import org.sentrysoftware.metricshub.engine.configuration.IpmiConfiguration;
import org.sentrysoftware.metricshub.engine.configuration.SnmpConfiguration;
import org.sentrysoftware.metricshub.engine.configuration.TransportProtocols;
import org.sentrysoftware.metricshub.engine.configuration.WbemConfiguration;
import org.sentrysoftware.metricshub.engine.configuration.WinRmConfiguration;
import org.sentrysoftware.metricshub.engine.configuration.WmiConfiguration;
import org.sentrysoftware.metricshub.engine.connector.model.common.ResultContent;
import org.sentrysoftware.metricshub.engine.strategy.utils.OsCommandHelper;
import org.sentrysoftware.metricshub.engine.strategy.utils.RetryOperation;
import org.sentrysoftware.metricshub.engine.telemetry.TelemetryManager;
import org.sentrysoftware.snmp.client.SnmpClient;
import org.sentrysoftware.ssh.SshClient;
import org.sentrysoftware.tablejoin.TableJoin;
import org.sentrysoftware.vcenter.VCenterClient;
import org.sentrysoftware.wbem.client.WbemExecutor;
import org.sentrysoftware.wbem.client.WbemQueryResult;
import org.sentrysoftware.wbem.javax.wbem.WBEMException;
import org.sentrysoftware.winrm.WinRMHttpProtocolEnum;
import org.sentrysoftware.winrm.WindowsRemoteCommandResult;
import org.sentrysoftware.winrm.command.WinRMCommandExecutor;
import org.sentrysoftware.winrm.service.client.auth.AuthenticationEnum;
import org.sentrysoftware.winrm.wql.WinRMWqlExecutor;
import org.sentrysoftware.wmi.WmiHelper;
import org.sentrysoftware.wmi.WmiStringConverter;
import org.sentrysoftware.wmi.remotecommand.WinRemoteCommandExecutor;
import org.sentrysoftware.wmi.wbem.WmiWbemServices;
import org.sentrysoftware.xflat.XFlat;
import org.sentrysoftware.xflat.exceptions.XFlatException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class ClientsExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClientsExecutor.class);
    private static final String MASK = "*****";
    private static final char[] CHAR_ARRAY_MASK = "*****".toCharArray();
    private static final String TIMEOUT_CANNOT_BE_NULL = "Timeout cannot be null";
    private static final String PASSWORD_CANNOT_BE_NULL = "Password cannot be null";
    private static final String USERNAME_CANNOT_BE_NULL = "Username cannot be null";
    private static final String HOSTNAME_CANNOT_BE_NULL = "hostname cannot be null";
    private static final String PROTOCOL_CANNOT_BE_NULL = "protocol cannot be null";
    private static final long JSON_2_CSV_TIMEOUT = 60L;
    private static final String SSH_FILE_MODE = "0700";
    private static final String SSH_REMOTE_DIRECTORY = "/var/tmp/";
    private TelemetryManager telemetryManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> T execute(Callable<T> callable, long timeout) throws InterruptedException, ExecutionException, TimeoutException {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        try {
            Future<T> handler = executorService.submit(callable);
            T t = handler.get(timeout, TimeUnit.SECONDS);
            return t;
        }
        finally {
            executorService.shutdownNow();
        }
    }

    @WithSpan(value="SNMP Get Next")
    public String executeSNMPGetNext(@SpanAttribute(value="snmp.oid") @NonNull String oid, @SpanAttribute(value="snmp.config") @NonNull SnmpConfiguration configuration, @SpanAttribute(value="host.hostname") @NonNull String hostname, boolean logMode) throws InterruptedException, ExecutionException, TimeoutException {
        if (oid == null) {
            throw new IllegalArgumentException("oid is marked non-null but is null");
        }
        if (configuration == null) {
            throw new IllegalArgumentException("configuration is marked non-null but is null");
        }
        if (hostname == null) {
            throw new IllegalArgumentException("hostname is marked non-null but is null");
        }
        ClientsExecutor.trace(() -> log.trace("Executing SNMP GetNext request:\n- OID: {}\n", (Object)oid));
        long startTime = System.currentTimeMillis();
        String result = (String)this.executeSNMPGetRequest(SnmpGetRequest.GETNEXT, oid, configuration, hostname, null, logMode);
        long responseTime = System.currentTimeMillis() - startTime;
        ClientsExecutor.trace(() -> log.trace("Executed SNMP GetNext request:\n- OID: {}\n- Result: {}\n- response-time: {}\n", new Object[]{oid, result, responseTime}));
        return result;
    }

    @WithSpan(value="SNMP Get")
    public String executeSNMPGet(@SpanAttribute(value="snmp.oid") @NonNull String oid, @SpanAttribute(value="snmp.config") @NonNull SnmpConfiguration configuration, @SpanAttribute(value="host.hostname") @NonNull String hostname, boolean logMode) throws InterruptedException, ExecutionException, TimeoutException {
        if (oid == null) {
            throw new IllegalArgumentException("oid is marked non-null but is null");
        }
        if (configuration == null) {
            throw new IllegalArgumentException("configuration is marked non-null but is null");
        }
        if (hostname == null) {
            throw new IllegalArgumentException("hostname is marked non-null but is null");
        }
        ClientsExecutor.trace(() -> log.trace("Executing SNMP Get request:\n- OID: {}\n", (Object)oid));
        long startTime = System.currentTimeMillis();
        String result = (String)this.executeSNMPGetRequest(SnmpGetRequest.GET, oid, configuration, hostname, null, logMode);
        long responseTime = System.currentTimeMillis() - startTime;
        ClientsExecutor.trace(() -> log.trace("Executed SNMP Get request:\n- OID: {}\n- Result: {}\n- response-time: {}\n", new Object[]{oid, result, responseTime}));
        return result;
    }

    @WithSpan(value="SNMP Get Table")
    public List<List<String>> executeSNMPTable(@SpanAttribute(value="snmp.oid") @NonNull String oid, @SpanAttribute(value="snmp.columns") @NonNull String[] selectColumnArray, @SpanAttribute(value="snmp.config") @NonNull SnmpConfiguration configuration, @SpanAttribute(value="host.hostname") @NonNull String hostname, boolean logMode) throws InterruptedException, ExecutionException, TimeoutException {
        if (oid == null) {
            throw new IllegalArgumentException("oid is marked non-null but is null");
        }
        if (selectColumnArray == null) {
            throw new IllegalArgumentException("selectColumnArray is marked non-null but is null");
        }
        if (configuration == null) {
            throw new IllegalArgumentException("configuration is marked non-null but is null");
        }
        if (hostname == null) {
            throw new IllegalArgumentException("hostname is marked non-null but is null");
        }
        ClientsExecutor.trace(() -> log.trace("Executing SNMP Table request:\n- OID: {}\n- Columns: {}\n", (Object)oid, (Object)Arrays.toString(selectColumnArray)));
        long startTime = System.currentTimeMillis();
        List result = (List)this.executeSNMPGetRequest(SnmpGetRequest.TABLE, oid, configuration, hostname, selectColumnArray, logMode);
        long responseTime = System.currentTimeMillis() - startTime;
        ClientsExecutor.trace(() -> log.trace("Executed SNMP Table request:\n- OID: {}\n- Columns: {}\n- Result:\n{}\n- response-time: {}\n", new Object[]{oid, Arrays.toString(selectColumnArray), TextTableHelper.generateTextTable(selectColumnArray, (List<List<String>>)result), responseTime}));
        return result;
    }

    private <T> T executeSNMPGetRequest(SnmpGetRequest request, String oid, SnmpConfiguration protocol, String hostname, String[] selectColumnArray, boolean logMode) throws InterruptedException, ExecutionException, TimeoutException {
        return (T)this.execute(() -> {
            SnmpClient snmpClient = new SnmpClient(hostname, protocol.getPort(), protocol.getVersion().getIntVersion(), null, protocol.getCommunity(), null, null, null, null, null, null, null);
            try {
                switch (request.ordinal()) {
                    case 0: {
                        String string = snmpClient.get(oid);
                        return string;
                    }
                    case 1: {
                        String string = snmpClient.getNext(oid);
                        return string;
                    }
                    case 2: {
                        List<List<String>> list = snmpClient.table(oid, selectColumnArray);
                        return list;
                    }
                }
                try {
                    throw new IllegalArgumentException("Not implemented.");
                }
                catch (Exception e) {
                    if (logMode) {
                        log.warn("Hostname {} - Error detected when running SNMP {} Query OID: {}. Error message: {}.", new Object[]{hostname, request, oid, e.getMessage()});
                    }
                    Object var8_11 = null;
                    return var8_11;
                }
            }
            finally {
                snmpClient.freeResources();
            }
        }, protocol.getTimeout());
    }

    public List<List<String>> executeTableJoin(List<List<String>> leftTable, List<List<String>> rightTable, int leftKeyColumnNumber, int rightKeyColumnNumber, List<String> defaultRightLine, boolean wbemKeyType, boolean caseInsensitive) {
        ClientsExecutor.trace(() -> log.trace("Executing Table Join request:\n- Left-table:\n{}\n- Right-table:\n{}\n", (Object)TextTableHelper.generateTextTable(leftTable), (Object)TextTableHelper.generateTextTable(rightTable)));
        List<List<String>> result = TableJoin.join(leftTable, rightTable, leftKeyColumnNumber, rightKeyColumnNumber, defaultRightLine, wbemKeyType, caseInsensitive);
        ClientsExecutor.trace(() -> log.trace("Executed Table Join request:\n- Left-table:\n{}\n- Right-table:\n{}\n- Result:\n{}\n", new Object[]{TextTableHelper.generateTextTable(leftTable), TextTableHelper.generateTextTable(rightTable), TextTableHelper.generateTextTable(result)}));
        return result;
    }

    @WithSpan(value="AWK")
    public String executeAwkScript(@SpanAttribute(value="awk.script") String embeddedFileScript, @SpanAttribute(value="awk.input") String input) throws AwkException {
        if (embeddedFileScript == null || input == null) {
            return null;
        }
        return AwkExecutor.executeAwk(embeddedFileScript, input);
    }

    public String executeJson2Csv(String jsonSource, String jsonEntryKey, List<String> propertyList, String separator) throws InterruptedException, ExecutionException, TimeoutException {
        ClientsExecutor.trace(() -> log.trace("Executing JSON to CSV conversion:\n- Json-source:\n{}\n- Json-entry-key: {}\n- Property-list: {}\n- Separator: {}\n", new Object[]{jsonSource, jsonEntryKey, propertyList, separator}));
        String hostname = this.telemetryManager.getHostConfiguration().getHostname();
        Callable<String> jflatToCSV = () -> {
            try {
                JFlat jsonFlat = new JFlat(jsonSource);
                jsonFlat.parse();
                return jsonFlat.toCSV(jsonEntryKey, propertyList.toArray(new String[0]), separator).toString();
            }
            catch (IllegalArgumentException e) {
                log.error("Hostname {} - Error detected in the arguments when translating the JSON structure into CSV.", (Object)hostname);
            }
            catch (Exception e) {
                log.warn("Hostname {} - Error detected when running jsonFlat parsing:\n{}", (Object)hostname, (Object)jsonSource);
                log.debug("Hostname {} - Exception detected when running jsonFlat parsing: ", (Object)hostname, (Object)e);
            }
            return null;
        };
        String result = this.execute(jflatToCSV, 60L);
        ClientsExecutor.trace(() -> log.trace("Executed JSON to CSV conversion:\n- Json-source:\n{}\n- Json-entry-key: {}\n- Property-list: {}\n- Separator: {}\n- Result:\n{}\n", new Object[]{jsonSource, jsonEntryKey, propertyList, separator, result}));
        return result;
    }

    public List<List<String>> executeXmlParsing(String xml, String properties, String recordTag) throws XFlatException {
        ClientsExecutor.trace(() -> log.trace("Executing XML parsing:\n- Xml-source:\n{}\n- Properties: {}\n- Record-tag: {}\n", new Object[]{xml, properties, recordTag}));
        List<List<String>> result = XFlat.parseXml(xml, properties, recordTag);
        ClientsExecutor.trace(() -> log.trace("Executed XML parsing:\n- Xml-source:\n{}\n- Properties: {}\n- Record-tag: {}\n- Result:\n{}\n", new Object[]{xml, properties, recordTag, TextTableHelper.generateTextTable(properties, result)}));
        return result;
    }

    public List<List<String>> executeWql(String hostname, IConfiguration configuration, String query, String namespace) throws ClientException {
        if (configuration instanceof WbemConfiguration) {
            WbemConfiguration wbemConfiguration = (WbemConfiguration)configuration;
            return this.executeWbem(hostname, wbemConfiguration, query, namespace);
        }
        if (configuration instanceof WmiConfiguration) {
            WmiConfiguration wmiConfiguration = (WmiConfiguration)configuration;
            return this.executeWmi(hostname, wmiConfiguration, query, namespace);
        }
        if (configuration instanceof WinRmConfiguration) {
            WinRmConfiguration winRmConfiguration = (WinRmConfiguration)configuration;
            return this.executeWqlThroughWinRm(hostname, winRmConfiguration, query, namespace);
        }
        throw new IllegalStateException("WQL queries can be executed only in WBEM, WMI and WinRM protocols.");
    }

    public static String executeWinRemoteCommand(String hostname, IConfiguration configuration, String command, List<String> embeddedFiles) throws ClientException {
        if (configuration instanceof WmiConfiguration) {
            WmiConfiguration wmiConfiguration = (WmiConfiguration)configuration;
            return ClientsExecutor.executeWmiRemoteCommand(command, hostname, wmiConfiguration.getUsername(), wmiConfiguration.getPassword(), wmiConfiguration.getTimeout().intValue(), embeddedFiles);
        }
        if (configuration instanceof WinRmConfiguration) {
            WinRmConfiguration winRmConfiguration = (WinRmConfiguration)configuration;
            return ClientsExecutor.executeRemoteWinRmCommand(hostname, winRmConfiguration, command);
        }
        throw new IllegalStateException("Windows commands can be executed only in WMI and WinRM protocols.");
    }

    @WithSpan(value="WBEM")
    public List<List<String>> executeWbem(@SpanAttribute(value="host.hostname") @NonNull String hostname, @SpanAttribute(value="wbem.config") @NonNull WbemConfiguration wbemConfig, @SpanAttribute(value="wbem.query") @NonNull String query, @SpanAttribute(value="wbem.namespace") @NonNull String namespace) throws ClientException {
        if (hostname == null) {
            throw new IllegalArgumentException("hostname is marked non-null but is null");
        }
        if (wbemConfig == null) {
            throw new IllegalArgumentException("wbemConfig is marked non-null but is null");
        }
        if (query == null) {
            throw new IllegalArgumentException("query is marked non-null but is null");
        }
        if (namespace == null) {
            throw new IllegalArgumentException("namespace is marked non-null but is null");
        }
        if (wbemConfig.getVCenter() != null) {
            return this.doVCenterQuery(hostname, wbemConfig, query, namespace);
        }
        return this.doWbemQuery(hostname, wbemConfig, query, namespace);
    }

    private List<List<String>> doVCenterQuery(@NonNull String hostname, @NonNull WbemConfiguration wbemConfig, @NonNull String query, @NonNull String namespace) throws ClientException {
        if (hostname == null) {
            throw new IllegalArgumentException("hostname is marked non-null but is null");
        }
        if (wbemConfig == null) {
            throw new IllegalArgumentException("wbemConfig is marked non-null but is null");
        }
        if (query == null) {
            throw new IllegalArgumentException("query is marked non-null but is null");
        }
        if (namespace == null) {
            throw new IllegalArgumentException("namespace is marked non-null but is null");
        }
        String ticket = this.telemetryManager.getHostProperties().getVCenterTicket();
        if (ticket == null) {
            ticket = this.refreshVCenterTicket(wbemConfig.getVCenter(), wbemConfig.getUsername(), wbemConfig.getPassword(), hostname, wbemConfig.getTimeout());
        }
        WbemConfiguration vCenterWbemConfig = WbemConfiguration.builder().username(ticket).password(ticket.toCharArray()).namespace(wbemConfig.getNamespace()).port(wbemConfig.getPort()).protocol(wbemConfig.getProtocol()).timeout(wbemConfig.getTimeout()).build();
        try {
            List<List<String>> list = this.doWbemQuery(hostname, vCenterWbemConfig, query, namespace);
            return list;
        }
        catch (ClientException e) {
            if (ClientsExecutor.isRefreshTicketNeeded(e.getCause())) {
                ticket = this.refreshVCenterTicket(wbemConfig.getVCenter(), wbemConfig.getUsername(), wbemConfig.getPassword(), hostname, wbemConfig.getTimeout());
                vCenterWbemConfig.setUsername(ticket);
                vCenterWbemConfig.setPassword(ticket.toCharArray());
                List<List<String>> list = this.doWbemQuery(hostname, vCenterWbemConfig, query, namespace);
                return list;
            }
            throw e;
        }
        finally {
            this.telemetryManager.getHostProperties().setVCenterTicket(ticket);
        }
    }

    private String refreshVCenterTicket(@NonNull String vCenter, @NonNull String username, @NonNull char[] password, @NonNull String hostname, @NonNull Long timeout) throws ClientException {
        if (vCenter == null) {
            throw new IllegalArgumentException("vCenter is marked non-null but is null");
        }
        if (username == null) {
            throw new IllegalArgumentException("username is marked non-null but is null");
        }
        if (password == null) {
            throw new IllegalArgumentException("password is marked non-null but is null");
        }
        if (hostname == null) {
            throw new IllegalArgumentException("hostname is marked non-null but is null");
        }
        if (timeout == null) {
            throw new IllegalArgumentException("timeout is marked non-null but is null");
        }
        VCenterClient.setDebug(() -> true, arg_0 -> ((Logger)log).debug(arg_0));
        try {
            String ticket = this.execute(() -> VCenterClient.requestCertificate(vCenter, username, new String(password), hostname), timeout);
            if (ticket == null) {
                throw new ClientException("Cannot get the ticket through vCenter module");
            }
            return ticket;
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            log.error("Hostname {} - Vcenter ticket refresh query failed. Exception: {}", (Throwable)e);
            throw new ClientException("vCenter refresh ticket query failed on " + hostname + ".", e);
        }
    }

    private static boolean isRefreshTicketNeeded(Throwable t) {
        if (t == null) {
            return false;
        }
        if (t instanceof WBEMException) {
            WBEMException wbemException = (WBEMException)t;
            int cimErrorType = wbemException.getID();
            return cimErrorType == 2;
        }
        return ClientsExecutor.isRefreshTicketNeeded(t.getCause());
    }

    private List<List<String>> doWbemQuery(String hostname, WbemConfiguration wbemConfig, String query, String namespace) throws ClientException {
        try {
            String urlSpec = String.format("%s://%s:%d", wbemConfig.getProtocol().toString(), hostname, wbemConfig.getPort());
            URL url = new URI(urlSpec).toURL();
            ClientsExecutor.trace(() -> log.trace("Executing WBEM request:\n- Hostname: {}\n- Port: {}\n- Protocol: {}\n- URL: {}\n- Username: {}\n- Query: {}\n- Namespace: {}\n- Timeout: {} s\n", new Object[]{hostname, wbemConfig.getPort(), wbemConfig.getProtocol().toString(), url, wbemConfig.getUsername(), query, namespace, wbemConfig.getTimeout()}));
            long startTime = System.currentTimeMillis();
            WbemQueryResult wbemQueryResult = WbemExecutor.executeWql(url, namespace, wbemConfig.getUsername(), wbemConfig.getPassword(), query, wbemConfig.getTimeout().intValue() * 1000, null);
            long responseTime = System.currentTimeMillis() - startTime;
            List<List<String>> result = wbemQueryResult.getValues();
            ClientsExecutor.trace(() -> log.trace("Executed WBEM request:\n- Hostname: {}\n- Port: {}\n- Protocol: {}\n- URL: {}\n- Username: {}\n- Query: {}\n- Namespace: {}\n- Timeout: {} s\n- Result:\n{}\n- response-time: {}\n", new Object[]{hostname, wbemConfig.getPort(), wbemConfig.getProtocol().toString(), url, wbemConfig.getUsername(), query, namespace, wbemConfig.getTimeout(), TextTableHelper.generateTextTable(wbemQueryResult.getProperties(), result), responseTime}));
            return result;
        }
        catch (Exception e) {
            throw new ClientException("WBEM query failed on " + hostname + ".", e);
        }
    }

    @WithSpan(value="WMI")
    public List<List<String>> executeWmi(@SpanAttribute(value="host.hostname") String hostname, @SpanAttribute(value="wmi.config") @NonNull WmiConfiguration wmiConfig, @SpanAttribute(value="wmi.query") @NonNull String wbemQuery, @SpanAttribute(value="wmi.namespace") @NonNull String namespace) throws ClientException {
        if (wmiConfig == null) {
            throw new IllegalArgumentException("wmiConfig is marked non-null but is null");
        }
        if (wbemQuery == null) {
            throw new IllegalArgumentException("wbemQuery is marked non-null but is null");
        }
        if (namespace == null) {
            throw new IllegalArgumentException("namespace is marked non-null but is null");
        }
        String networkResource = NetworkHelper.isLocalhost(hostname) ? namespace : String.format("\\\\%s\\%s", hostname, namespace);
        ClientsExecutor.trace(() -> log.trace("Executing WMI request:\n- Hostname: {}\n- Network-resource: {}\n- Username: {}\n- Query: {}\n- Namespace: {}\n- Timeout: {} s\n", new Object[]{hostname, networkResource, wmiConfig.getUsername(), wbemQuery, namespace, wmiConfig.getTimeout()}));
        WmiWbemServices wbemServices = WmiWbemServices.getInstance(networkResource, wmiConfig.getUsername(), wmiConfig.getPassword());
        try {
            long startTime = System.currentTimeMillis();
            List<Map<String, Object>> result = wbemServices.executeWql(wbemQuery, wmiConfig.getTimeout() * 1000L);
            long responseTime = System.currentTimeMillis() - startTime;
            List<String> properties = WmiHelper.extractPropertiesFromResult(result, wbemQuery);
            List<List<String>> resultTable = this.buildWmiTable(result, properties);
            ClientsExecutor.trace(() -> log.trace("Executed WMI request:\n- Hostname: {}\n- Network-resource: {}\n- Username: {}\n- Query: {}\n- Namespace: {}\n- Timeout: {} s\n- Result:\n{}\n- response-time: {}\n", new Object[]{hostname, networkResource, wmiConfig.getUsername(), wbemQuery, namespace, wmiConfig.getTimeout(), TextTableHelper.generateTextTable(properties, resultTable), responseTime}));
            List<List<String>> list = resultTable;
            if (wbemServices != null) {
                wbemServices.close();
            }
            return list;
        }
        catch (Throwable throwable) {
            try {
                if (wbemServices != null) {
                    try {
                        wbemServices.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new ClientException("WMI query failed on " + hostname + ".", e);
            }
        }
    }

    @WithSpan(value="Remote Command WMI")
    public static String executeWmiRemoteCommand(@SpanAttribute(value="wmi.command") String command, @SpanAttribute(value="host.hostname") String hostname, @SpanAttribute(value="wmi.username") String username, char[] password, @SpanAttribute(value="wmi.timeout") int timeout, @SpanAttribute(value="wmi.local_files") List<String> localFiles) throws ClientException {
        try {
            ClientsExecutor.trace(() -> log.trace("Executing WMI remote command:\n- Command: {}\n- Hostname: {}\n- Username: {}\n- Timeout: {} s\n- Local-files: {}\n", new Object[]{command, hostname, username, timeout, localFiles}));
            long startTime = System.currentTimeMillis();
            WinRemoteCommandExecutor result = WinRemoteCommandExecutor.execute(command, hostname, username, password, null, (long)timeout * 1000L, localFiles, true);
            String resultStdout = result.getStdout();
            long responseTime = System.currentTimeMillis() - startTime;
            ClientsExecutor.trace(() -> log.trace("Executed WMI remote command:\n- Command: {}\n- Hostname: {}\n- Username: {}\n- Timeout: {} s\n- Local-files: {}\n- Result:\n{}\n- response-time: {}\n", new Object[]{command, hostname, username, timeout, localFiles, resultStdout, responseTime}));
            return resultStdout;
        }
        catch (Exception e) {
            throw new ClientException((Exception)e.getCause());
        }
    }

    List<List<String>> buildWmiTable(List<Map<String, Object>> result, List<String> properties) {
        ArrayList<List<String>> table = new ArrayList<List<String>>();
        WmiStringConverter stringConverter = new WmiStringConverter();
        result.forEach(row -> {
            ArrayList line = new ArrayList();
            properties.forEach(property -> line.add(stringConverter.convert(row.get(property))));
            if (!line.isEmpty()) {
                table.add(line);
            }
        });
        return table;
    }

    @WithSpan(value="HTTP")
    public String executeHttp(@SpanAttribute(value="http.config") @NonNull HttpRequest httpRequest, boolean logMode) {
        if (httpRequest == null) {
            throw new IllegalArgumentException("httpRequest is marked non-null but is null");
        }
        HttpConfiguration httpConfiguration = httpRequest.getHttpConfiguration();
        Assert.notNull((Object)httpConfiguration, PROTOCOL_CANNOT_BE_NULL);
        String hostname = httpRequest.getHostname();
        Assert.notNull((Object)hostname, HOSTNAME_CANNOT_BE_NULL);
        String requestMethod = httpRequest.getMethod();
        String method = requestMethod != null ? requestMethod : "GET";
        String username = httpConfiguration.getUsername();
        char[] password = httpConfiguration.getPassword();
        String httpRequestAuthToken = httpRequest.getAuthenticationToken();
        String authenticationToken = HttpMacrosUpdater.update(httpRequestAuthToken, username, password, httpRequestAuthToken, hostname);
        Header header = httpRequest.getHeader();
        Map headerContent = header == null ? Collections.emptyMap() : header.getContent(username, password, authenticationToken, hostname);
        Map headerContentProtected = header == null ? Collections.emptyMap() : header.getContent(username, CHAR_ARRAY_MASK, MASK, hostname);
        Body body = httpRequest.getBody();
        String bodyContent = body == null ? "" : body.getContent(username, password, authenticationToken, hostname);
        String bodyContentProtected = body == null ? "" : body.getContent(username, CHAR_ARRAY_MASK, MASK, hostname);
        String protocol = Boolean.TRUE.equals(httpConfiguration.getHttps()) ? "https" : "http";
        String httpRequestUrl = httpRequest.getUrl();
        String httpRequestPath = httpRequest.getPath();
        String path = HttpMacrosUpdater.update(httpRequestPath, username, password, authenticationToken, hostname);
        String url = HttpMacrosUpdater.update(httpRequestUrl, username, password, authenticationToken, hostname);
        String fullUrl = Url.format(protocol, hostname, httpConfiguration.getPort(), path, url);
        ClientsExecutor.trace(() -> log.trace("Executing HTTP request: {} {}\n- hostname: {}\n- url: {}\n- path: {}\n- Protocol: {}\n- Port: {}\n- Request-headers:\n{}\n- Request-body:\n{}\n- Timeout: {} s\n- Get-result-content: {}\n", new Object[]{method, fullUrl, hostname, url, path, protocol, httpConfiguration.getPort(), StringHelper.prettyHttpHeaders(headerContentProtected), bodyContentProtected, httpConfiguration.getTimeout().intValue(), httpRequest.getResultContent()}));
        return RetryOperation.builder().withDescription(String.format("%s %s", method, fullUrl)).withWaitStrategy((int)this.telemetryManager.getHostConfiguration().getRetryDelay()).withMaxRetries(1).withHostname(hostname).withDefaultValue("").build().run(() -> this.doHttpRequest(httpRequest.getResultContent(), logMode, httpConfiguration, hostname, method, username, password, headerContent, headerContentProtected, bodyContent, bodyContentProtected, url, path, protocol, fullUrl));
    }

    private String doHttpRequest(ResultContent resultContent, boolean logMode, HttpConfiguration httpConfiguration, String hostname, String method, String username, char[] password, Map<String, String> headerContent, Map<String, String> headerContentProtected, String bodyContent, String bodyContentProtected, String url, String path, String protocol, String fullUrl) {
        try {
            long startTime = System.currentTimeMillis();
            HttpResponse httpResponse = this.sendHttpRequest(fullUrl, method, username, password, headerContent, bodyContent, httpConfiguration.getTimeout().intValue());
            long responseTime = System.currentTimeMillis() - startTime;
            int statusCode = httpResponse.getStatusCode();
            if (statusCode >= 400) {
                log.warn("Hostname {} - Bad response for HTTP request {} {}: {}.", new Object[]{hostname, method, fullUrl, statusCode});
                if (statusCode == 500 || statusCode == 503 || statusCode == 504 || statusCode == 507) {
                    throw new RetryableException();
                }
                return "";
            }
            String result = switch (resultContent) {
                case ResultContent.BODY -> httpResponse.getBody();
                case ResultContent.HEADER -> httpResponse.getHeader();
                case ResultContent.HTTP_STATUS -> String.valueOf(statusCode);
                case ResultContent.ALL -> httpResponse.toString();
                default -> throw new IllegalArgumentException("Unsupported ResultContent: " + String.valueOf((Object)resultContent));
            };
            ClientsExecutor.trace(() -> log.trace("Executed HTTP request: {} {}\n- Hostname: {}\n- Url: {}\n- Path: {}\n- Protocol: {}\n- Port: {}\n- Request-headers:\n{}\n- Request-body:\n{}\n- Timeout: {} s\n- get-result-content: {}\n- response-status: {}\n- response-headers:\n{}\n- response-body:\n{}\n- response-time: {}\n", new Object[]{method, fullUrl, hostname, url, path, protocol, httpConfiguration.getPort(), StringHelper.prettyHttpHeaders(headerContentProtected), bodyContentProtected, httpConfiguration.getTimeout().intValue(), resultContent, statusCode, httpResponse.getHeader(), httpResponse.getBody(), responseTime}));
            return result;
        }
        catch (IOException e) {
            if (logMode) {
                log.error("Hostname {} - Error detected when running HTTP request {} {}: {}\nReturning null.", new Object[]{hostname, method, fullUrl, e.getMessage()});
                log.debug("Hostname {} - Exception detected when running HTTP request {} {}:", new Object[]{hostname, method, fullUrl, e});
            }
            return null;
        }
    }

    private HttpResponse sendHttpRequest(String url, String method, String username, char[] password, Map<String, String> headerContent, String bodyContent, int timeout) throws IOException {
        return HttpClient.sendRequest(url, method, null, username, password, null, 0, null, null, null, headerContent, bodyContent, timeout, null);
    }

    @WithSpan(value="SSH")
    public static String runRemoteSshCommand(@SpanAttribute(value="host.hostname") @NonNull String hostname, @SpanAttribute(value="ssh.username") @NonNull String username, char[] password, @SpanAttribute(value="ssh.key_file_path") File keyFilePath, String command, @SpanAttribute(value="ssh.timeout") long timeout, @SpanAttribute(value="ssh.local_files") List<File> localFiles, @SpanAttribute(value="ssh.command") String noPasswordCommand) throws ClientException {
        if (hostname == null) {
            throw new IllegalArgumentException("hostname is marked non-null but is null");
        }
        if (username == null) {
            throw new IllegalArgumentException("username is marked non-null but is null");
        }
        ClientsExecutor.trace(() -> log.trace("Executing Remote SSH command:\n- hostname: {}\n- username: {}\n- key-file-path: {}\n- command: {}\n- timeout: {} s\n- local-files: {}\n", new Object[]{hostname, username, keyFilePath, command, timeout, localFiles}));
        Assert.isTrue(command != null && !command.trim().isEmpty(), "Command cannot be null nor empty.");
        Assert.isTrue(timeout > 0L, "Timeout cannot be negative nor zero.");
        long timeoutInMilliseconds = timeout * 1000L;
        String updatedCommand = ClientsExecutor.updateCommandWithLocalList(command, localFiles);
        String noPasswordUpdatedCommand = noPasswordCommand == null ? updatedCommand : ClientsExecutor.updateCommandWithLocalList(noPasswordCommand, localFiles);
        SshClient sshClient = ClientsExecutor.createSshClientInstance(hostname);
        try {
            sshClient.connect((int)timeoutInMilliseconds);
            if (password == null) {
                log.warn("Hostname {} - Password could not be read. Using an empty password instead.", (Object)hostname);
            }
            ClientsExecutor.authenticateSsh(sshClient, hostname, username, password, keyFilePath);
            if (localFiles != null && !localFiles.isEmpty()) {
                for (File file : localFiles) {
                    sshClient.scp(file.getAbsolutePath(), file.getName(), SSH_REMOTE_DIRECTORY, SSH_FILE_MODE);
                }
            }
            long startTime = System.currentTimeMillis();
            SshClient.CommandResult commandResult = sshClient.executeCommand(updatedCommand, (int)timeoutInMilliseconds);
            long responseTime = System.currentTimeMillis() - startTime;
            if (!commandResult.success) {
                String message = String.format("Hostname %s - Command \"%s\" failed with result %s.", hostname, noPasswordUpdatedCommand, commandResult.result);
                log.error(message);
                throw new ClientException(message);
            }
            String result = commandResult.result;
            ClientsExecutor.trace(() -> log.trace("Executed Remote SSH command:\n- Hostname: {}\n- Username: {}\n- Key-file-path: {}\n- Command: {}\n- Timeout: {} s\n- Local-files: {}\n- Result:\n{}\n- response-time: {}\n", new Object[]{hostname, username, keyFilePath, command, timeout, localFiles, result, responseTime}));
            String string = result;
            if (sshClient != null) {
                sshClient.close();
            }
            return string;
        }
        catch (Throwable startTime) {
            try {
                if (sshClient != null) {
                    try {
                        sshClient.close();
                    }
                    catch (Throwable throwable) {
                        startTime.addSuppressed(throwable);
                    }
                }
                throw startTime;
            }
            catch (ClientException e) {
                throw e;
            }
            catch (Exception e) {
                String message = String.format("Failed to run SSH command \"%s\" as %s on %s.", noPasswordUpdatedCommand, username, hostname);
                log.error("Hostname {} - {}. Exception : {}.", new Object[]{hostname, message, e.getMessage()});
                throw new ClientException(message, (Exception)e.getCause());
            }
        }
    }

    static void authenticateSsh(SshClient sshClient, String hostname, String username, char[] password, File privateKey) throws ClientException {
        boolean authenticated;
        try {
            authenticated = privateKey != null ? sshClient.authenticate(username, privateKey, password) : (password != null && password.length > 0 ? sshClient.authenticate(username, password) : sshClient.authenticate(username));
        }
        catch (Exception e) {
            String message = String.format("Hostname %s - Authentication as %s has failed with %s.", hostname, username, privateKey != null ? privateKey.getAbsolutePath() : null);
            log.error("Hostname {} - {}. Exception : {}.", new Object[]{hostname, message, e.getMessage()});
            throw new ClientException(message, e);
        }
        if (!authenticated) {
            String message = String.format("Hostname %s - Authentication as %s has failed with %s.", hostname, username, privateKey != null ? privateKey.getAbsolutePath() : null);
            log.error(message);
            throw new ClientException(message);
        }
    }

    static String updateCommandWithLocalList(String command, List<File> localFiles) {
        return localFiles == null || localFiles.isEmpty() ? command : localFiles.stream().reduce(command, (s, file) -> command.replaceAll(OsCommandHelper.toCaseInsensitiveRegex(file.getAbsolutePath()), SSH_REMOTE_DIRECTORY + file.getName()), (s1, s2) -> null);
    }

    public static SshClient createSshClientInstance(String hostname) {
        return new SshClient(hostname, StandardCharsets.UTF_8);
    }

    public static SshClient connectSshClientTerminal(@NonNull String hostname, @NonNull String username, char[] password, File privateKey, int timeout) throws ClientException {
        if (hostname == null) {
            throw new IllegalArgumentException("hostname is marked non-null but is null");
        }
        if (username == null) {
            throw new IllegalArgumentException("username is marked non-null but is null");
        }
        Assert.isTrue(timeout > 0, "timeout must be > 0");
        SshClient sshClient = ClientsExecutor.createSshClientInstance(hostname);
        try {
            sshClient.connect(timeout * 1000);
            ClientsExecutor.authenticateSsh(sshClient, hostname, username, password, privateKey);
            sshClient.openSession();
            sshClient.openTerminal();
            return sshClient;
        }
        catch (IOException e) {
            sshClient.close();
            throw new ClientException(e);
        }
    }

    @WithSpan(value="IPMI Chassis Status")
    public String executeIpmiDetection(@SpanAttribute(value="host.hostname") String hostname, @SpanAttribute(value="ipmi.config") @NonNull IpmiConfiguration ipmiConfiguration) throws InterruptedException, ExecutionException, TimeoutException {
        if (ipmiConfiguration == null) {
            throw new IllegalArgumentException("ipmiConfiguration is marked non-null but is null");
        }
        ClientsExecutor.trace(() -> log.trace("Executing IPMI detection request:\n- Hostname: {}\n- Username: {}\n- SkipAuth: {}\n- Timeout: {} s\n", new Object[]{hostname, ipmiConfiguration.getUsername(), ipmiConfiguration.isSkipAuth(), ipmiConfiguration.getTimeout()}));
        long startTime = System.currentTimeMillis();
        String result = IpmiClient.getChassisStatusAsStringResult(ClientsExecutor.buildIpmiConfiguration(hostname, ipmiConfiguration));
        long responseTime = System.currentTimeMillis() - startTime;
        ClientsExecutor.trace(() -> log.trace("Executed IPMI detection request:\n- Hostname: {}\n- Username: {}\n- SkipAuth: {}\n- Timeout: {} s\n- Result:\n{}\n- response-time: {}\n", new Object[]{hostname, ipmiConfiguration.getUsername(), ipmiConfiguration.isSkipAuth(), ipmiConfiguration.getTimeout(), result, responseTime}));
        return result;
    }

    private static IpmiClientConfiguration buildIpmiConfiguration(@NonNull String hostname, @NonNull IpmiConfiguration ipmiConfiguration) {
        if (hostname == null) {
            throw new IllegalArgumentException("hostname is marked non-null but is null");
        }
        if (ipmiConfiguration == null) {
            throw new IllegalArgumentException("ipmiConfiguration is marked non-null but is null");
        }
        String username = ipmiConfiguration.getUsername();
        char[] password = ipmiConfiguration.getPassword();
        Long timeout = ipmiConfiguration.getTimeout();
        Assert.notNull((Object)username, USERNAME_CANNOT_BE_NULL);
        Assert.notNull((Object)password, PASSWORD_CANNOT_BE_NULL);
        Assert.notNull((Object)timeout, TIMEOUT_CANNOT_BE_NULL);
        return new IpmiClientConfiguration(hostname, username, password, ipmiConfiguration.getBmcKey(), ipmiConfiguration.isSkipAuth(), timeout);
    }

    @WithSpan(value="IPMI Sensors")
    public String executeIpmiGetSensors(@SpanAttribute(value="host.hostname") String hostname, @SpanAttribute(value="ipmi.config") @NonNull IpmiConfiguration ipmiConfiguration) throws InterruptedException, ExecutionException, TimeoutException {
        if (ipmiConfiguration == null) {
            throw new IllegalArgumentException("ipmiConfiguration is marked non-null but is null");
        }
        ClientsExecutor.trace(() -> log.trace("Executing IPMI FRUs and Sensors request:\n- Hostname: {}\n- Username: {}\n- SkipAuth: {}\n- Timeout: {} s\n", new Object[]{hostname, ipmiConfiguration.getUsername(), ipmiConfiguration.isSkipAuth(), ipmiConfiguration.getTimeout()}));
        long startTime = System.currentTimeMillis();
        String result = IpmiClient.getFrusAndSensorsAsStringResult(ClientsExecutor.buildIpmiConfiguration(hostname, ipmiConfiguration));
        long responseTime = System.currentTimeMillis() - startTime;
        ClientsExecutor.trace(() -> log.trace("Executed IPMI FRUs and Sensors request:\n- Hostname: {}\n- Username: {}\n- SkipAuth: {}\n- Timeout: {} s\n- Result:\n{}\n- response-time: {}\n", new Object[]{hostname, ipmiConfiguration.getUsername(), ipmiConfiguration.isSkipAuth(), ipmiConfiguration.getTimeout(), result, responseTime}));
        return result;
    }

    @WithSpan(value="WQL WinRM")
    public List<List<String>> executeWqlThroughWinRm(@SpanAttribute(value="host.hostname") @NonNull String hostname, @SpanAttribute(value="wql.config") @NonNull WinRmConfiguration winRmConfiguration, @SpanAttribute(value="wql.query") @NonNull String query, @SpanAttribute(value="wql.namespace") @NonNull String namespace) throws ClientException {
        if (hostname == null) {
            throw new IllegalArgumentException("hostname is marked non-null but is null");
        }
        if (winRmConfiguration == null) {
            throw new IllegalArgumentException("winRmConfiguration is marked non-null but is null");
        }
        if (query == null) {
            throw new IllegalArgumentException("query is marked non-null but is null");
        }
        if (namespace == null) {
            throw new IllegalArgumentException("namespace is marked non-null but is null");
        }
        String username = winRmConfiguration.getUsername();
        WinRMHttpProtocolEnum httpProtocol = TransportProtocols.HTTP.equals((Object)winRmConfiguration.getProtocol()) ? WinRMHttpProtocolEnum.HTTP : WinRMHttpProtocolEnum.HTTPS;
        Integer port = winRmConfiguration.getPort();
        List<AuthenticationEnum> authentications = winRmConfiguration.getAuthentications();
        Long timeout = winRmConfiguration.getTimeout();
        ClientsExecutor.trace(() -> log.trace("Executing WinRM WQL request:\n- hostname: {}\n- username: {}\n- query: {}\n- protocol: {}\n- port: {}\n- authentications: {}\n- timeout: {}\n- namespace: {}\n", new Object[]{hostname, username, query, httpProtocol, port, authentications, timeout, namespace}));
        try {
            long startTime = System.currentTimeMillis();
            WinRMWqlExecutor result = WinRMWqlExecutor.executeWql(httpProtocol, hostname, port, username, winRmConfiguration.getPassword(), namespace, query, timeout * 1000L, null, authentications);
            long responseTime = System.currentTimeMillis() - startTime;
            List<List<String>> table = result.getRows();
            ClientsExecutor.trace(() -> log.trace("Executed WinRM WQL request:\n- hostname: {}\n- username: {}\n- query: {}\n- protocol: {}\n- port: {}\n- authentications: {}\n- timeout: {}\n- namespace: {}\n- Result:\n{}\n- response-time: {}\n", new Object[]{hostname, username, query, httpProtocol, port, authentications, timeout, namespace, TextTableHelper.generateTextTable(table), responseTime}));
            return table;
        }
        catch (Exception e) {
            log.error("Hostname {} - WinRM WQL request failed. Errors:\n{}\n", (Object)hostname, (Object)StringHelper.getStackMessages(e));
            throw new ClientException(String.format("WinRM WQL request failed on %s.", hostname), e);
        }
    }

    @WithSpan(value="Remote Command WinRM")
    public static String executeRemoteWinRmCommand(@SpanAttribute(value="host.hostname") @NonNull String hostname, @SpanAttribute(value="winrm.config") @NonNull WinRmConfiguration winRmConfiguration, @SpanAttribute(value="winrm.command") @NonNull String command) throws ClientException {
        if (hostname == null) {
            throw new IllegalArgumentException("hostname is marked non-null but is null");
        }
        if (winRmConfiguration == null) {
            throw new IllegalArgumentException("winRmConfiguration is marked non-null but is null");
        }
        if (command == null) {
            throw new IllegalArgumentException("command is marked non-null but is null");
        }
        String username = winRmConfiguration.getUsername();
        WinRMHttpProtocolEnum httpProtocol = TransportProtocols.HTTP.equals((Object)winRmConfiguration.getProtocol()) ? WinRMHttpProtocolEnum.HTTP : WinRMHttpProtocolEnum.HTTPS;
        Integer port = winRmConfiguration.getPort();
        List<AuthenticationEnum> authentications = winRmConfiguration.getAuthentications();
        Long timeout = winRmConfiguration.getTimeout();
        ClientsExecutor.trace(() -> log.trace("Executing WinRM remote command:\n- hostname: {}\n- username: {}\n- command: {}\n- protocol: {}\n- port: {}\n- authentications: {}\n- timeout: {}\n", new Object[]{hostname, username, command, httpProtocol, port, authentications, timeout}));
        try {
            long startTime = System.currentTimeMillis();
            WindowsRemoteCommandResult result = WinRMCommandExecutor.execute(command, httpProtocol, hostname, port, username, winRmConfiguration.getPassword(), null, timeout * 1000L, null, null, authentications);
            long responseTime = System.currentTimeMillis() - startTime;
            if (result.getStatusCode() != 0) {
                throw new ClientException(String.format("WinRM remote command failed on %s: %s", hostname, result.getStderr()));
            }
            String resultStdout = result.getStdout();
            ClientsExecutor.trace(() -> log.trace("Executed WinRM remote command:\n- hostname: {}\n- username: {}\n- command: {}\n- protocol: {}\n- port: {}\n- authentications: {}\n- timeout: {}\n- Result:\n{}\n- response-time: {}\n", new Object[]{hostname, username, command, httpProtocol, port, authentications, timeout, resultStdout, responseTime}));
            return resultStdout;
        }
        catch (Exception e) {
            log.error("Hostname {} - WinRM remote command failed. Errors:\n{}\n", (Object)hostname, (Object)StringHelper.getStackMessages(e));
            throw new ClientException(String.format("WinRM remote command failed on %s.", hostname), e);
        }
    }

    static void trace(Runnable runnable) {
        if (log.isTraceEnabled()) {
            runnable.run();
        }
    }

    @Generated
    public TelemetryManager getTelemetryManager() {
        return this.telemetryManager;
    }

    @Generated
    public void setTelemetryManager(TelemetryManager telemetryManager) {
        this.telemetryManager = telemetryManager;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientsExecutor)) {
            return false;
        }
        ClientsExecutor other = (ClientsExecutor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TelemetryManager this$telemetryManager = this.getTelemetryManager();
        TelemetryManager other$telemetryManager = other.getTelemetryManager();
        return !(this$telemetryManager == null ? other$telemetryManager != null : !((Object)this$telemetryManager).equals(other$telemetryManager));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ClientsExecutor;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TelemetryManager $telemetryManager = this.getTelemetryManager();
        result = result * 59 + ($telemetryManager == null ? 43 : ((Object)$telemetryManager).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ClientsExecutor(telemetryManager=" + String.valueOf(this.getTelemetryManager()) + ")";
    }

    @Generated
    public ClientsExecutor(TelemetryManager telemetryManager) {
        this.telemetryManager = telemetryManager;
    }

    @Generated
    public ClientsExecutor() {
    }

    public static enum SnmpGetRequest {
        GET,
        GETNEXT,
        TABLE;

    }
}

