/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.jawk;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.StringTokenizer;
import org.sentrysoftware.jawk.ExitException;
import org.sentrysoftware.jawk.backend.AVM;
import org.sentrysoftware.jawk.ext.CoreExtension;
import org.sentrysoftware.jawk.ext.JawkExtension;
import org.sentrysoftware.jawk.ext.StdinExtension;
import org.sentrysoftware.jawk.frontend.AwkParser;
import org.sentrysoftware.jawk.frontend.AwkSyntaxTree;
import org.sentrysoftware.jawk.intermediate.AwkTuples;
import org.sentrysoftware.jawk.util.AwkSettings;
import org.sentrysoftware.jawk.util.ScriptSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Awk {
    private static final String DEFAULT_EXTENSIONS = CoreExtension.class.getName() + "#" + StdinExtension.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger(Awk.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(AwkSettings settings) throws IOException, ClassNotFoundException, ExitException {
        AVM avm = null;
        try {
            Map<String, JawkExtension> extensions;
            if (settings.isUserExtensions()) {
                extensions = Awk.getJawkExtensions();
                LOG.trace("user extensions = {}", extensions.keySet());
            } else {
                extensions = Collections.emptyMap();
                LOG.trace("user extensions not enabled");
            }
            AwkTuples tuples = new AwkTuples();
            ArrayList<ScriptSource> notIntermediateScriptSources = new ArrayList<ScriptSource>(settings.getScriptSources().size());
            for (ScriptSource scriptSource : settings.getScriptSources()) {
                if (scriptSource.isIntermediate()) {
                    tuples = (AwkTuples)Awk.readObjectFromInputStream(scriptSource.getInputStream());
                    continue;
                }
                notIntermediateScriptSources.add(scriptSource);
            }
            if (!notIntermediateScriptSources.isEmpty()) {
                AwkParser parser = new AwkParser(settings.isAdditionalFunctions(), settings.isAdditionalTypeFunctions(), settings.isUseStdIn(), extensions);
                AwkSyntaxTree ast = parser.parse(notIntermediateScriptSources);
                if (settings.isDumpSyntaxTree()) {
                    String filename = settings.getOutputFilename("syntax_tree.lst");
                    LOG.info("writing to '{}'", (Object)filename);
                    PrintStream ps = new PrintStream(new FileOutputStream(filename));
                    if (ast != null) {
                        ast.dump(ps);
                    }
                    ps.close();
                    return;
                }
                if (ast != null) {
                    ast.semanticAnalysis();
                    ast.semanticAnalysis();
                    int result = ast.populateTuples(tuples);
                    assert (result == 0);
                    tuples.postProcess();
                    parser.populateGlobalVariableNameToOffsetMappings(tuples);
                }
                if (settings.isWriteIntermediateFile()) {
                    String filename = settings.getOutputFilename("a.ai");
                    LOG.info("writing to '{}'", (Object)filename);
                    Awk.writeObjectToFile(tuples, filename);
                    return;
                }
            }
            if (settings.isDumpIntermediateCode()) {
                String filename = settings.getOutputFilename("avm.lst");
                LOG.info("writing to '{}'", (Object)filename);
                PrintStream ps = new PrintStream(new FileOutputStream(filename));
                tuples.dump(ps);
                ps.close();
                return;
            }
            avm = new AVM(settings, extensions);
            avm.interpret(tuples);
        }
        finally {
            if (avm != null) {
                avm.waitForIO();
            }
        }
    }

    private static Object readObjectFromInputStream(InputStream is) throws IOException, ClassNotFoundException {
        ObjectInputStream ois = new ObjectInputStream(is);
        Object retval = ois.readObject();
        ois.close();
        return retval;
    }

    private static void writeObjectToFile(Object object, String filename) throws IOException {
        ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(filename));
        oos.writeObject(object);
        oos.close();
    }

    private static Map<String, JawkExtension> getJawkExtensions() {
        Object extensionsStr = System.getProperty("jawk.extensions", null);
        extensionsStr = extensionsStr == null ? DEFAULT_EXTENSIONS : DEFAULT_EXTENSIONS + "#" + (String)extensionsStr;
        HashSet extensionClasses = new HashSet();
        HashMap<String, JawkExtension> retval = new HashMap<String, JawkExtension>();
        StringTokenizer st = new StringTokenizer((String)extensionsStr, "#");
        while (st.hasMoreTokens()) {
            String cls = st.nextToken();
            LOG.trace("cls = {}", (Object)cls);
            try {
                Class<?> c = Class.forName(cls);
                if (!JawkExtension.class.isAssignableFrom(c)) {
                    throw new ClassNotFoundException(cls + " does not implement JawkExtension");
                }
                if (extensionClasses.contains(c)) {
                    LOG.warn("class {} is multiple times referred in extension class list. Skipping.", (Object)cls);
                    continue;
                }
                extensionClasses.add(c);
                try {
                    String[] keywords;
                    Constructor<?> constructor = c.getDeclaredConstructor(new Class[0]);
                    JawkExtension ji = (JawkExtension)constructor.newInstance(new Object[0]);
                    for (String keyword : keywords = ji.extensionKeywords()) {
                        if (retval.get(keyword) != null) {
                            throw new IllegalArgumentException("keyword collision : " + keyword + " for both " + ((JawkExtension)retval.get(keyword)).getExtensionName() + " and " + ji.getExtensionName());
                        }
                        retval.put(keyword, ji);
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    LOG.warn("Cannot instantiate " + c.getName(), (Throwable)e);
                }
            }
            catch (ClassNotFoundException cnfe) {
                LOG.warn("Cannot classload {} : {}", new Object[]{cls, cnfe});
            }
        }
        return retval;
    }
}

