/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.ipmi.core.transport;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.sentrysoftware.ipmi.core.transport.Messenger;
import org.sentrysoftware.ipmi.core.transport.UdpListener;
import org.sentrysoftware.ipmi.core.transport.UdpMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UdpMessenger
extends Thread
implements Messenger {
    private int port;
    private DatagramSocket socket;
    private List<UdpListener> listeners;
    private boolean closing = false;
    private static final String DEFAULT_ADDRESS = "0.0.0.0";
    private int bufferSize;
    private static final int DEFAULTBUFFERSIZE = 512;
    private static Logger logger = LoggerFactory.getLogger(UdpMessenger.class);
    private static int sentPackets = 0;

    public int getPort() {
        return this.port;
    }

    public UdpMessenger(int port) throws SocketException, UnknownHostException {
        this(port, InetAddress.getByName(DEFAULT_ADDRESS));
    }

    public UdpMessenger(int port, InetAddress address) throws SocketException {
        sentPackets = 0;
        this.port = port;
        this.listeners = new ArrayList<UdpListener>();
        this.bufferSize = 512;
        this.socket = new DatagramSocket(this.port, address);
        this.socket.setSoTimeout(0);
        this.start();
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        super.run();
        boolean run = true;
        while (run) {
            DatagramPacket response = new DatagramPacket(new byte[512], 512);
            try {
                this.socket.receive(response);
                UdpMessage message = new UdpMessage();
                message.setAddress(response.getAddress());
                message.setPort(response.getPort());
                byte[] buffer = new byte[response.getLength()];
                System.arraycopy(response.getData(), 0, buffer, 0, buffer.length);
                message.setMessage(buffer);
                this.notifyListeners(message);
            }
            catch (SocketException se) {
                if (this.closing) {
                    run = false;
                    continue;
                }
                logger.error(se.getMessage(), (Throwable)se);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            finally {
                if (!this.socket.isClosed()) continue;
                run = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners(UdpMessage message) {
        List<UdpListener> list = this.listeners;
        synchronized (list) {
            for (UdpListener listener : this.listeners) {
                if (listener == null) continue;
                listener.notifyMessage(message);
            }
        }
    }

    @Override
    public void closeConnection() {
        this.closing = true;
        this.socket.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(UdpListener listener) {
        List<UdpListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregister(UdpListener listener) {
        List<UdpListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    public static int getSentPackets() {
        return sentPackets;
    }

    @Override
    public synchronized void send(UdpMessage message) throws IOException {
        DatagramPacket packet = new DatagramPacket(message.getMessage(), message.getMessage().length, message.getAddress(), message.getPort());
        this.socket.send(packet);
        try {
            Thread.sleep(1L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ++sentPackets;
    }
}

