/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.ipmi.core.sm.states;

import org.sentrysoftware.ipmi.core.coding.Encoder;
import org.sentrysoftware.ipmi.core.coding.commands.session.OpenSession;
import org.sentrysoftware.ipmi.core.coding.protocol.encoder.Protocolv20Encoder;
import org.sentrysoftware.ipmi.core.coding.rmcp.RmcpMessage;
import org.sentrysoftware.ipmi.core.sm.StateMachine;
import org.sentrysoftware.ipmi.core.sm.actions.ErrorAction;
import org.sentrysoftware.ipmi.core.sm.events.Authorize;
import org.sentrysoftware.ipmi.core.sm.events.StateMachineEvent;
import org.sentrysoftware.ipmi.core.sm.states.OpenSessionWaiting;
import org.sentrysoftware.ipmi.core.sm.states.State;

public class Authcap
extends State {
    @Override
    public void doTransition(StateMachine stateMachine, StateMachineEvent machineEvent) {
        if (machineEvent instanceof Authorize) {
            Authorize event = (Authorize)machineEvent;
            OpenSession openSession = new OpenSession(event.getSessionId(), event.getPrivilegeLevel(), event.getCipherSuite());
            try {
                stateMachine.setCurrent(new OpenSessionWaiting(event.getSequenceNumber()));
                stateMachine.sendMessage(Encoder.encode(new Protocolv20Encoder(), openSession, event.getSequenceNumber(), 0, 0));
            }
            catch (Exception e) {
                stateMachine.setCurrent(this);
                stateMachine.doExternalAction(new ErrorAction(e));
            }
        } else {
            stateMachine.doExternalAction(new ErrorAction(new IllegalArgumentException("Invalid transition: " + machineEvent.getClass().getSimpleName())));
        }
    }

    @Override
    public void doAction(StateMachine stateMachine, RmcpMessage message) {
    }
}

