/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.ipmi.core.connection;

import org.sentrysoftware.ipmi.core.coding.PayloadCoder;
import org.sentrysoftware.ipmi.core.coding.protocol.Ipmiv20Message;
import org.sentrysoftware.ipmi.core.connection.Connection;
import org.sentrysoftware.ipmi.core.connection.ConnectionException;
import org.sentrysoftware.ipmi.core.connection.queue.MessageQueue;
import org.sentrysoftware.ipmi.core.sm.StateMachine;
import org.sentrysoftware.ipmi.core.sm.events.Sendv20Message;
import org.sentrysoftware.ipmi.core.sm.states.SessionValid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MessageHandler {
    private static final Logger logger = LoggerFactory.getLogger(MessageHandler.class);
    protected int lastReceivedSequenceNumber = 0;
    protected final MessageQueue messageQueue;
    protected final Connection connection;

    public MessageHandler(Connection connection, int timeout, int minSequenceNumber, int maxSequenceNumber) {
        this.messageQueue = new MessageQueue(connection, timeout, minSequenceNumber, maxSequenceNumber);
        this.connection = connection;
    }

    public int sendMessage(PayloadCoder payloadCoder, StateMachine stateMachine, int sessionId, boolean isOneWay) throws ConnectionException {
        int seq;
        this.validateSessionState(stateMachine);
        int n = seq = isOneWay ? this.messageQueue.getSequenceNumber() : this.messageQueue.add(payloadCoder);
        if (seq > 0) {
            stateMachine.doTransition(new Sendv20Message(payloadCoder, sessionId, seq, this.connection.getNextSessionSequenceNumber()));
        }
        return seq;
    }

    public int retryMessage(int tag, StateMachine stateMachine, int sessionId) throws ConnectionException {
        this.validateSessionState(stateMachine);
        PayloadCoder payloadCoder = this.messageQueue.getMessageFromQueue(tag);
        if (payloadCoder == null) {
            return -1;
        }
        stateMachine.doTransition(new Sendv20Message(payloadCoder, sessionId, tag, this.connection.getNextSessionSequenceNumber()));
        return tag;
    }

    private void validateSessionState(StateMachine stateMachine) throws ConnectionException {
        if (stateMachine.getCurrent().getClass() != SessionValid.class) {
            throw new ConnectionException("Illegal connection state: " + stateMachine.getCurrent().getClass().getSimpleName());
        }
    }

    public void handleIncomingMessage(Ipmiv20Message message) {
        int seq = message.getSessionSequenceNumber();
        if (seq != 0 && (seq > this.lastReceivedSequenceNumber + 15 || seq < this.lastReceivedSequenceNumber - 16)) {
            logger.debug("Dropping message " + seq);
            return;
        }
        if (seq != 0) {
            this.lastReceivedSequenceNumber = seq > this.lastReceivedSequenceNumber ? seq : this.lastReceivedSequenceNumber;
        }
        this.handleIncomingMessageInternal(message);
    }

    public void setTimeout(int timeout) {
        this.messageQueue.setTimeout(timeout);
    }

    public void tearDown() {
        this.messageQueue.tearDown();
    }

    public int getSequenceNumber() {
        return this.messageQueue.getSequenceNumber();
    }

    protected abstract void handleIncomingMessageInternal(Ipmiv20Message var1);
}

