/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.ipmi.core.connection;

import java.io.IOException;
import java.net.InetAddress;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import org.sentrysoftware.ipmi.core.coding.PayloadCoder;
import org.sentrysoftware.ipmi.core.coding.commands.IpmiVersion;
import org.sentrysoftware.ipmi.core.coding.commands.PrivilegeLevel;
import org.sentrysoftware.ipmi.core.coding.commands.ResponseData;
import org.sentrysoftware.ipmi.core.coding.commands.session.GetChannelAuthenticationCapabilities;
import org.sentrysoftware.ipmi.core.coding.commands.session.GetChannelAuthenticationCapabilitiesResponseData;
import org.sentrysoftware.ipmi.core.coding.commands.session.GetChannelCipherSuitesResponseData;
import org.sentrysoftware.ipmi.core.coding.commands.session.OpenSessionResponseData;
import org.sentrysoftware.ipmi.core.coding.commands.session.Rakp1ResponseData;
import org.sentrysoftware.ipmi.core.coding.commands.session.Rakp3ResponseData;
import org.sentrysoftware.ipmi.core.coding.payload.IpmiPayload;
import org.sentrysoftware.ipmi.core.coding.protocol.Ipmiv20Message;
import org.sentrysoftware.ipmi.core.coding.protocol.PayloadType;
import org.sentrysoftware.ipmi.core.coding.security.AuthenticationRakpHmacSha1;
import org.sentrysoftware.ipmi.core.coding.security.CipherSuite;
import org.sentrysoftware.ipmi.core.coding.security.ConfidentialityAesCbc128;
import org.sentrysoftware.ipmi.core.coding.security.IntegrityHmacSha1_96;
import org.sentrysoftware.ipmi.core.common.PropertiesManager;
import org.sentrysoftware.ipmi.core.common.TypeConverter;
import org.sentrysoftware.ipmi.core.connection.ConnectionException;
import org.sentrysoftware.ipmi.core.connection.ConnectionListener;
import org.sentrysoftware.ipmi.core.connection.IpmiMessageHandler;
import org.sentrysoftware.ipmi.core.connection.MessageHandler;
import org.sentrysoftware.ipmi.core.connection.SessionManager;
import org.sentrysoftware.ipmi.core.connection.SolMessageHandler;
import org.sentrysoftware.ipmi.core.sm.MachineObserver;
import org.sentrysoftware.ipmi.core.sm.StateMachine;
import org.sentrysoftware.ipmi.core.sm.actions.ErrorAction;
import org.sentrysoftware.ipmi.core.sm.actions.GetSikAction;
import org.sentrysoftware.ipmi.core.sm.actions.MessageAction;
import org.sentrysoftware.ipmi.core.sm.actions.ResponseAction;
import org.sentrysoftware.ipmi.core.sm.actions.StateMachineAction;
import org.sentrysoftware.ipmi.core.sm.events.AuthenticationCapabilitiesReceived;
import org.sentrysoftware.ipmi.core.sm.events.Authorize;
import org.sentrysoftware.ipmi.core.sm.events.CloseSession;
import org.sentrysoftware.ipmi.core.sm.events.Default;
import org.sentrysoftware.ipmi.core.sm.events.DefaultAck;
import org.sentrysoftware.ipmi.core.sm.events.GetChannelCipherSuitesPending;
import org.sentrysoftware.ipmi.core.sm.events.OpenSessionAck;
import org.sentrysoftware.ipmi.core.sm.events.Rakp2Ack;
import org.sentrysoftware.ipmi.core.sm.events.StartSession;
import org.sentrysoftware.ipmi.core.sm.events.Timeout;
import org.sentrysoftware.ipmi.core.sm.states.Authcap;
import org.sentrysoftware.ipmi.core.sm.states.Ciphers;
import org.sentrysoftware.ipmi.core.sm.states.SessionValid;
import org.sentrysoftware.ipmi.core.sm.states.Uninitialized;
import org.sentrysoftware.ipmi.core.transport.Messenger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Connection
extends TimerTask
implements MachineObserver {
    private static final Logger logger = LoggerFactory.getLogger(Connection.class);
    private static final int DEFAULT_CIPHER_SUITE = 3;
    private static final int SESSION_SEQUENCE_NUMBER_UPPER_BOUND = 0x1FFFFFFF;
    private static final String ILLEGAL_CONNECTION_STATE_MESSAGE = "Illegal connection state: ";
    private List<ConnectionListener> listeners;
    private StateMachine stateMachine;
    private int timeout = -1;
    private StateMachineAction lastAction;
    private int sessionId;
    private int managedSystemSessionId;
    private byte[] sik;
    private int handle;
    private Map<PayloadType, MessageHandler> messageHandlers;
    private Timer timer;
    private AtomicInteger currentSessionSequenceNumber;

    public int getHandle() {
        return this.handle;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
        for (MessageHandler messageHandler : this.messageHandlers.values()) {
            messageHandler.setTimeout(timeout);
        }
    }

    public Connection(Messenger messenger, int handle) {
        this.stateMachine = new StateMachine(messenger);
        this.handle = handle;
        this.listeners = new ArrayList<ConnectionListener>();
        this.timeout = Integer.parseInt(PropertiesManager.getInstance().getProperty("timeout"));
        this.messageHandlers = new EnumMap<PayloadType, MessageHandler>(PayloadType.class);
        this.currentSessionSequenceNumber = new AtomicInteger(0);
    }

    public void registerListener(ConnectionListener listener) {
        this.listeners.add(listener);
    }

    public void unregisterListener(ConnectionListener listener) {
        this.listeners.remove(listener);
    }

    public void connect(InetAddress address, int port, int pingPeriod) throws IOException {
        this.connect(address, port, pingPeriod, false);
    }

    public void connect(InetAddress address, int port, int pingPeriod, boolean skipCiphers) throws IOException {
        IpmiMessageHandler ipmiMessageHandler = new IpmiMessageHandler(this, this.timeout);
        this.messageHandlers.put(PayloadType.Ipmi, ipmiMessageHandler);
        SolMessageHandler solMessageHandler = new SolMessageHandler(this, this.timeout);
        this.messageHandlers.put(PayloadType.Sol, solMessageHandler);
        this.timer = new Timer();
        this.timer.schedule((TimerTask)this, pingPeriod, (long)pingPeriod);
        this.stateMachine.register(this);
        if (skipCiphers) {
            this.stateMachine.start(address, port);
            this.sessionId = SessionManager.generateSessionId();
            this.stateMachine.setCurrent(new Authcap());
        } else {
            this.stateMachine.start(address, port);
        }
    }

    public void disconnect() {
        this.timer.cancel();
        this.stateMachine.stop();
        for (MessageHandler messageHandler : this.messageHandlers.values()) {
            messageHandler.tearDown();
        }
    }

    public boolean isActive() {
        return this.stateMachine.isActive();
    }

    public List<CipherSuite> getAvailableCipherSuites(int tag) throws Exception {
        if (this.stateMachine.getCurrent().getClass() != Uninitialized.class) {
            throw new ConnectionException(ILLEGAL_CONNECTION_STATE_MESSAGE + this.stateMachine.getCurrent().getClass().getSimpleName());
        }
        boolean process = true;
        ArrayList<byte[]> rawCipherSuites = new ArrayList<byte[]>();
        while (process) {
            this.lastAction = null;
            this.stateMachine.doTransition(new GetChannelCipherSuitesPending(tag));
            this.waitForResponse();
            ResponseAction action = (ResponseAction)this.lastAction;
            if (!(action.getIpmiResponseData() instanceof GetChannelCipherSuitesResponseData)) {
                this.stateMachine.doTransition(new Timeout());
                throw new ConnectionException("Response data not matching Get Channel Cipher Suites command.");
            }
            GetChannelCipherSuitesResponseData responseData = (GetChannelCipherSuitesResponseData)action.getIpmiResponseData();
            rawCipherSuites.add(responseData.getCipherSuiteData());
            if (responseData.getCipherSuiteData().length >= 16) continue;
            process = false;
        }
        this.stateMachine.doTransition(new DefaultAck());
        int length = 0;
        for (byte[] partial : rawCipherSuites) {
            length += partial.length;
        }
        byte[] csRaw = new byte[length];
        int index = 0;
        for (byte[] partial : rawCipherSuites) {
            System.arraycopy(partial, 0, csRaw, index, partial.length);
            index += partial.length;
        }
        return CipherSuite.getCipherSuites(csRaw);
    }

    private void waitForResponse() throws Exception {
        for (int time = 0; time < this.timeout && this.lastAction == null; ++time) {
            try {
                Thread.sleep(1L);
                continue;
            }
            catch (InterruptedException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        if (this.lastAction == null) {
            this.stateMachine.doTransition(new Timeout());
            throw new ConnectionException("Command timed out");
        }
        if (!(this.lastAction instanceof ResponseAction) && !(this.lastAction instanceof GetSikAction)) {
            if (this.lastAction instanceof ErrorAction) {
                throw ((ErrorAction)this.lastAction).getException();
            }
            throw new ConnectionException("Invalid StateMachine response: " + this.lastAction.getClass().getSimpleName());
        }
    }

    public GetChannelAuthenticationCapabilitiesResponseData getChannelAuthenticationCapabilities(int tag, CipherSuite cipherSuite, PrivilegeLevel requestedPrivilegeLevel) throws Exception {
        if (this.stateMachine.getCurrent().getClass() != Ciphers.class) {
            throw new ConnectionException(ILLEGAL_CONNECTION_STATE_MESSAGE + this.stateMachine.getCurrent().getClass().getSimpleName());
        }
        this.lastAction = null;
        this.stateMachine.doTransition(new Default(cipherSuite, tag, requestedPrivilegeLevel));
        this.waitForResponse();
        ResponseAction action = (ResponseAction)this.lastAction;
        if (!(action.getIpmiResponseData() instanceof GetChannelAuthenticationCapabilitiesResponseData)) {
            this.stateMachine.doTransition(new Timeout());
            throw new ConnectionException("Response data not matching Get Channel Authentication Capabilities command.");
        }
        GetChannelAuthenticationCapabilitiesResponseData responseData = (GetChannelAuthenticationCapabilitiesResponseData)action.getIpmiResponseData();
        this.sessionId = SessionManager.generateSessionId();
        this.stateMachine.doTransition(new AuthenticationCapabilitiesReceived(this.sessionId, requestedPrivilegeLevel));
        return responseData;
    }

    public int startSession(int tag, CipherSuite cipherSuite, PrivilegeLevel privilegeLevel, String username, String password, byte[] bmcKey) throws Exception {
        if (this.stateMachine.getCurrent().getClass() != Authcap.class) {
            throw new ConnectionException(ILLEGAL_CONNECTION_STATE_MESSAGE + this.stateMachine.getCurrent().getClass().getSimpleName());
        }
        this.lastAction = null;
        this.stateMachine.doTransition(new Authorize(cipherSuite, tag, privilegeLevel, this.sessionId));
        this.waitForResponse();
        ResponseAction action = (ResponseAction)this.lastAction;
        this.lastAction = null;
        if (!(action.getIpmiResponseData() instanceof OpenSessionResponseData)) {
            this.stateMachine.doTransition(new Timeout());
            throw new ConnectionException("Response data not matching OpenSession response data");
        }
        this.managedSystemSessionId = ((OpenSessionResponseData)action.getIpmiResponseData()).getManagedSystemSessionId();
        this.stateMachine.doTransition(new DefaultAck());
        this.stateMachine.doTransition(new OpenSessionAck(cipherSuite, privilegeLevel, tag, this.managedSystemSessionId, username, password, bmcKey));
        this.waitForResponse();
        action = (ResponseAction)this.lastAction;
        this.lastAction = null;
        if (!(action.getIpmiResponseData() instanceof Rakp1ResponseData)) {
            this.stateMachine.doTransition(new Timeout());
            throw new ConnectionException("Response data not matching RAKP Message 2: " + action.getIpmiResponseData().getClass().getSimpleName());
        }
        Rakp1ResponseData rakp1ResponseData = (Rakp1ResponseData)action.getIpmiResponseData();
        this.stateMachine.doTransition(new DefaultAck());
        this.stateMachine.doTransition(new Rakp2Ack(cipherSuite, tag, 0, this.managedSystemSessionId, rakp1ResponseData));
        this.waitForResponse();
        action = (ResponseAction)this.lastAction;
        if (this.sik == null) {
            throw new ConnectionException("Session Integrity Key is null");
        }
        cipherSuite.initializeAlgorithms(this.sik);
        this.lastAction = null;
        if (!(action.getIpmiResponseData() instanceof Rakp3ResponseData)) {
            this.stateMachine.doTransition(new Timeout());
            throw new ConnectionException("Response data not matching RAKP Message 4");
        }
        this.stateMachine.doTransition(new DefaultAck());
        this.stateMachine.doTransition(new StartSession(cipherSuite, this.sessionId));
        return this.sessionId;
    }

    public void closeSession() throws ConnectionException {
        if (this.stateMachine.getCurrent().getClass() != SessionValid.class) {
            throw new ConnectionException(ILLEGAL_CONNECTION_STATE_MESSAGE + this.stateMachine.getCurrent().getClass().getSimpleName());
        }
        this.stateMachine.doTransition(new CloseSession(this.managedSystemSessionId, this.messageHandlers.get((Object)PayloadType.Ipmi).getSequenceNumber(), this.getNextSessionSequenceNumber()));
    }

    public int sendMessage(PayloadCoder payloadCoder, boolean isOneWay) throws ConnectionException {
        MessageHandler messageHandler = this.messageHandlers.get((Object)payloadCoder.getSupportedPayloadType());
        if (messageHandler == null) {
            messageHandler = this.messageHandlers.get((Object)PayloadType.Ipmi);
        }
        return messageHandler.sendMessage(payloadCoder, this.stateMachine, this.managedSystemSessionId, isOneWay);
    }

    public int retry(int tag, PayloadType messagePayloadType) throws ConnectionException {
        MessageHandler messageHandler = this.messageHandlers.containsKey((Object)messagePayloadType) ? this.messageHandlers.get((Object)messagePayloadType) : this.messageHandlers.get((Object)PayloadType.Ipmi);
        return messageHandler.retryMessage(tag, this.stateMachine, this.managedSystemSessionId);
    }

    private void handleIncomingMessage(Ipmiv20Message message) {
        MessageHandler messageHandler = this.messageHandlers.get((Object)message.getPayloadType());
        messageHandler.handleIncomingMessage(message);
    }

    public void notifyResponseListeners(int handle, int tag, ResponseData responseData, Exception exception) {
        for (ConnectionListener listener : this.listeners) {
            if (listener == null) continue;
            listener.processResponse(responseData, handle, tag, exception);
        }
    }

    public void notifyRequestListeners(IpmiPayload payload) {
        for (ConnectionListener listener : this.listeners) {
            if (listener == null) continue;
            listener.processRequest(payload);
        }
    }

    @Override
    public void notify(StateMachineAction action) {
        if (action instanceof GetSikAction) {
            this.sik = ((GetSikAction)action).getSik();
        } else if (!(action instanceof MessageAction)) {
            this.lastAction = action;
            if (action instanceof ErrorAction) {
                ErrorAction errorAction = (ErrorAction)action;
                logger.error(errorAction.getException().getMessage(), (Throwable)errorAction.getException());
            }
        } else {
            this.handleIncomingMessage(((MessageAction)action).getIpmiv20Message());
        }
    }

    @Override
    public void run() {
        int result = -1;
        do {
            try {
                if (!(this.stateMachine.getCurrent() instanceof SessionValid)) break;
                result = this.sendMessage(new GetChannelAuthenticationCapabilities(IpmiVersion.V20, IpmiVersion.V20, ((SessionValid)this.stateMachine.getCurrent()).getCipherSuite(), PrivilegeLevel.Callback, TypeConverter.intToByte(14)), false);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        } while (result <= 0);
    }

    public InetAddress getRemoteMachineAddress() {
        return this.stateMachine.getRemoteMachineAddress();
    }

    public int getRemoteMachinePort() {
        return this.stateMachine.getRemoteMachinePort();
    }

    public boolean isSessionValid() {
        return this.stateMachine.getCurrent() instanceof SessionValid;
    }

    public int getNextSessionSequenceNumber() {
        int result = this.currentSessionSequenceNumber.incrementAndGet() % 0x1FFFFFFF;
        if (result == 0) {
            throw new ArithmeticException("Session sequence number overload. Reset session.");
        }
        return result;
    }

    public static CipherSuite getDefaultCipherSuite() {
        try {
            return new CipherSuite(3, new AuthenticationRakpHmacSha1().getCode(), new ConfidentialityAesCbc128().getCode(), new IntegrityHmacSha1_96().getCode());
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("Wrong algorithm in default Cipher suite - SHOULD NOT HAPPEN!!!", (Throwable)e);
            return null;
        }
    }
}

