/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.ipmi.core.common;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PropertiesManager {
    private static PropertiesManager instance;
    private Map<String, String> properties;
    private Logger logger = LoggerFactory.getLogger(PropertiesManager.class);

    private PropertiesManager() {
        this.properties = new HashMap<String, String>();
        this.loadProperties("/connection.properties");
        this.loadProperties("/vxipmi.properties");
    }

    public static PropertiesManager getInstance() {
        if (instance == null) {
            instance = new PropertiesManager();
        }
        return instance;
    }

    private void loadProperties(String name) {
        try {
            Properties props = new Properties();
            props.load(this.getClass().getResourceAsStream(name));
            for (Object key : props.keySet()) {
                this.properties.put(key.toString(), props.getProperty(key.toString()));
            }
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public String getProperty(String key) {
        this.logger.info("Getting " + key + ": " + this.properties.get(key));
        return this.properties.get(key);
    }

    public void setProperty(String key, String value) {
        this.properties.put(key, value);
    }
}

