/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.ipmi.core.coding.rmcp;

import org.sentrysoftware.ipmi.core.coding.rmcp.RmcpClassOfMessage;
import org.sentrysoftware.ipmi.core.coding.rmcp.RmcpMessage;
import org.sentrysoftware.ipmi.core.coding.rmcp.RmcpVersion;
import org.sentrysoftware.ipmi.core.common.TypeConverter;

public final class RmcpDecoder {
    private RmcpDecoder() {
    }

    public static RmcpMessage decode(byte[] rawMessage) {
        RmcpMessage message = new RmcpMessage();
        if (rawMessage.length < 4) {
            throw new IllegalArgumentException("Message is corrupted");
        }
        message.setVersion(RmcpDecoder.decodeVersion(rawMessage[0]));
        message.setSequenceNumber(RmcpDecoder.decodeSequenceNumber(rawMessage[2]));
        message.setClassOfMessage(RmcpDecoder.decodeClassOfMessage(rawMessage[3]));
        message.setData(RmcpDecoder.decodeData(rawMessage));
        return message;
    }

    private static RmcpVersion decodeVersion(byte version) {
        if (version == 6) {
            return RmcpVersion.RMCP1_0;
        }
        throw new IllegalArgumentException("Illegal RMCP version");
    }

    private static int decodeSequenceNumber(byte sequenceNumber) {
        return TypeConverter.byteToInt(sequenceNumber);
    }

    private static RmcpClassOfMessage decodeClassOfMessage(byte classOfMessage) {
        return RmcpClassOfMessage.parseInt(TypeConverter.byteToInt(classOfMessage) & 0x9F);
    }

    private static byte[] decodeData(byte[] rawMessage) {
        byte[] data = new byte[rawMessage.length - 4];
        System.arraycopy(rawMessage, 4, data, 0, data.length);
        return data;
    }
}

