/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.ipmi.core.coding.protocol.decoder;

import org.sentrysoftware.ipmi.core.coding.protocol.AuthenticationType;
import org.sentrysoftware.ipmi.core.coding.protocol.IpmiMessage;
import org.sentrysoftware.ipmi.core.coding.protocol.Ipmiv15Message;
import org.sentrysoftware.ipmi.core.coding.protocol.PayloadType;
import org.sentrysoftware.ipmi.core.coding.protocol.decoder.ProtocolDecoder;
import org.sentrysoftware.ipmi.core.coding.rmcp.RmcpMessage;
import org.sentrysoftware.ipmi.core.common.TypeConverter;

public class Protocolv15Decoder
extends ProtocolDecoder {
    @Override
    public IpmiMessage decode(RmcpMessage rmcpMessage) {
        Ipmiv15Message message = new Ipmiv15Message();
        byte[] raw = rmcpMessage.getData();
        message.setAuthenticationType(Protocolv15Decoder.decodeAuthenticationType(raw[0]));
        int offset = 1;
        message.setSessionSequenceNumber(this.decodeSessionSequenceNumber(raw, offset));
        message.setSessionID(Protocolv15Decoder.decodeSessionID(raw, offset += 4));
        offset += 4;
        if (message.getAuthenticationType() != AuthenticationType.None) {
            message.setAuthCode(this.decodeAuthCode(raw, offset));
            offset += 16;
        }
        int payloadLength = this.decodePayloadLength(raw, offset);
        message.setPayloadLength(payloadLength);
        message.setPayload(this.decodePayload(raw, ++offset, payloadLength, message.getConfidentialityAlgorithm(), PayloadType.Ipmi));
        return message;
    }

    private byte[] decodeAuthCode(byte[] rawMessage, int offset) {
        byte[] authCode = new byte[16];
        System.arraycopy(rawMessage, offset, authCode, 0, 16);
        return authCode;
    }

    @Override
    protected int decodePayloadLength(byte[] rawData, int offset) {
        return TypeConverter.byteToInt(rawData[offset]);
    }
}

