/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.ipmi.core.coding.commands.session;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import org.sentrysoftware.ipmi.core.coding.commands.IpmiCommandCoder;
import org.sentrysoftware.ipmi.core.coding.commands.IpmiVersion;
import org.sentrysoftware.ipmi.core.coding.commands.PrivilegeLevel;
import org.sentrysoftware.ipmi.core.coding.commands.ResponseData;
import org.sentrysoftware.ipmi.core.coding.commands.session.GetChannelAuthenticationCapabilitiesResponseData;
import org.sentrysoftware.ipmi.core.coding.payload.CompletionCode;
import org.sentrysoftware.ipmi.core.coding.payload.IpmiPayload;
import org.sentrysoftware.ipmi.core.coding.payload.lan.IPMIException;
import org.sentrysoftware.ipmi.core.coding.payload.lan.IpmiLanRequest;
import org.sentrysoftware.ipmi.core.coding.payload.lan.IpmiLanResponse;
import org.sentrysoftware.ipmi.core.coding.payload.lan.NetworkFunction;
import org.sentrysoftware.ipmi.core.coding.protocol.AuthenticationType;
import org.sentrysoftware.ipmi.core.coding.protocol.IpmiMessage;
import org.sentrysoftware.ipmi.core.coding.protocol.Ipmiv15Message;
import org.sentrysoftware.ipmi.core.coding.security.CipherSuite;
import org.sentrysoftware.ipmi.core.common.TypeConverter;

public class GetChannelAuthenticationCapabilities
extends IpmiCommandCoder {
    private PrivilegeLevel requestedPrivilegeLevel;
    private byte channelNumber;
    private IpmiVersion requestVersion;

    public void setRequestedPrivilegeLevel(PrivilegeLevel requestedPrivilegeLevel) {
        this.requestedPrivilegeLevel = requestedPrivilegeLevel;
    }

    public PrivilegeLevel getRequestedPrivilegeLevel() {
        return this.requestedPrivilegeLevel;
    }

    public void setChannelNumber(int channelNumber) {
        if (channelNumber < 0 || channelNumber > 15 || channelNumber == 12 || channelNumber == 13) {
            throw new IllegalArgumentException("Invalid channel number");
        }
        this.channelNumber = TypeConverter.intToByte(channelNumber);
    }

    public int getChannelNumber() {
        return TypeConverter.byteToInt(this.channelNumber);
    }

    protected void setRequestVersion(IpmiVersion requestVersion) {
        this.requestVersion = requestVersion;
    }

    protected IpmiVersion getRequestVersion() {
        return this.requestVersion;
    }

    public GetChannelAuthenticationCapabilities() {
        this.setRequestedPrivilegeLevel(PrivilegeLevel.User);
        this.setChannelNumber(14);
    }

    public GetChannelAuthenticationCapabilities(IpmiVersion version, IpmiVersion requestVersion, CipherSuite cipherSuite) {
        super(version, cipherSuite, AuthenticationType.None);
        this.setRequestVersion(requestVersion);
        this.setRequestedPrivilegeLevel(PrivilegeLevel.User);
        this.setChannelNumber(14);
    }

    public GetChannelAuthenticationCapabilities(IpmiVersion version, IpmiVersion requestVersion, CipherSuite cipherSuite, PrivilegeLevel privilegeLevel, byte channelNumber) {
        super(version, cipherSuite, AuthenticationType.None);
        this.setRequestVersion(requestVersion);
        this.setRequestedPrivilegeLevel(privilegeLevel);
        this.setChannelNumber(channelNumber);
    }

    @Override
    public IpmiMessage encodePayload(int messageSequenceNumber, int sessionSequenceNumber, int sessionId) throws InvalidKeyException, NoSuchAlgorithmException {
        if (this.getIpmiVersion() == IpmiVersion.V15) {
            if (sessionId != 0) {
                throw new IllegalArgumentException("Session ID must be 0");
            }
            Ipmiv15Message message = new Ipmiv15Message();
            message.setAuthenticationType(this.getAuthenticationType());
            message.setSessionSequenceNumber(0);
            message.setSessionID(0);
            message.setPayload(this.preparePayload(messageSequenceNumber));
            return message;
        }
        this.setAuthenticationType(AuthenticationType.RMCPPlus);
        return super.encodePayload(messageSequenceNumber, sessionSequenceNumber, sessionId);
    }

    @Override
    protected IpmiPayload preparePayload(int sequenceNumber) {
        byte[] payload = new byte[2];
        payload[0] = 0;
        if (this.getRequestVersion() == IpmiVersion.V20) {
            payload[0] = (byte)(payload[0] | TypeConverter.intToByte(128));
        }
        payload[0] = (byte)(payload[0] | this.channelNumber);
        payload[1] = this.encodePrivilegeLevel(this.requestedPrivilegeLevel);
        return new IpmiLanRequest(this.getNetworkFunction(), this.getCommandCode(), payload, TypeConverter.intToByte(sequenceNumber));
    }

    @Override
    public byte getCommandCode() {
        return 56;
    }

    @Override
    public NetworkFunction getNetworkFunction() {
        return NetworkFunction.ApplicationRequest;
    }

    @Override
    public ResponseData getResponseData(IpmiMessage message) throws IPMIException {
        if (!this.isCommandResponse(message)) {
            throw new IllegalArgumentException("This is not a response for Get Channel Authentication Capabilities command");
        }
        if (!(message.getPayload() instanceof IpmiLanResponse)) {
            throw new IllegalArgumentException("Invalid response payload");
        }
        if (((IpmiLanResponse)message.getPayload()).getCompletionCode() != CompletionCode.Ok) {
            throw new IPMIException(((IpmiLanResponse)message.getPayload()).getCompletionCode());
        }
        GetChannelAuthenticationCapabilitiesResponseData responseData = new GetChannelAuthenticationCapabilitiesResponseData();
        byte[] raw = message.getPayload().getIpmiCommandData();
        if (raw.length != 8) {
            throw new IllegalArgumentException("Data has invalid length");
        }
        responseData.setChannelNumber(raw[0]);
        responseData.setIpmiv20Support((raw[1] & 0x80) != 0);
        responseData.setAuthenticationTypes(new ArrayList<AuthenticationType>());
        if ((raw[1] & 0x20) != 0) {
            responseData.getAuthenticationTypes().add(AuthenticationType.Oem);
        }
        if ((raw[1] & 0x10) != 0) {
            responseData.getAuthenticationTypes().add(AuthenticationType.Simple);
        }
        if ((raw[1] & 4) != 0) {
            responseData.getAuthenticationTypes().add(AuthenticationType.Md5);
        }
        if ((raw[1] & 2) != 0) {
            responseData.getAuthenticationTypes().add(AuthenticationType.Md2);
        }
        if ((raw[1] & 1) != 0) {
            responseData.getAuthenticationTypes().add(AuthenticationType.None);
        }
        responseData.setKgEnabled((raw[2] & 0x20) != 0);
        responseData.setPerMessageAuthenticationEnabled((raw[2] & 0x10) == 0);
        responseData.setUserLevelAuthenticationEnabled((raw[2] & 8) == 0);
        responseData.setNonNullUsernamesEnabled((raw[2] & 4) != 0);
        responseData.setNullUsernamesEnabled((raw[2] & 2) != 0);
        responseData.setAnonymusLoginEnabled((raw[2] & 1) != 0);
        byte[] oemId = new byte[4];
        System.arraycopy(raw, 4, oemId, 0, 3);
        oemId[3] = 0;
        responseData.setOemId(TypeConverter.littleEndianByteArrayToInt(oemId));
        responseData.setOemData(raw[7]);
        return responseData;
    }

    @Override
    public void setSessionParameters(IpmiVersion version, CipherSuite cipherSuite, AuthenticationType authenticationType) {
        if (version == IpmiVersion.V20 && authenticationType != AuthenticationType.RMCPPlus && authenticationType != AuthenticationType.None) {
            throw new IllegalArgumentException("Authentication Type must be RMCPPlus for IPMI v2.0 messages");
        }
        this.setIpmiVersion(version);
        this.setAuthenticationType(authenticationType);
        this.setCipherSuite(cipherSuite);
    }
}

