/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.ipmi.core.coding.commands.sel;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import org.sentrysoftware.ipmi.core.coding.commands.IpmiCommandCoder;
import org.sentrysoftware.ipmi.core.coding.commands.IpmiVersion;
import org.sentrysoftware.ipmi.core.coding.commands.ResponseData;
import org.sentrysoftware.ipmi.core.coding.commands.sel.GetSelInfoResponseData;
import org.sentrysoftware.ipmi.core.coding.payload.CompletionCode;
import org.sentrysoftware.ipmi.core.coding.payload.IpmiPayload;
import org.sentrysoftware.ipmi.core.coding.payload.lan.IPMIException;
import org.sentrysoftware.ipmi.core.coding.payload.lan.IpmiLanRequest;
import org.sentrysoftware.ipmi.core.coding.payload.lan.IpmiLanResponse;
import org.sentrysoftware.ipmi.core.coding.payload.lan.NetworkFunction;
import org.sentrysoftware.ipmi.core.coding.protocol.AuthenticationType;
import org.sentrysoftware.ipmi.core.coding.protocol.IpmiMessage;
import org.sentrysoftware.ipmi.core.coding.security.CipherSuite;
import org.sentrysoftware.ipmi.core.common.TypeConverter;

public class GetSelInfo
extends IpmiCommandCoder {
    public GetSelInfo(IpmiVersion version, CipherSuite cipherSuite, AuthenticationType authenticationType) {
        super(version, cipherSuite, authenticationType);
    }

    @Override
    public byte getCommandCode() {
        return 64;
    }

    @Override
    public NetworkFunction getNetworkFunction() {
        return NetworkFunction.StorageRequest;
    }

    @Override
    protected IpmiPayload preparePayload(int sequenceNumber) throws NoSuchAlgorithmException, InvalidKeyException {
        return new IpmiLanRequest(this.getNetworkFunction(), this.getCommandCode(), null, TypeConverter.intToByte(sequenceNumber));
    }

    @Override
    public ResponseData getResponseData(IpmiMessage message) throws IPMIException, NoSuchAlgorithmException, InvalidKeyException {
        if (!this.isCommandResponse(message)) {
            throw new IllegalArgumentException("This is not a response for Get SEL Info command");
        }
        if (!(message.getPayload() instanceof IpmiLanResponse)) {
            throw new IllegalArgumentException("Invalid response payload");
        }
        if (((IpmiLanResponse)message.getPayload()).getCompletionCode() != CompletionCode.Ok) {
            throw new IPMIException(((IpmiLanResponse)message.getPayload()).getCompletionCode());
        }
        byte[] raw = message.getPayload().getIpmiCommandData();
        if (raw == null || raw.length != 14) {
            throw new IllegalArgumentException("Invalid response payload length: " + (raw != null ? Integer.valueOf(raw.length) : "null"));
        }
        GetSelInfoResponseData responseData = new GetSelInfoResponseData();
        responseData.setSelVersion(TypeConverter.littleEndianBcdByteToInt(raw[0]));
        byte[] buffer = new byte[]{raw[1], raw[2], 0, 0};
        responseData.setEntriesCount(TypeConverter.littleEndianByteArrayToInt(buffer));
        System.arraycopy(raw, 5, buffer, 0, 4);
        responseData.setAdditionTimestamp(TypeConverter.decodeDate(TypeConverter.littleEndianByteArrayToInt(buffer)));
        System.arraycopy(raw, 9, buffer, 0, 4);
        responseData.setEraseTimestamp(TypeConverter.decodeDate(TypeConverter.littleEndianByteArrayToInt(buffer)));
        return responseData;
    }
}

