/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.ipmi.core.coding.commands.sdr;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import org.sentrysoftware.ipmi.core.coding.commands.IpmiCommandCoder;
import org.sentrysoftware.ipmi.core.coding.commands.IpmiVersion;
import org.sentrysoftware.ipmi.core.coding.commands.ResponseData;
import org.sentrysoftware.ipmi.core.coding.commands.sdr.GetSensorReadingResponseData;
import org.sentrysoftware.ipmi.core.coding.commands.sdr.SensorState;
import org.sentrysoftware.ipmi.core.coding.payload.CompletionCode;
import org.sentrysoftware.ipmi.core.coding.payload.IpmiPayload;
import org.sentrysoftware.ipmi.core.coding.payload.lan.IPMIException;
import org.sentrysoftware.ipmi.core.coding.payload.lan.IpmiLanRequest;
import org.sentrysoftware.ipmi.core.coding.payload.lan.IpmiLanResponse;
import org.sentrysoftware.ipmi.core.coding.payload.lan.NetworkFunction;
import org.sentrysoftware.ipmi.core.coding.protocol.AuthenticationType;
import org.sentrysoftware.ipmi.core.coding.protocol.IpmiMessage;
import org.sentrysoftware.ipmi.core.coding.security.CipherSuite;
import org.sentrysoftware.ipmi.core.common.TypeConverter;

public class GetSensorReading
extends IpmiCommandCoder {
    private byte sensorId;

    public GetSensorReading(IpmiVersion version, CipherSuite cipherSuite, AuthenticationType authenticationType, int sensorId) {
        super(version, cipherSuite, authenticationType);
        this.sensorId = TypeConverter.intToByte(sensorId);
    }

    @Override
    public byte getCommandCode() {
        return 45;
    }

    @Override
    public NetworkFunction getNetworkFunction() {
        return NetworkFunction.SensorRequest;
    }

    @Override
    protected IpmiPayload preparePayload(int sequenceNumber) throws NoSuchAlgorithmException, InvalidKeyException {
        byte[] payloadData = new byte[]{this.sensorId};
        return new IpmiLanRequest(this.getNetworkFunction(), this.getCommandCode(), payloadData, TypeConverter.intToByte(sequenceNumber));
    }

    @Override
    public ResponseData getResponseData(IpmiMessage message) throws IPMIException, NoSuchAlgorithmException, InvalidKeyException {
        if (!this.isCommandResponse(message)) {
            throw new IllegalArgumentException("This is not a response for Get Sensor Reading command");
        }
        if (!(message.getPayload() instanceof IpmiLanResponse)) {
            throw new IllegalArgumentException("Invalid response payload");
        }
        if (((IpmiLanResponse)message.getPayload()).getCompletionCode() != CompletionCode.Ok) {
            throw new IPMIException(((IpmiLanResponse)message.getPayload()).getCompletionCode());
        }
        byte[] raw = message.getPayload().getIpmiCommandData();
        if (raw.length < 2) {
            throw new IllegalStateException("Invalid data length");
        }
        GetSensorReadingResponseData responseData = new GetSensorReadingResponseData();
        responseData.setRaw(raw);
        responseData.setSensorReading(raw[0]);
        responseData.setSensorStateValid((TypeConverter.byteToInt(raw[1]) & 0x20) == 0);
        if (raw.length >= 3) {
            int i;
            responseData.setSensorState(SensorState.parseInt(TypeConverter.byteToInt(raw[2]) & 0x3F));
            boolean[] states = null;
            states = raw.length > 3 ? new boolean[16] : new boolean[8];
            for (i = 0; i < 8; ++i) {
                states[i] = (TypeConverter.byteToInt(raw[2]) & 1 << i) != 0;
            }
            if (raw.length > 3) {
                for (i = 0; i < 7; ++i) {
                    states[i + 8] = (TypeConverter.byteToInt(raw[3]) & 1 << i) != 0;
                }
                states[15] = false;
            }
            responseData.setStatesAsserted(states);
        }
        return responseData;
    }
}

