/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.ipmi.core.coding.commands.payload;

import java.util.HashSet;
import java.util.Set;
import org.sentrysoftware.ipmi.core.coding.commands.ResponseData;
import org.sentrysoftware.ipmi.core.coding.protocol.PayloadType;
import org.sentrysoftware.ipmi.core.common.TypeConverter;

public class GetChannelPayloadSupportResponseData
implements ResponseData {
    private byte standardPayloads;
    private byte sessionSetupPayloads;
    private byte oemPayloads;
    private Set<PayloadType> supportedPayloads;

    public void setStandardPayloads(byte standardPayloads) {
        this.standardPayloads = standardPayloads;
    }

    public void setSessionSetupPayloads(byte sessionSetupPayloads) {
        this.sessionSetupPayloads = sessionSetupPayloads;
    }

    public void setOemPayloads(byte oemPayloads) {
        this.oemPayloads = oemPayloads;
    }

    public Set<PayloadType> getSupportedPayloads() {
        if (this.supportedPayloads == null) {
            this.initializeSupportedPayloads();
        }
        return this.supportedPayloads;
    }

    private void initializeSupportedPayloads() {
        this.supportedPayloads = new HashSet<PayloadType>();
        this.lookForGivenPayloads(this.standardPayloads, PayloadType.Ipmi, PayloadType.Sol, PayloadType.Oem);
        this.lookForGivenPayloads(this.sessionSetupPayloads, PayloadType.RmcpOpenSessionRequest, PayloadType.RmcpOpenSessionResponse, PayloadType.Rakp1, PayloadType.Rakp2, PayloadType.Rakp3, PayloadType.Rakp4);
        this.lookForGivenPayloads(this.oemPayloads, PayloadType.Oem0, PayloadType.Oem1, PayloadType.Oem2, PayloadType.Oem3, PayloadType.Oem4, PayloadType.Oem5, PayloadType.Oem6, PayloadType.Oem7);
    }

    private void lookForGivenPayloads(byte payloadsByte, PayloadType ... types) {
        for (int i = 0; i < types.length; ++i) {
            if (!TypeConverter.isBitSetOnPosition(i, payloadsByte)) continue;
            this.supportedPayloads.add(types[i]);
        }
    }
}

