/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.ipmi.core.coding.commands.payload;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import org.sentrysoftware.ipmi.core.coding.commands.IpmiCommandCoder;
import org.sentrysoftware.ipmi.core.coding.commands.IpmiVersion;
import org.sentrysoftware.ipmi.core.coding.commands.ResponseData;
import org.sentrysoftware.ipmi.core.coding.commands.payload.DeactivatePayloadCompletionCode;
import org.sentrysoftware.ipmi.core.coding.commands.payload.DeactivatePayloadResponseData;
import org.sentrysoftware.ipmi.core.coding.payload.CompletionCode;
import org.sentrysoftware.ipmi.core.coding.payload.IpmiPayload;
import org.sentrysoftware.ipmi.core.coding.payload.lan.IPMIException;
import org.sentrysoftware.ipmi.core.coding.payload.lan.IpmiLanRequest;
import org.sentrysoftware.ipmi.core.coding.payload.lan.IpmiLanResponse;
import org.sentrysoftware.ipmi.core.coding.payload.lan.NetworkFunction;
import org.sentrysoftware.ipmi.core.coding.protocol.AuthenticationType;
import org.sentrysoftware.ipmi.core.coding.protocol.IpmiMessage;
import org.sentrysoftware.ipmi.core.coding.protocol.PayloadType;
import org.sentrysoftware.ipmi.core.coding.security.CipherSuite;
import org.sentrysoftware.ipmi.core.common.MessageComposer;
import org.sentrysoftware.ipmi.core.common.TypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeactivatePayload
extends IpmiCommandCoder {
    private static final Logger logger = LoggerFactory.getLogger(DeactivatePayload.class);
    private static final int REQUEST_DATA_LENGTH = 6;
    private final PayloadType payloadType;
    private final int payloadInstance;

    public DeactivatePayload(CipherSuite cipherSuite, PayloadType payloadType, int payloadInstance) {
        super(IpmiVersion.V20, cipherSuite, AuthenticationType.RMCPPlus);
        this.payloadType = payloadType;
        this.payloadInstance = payloadInstance;
    }

    @Override
    public byte getCommandCode() {
        return 73;
    }

    public DeactivatePayload(PayloadType payloadType, int payloadInstance) {
        this.payloadType = payloadType;
        this.payloadInstance = payloadInstance;
    }

    @Override
    public NetworkFunction getNetworkFunction() {
        return NetworkFunction.ApplicationRequest;
    }

    @Override
    protected IpmiPayload preparePayload(int sequenceNumber) throws NoSuchAlgorithmException, InvalidKeyException {
        byte[] message = MessageComposer.get(6).appendField(TypeConverter.intToByte(this.payloadType.getCode())).appendField(TypeConverter.intToByte(this.payloadInstance)).getMessage();
        return new IpmiLanRequest(this.getNetworkFunction(), this.getCommandCode(), message, TypeConverter.intToByte(sequenceNumber));
    }

    @Override
    public ResponseData getResponseData(IpmiMessage message) throws IPMIException, NoSuchAlgorithmException, InvalidKeyException {
        if (!this.isCommandResponse(message)) {
            throw new IllegalArgumentException("This is not a response for Deactivate Payload command");
        }
        if (!(message.getPayload() instanceof IpmiLanResponse)) {
            throw new IllegalArgumentException("Invalid response payload");
        }
        CompletionCode completionCode = ((IpmiLanResponse)message.getPayload()).getCompletionCode();
        if (completionCode != CompletionCode.Ok) {
            DeactivatePayloadCompletionCode specificCompletionCode = DeactivatePayloadCompletionCode.parseInt(completionCode.getCode());
            if (specificCompletionCode == DeactivatePayloadCompletionCode.PAYLOAD_ALREADY_DEACTIVATED) {
                logger.warn(specificCompletionCode.getMessage());
            } else {
                throw new IPMIException(((IpmiLanResponse)message.getPayload()).getCompletionCode());
            }
        }
        return new DeactivatePayloadResponseData();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeactivatePayload that = (DeactivatePayload)o;
        if (this.payloadInstance != that.payloadInstance) {
            return false;
        }
        if (this.payloadType != that.payloadType) {
            return false;
        }
        return this.getCipherSuite().equals(that.getCipherSuite());
    }

    public int hashCode() {
        int result = this.payloadInstance;
        result = 31 * result + this.payloadType.getCode();
        result = 31 * result + (this.getCipherSuite() == null ? 0 : this.getCipherSuite().hashCode());
        return result;
    }
}

