/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.ipmi.core.coding.commands.fru.record;

import java.util.ArrayList;
import org.sentrysoftware.ipmi.core.coding.commands.fru.record.FruRecord;
import org.sentrysoftware.ipmi.core.common.TypeConverter;

public class ProductInfo
extends FruRecord {
    private String manufacturerName = "";
    private String productName = "";
    private String productModelNumber = "";
    private String productVersion = "";
    private String productSerialNumber = "";
    private String assetTag = "";
    private byte[] fruFileId = new byte[0];
    private String[] customProductInfo = new String[0];

    public ProductInfo(byte[] fruData, int offset) {
        if (fruData[offset] != 1) {
            throw new IllegalArgumentException("Invalid format version");
        }
        int languageCode = TypeConverter.byteToInt(fruData[offset + 2]);
        int partNumber = TypeConverter.byteToInt(fruData[offset + 3]);
        ArrayList<String> customInfo = this.readCustomInfo(fruData, languageCode, partNumber, offset + 4);
        this.customProductInfo = new String[customInfo.size()];
        this.customProductInfo = customInfo.toArray(this.customProductInfo);
    }

    private ArrayList<String> readCustomInfo(byte[] fruData, int languageCode, int partNumber, int offset) {
        int index = 0;
        ArrayList<String> customInfo = new ArrayList<String>();
        int currentOffset = offset;
        int currentPartNumber = partNumber;
        block9: while (currentPartNumber != 193 && currentOffset < fruData.length) {
            int partType = (currentPartNumber & 0xC0) >> 6;
            int partDataLength = currentPartNumber & 0x3F;
            if (this.partDataLengthWithinBounds(fruData, currentOffset, partDataLength)) {
                byte[] partNumberData = new byte[partDataLength];
                System.arraycopy(fruData, currentOffset, partNumberData, 0, partDataLength);
                currentOffset += partDataLength;
                switch (index) {
                    case 0: {
                        this.setManufacturerName(FruRecord.decodeString(partType, partNumberData, this.isEnglishLanguageCode(languageCode)));
                        break;
                    }
                    case 1: {
                        this.setProductName(FruRecord.decodeString(partType, partNumberData, this.isEnglishLanguageCode(languageCode)));
                        break;
                    }
                    case 2: {
                        this.setProductModelNumber(FruRecord.decodeString(partType, partNumberData, this.isEnglishLanguageCode(languageCode)));
                        break;
                    }
                    case 3: {
                        this.setProductVersion(FruRecord.decodeString(partType, partNumberData, this.isEnglishLanguageCode(languageCode)));
                        break;
                    }
                    case 4: {
                        this.setProductSerialNumber(FruRecord.decodeString(partType, partNumberData, true));
                        break;
                    }
                    case 5: {
                        this.setAssetTag(FruRecord.decodeString(partType, partNumberData, this.isEnglishLanguageCode(languageCode)));
                        break;
                    }
                    case 6: {
                        this.setFruFileId(partNumberData);
                        break;
                    }
                    default: {
                        if (partDataLength == 0) {
                            currentPartNumber = TypeConverter.byteToInt(fruData[currentOffset]);
                            ++currentOffset;
                            continue block9;
                        }
                        customInfo.add(FruRecord.decodeString(partType, partNumberData, this.isEnglishLanguageCode(languageCode)));
                    }
                }
            }
            currentPartNumber = TypeConverter.byteToInt(fruData[currentOffset]);
            ++currentOffset;
            ++index;
        }
        return customInfo;
    }

    private boolean isEnglishLanguageCode(int languageCode) {
        return languageCode != 0 && languageCode != 25;
    }

    private boolean partDataLengthWithinBounds(byte[] fruData, int currentOffset, int partDataLength) {
        return partDataLength > 0 && partDataLength + currentOffset < fruData.length;
    }

    public String getManufacturerName() {
        return this.manufacturerName;
    }

    public void setManufacturerName(String manufacturerName) {
        this.manufacturerName = manufacturerName;
    }

    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public String getProductModelNumber() {
        return this.productModelNumber;
    }

    public void setProductModelNumber(String productModelNumber) {
        this.productModelNumber = productModelNumber;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public void setProductVersion(String productVersion) {
        this.productVersion = productVersion;
    }

    public void setProductSerialNumber(String productSerialNumber) {
        this.productSerialNumber = productSerialNumber;
    }

    public String getProductSerialNumber() {
        return this.productSerialNumber;
    }

    public String getAssetTag() {
        return this.assetTag;
    }

    public void setAssetTag(String assetTag) {
        this.assetTag = assetTag;
    }

    public byte[] getFruFileId() {
        return this.fruFileId;
    }

    public void setFruFileId(byte[] fruFileId) {
        this.fruFileId = fruFileId;
    }

    public String[] getCustomProductInfo() {
        return this.customProductInfo;
    }

    public void setCustomProductInfo(String[] customProductInfo) {
        this.customProductInfo = customProductInfo;
    }
}

