/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.ipmi.core.coding.commands.fru;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import org.sentrysoftware.ipmi.core.coding.commands.IpmiCommandCoder;
import org.sentrysoftware.ipmi.core.coding.commands.IpmiVersion;
import org.sentrysoftware.ipmi.core.coding.commands.ResponseData;
import org.sentrysoftware.ipmi.core.coding.commands.fru.BaseUnit;
import org.sentrysoftware.ipmi.core.coding.commands.fru.GetFruInventoryAreaInfoResponseData;
import org.sentrysoftware.ipmi.core.coding.payload.CompletionCode;
import org.sentrysoftware.ipmi.core.coding.payload.IpmiPayload;
import org.sentrysoftware.ipmi.core.coding.payload.lan.IPMIException;
import org.sentrysoftware.ipmi.core.coding.payload.lan.IpmiLanRequest;
import org.sentrysoftware.ipmi.core.coding.payload.lan.IpmiLanResponse;
import org.sentrysoftware.ipmi.core.coding.payload.lan.NetworkFunction;
import org.sentrysoftware.ipmi.core.coding.protocol.AuthenticationType;
import org.sentrysoftware.ipmi.core.coding.protocol.IpmiMessage;
import org.sentrysoftware.ipmi.core.coding.security.CipherSuite;
import org.sentrysoftware.ipmi.core.common.TypeConverter;

public class GetFruInventoryAreaInfo
extends IpmiCommandCoder {
    private int fruId;

    public GetFruInventoryAreaInfo(IpmiVersion version, CipherSuite cipherSuite, AuthenticationType authenticationType, int fruId) {
        super(version, cipherSuite, authenticationType);
        if (fruId > 255) {
            throw new IllegalArgumentException("FRU ID cannot exceed 255");
        }
        this.fruId = fruId;
    }

    @Override
    public byte getCommandCode() {
        return 16;
    }

    @Override
    public NetworkFunction getNetworkFunction() {
        return NetworkFunction.StorageRequest;
    }

    @Override
    protected IpmiPayload preparePayload(int sequenceNumber) throws NoSuchAlgorithmException, InvalidKeyException {
        byte[] payload = new byte[]{TypeConverter.intToByte(this.fruId)};
        return new IpmiLanRequest(this.getNetworkFunction(), this.getCommandCode(), payload, TypeConverter.intToByte(sequenceNumber));
    }

    @Override
    public ResponseData getResponseData(IpmiMessage message) throws IPMIException, NoSuchAlgorithmException, InvalidKeyException {
        if (!this.isCommandResponse(message)) {
            throw new IllegalArgumentException("This is not a response for Get FRU Inventory Info command");
        }
        if (!(message.getPayload() instanceof IpmiLanResponse)) {
            throw new IllegalArgumentException("Invalid response payload");
        }
        if (((IpmiLanResponse)message.getPayload()).getCompletionCode() != CompletionCode.Ok) {
            throw new IPMIException(((IpmiLanResponse)message.getPayload()).getCompletionCode());
        }
        byte[] raw = message.getPayload().getIpmiCommandData();
        if (raw == null || raw.length != 3) {
            throw new IllegalArgumentException("Invalid response payload length");
        }
        GetFruInventoryAreaInfoResponseData responseData = new GetFruInventoryAreaInfoResponseData();
        byte[] buffer = new byte[]{raw[0], raw[1], 0, 0};
        responseData.setFruInventoryAreaSize(TypeConverter.littleEndianByteArrayToInt(buffer));
        responseData.setFruUnit(BaseUnit.parseInt(TypeConverter.byteToInt(raw[2]) & 1));
        return responseData;
    }
}

