/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.ipmi.core.coding.commands.chassis;

import org.sentrysoftware.ipmi.core.coding.commands.ResponseData;
import org.sentrysoftware.ipmi.core.coding.commands.chassis.ChassisIdentifyState;
import org.sentrysoftware.ipmi.core.coding.commands.chassis.PowerRestorePolicy;
import org.sentrysoftware.ipmi.core.common.TypeConverter;

public class GetChassisStatusResponseData
implements ResponseData {
    public static final String FRONT_PANEL_BUTTON_CAPABILITIES_NOT_SET_MESSAGE = "Front Panel Button Capabilities not set";
    private byte currentPowerState;
    private byte lastPowerEvent;
    private byte miscChassisState;
    private boolean isFrontPanelButtonCapabilitiesSet;
    private byte frontPanelButtonCapabilities;

    public GetChassisStatusResponseData() {
        this.setFrontPanelButtonCapabilitiesSet(false);
    }

    public void setCurrentPowerState(byte currentPowerState) {
        this.currentPowerState = currentPowerState;
    }

    public byte getCurrentPowerState() {
        return this.currentPowerState;
    }

    public PowerRestorePolicy getPowerRestorePolicy() {
        switch ((this.currentPowerState & TypeConverter.intToByte(96)) >> 5) {
            case 0: {
                return PowerRestorePolicy.PoweredOff;
            }
            case 1: {
                return PowerRestorePolicy.PowerRestored;
            }
            case 2: {
                return PowerRestorePolicy.PoweredUp;
            }
        }
        throw new IllegalArgumentException("Invalid Power Restore Policy");
    }

    public boolean isPowerControlFault() {
        return (this.currentPowerState & TypeConverter.intToByte(16)) != 0;
    }

    public boolean isPowerFault() {
        return (this.currentPowerState & TypeConverter.intToByte(8)) != 0;
    }

    public boolean isInterlock() {
        return (this.currentPowerState & TypeConverter.intToByte(4)) != 0;
    }

    public boolean isPowerOverload() {
        return (this.currentPowerState & TypeConverter.intToByte(2)) != 0;
    }

    public boolean isPowerOn() {
        return (this.currentPowerState & TypeConverter.intToByte(1)) != 0;
    }

    public void setLastPowerEvent(byte lastPowerEvent) {
        this.lastPowerEvent = lastPowerEvent;
    }

    public byte getLastPowerEvent() {
        return this.lastPowerEvent;
    }

    public boolean wasIpmiPowerOn() {
        return (this.lastPowerEvent & TypeConverter.intToByte(16)) != 0;
    }

    public boolean wasPowerFault() {
        return (this.lastPowerEvent & TypeConverter.intToByte(8)) != 0;
    }

    public boolean wasInterlock() {
        return (this.lastPowerEvent & TypeConverter.intToByte(4)) != 0;
    }

    public boolean wasPowerOverload() {
        return (this.lastPowerEvent & TypeConverter.intToByte(2)) != 0;
    }

    public boolean acFailed() {
        return (this.lastPowerEvent & TypeConverter.intToByte(1)) != 0;
    }

    public void setMiscChassisState(byte miscChassisState) {
        this.miscChassisState = miscChassisState;
    }

    public byte getMiscChassisState() {
        return this.miscChassisState;
    }

    public boolean isChassisIdentifyCommandSupported() {
        return (this.miscChassisState & TypeConverter.intToByte(64)) != 0;
    }

    public ChassisIdentifyState getChassisIdentifyState() {
        if (!this.isChassisIdentifyCommandSupported()) {
            throw new IllegalAccessError("Chassis Idetify command and state not supported");
        }
        return ChassisIdentifyState.parseInt((this.miscChassisState & TypeConverter.intToByte(48)) >> 4);
    }

    public boolean coolingFaultDetected() {
        return (this.miscChassisState & TypeConverter.intToByte(8)) != 0;
    }

    public boolean driveFaultDetected() {
        return (this.miscChassisState & TypeConverter.intToByte(4)) != 0;
    }

    public boolean isFrontPanelLockoutActive() {
        return (this.miscChassisState & TypeConverter.intToByte(2)) != 0;
    }

    public boolean isChassisIntrusionActive() {
        return (this.miscChassisState & TypeConverter.intToByte(1)) != 0;
    }

    public void setFrontPanelButtonCapabilities(byte frontPanelButtonCapabilities) {
        this.frontPanelButtonCapabilities = frontPanelButtonCapabilities;
        this.setFrontPanelButtonCapabilitiesSet(true);
    }

    public byte getFrontPanelButtonCapabilities() {
        return this.frontPanelButtonCapabilities;
    }

    public boolean isStandbyButtonDisableAllowed() throws IllegalAccessException {
        if (!this.isFrontPanelButtonCapabilitiesSet()) {
            throw new IllegalAccessException(FRONT_PANEL_BUTTON_CAPABILITIES_NOT_SET_MESSAGE);
        }
        return (this.frontPanelButtonCapabilities & TypeConverter.intToByte(128)) != 0;
    }

    public boolean isDiagnosticInterruptButtonDisableAllowed() throws IllegalAccessException {
        if (!this.isFrontPanelButtonCapabilitiesSet()) {
            throw new IllegalAccessException(FRONT_PANEL_BUTTON_CAPABILITIES_NOT_SET_MESSAGE);
        }
        return (this.frontPanelButtonCapabilities & TypeConverter.intToByte(64)) != 0;
    }

    public boolean isResetButtonDisableAllowed() throws IllegalAccessException {
        if (!this.isFrontPanelButtonCapabilitiesSet()) {
            throw new IllegalAccessException(FRONT_PANEL_BUTTON_CAPABILITIES_NOT_SET_MESSAGE);
        }
        return (this.frontPanelButtonCapabilities & TypeConverter.intToByte(32)) != 0;
    }

    public boolean isPowerOffButtonDisableAllowed() throws IllegalAccessException {
        if (!this.isFrontPanelButtonCapabilitiesSet()) {
            throw new IllegalAccessException(FRONT_PANEL_BUTTON_CAPABILITIES_NOT_SET_MESSAGE);
        }
        return (this.frontPanelButtonCapabilities & TypeConverter.intToByte(16)) != 0;
    }

    public boolean isStandbyButtonDisabled() throws IllegalAccessException {
        if (!this.isFrontPanelButtonCapabilitiesSet()) {
            throw new IllegalAccessException(FRONT_PANEL_BUTTON_CAPABILITIES_NOT_SET_MESSAGE);
        }
        return (this.frontPanelButtonCapabilities & TypeConverter.intToByte(8)) != 0;
    }

    public boolean isDiagnosticInterruptButtonDisabled() throws IllegalAccessException {
        if (!this.isFrontPanelButtonCapabilitiesSet()) {
            throw new IllegalAccessException(FRONT_PANEL_BUTTON_CAPABILITIES_NOT_SET_MESSAGE);
        }
        return (this.frontPanelButtonCapabilities & TypeConverter.intToByte(4)) != 0;
    }

    public boolean isResetButtonDisabled() throws IllegalAccessException {
        if (!this.isFrontPanelButtonCapabilitiesSet()) {
            throw new IllegalAccessException(FRONT_PANEL_BUTTON_CAPABILITIES_NOT_SET_MESSAGE);
        }
        return (this.frontPanelButtonCapabilities & TypeConverter.intToByte(2)) != 0;
    }

    public boolean isPowerOffButtonDisabled() throws IllegalAccessException {
        if (!this.isFrontPanelButtonCapabilitiesSet()) {
            throw new IllegalAccessException(FRONT_PANEL_BUTTON_CAPABILITIES_NOT_SET_MESSAGE);
        }
        return (this.frontPanelButtonCapabilities & TypeConverter.intToByte(1)) != 0;
    }

    private void setFrontPanelButtonCapabilitiesSet(boolean isFrontPanelButtonCapabilitiesSet) {
        this.isFrontPanelButtonCapabilitiesSet = isFrontPanelButtonCapabilitiesSet;
    }

    public boolean isFrontPanelButtonCapabilitiesSet() {
        return this.isFrontPanelButtonCapabilitiesSet;
    }
}

