/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.ipmi.core.api.async;

import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import org.sentrysoftware.ipmi.core.api.async.ConnectionHandle;
import org.sentrysoftware.ipmi.core.api.async.InboundMessageListener;
import org.sentrysoftware.ipmi.core.api.async.IpmiResponseListener;
import org.sentrysoftware.ipmi.core.api.async.messages.IpmiError;
import org.sentrysoftware.ipmi.core.api.async.messages.IpmiResponse;
import org.sentrysoftware.ipmi.core.api.async.messages.IpmiResponseData;
import org.sentrysoftware.ipmi.core.coding.PayloadCoder;
import org.sentrysoftware.ipmi.core.coding.commands.PrivilegeLevel;
import org.sentrysoftware.ipmi.core.coding.commands.ResponseData;
import org.sentrysoftware.ipmi.core.coding.commands.session.GetChannelAuthenticationCapabilitiesResponseData;
import org.sentrysoftware.ipmi.core.coding.payload.IpmiPayload;
import org.sentrysoftware.ipmi.core.coding.protocol.PayloadType;
import org.sentrysoftware.ipmi.core.coding.security.CipherSuite;
import org.sentrysoftware.ipmi.core.common.PropertiesManager;
import org.sentrysoftware.ipmi.core.connection.Connection;
import org.sentrysoftware.ipmi.core.connection.ConnectionException;
import org.sentrysoftware.ipmi.core.connection.ConnectionListener;
import org.sentrysoftware.ipmi.core.connection.ConnectionManager;
import org.sentrysoftware.ipmi.core.connection.Session;
import org.sentrysoftware.ipmi.core.connection.SessionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpmiAsyncConnector
implements ConnectionListener {
    public static final String FAILED_TO_RECEIVE_ANSWER_CAUSE_MESSAGE = "Failed to receive answer, cause:";
    private ConnectionManager connectionManager;
    private SessionManager sessionManager;
    private int retries;
    private final List<IpmiResponseListener> responseListeners = new ArrayList<IpmiResponseListener>();
    private final List<InboundMessageListener> inboundMessageListeners = new ArrayList<InboundMessageListener>();
    private static Logger logger = LoggerFactory.getLogger(IpmiAsyncConnector.class);

    public IpmiAsyncConnector(int port) throws IOException {
        this.connectionManager = new ConnectionManager(port);
        this.sessionManager = new SessionManager();
        this.loadProperties();
    }

    public IpmiAsyncConnector(int port, InetAddress address) throws IOException {
        this.connectionManager = new ConnectionManager(port, address);
        this.sessionManager = new SessionManager();
        this.loadProperties();
    }

    private void loadProperties() {
        this.retries = Integer.parseInt(PropertiesManager.getInstance().getProperty("retries"));
    }

    public ConnectionHandle createConnection(InetAddress address, int port) throws IOException {
        int handle = this.connectionManager.createConnection(address, port);
        this.connectionManager.getConnection(handle).registerListener(this);
        return new ConnectionHandle(handle, address, port);
    }

    public ConnectionHandle createConnection(InetAddress address, int port, CipherSuite cipherSuite, PrivilegeLevel privilegeLevel) throws IOException {
        int handle = this.connectionManager.createConnection(address, port, true);
        this.connectionManager.getConnection(handle).registerListener(this);
        ConnectionHandle connectionHandle = new ConnectionHandle(handle, address, port);
        connectionHandle.setCipherSuite(cipherSuite);
        connectionHandle.setPrivilegeLevel(privilegeLevel);
        return connectionHandle;
    }

    public List<CipherSuite> getAvailableCipherSuites(ConnectionHandle connectionHandle) throws Exception {
        int tries = 0;
        List<CipherSuite> result = null;
        while (tries <= this.retries && result == null) {
            try {
                ++tries;
                result = this.connectionManager.getAvailableCipherSuites(connectionHandle.getHandle());
            }
            catch (Exception e) {
                logger.warn(FAILED_TO_RECEIVE_ANSWER_CAUSE_MESSAGE, (Throwable)e);
                if (tries <= this.retries) continue;
                throw e;
            }
        }
        return result;
    }

    public GetChannelAuthenticationCapabilitiesResponseData getChannelAuthenticationCapabilities(ConnectionHandle connectionHandle, CipherSuite cipherSuite, PrivilegeLevel requestedPrivilegeLevel) throws Exception {
        int tries = 0;
        GetChannelAuthenticationCapabilitiesResponseData result = null;
        while (tries <= this.retries && result == null) {
            try {
                ++tries;
                result = this.connectionManager.getChannelAuthenticationCapabilities(connectionHandle.getHandle(), cipherSuite, requestedPrivilegeLevel);
                connectionHandle.setCipherSuite(cipherSuite);
                connectionHandle.setPrivilegeLevel(requestedPrivilegeLevel);
            }
            catch (Exception e) {
                logger.warn(FAILED_TO_RECEIVE_ANSWER_CAUSE_MESSAGE, (Throwable)e);
                if (tries <= this.retries) continue;
                throw e;
            }
        }
        return result;
    }

    public Session openSession(ConnectionHandle connectionHandle, String username, String password, byte[] bmcKey) throws Exception {
        Session session = null;
        int tries = 0;
        boolean succeded = false;
        connectionHandle.setUser(username);
        connectionHandle.setPassword(password);
        while (tries <= this.retries && !succeded) {
            try {
                ++tries;
                int sessionId = this.connectionManager.startSession(connectionHandle.getHandle(), connectionHandle.getCipherSuite(), connectionHandle.getPrivilegeLevel(), username, password, bmcKey);
                session = this.sessionManager.registerSession(sessionId, connectionHandle);
                succeded = true;
            }
            catch (Exception e) {
                logger.warn(FAILED_TO_RECEIVE_ANSWER_CAUSE_MESSAGE, (Throwable)e);
                if (tries <= this.retries) continue;
                throw e;
            }
        }
        return session;
    }

    public Session getExistingSessionForCriteria(InetAddress remoteAddress, int remotePort, String user2) {
        return this.sessionManager.getSessionForCriteria(remoteAddress, remotePort, user2);
    }

    public void closeSession(ConnectionHandle connectionHandle) throws Exception {
        if (!this.connectionManager.getConnection(connectionHandle.getHandle()).isSessionValid()) {
            return;
        }
        int tries = 0;
        boolean succeded = false;
        while (tries <= this.retries && !succeded) {
            try {
                ++tries;
                this.connectionManager.getConnection(connectionHandle.getHandle()).closeSession();
                this.sessionManager.unregisterSession(connectionHandle);
                succeded = true;
            }
            catch (Exception e) {
                logger.warn(FAILED_TO_RECEIVE_ANSWER_CAUSE_MESSAGE, (Throwable)e);
                if (tries <= this.retries) continue;
                throw e;
            }
        }
    }

    public int sendMessage(ConnectionHandle connectionHandle, PayloadCoder request, boolean isOneWay) throws Exception {
        int tries = 0;
        int tag = -1;
        while (tries <= this.retries && tag < 0) {
            try {
                ++tries;
                while (tag < 0) {
                    tag = this.connectionManager.getConnection(connectionHandle.getHandle()).sendMessage(request, isOneWay);
                    if (tag >= 0) continue;
                    Thread.sleep(10L);
                }
                logger.debug("Sending message with tag " + tag + ", try " + tries);
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                logger.warn("Failed to send message, cause:", (Throwable)e);
                if (tries <= this.retries) continue;
                throw e;
            }
        }
        return tag;
    }

    public int retry(ConnectionHandle connectionHandle, int tag, PayloadType messagePayloadType) throws ConnectionException {
        return this.connectionManager.getConnection(connectionHandle.getHandle()).retry(tag, messagePayloadType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListener(IpmiResponseListener listener) {
        List<IpmiResponseListener> list = this.responseListeners;
        synchronized (list) {
            this.responseListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterListener(IpmiResponseListener listener) {
        List<IpmiResponseListener> list = this.responseListeners;
        synchronized (list) {
            this.responseListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerIncomingPayloadListener(InboundMessageListener listener) {
        List<InboundMessageListener> list = this.inboundMessageListeners;
        synchronized (list) {
            this.inboundMessageListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterIncomingPayloadListener(InboundMessageListener listener) {
        List<InboundMessageListener> list = this.inboundMessageListeners;
        synchronized (list) {
            this.inboundMessageListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processResponse(ResponseData responseData, int handle, int tag, Exception exception) {
        IpmiResponse response = null;
        Connection connection = this.connectionManager.getConnection(handle);
        if (responseData == null || exception != null) {
            Exception notNullException = exception != null ? exception : new Exception("Empty response");
            response = new IpmiError(notNullException, tag, new ConnectionHandle(handle, connection.getRemoteMachineAddress(), connection.getRemoteMachinePort()));
        } else {
            response = new IpmiResponseData(responseData, tag, new ConnectionHandle(handle, connection.getRemoteMachineAddress(), connection.getRemoteMachinePort()));
        }
        List<IpmiResponseListener> list = this.responseListeners;
        synchronized (list) {
            for (IpmiResponseListener listener : this.responseListeners) {
                if (listener == null) continue;
                listener.notify(response);
            }
        }
    }

    @Override
    public void processRequest(IpmiPayload payload) {
        for (InboundMessageListener listener : this.inboundMessageListeners) {
            if (!listener.isPayloadSupported(payload)) continue;
            listener.notify(payload);
        }
    }

    public void closeConnection(ConnectionHandle handle) {
        this.connectionManager.getConnection(handle.getHandle()).unregisterListener(this);
        this.connectionManager.closeConnection(handle.getHandle());
    }

    public void tearDown() {
        this.connectionManager.close();
    }

    public void setTimeout(ConnectionHandle handle, int timeout) {
        this.connectionManager.getConnection(handle.getHandle()).setTimeout(timeout);
    }
}

