/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.ipmi.client.runner;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.sentrysoftware.ipmi.client.IpmiClientConfiguration;
import org.sentrysoftware.ipmi.client.model.Fru;
import org.sentrysoftware.ipmi.client.runner.AbstractIpmiRunner;
import org.sentrysoftware.ipmi.core.coding.commands.IpmiVersion;
import org.sentrysoftware.ipmi.core.coding.commands.fru.BaseUnit;
import org.sentrysoftware.ipmi.core.coding.commands.fru.GetFruInventoryAreaInfo;
import org.sentrysoftware.ipmi.core.coding.commands.fru.GetFruInventoryAreaInfoResponseData;
import org.sentrysoftware.ipmi.core.coding.commands.fru.ReadFruData;
import org.sentrysoftware.ipmi.core.coding.commands.fru.ReadFruDataResponseData;
import org.sentrysoftware.ipmi.core.coding.commands.fru.record.BoardInfo;
import org.sentrysoftware.ipmi.core.coding.commands.fru.record.ChassisInfo;
import org.sentrysoftware.ipmi.core.coding.commands.fru.record.FruRecord;
import org.sentrysoftware.ipmi.core.coding.commands.fru.record.ProductInfo;
import org.sentrysoftware.ipmi.core.coding.commands.sdr.ReserveSdrRepository;
import org.sentrysoftware.ipmi.core.coding.commands.sdr.ReserveSdrRepositoryResponseData;
import org.sentrysoftware.ipmi.core.coding.commands.sdr.record.CompactSensorRecord;
import org.sentrysoftware.ipmi.core.coding.commands.sdr.record.EntityId;
import org.sentrysoftware.ipmi.core.coding.commands.sdr.record.FruDeviceLocatorRecord;
import org.sentrysoftware.ipmi.core.coding.commands.sdr.record.SensorRecord;
import org.sentrysoftware.ipmi.core.coding.payload.CompletionCode;
import org.sentrysoftware.ipmi.core.coding.payload.lan.IPMIException;
import org.sentrysoftware.ipmi.core.coding.protocol.AuthenticationType;

public class GetFrusRunner
extends AbstractIpmiRunner<List<Fru>> {
    private static final int DEFAULT_FRU_ID = 0;
    private static final int FRU_READ_PACKET_SIZE = 16;
    private boolean systemBoardFruUpdated = false;

    public GetFrusRunner(IpmiClientConfiguration ipmiConfiguration) {
        super(ipmiConfiguration);
    }

    @Override
    public void doRun() throws Exception {
        ArrayList<Fru> result = new ArrayList<Fru>();
        super.startSession();
        this.nextRecId = 0;
        int reservationId = 0;
        int lastReservationId = -1;
        List<FruRecord> systemBoardFruRecords = this.getFruRecords(0);
        while (this.nextRecId < 65535) {
            SensorRecord sensorRecord = null;
            try {
                sensorRecord = super.getSensorData(reservationId);
                this.processFruRecord(result, sensorRecord, systemBoardFruRecords);
            }
            catch (IPMIException e) {
                if (lastReservationId == reservationId || e.getCompletionCode() != CompletionCode.ReservationCanceled) {
                    throw e;
                }
                lastReservationId = reservationId;
                reservationId = ((ReserveSdrRepositoryResponseData)this.connector.sendMessage(this.handle, new ReserveSdrRepository(IpmiVersion.V20, this.handle.getCipherSuite(), AuthenticationType.RMCPPlus))).getReservationId();
            }
        }
        super.setResult(result);
    }

    private void processFruRecord(List<Fru> result, SensorRecord sensorRecord, List<FruRecord> systemBoardFruRecords) throws Exception {
        try {
            Fru fru = null;
            if (sensorRecord instanceof FruDeviceLocatorRecord) {
                List<FruRecord> fruRecords;
                FruDeviceLocatorRecord fruLocator = (FruDeviceLocatorRecord)sensorRecord;
                if (fruLocator.isLogical() && !(fruRecords = this.getFruRecords(fruLocator.getDeviceId())).isEmpty()) {
                    fru = new Fru(fruLocator, fruRecords);
                }
            } else if (!systemBoardFruRecords.isEmpty() && !this.systemBoardFruUpdated && sensorRecord instanceof CompactSensorRecord && ((CompactSensorRecord)sensorRecord).getEntityId().equals((Object)EntityId.SystemBoard)) {
                CompactSensorRecord compactSensorRecord = (CompactSensorRecord)sensorRecord;
                BoardInfo boardInfo = systemBoardFruRecords.stream().filter(BoardInfo.class::isInstance).map(BoardInfo.class::cast).findFirst().orElse(null);
                if (boardInfo != null) {
                    FruDeviceLocatorRecord locator = new FruDeviceLocatorRecord();
                    locator.setFruEntityId(EntityId.SystemBoard.getCode());
                    locator.setFruEntityInstance(compactSensorRecord.getEntityInstanceNumber());
                    locator.setName(boardInfo.getBoardProductName() + " " + compactSensorRecord.getEntityInstanceNumber());
                    fru = new Fru(locator, systemBoardFruRecords);
                    this.systemBoardFruUpdated = true;
                }
            }
            if (fru != null) {
                result.add(fru);
            }
        }
        catch (IPMIException iPMIException) {
            // empty catch block
        }
    }

    private List<FruRecord> getFruRecords(int fruId) throws Exception {
        ArrayList<ReadFruDataResponseData> fruData = new ArrayList<ReadFruDataResponseData>();
        GetFruInventoryAreaInfoResponseData info = (GetFruInventoryAreaInfoResponseData)this.connector.sendMessage(this.handle, new GetFruInventoryAreaInfo(IpmiVersion.V20, this.handle.getCipherSuite(), AuthenticationType.RMCPPlus, fruId));
        int size = info.getFruInventoryAreaSize();
        BaseUnit unit = info.getFruUnit();
        for (int i = 0; i < size; i += 16) {
            int fruReadPacketSize = 16;
            if (i + fruReadPacketSize > size) {
                fruReadPacketSize = size % 16;
            }
            try {
                ReadFruDataResponseData data = (ReadFruDataResponseData)this.connector.sendMessage(this.handle, new ReadFruData(IpmiVersion.V20, this.handle.getCipherSuite(), AuthenticationType.RMCPPlus, fruId, unit, i, fruReadPacketSize));
                fruData.add(data);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            return ReadFruData.decodeFruData(fruData).stream().filter(fruRecord -> fruRecord instanceof BoardInfo || fruRecord instanceof ChassisInfo || fruRecord instanceof ProductInfo).collect(Collectors.toList());
        }
        catch (Exception exception) {
            return new ArrayList<FruRecord>();
        }
    }
}

