/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.ipmi.client.runner;

import java.net.InetAddress;
import java.util.List;
import org.sentrysoftware.ipmi.client.IpmiClientConfiguration;
import org.sentrysoftware.ipmi.core.api.async.ConnectionHandle;
import org.sentrysoftware.ipmi.core.api.sync.IpmiConnector;
import org.sentrysoftware.ipmi.core.coding.commands.IpmiVersion;
import org.sentrysoftware.ipmi.core.coding.commands.PrivilegeLevel;
import org.sentrysoftware.ipmi.core.coding.commands.sdr.GetSdr;
import org.sentrysoftware.ipmi.core.coding.commands.sdr.GetSdrResponseData;
import org.sentrysoftware.ipmi.core.coding.commands.sdr.record.SensorRecord;
import org.sentrysoftware.ipmi.core.coding.payload.CompletionCode;
import org.sentrysoftware.ipmi.core.coding.payload.lan.IPMIException;
import org.sentrysoftware.ipmi.core.coding.protocol.AuthenticationType;
import org.sentrysoftware.ipmi.core.coding.security.CipherSuite;
import org.sentrysoftware.ipmi.core.common.TypeConverter;
import org.sentrysoftware.ipmi.core.connection.Connection;

public abstract class AbstractIpmiRunner<T>
implements AutoCloseable {
    private static final int DEFAULT_LOCAL_UDP_PORT = 0;
    protected static final int MAX_REPO_RECORD_ID = 65535;
    protected static final int INITIAL_CHUNK_SIZE = 8;
    protected static final int CHUNK_SIZE = 16;
    protected static final int HEADER_SIZE = 5;
    protected IpmiClientConfiguration ipmiConfiguration;
    private T result;
    protected IpmiConnector connector;
    protected ConnectionHandle handle;
    protected int nextRecId;

    protected AbstractIpmiRunner(IpmiClientConfiguration ipmiConfiguration) {
        this.ipmiConfiguration = ipmiConfiguration;
    }

    public abstract void doRun() throws Exception;

    protected void startSession() throws Exception {
        this.connector = new IpmiConnector(0);
        if (!this.ipmiConfiguration.isSkipAuth()) {
            this.authenticate();
        } else {
            this.handle = this.connector.createConnection(InetAddress.getByName(this.ipmiConfiguration.getHostname()), Connection.getDefaultCipherSuite(), PrivilegeLevel.User);
        }
        this.connector.openSession(this.handle, this.ipmiConfiguration.getUsername(), String.valueOf(this.ipmiConfiguration.getPassword()), this.ipmiConfiguration.getBmcKey());
    }

    public T getResult() {
        return this.result;
    }

    public void setResult(T result) {
        this.result = result;
    }

    public void authenticate() throws Exception {
        this.handle = this.connector.createConnection(InetAddress.getByName(this.ipmiConfiguration.getHostname()));
        CipherSuite cs = this.getAvailableCipherSuite();
        this.connector.getChannelAuthenticationCapabilities(this.handle, cs, PrivilegeLevel.User);
    }

    protected CipherSuite getAvailableCipherSuite() throws Exception {
        List<CipherSuite> suites = this.connector.getAvailableCipherSuites(this.handle);
        if (suites == null || suites.isEmpty()) {
            throw new Exception("Cannot get the available cipher suites.");
        }
        if (suites.size() > 3) {
            return suites.get(3);
        }
        if (suites.size() > 2) {
            return suites.get(2);
        }
        if (suites.size() > 1) {
            return suites.get(1);
        }
        return suites.get(0);
    }

    @Override
    public void close() throws Exception {
        if (this.handle != null) {
            this.connector.closeSession(this.handle);
        }
        this.connector.tearDown();
    }

    protected SensorRecord getSensorData(int reservationId) throws Exception {
        try {
            GetSdrResponseData data = (GetSdrResponseData)this.connector.sendMessage(this.handle, new GetSdr(IpmiVersion.V20, this.handle.getCipherSuite(), AuthenticationType.RMCPPlus, reservationId, this.nextRecId));
            SensorRecord sensorDataToPopulate = SensorRecord.populateSensorRecord(data.getSensorRecordData());
            this.nextRecId = data.getNextRecordId();
            return sensorDataToPopulate;
        }
        catch (IPMIException e) {
            if (e.getCompletionCode() != CompletionCode.CannotRespond && e.getCompletionCode() != CompletionCode.UnspecifiedError) {
                throw e;
            }
            return this.getSensorViaChunks(reservationId);
        }
        catch (Exception e) {
            throw e;
        }
    }

    protected SensorRecord getSensorViaChunks(int reservationId) throws Exception {
        int bytesToRead;
        GetSdrResponseData data = (GetSdrResponseData)this.connector.sendMessage(this.handle, new GetSdr(IpmiVersion.V20, this.handle.getCipherSuite(), AuthenticationType.RMCPPlus, reservationId, this.nextRecId, 0, 8));
        int recSize = TypeConverter.byteToInt(data.getSensorRecordData()[4]) + 5;
        byte[] bytes = new byte[recSize];
        System.arraycopy(data.getSensorRecordData(), 0, bytes, 0, data.getSensorRecordData().length);
        for (int read = 8; read < recSize; read += bytesToRead) {
            bytesToRead = 16;
            if (recSize - read < bytesToRead) {
                bytesToRead = recSize - read;
            }
            GetSdrResponseData part = (GetSdrResponseData)this.connector.sendMessage(this.handle, new GetSdr(IpmiVersion.V20, this.handle.getCipherSuite(), AuthenticationType.RMCPPlus, reservationId, this.nextRecId, read, bytesToRead));
            System.arraycopy(part.getSensorRecordData(), 0, bytes, read, bytesToRead);
        }
        SensorRecord sensorDataToPopulate = SensorRecord.populateSensorRecord(bytes);
        this.nextRecId = data.getNextRecordId();
        return sensorDataToPopulate;
    }
}

