/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.ipmi.client.model;

import org.sentrysoftware.ipmi.core.coding.commands.sdr.GetSensorReadingResponseData;
import org.sentrysoftware.ipmi.core.coding.commands.sdr.record.CompactSensorRecord;
import org.sentrysoftware.ipmi.core.coding.commands.sdr.record.EntityId;
import org.sentrysoftware.ipmi.core.coding.commands.sdr.record.FullSensorRecord;
import org.sentrysoftware.ipmi.core.coding.commands.sdr.record.SensorRecord;

public class Sensor {
    private SensorRecord sensorRecord;
    private GetSensorReadingResponseData data;
    private String states;

    public Sensor(SensorRecord sensorRecord, GetSensorReadingResponseData data, String states) {
        this.sensorRecord = sensorRecord;
        this.data = data;
        this.states = states;
    }

    public SensorRecord getRecord() {
        return this.sensorRecord;
    }

    public GetSensorReadingResponseData getData() {
        return this.data;
    }

    public boolean isCompact() {
        return this.sensorRecord instanceof CompactSensorRecord;
    }

    public boolean isFull() {
        return this.sensorRecord instanceof FullSensorRecord;
    }

    private CompactSensorRecord getCompactSensorRecord() {
        return (CompactSensorRecord)this.sensorRecord;
    }

    private FullSensorRecord getFullSensorRecord() {
        return (FullSensorRecord)this.sensorRecord;
    }

    public EntityId getEntityId() {
        if (this.isCompact()) {
            return this.getCompactSensorRecord().getEntityId();
        }
        if (this.isFull()) {
            return this.getFullSensorRecord().getEntityId();
        }
        return null;
    }

    public Byte getDeviceId() {
        if (this.isCompact()) {
            return this.getCompactSensorRecord().getEntityInstanceNumber();
        }
        if (this.isFull()) {
            return this.getFullSensorRecord().getEntityInstanceNumber();
        }
        return null;
    }

    public String getName() {
        if (this.isCompact()) {
            return this.getCompactSensorRecord().getName();
        }
        if (this.isFull()) {
            return this.getFullSensorRecord().getName();
        }
        return null;
    }

    public String getStates() {
        return this.states;
    }
}

