/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.ipmi.client;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.sentrysoftware.ipmi.client.IpmiClientConfiguration;
import org.sentrysoftware.ipmi.client.IpmiResultConverter;
import org.sentrysoftware.ipmi.client.Utils;
import org.sentrysoftware.ipmi.client.model.Fru;
import org.sentrysoftware.ipmi.client.model.Sensor;
import org.sentrysoftware.ipmi.client.runner.GetChassisStatusRunner;
import org.sentrysoftware.ipmi.client.runner.GetFrusRunner;
import org.sentrysoftware.ipmi.client.runner.GetSensorsRunner;
import org.sentrysoftware.ipmi.core.coding.commands.chassis.GetChassisStatusResponseData;

public class IpmiClient {
    private IpmiClient() {
    }

    public static GetChassisStatusResponseData getChassisStatus(IpmiClientConfiguration ipmiConfiguration) throws InterruptedException, ExecutionException, TimeoutException {
        return Utils.execute(() -> {
            try (GetChassisStatusRunner runner = new GetChassisStatusRunner(ipmiConfiguration);){
                runner.doRun();
                GetChassisStatusResponseData getChassisStatusResponseData = (GetChassisStatusResponseData)runner.getResult();
                return getChassisStatusResponseData;
            }
        }, ipmiConfiguration.getTimeout() * 1000L);
    }

    public static List<Sensor> getSensors(IpmiClientConfiguration ipmiConfiguration) throws InterruptedException, ExecutionException, TimeoutException {
        return Utils.execute(() -> {
            try (GetSensorsRunner runner = new GetSensorsRunner(ipmiConfiguration);){
                runner.doRun();
                List result = (List)runner.getResult();
                List list = result != null ? result : new ArrayList();
                return list;
            }
        }, ipmiConfiguration.getTimeout() * 1000L);
    }

    public static List<Fru> getFrus(IpmiClientConfiguration ipmiConfiguration) throws InterruptedException, ExecutionException, TimeoutException {
        return Utils.execute(() -> {
            try (GetFrusRunner runner = new GetFrusRunner(ipmiConfiguration);){
                runner.doRun();
                List result = (List)runner.getResult();
                List list = result != null ? result : new ArrayList();
                return list;
            }
        }, ipmiConfiguration.getTimeout() * 1000L);
    }

    public static String getChassisStatusAsStringResult(IpmiClientConfiguration ipmiConfiguration) throws InterruptedException, ExecutionException, TimeoutException {
        return IpmiResultConverter.convertResult(IpmiClient.getChassisStatus(ipmiConfiguration));
    }

    public static String getFrusAndSensorsAsStringResult(IpmiClientConfiguration ipmiConfiguration) throws InterruptedException, ExecutionException, TimeoutException {
        return IpmiResultConverter.convertResult(IpmiClient.getFrus(ipmiConfiguration), IpmiClient.getSensors(ipmiConfiguration));
    }
}

