/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http.asyncclient;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.util.ByteBufferAllocator;
import org.apache.http.nio.util.ExpandableBuffer;

public class SharedInputBuffer
extends ExpandableBuffer {
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private final int requestInputSize;
    private volatile IOControl ioctrl;
    private volatile boolean shutdown;
    private volatile boolean endOfStream;
    private volatile ByteBuffer waitingBuffer;

    public SharedInputBuffer(int buffersize, ByteBufferAllocator allocator) {
        super(buffersize, allocator);
        this.requestInputSize = buffersize * 3 / 4;
    }

    public void reset() {
        if (this.shutdown) {
            return;
        }
        this.lock.lock();
        try {
            this.clear();
            this.endOfStream = false;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int consumeContent(ContentDecoder decoder, IOControl ioc) throws IOException {
        if (this.shutdown) {
            ioc.shutdown();
            return -1;
        }
        this.lock.lock();
        try {
            int bytesRead;
            this.ioctrl = ioc;
            this.setInputMode();
            int totalRead = 0;
            if (this.waitingBuffer != null && this.buffer.position() == 0) {
                while ((bytesRead = decoder.read(this.waitingBuffer)) > 0) {
                    totalRead += bytesRead;
                }
            }
            while ((bytesRead = decoder.read(this.buffer)) > 0) {
                totalRead += bytesRead;
            }
            if (bytesRead == -1 || decoder.isCompleted()) {
                this.endOfStream = true;
            }
            if (!this.buffer.hasRemaining() && this.ioctrl != null && !this.endOfStream) {
                this.ioctrl.suspendInput();
            }
            this.condition.signalAll();
            if (totalRead > 0) {
                int n = totalRead;
                return n;
            }
            if (this.endOfStream) {
                int n = -1;
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean hasData() {
        this.lock.lock();
        try {
            boolean bl = super.hasData();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int available() {
        this.lock.lock();
        try {
            int n = super.length();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int capacity() {
        this.lock.lock();
        try {
            int n = super.capacity();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int length() {
        this.lock.lock();
        try {
            int n = super.length();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void waitForData(int waitPos) throws IOException {
        this.lock.lock();
        try {
            while (true) {
                if (this.waitingBuffer != null && this.waitingBuffer.position() > waitPos) {
                    return;
                }
                if (super.hasData()) {
                    return;
                }
                if (this.endOfStream) {
                    return;
                }
                if (this.shutdown) {
                    throw new InterruptedIOException("Input operation aborted");
                }
                if (this.ioctrl != null) {
                    this.ioctrl.requestInput();
                }
                this.condition.await();
                continue;
                break;
            }
        }
        catch (InterruptedException ex) {
            throw new IOException("Interrupted while waiting for more data");
        }
        finally {
            this.lock.unlock();
        }
    }

    public void close() {
        if (this.shutdown) {
            return;
        }
        this.endOfStream = true;
        this.lock.lock();
        try {
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void shutdown() {
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        this.lock.lock();
        try {
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    protected boolean isShutdown() {
        return this.shutdown;
    }

    protected boolean isEndOfStream() {
        return this.shutdown || !this.hasData() && this.endOfStream;
    }

    public int read() throws IOException {
        if (this.shutdown) {
            return -1;
        }
        this.lock.lock();
        try {
            if (!super.hasData()) {
                this.waitForData(0);
            }
            if (this.isEndOfStream()) {
                int n = -1;
                return n;
            }
            this.setOutputMode();
            int n = this.buffer.get() & 0xFF;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.shutdown) {
            return -1;
        }
        if (b == null) {
            return 0;
        }
        this.lock.lock();
        try {
            int i;
            if (!this.hasData()) {
                this.waitingBuffer = ByteBuffer.wrap(b, off, len);
                this.waitForData(off);
                i = this.waitingBuffer.position() - off;
                this.waitingBuffer = null;
                if (i > 0) {
                    int n = i;
                    return n;
                }
            }
            if (this.isEndOfStream()) {
                i = -1;
                return i;
            }
            this.setOutputMode();
            int chunk = len;
            if (chunk > this.buffer.remaining()) {
                chunk = this.buffer.remaining();
            }
            this.buffer.get(b, off, chunk);
            if (this.buffer.position() >= this.requestInputSize && !this.endOfStream && this.ioctrl != null) {
                this.ioctrl.requestInput();
            }
            int n = chunk;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int read(byte[] b) throws IOException {
        if (this.shutdown) {
            return -1;
        }
        if (b == null) {
            return 0;
        }
        return this.read(b, 0, b.length);
    }
}

