/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim25.mo;

import com.vmware.vim25.AlreadyExists;
import com.vmware.vim25.AlreadyUpgraded;
import com.vmware.vim25.ConcurrentAccess;
import com.vmware.vim25.CustomizationFault;
import com.vmware.vim25.CustomizationSpec;
import com.vmware.vim25.DiskChangeInfo;
import com.vmware.vim25.DuplicateName;
import com.vmware.vim25.FileFault;
import com.vmware.vim25.GuestInfo;
import com.vmware.vim25.HostIncompatibleForRecordReplay;
import com.vmware.vim25.InsufficientResourcesFault;
import com.vmware.vim25.InvalidDatastore;
import com.vmware.vim25.InvalidName;
import com.vmware.vim25.InvalidPowerState;
import com.vmware.vim25.InvalidProperty;
import com.vmware.vim25.InvalidState;
import com.vmware.vim25.LocalizedMethodFault;
import com.vmware.vim25.ManagedEntityStatus;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.MigrationFault;
import com.vmware.vim25.NoDiskFound;
import com.vmware.vim25.NotFound;
import com.vmware.vim25.RecordReplayDisabled;
import com.vmware.vim25.ResourceConfigSpec;
import com.vmware.vim25.RuntimeFault;
import com.vmware.vim25.SnapshotFault;
import com.vmware.vim25.TaskInProgress;
import com.vmware.vim25.Timedout;
import com.vmware.vim25.ToolsUnavailable;
import com.vmware.vim25.VirtualDisk;
import com.vmware.vim25.VirtualMachineCapability;
import com.vmware.vim25.VirtualMachineCloneSpec;
import com.vmware.vim25.VirtualMachineConfigInfo;
import com.vmware.vim25.VirtualMachineConfigSpec;
import com.vmware.vim25.VirtualMachineDisplayTopology;
import com.vmware.vim25.VirtualMachineFileLayout;
import com.vmware.vim25.VirtualMachineFileLayoutEx;
import com.vmware.vim25.VirtualMachineMksTicket;
import com.vmware.vim25.VirtualMachineMovePriority;
import com.vmware.vim25.VirtualMachinePowerState;
import com.vmware.vim25.VirtualMachineRelocateSpec;
import com.vmware.vim25.VirtualMachineRuntimeInfo;
import com.vmware.vim25.VirtualMachineSnapshotInfo;
import com.vmware.vim25.VirtualMachineStorageInfo;
import com.vmware.vim25.VirtualMachineSummary;
import com.vmware.vim25.VirtualMachineTicket;
import com.vmware.vim25.VmConfigFault;
import com.vmware.vim25.VmFaultToleranceIssue;
import com.vmware.vim25.VmToolsUpgradeFault;
import com.vmware.vim25.mo.Datastore;
import com.vmware.vim25.mo.EnvironmentBrowser;
import com.vmware.vim25.mo.Folder;
import com.vmware.vim25.mo.HostSystem;
import com.vmware.vim25.mo.HttpNfcLease;
import com.vmware.vim25.mo.ManagedEntity;
import com.vmware.vim25.mo.Network;
import com.vmware.vim25.mo.ResourcePool;
import com.vmware.vim25.mo.ServerConnection;
import com.vmware.vim25.mo.Task;
import com.vmware.vim25.mo.VirtualMachineSnapshot;
import java.rmi.RemoteException;

public class VirtualMachine
extends ManagedEntity {
    public VirtualMachine(ServerConnection sc, ManagedObjectReference mor) {
        super(sc, mor);
    }

    public VirtualMachineCapability getCapability() {
        return (VirtualMachineCapability)this.getCurrentProperty("capability");
    }

    public VirtualMachineConfigInfo getConfig() {
        return (VirtualMachineConfigInfo)this.getCurrentProperty("config");
    }

    public Datastore[] getDatastores() throws InvalidProperty, RuntimeFault, RemoteException {
        return this.getDatastores("datastore");
    }

    public EnvironmentBrowser getEnvironmentBrowser() throws InvalidProperty, RuntimeFault, RemoteException {
        return (EnvironmentBrowser)this.getManagedObject("environmentBrowser");
    }

    public GuestInfo getGuest() {
        return (GuestInfo)this.getCurrentProperty("guest");
    }

    public ManagedEntityStatus getGuestHeartbeatStatus() {
        return (ManagedEntityStatus)((Object)this.getCurrentProperty("guestHeartbeatStatus"));
    }

    public VirtualMachineFileLayout getLayout() {
        return (VirtualMachineFileLayout)this.getCurrentProperty("layout");
    }

    public VirtualMachineFileLayoutEx getLayoutEx() {
        return (VirtualMachineFileLayoutEx)this.getCurrentProperty("layoutEx");
    }

    public VirtualMachineStorageInfo getStorage() {
        return (VirtualMachineStorageInfo)this.getCurrentProperty("storage");
    }

    public Network[] getNetworks() throws InvalidProperty, RuntimeFault, RemoteException {
        return this.getNetworks("network");
    }

    public ManagedEntity getParentVApp() {
        ManagedObjectReference mor = (ManagedObjectReference)this.getCurrentProperty("parentVApp");
        return new ManagedEntity(this.getServerConnection(), mor);
    }

    public ResourceConfigSpec getResourceConfig() {
        return (ResourceConfigSpec)this.getCurrentProperty("resourceConfig");
    }

    public ResourcePool getResourcePool() throws InvalidProperty, RuntimeFault, RemoteException {
        return (ResourcePool)this.getManagedObject("resourcePool");
    }

    public VirtualMachineSnapshot[] getRootSnapshot() {
        ManagedObjectReference[] mors = (ManagedObjectReference[])this.getCurrentProperty("rootSnapshot");
        if (mors == null) {
            return new VirtualMachineSnapshot[0];
        }
        VirtualMachineSnapshot[] vmns = new VirtualMachineSnapshot[mors.length];
        int i = 0;
        while (i < mors.length) {
            vmns[i] = new VirtualMachineSnapshot(this.getServerConnection(), mors[i]);
            ++i;
        }
        return vmns;
    }

    public VirtualMachineRuntimeInfo getRuntime() {
        return (VirtualMachineRuntimeInfo)this.getCurrentProperty("runtime");
    }

    public VirtualMachineSnapshotInfo getSnapshot() {
        return (VirtualMachineSnapshotInfo)this.getCurrentProperty("snapshot");
    }

    public VirtualMachineSnapshot getCurrentSnapShot() throws InvalidProperty, RuntimeFault, RemoteException {
        return (VirtualMachineSnapshot)this.getManagedObject("snapshot.currentSnapshot");
    }

    public VirtualMachineSummary getSummary() {
        return (VirtualMachineSummary)this.getCurrentProperty("summary");
    }

    public VirtualMachineMksTicket acquireMksTicket() throws RuntimeFault, RemoteException {
        return this.getVimService().acquireMksTicket(this.getMOR());
    }

    public VirtualMachineTicket acquireTicket(String ticketType) throws InvalidState, RuntimeFault, RemoteException {
        return this.getVimService().acquireTicket(this.getMOR(), ticketType);
    }

    public void answerVM(String questionId, String answerChoice) throws ConcurrentAccess, RuntimeFault, RemoteException {
        this.getVimService().answerVM(this.getMOR(), questionId, answerChoice);
    }

    public void checkCustomizationSpec(CustomizationSpec spec) throws CustomizationFault, RuntimeFault, RemoteException {
        this.getVimService().checkCustomizationSpec(this.getMOR(), spec);
    }

    public Task cloneVM_Task(Folder folder, String name, VirtualMachineCloneSpec spec) throws VmConfigFault, TaskInProgress, CustomizationFault, FileFault, InvalidState, InsufficientResourcesFault, MigrationFault, InvalidDatastore, RuntimeFault, RemoteException {
        if (folder == null) {
            throw new IllegalArgumentException("folder must not be null.");
        }
        ManagedObjectReference mor = this.getVimService().cloneVM_Task(this.getMOR(), folder.getMOR(), name, spec);
        return new Task(this.getServerConnection(), mor);
    }

    public Task consolidateVMDisks_Task() throws TaskInProgress, InvalidState, FileFault, VmConfigFault, RuntimeFault, RemoteException {
        ManagedObjectReference taskMor = this.getVimService().consolidateVMDisks_Task(this.getMOR());
        return new Task(this.getServerConnection(), taskMor);
    }

    public Task CreateScreenshot_Task() throws TaskInProgress, FileFault, InvalidState, RuntimeFault, RemoteException {
        ManagedObjectReference mor = this.getVimService().createScreenshot_Task(this.getMOR());
        return new Task(this.getServerConnection(), mor);
    }

    public Task createSnapshot_Task(String name, String description, boolean memory2, boolean quiesce) throws InvalidName, VmConfigFault, SnapshotFault, TaskInProgress, FileFault, InvalidState, RuntimeFault, RemoteException {
        ManagedObjectReference mor = this.getVimService().createSnapshot_Task(this.getMOR(), name, description, memory2, quiesce);
        return new Task(this.getServerConnection(), mor);
    }

    public Task createSecondaryVM_Task(HostSystem host) throws TaskInProgress, InvalidState, InsufficientResourcesFault, VmFaultToleranceIssue, FileFault, VmConfigFault, RuntimeFault, RemoteException {
        ManagedObjectReference mor = this.getVimService().createSecondaryVM_Task(this.getMOR(), host == null ? null : host.getMOR());
        return new Task(this.getServerConnection(), mor);
    }

    public Task disableSecondaryVM_Task(VirtualMachine vm) throws TaskInProgress, VmFaultToleranceIssue, InvalidState, RuntimeFault, RemoteException {
        ManagedObjectReference mor = this.getVimService().disableSecondaryVM_Task(this.getMOR(), vm.getMOR());
        return new Task(this.getServerConnection(), mor);
    }

    public Task enableSecondaryVM_Task(VirtualMachine vm, HostSystem host) throws TaskInProgress, VmFaultToleranceIssue, InvalidState, VmConfigFault, RuntimeFault, RemoteException {
        ManagedObjectReference mor = this.getVimService().enableSecondaryVM_Task(this.getMOR(), vm.getMOR(), host == null ? null : host.getMOR());
        return new Task(this.getServerConnection(), mor);
    }

    public Task estimateStorageForConsolidateSnapshots_Task() throws TaskInProgress, InvalidState, FileFault, VmConfigFault, RuntimeFault, RemoteException {
        ManagedObjectReference taskMor = this.getVimService().estimateStorageForConsolidateSnapshots_Task(this.getMOR());
        return new Task(this.getServerConnection(), taskMor);
    }

    public HttpNfcLease exportVm() throws InvalidPowerState, TaskInProgress, InvalidState, FileFault, RuntimeFault, RemoteException {
        ManagedObjectReference mor = this.getVimService().exportVm(this.getMOR());
        return new HttpNfcLease(this.getServerConnection(), mor);
    }

    public String extractOvfEnvironment() throws InvalidState, RuntimeFault, RemoteException {
        return this.getVimService().extractOvfEnvironment(this.getMOR());
    }

    public Task makePrimaryVM_Task(VirtualMachine vm) throws TaskInProgress, VmFaultToleranceIssue, InvalidState, RuntimeFault, RemoteException {
        ManagedObjectReference mor = this.getVimService().makePrimaryVM_Task(this.getMOR(), vm.getMOR());
        return new Task(this.getServerConnection(), mor);
    }

    public Task customizeVM_Task(CustomizationSpec spec) throws CustomizationFault, RuntimeFault, RemoteException {
        ManagedObjectReference mor = this.getVimService().customizeVM_Task(this.getMOR(), spec);
        return new Task(this.getServerConnection(), mor);
    }

    public void defragmentAllDisks() throws InvalidPowerState, TaskInProgress, FileFault, InvalidState, RuntimeFault, RemoteException {
        this.getVimService().defragmentAllDisks(this.getMOR());
    }

    public void markAsTemplate() throws VmConfigFault, InvalidState, RuntimeFault, RemoteException {
        this.getVimService().markAsTemplate(this.getMOR());
    }

    public void markAsVirtualMachine(ResourcePool pool, HostSystem host) throws VmConfigFault, FileFault, InvalidState, InvalidDatastore, RuntimeFault, RemoteException {
        if (pool == null) {
            throw new IllegalArgumentException("pool must not be null.");
        }
        this.getVimService().markAsVirtualMachine(this.getMOR(), pool.getMOR(), host == null ? null : host.getMOR());
    }

    public Task migrateVM_Task(ResourcePool pool, HostSystem host, VirtualMachineMovePriority priority, VirtualMachinePowerState state) throws VmConfigFault, Timedout, FileFault, InvalidState, InsufficientResourcesFault, MigrationFault, RuntimeFault, RemoteException {
        ManagedObjectReference mor = this.getVimService().migrateVM_Task(this.getMOR(), pool == null ? null : pool.getMOR(), host == null ? null : host.getMOR(), priority, state);
        return new Task(this.getServerConnection(), mor);
    }

    public void mountToolsInstaller() throws InvalidState, RuntimeFault, RemoteException {
        this.getVimService().mountToolsInstaller(this.getMOR());
    }

    public Task powerOffVM_Task() throws TaskInProgress, InvalidState, RuntimeFault, RemoteException {
        ManagedObjectReference mor = this.getVimService().powerOffVM_Task(this.getMOR());
        return new Task(this.getServerConnection(), mor);
    }

    public Task powerOnVM_Task(HostSystem host) throws VmConfigFault, TaskInProgress, FileFault, InvalidState, InsufficientResourcesFault, RuntimeFault, RemoteException {
        ManagedObjectReference mor = this.getVimService().powerOnVM_Task(this.getMOR(), host == null ? null : host.getMOR());
        return new Task(this.getServerConnection(), mor);
    }

    public Task promoteDisks_Task(boolean unlink, VirtualDisk[] disks) throws InvalidPowerState, InvalidState, TaskInProgress, RuntimeFault, RemoteException {
        ManagedObjectReference mor = this.getVimService().promoteDisks_Task(this.getMOR(), unlink, disks);
        return new Task(this.getServerConnection(), mor);
    }

    public DiskChangeInfo queryChangedDiskAreas(VirtualMachineSnapshot snapshot, int deviceKey, long startOffset, String changeId) throws FileFault, NotFound, RuntimeFault, RemoteException {
        return this.getVimService().queryChangedDiskAreas(this.getMOR(), snapshot == null ? null : snapshot.getMOR(), deviceKey, startOffset, changeId);
    }

    public LocalizedMethodFault[] queryFaultToleranceCompatibility() throws InvalidState, VmConfigFault, RuntimeFault, RemoteException {
        return this.getVimService().queryFaultToleranceCompatibility(this.getMOR());
    }

    public String[] queryUnownedFiles() throws RuntimeFault, RemoteException {
        return this.getVimService().queryUnownedFiles(this.getMOR());
    }

    public void rebootGuest() throws TaskInProgress, InvalidState, ToolsUnavailable, RuntimeFault, RemoteException {
        this.getVimService().rebootGuest(this.getMOR());
    }

    public Task reconfigVM_Task(VirtualMachineConfigSpec spec) throws InvalidName, VmConfigFault, DuplicateName, TaskInProgress, FileFault, InvalidState, ConcurrentAccess, InvalidDatastore, InsufficientResourcesFault, RuntimeFault, RemoteException {
        ManagedObjectReference mor = this.getVimService().reconfigVM_Task(this.getMOR(), spec);
        return new Task(this.getServerConnection(), mor);
    }

    public Task reloadVirtualMachineFromPath_Task(String configurationPath) throws InvalidPowerState, TaskInProgress, FileFault, InvalidState, VmConfigFault, AlreadyExists, RuntimeFault, RemoteException {
        ManagedObjectReference mor = this.getVimService().reloadVirtualMachineFromPath_Task(this.getMOR(), configurationPath);
        return new Task(this.getServerConnection(), mor);
    }

    public void refreshStorageInfo() throws RuntimeFault, RemoteException {
        this.getVimService().refreshStorageInfo(this.getMOR());
    }

    public Task relocateVM_Task(VirtualMachineRelocateSpec spec) throws VmConfigFault, Timedout, FileFault, InvalidState, InsufficientResourcesFault, MigrationFault, InvalidDatastore, RuntimeFault, RemoteException {
        return this.relocateVM_Task(spec, null);
    }

    public Task relocateVM_Task(VirtualMachineRelocateSpec spec, VirtualMachineMovePriority priority) throws VmConfigFault, Timedout, FileFault, InvalidState, InsufficientResourcesFault, MigrationFault, InvalidDatastore, RuntimeFault, RemoteException {
        ManagedObjectReference mor = this.getVimService().relocateVM_Task(this.getMOR(), spec, priority);
        return new Task(this.getServerConnection(), mor);
    }

    public Task removeAllSnapshots_Task() throws SnapshotFault, TaskInProgress, InvalidState, RuntimeFault, RemoteException {
        return this.removeAllSnapshots_Task(null);
    }

    public Task removeAllSnapshots_Task(Boolean consolidate) throws SnapshotFault, TaskInProgress, InvalidState, RuntimeFault, RemoteException {
        ManagedObjectReference mor = this.getVimService().removeAllSnapshots_Task(this.getMOR(), consolidate);
        return new Task(this.getServerConnection(), mor);
    }

    public void resetGuestInformation() throws InvalidState, RuntimeFault, RemoteException {
        this.getVimService().resetGuestInformation(this.getMOR());
    }

    public Task resetVM_Task() throws TaskInProgress, InvalidState, RuntimeFault, RemoteException {
        ManagedObjectReference mor = this.getVimService().resetVM_Task(this.getMOR());
        return new Task(this.getServerConnection(), mor);
    }

    public Task revertToCurrentSnapshot_Task(HostSystem host) throws VmConfigFault, SnapshotFault, TaskInProgress, InvalidState, InsufficientResourcesFault, NotFound, RuntimeFault, RemoteException {
        return this.revertToCurrentSnapshot_Task(host, null);
    }

    public Task revertToCurrentSnapshot_Task(HostSystem host, Boolean suppressPowerOn) throws VmConfigFault, SnapshotFault, TaskInProgress, InvalidState, InsufficientResourcesFault, NotFound, RuntimeFault, RemoteException {
        ManagedObjectReference mor = this.getVimService().revertToCurrentSnapshot_Task(this.getMOR(), host == null ? null : host.getMOR(), suppressPowerOn);
        return new Task(this.getServerConnection(), mor);
    }

    public void setDisplayTopology(VirtualMachineDisplayTopology[] displays) throws InvalidState, ToolsUnavailable, RuntimeFault, RemoteException {
        this.getVimService().setDisplayTopology(this.getMOR(), displays);
    }

    public void setScreenResolution(int width, int height) throws InvalidPowerState, ToolsUnavailable, RuntimeFault, RemoteException {
        this.getVimService().setScreenResolution(this.getMOR(), width, height);
    }

    public void shutdownGuest() throws TaskInProgress, InvalidState, ToolsUnavailable, RuntimeFault, RemoteException {
        this.getVimService().shutdownGuest(this.getMOR());
    }

    public Task startRecording_Task(String name, String description) throws InvalidPowerState, InvalidState, TaskInProgress, FileFault, SnapshotFault, VmConfigFault, RecordReplayDisabled, HostIncompatibleForRecordReplay, InvalidName, RuntimeFault, RemoteException {
        ManagedObjectReference mor = this.getVimService().startRecording_Task(this.getMOR(), name, description);
        return new Task(this.getServerConnection(), mor);
    }

    public Task stopRecording_Task() throws InvalidPowerState, InvalidState, TaskInProgress, FileFault, SnapshotFault, RuntimeFault, RemoteException {
        ManagedObjectReference mor = this.getVimService().stopRecording_Task(this.getMOR());
        return new Task(this.getServerConnection(), mor);
    }

    public Task stopReplaying_Task() throws InvalidPowerState, InvalidState, TaskInProgress, FileFault, SnapshotFault, RuntimeFault, RemoteException {
        ManagedObjectReference mor = this.getVimService().stopReplaying_Task(this.getMOR());
        return new Task(this.getServerConnection(), mor);
    }

    public Task startReplaying_Task(VirtualMachineSnapshot replaySnapshot) throws InvalidPowerState, InvalidState, TaskInProgress, FileFault, SnapshotFault, VmConfigFault, RecordReplayDisabled, HostIncompatibleForRecordReplay, InvalidName, RuntimeFault, RemoteException {
        ManagedObjectReference mor = this.getVimService().startReplaying_Task(this.getMOR(), replaySnapshot.getMOR());
        return new Task(this.getServerConnection(), mor);
    }

    public void standbyGuest() throws TaskInProgress, InvalidState, ToolsUnavailable, RuntimeFault, RemoteException {
        this.getVimService().standbyGuest(this.getMOR());
    }

    public Task suspendVM_Task() throws TaskInProgress, InvalidState, RuntimeFault, RemoteException {
        ManagedObjectReference mor = this.getVimService().suspendVM_Task(this.getMOR());
        return new Task(this.getServerConnection(), mor);
    }

    public Task terminateFaultTolerantVM_Task(VirtualMachine vm) throws TaskInProgress, VmFaultToleranceIssue, InvalidState, RuntimeFault, RemoteException {
        ManagedObjectReference mor = this.getVimService().terminateFaultTolerantVM_Task(this.getMOR(), vm == null ? null : vm.getMOR());
        return new Task(this.getServerConnection(), mor);
    }

    public Task turnOffFaultToleranceForVM_Task() throws TaskInProgress, VmFaultToleranceIssue, InvalidState, RuntimeFault, RemoteException {
        ManagedObjectReference mor = this.getVimService().turnOffFaultToleranceForVM_Task(this.getMOR());
        return new Task(this.getServerConnection(), mor);
    }

    public void unmountToolsInstaller() throws InvalidState, RuntimeFault, RemoteException {
        this.getVimService().unmountToolsInstaller(this.getMOR());
    }

    public void unregisterVM() throws InvalidPowerState, RuntimeFault, RemoteException {
        this.getVimService().unregisterVM(this.getMOR());
    }

    public Task upgradeTools_Task(String installerOptions) throws TaskInProgress, VmToolsUpgradeFault, InvalidState, ToolsUnavailable, RuntimeFault, RemoteException {
        ManagedObjectReference mor = this.getVimService().upgradeTools_Task(this.getMOR(), installerOptions);
        return new Task(this.getServerConnection(), mor);
    }

    public Task upgradeVM_Task(String version) throws TaskInProgress, InvalidState, AlreadyUpgraded, NoDiskFound, RuntimeFault, RemoteException {
        ManagedObjectReference mor = this.getVimService().upgradeVM_Task(this.getMOR(), version);
        return new Task(this.getServerConnection(), mor);
    }
}

