/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2.auth;

import com.trilead.ssh2.InteractiveCallback;
import com.trilead.ssh2.auth.SignatureProxy;
import com.trilead.ssh2.crypto.PEMDecoder;
import com.trilead.ssh2.crypto.keys.Ed25519PrivateKey;
import com.trilead.ssh2.crypto.keys.Ed25519PublicKey;
import com.trilead.ssh2.packets.PacketServiceAccept;
import com.trilead.ssh2.packets.PacketServiceRequest;
import com.trilead.ssh2.packets.PacketUserauthBanner;
import com.trilead.ssh2.packets.PacketUserauthFailure;
import com.trilead.ssh2.packets.PacketUserauthInfoRequest;
import com.trilead.ssh2.packets.PacketUserauthInfoResponse;
import com.trilead.ssh2.packets.PacketUserauthRequestInteractive;
import com.trilead.ssh2.packets.PacketUserauthRequestNone;
import com.trilead.ssh2.packets.PacketUserauthRequestPassword;
import com.trilead.ssh2.packets.PacketUserauthRequestPublicKey;
import com.trilead.ssh2.packets.TypesWriter;
import com.trilead.ssh2.signature.DSASHA1Verify;
import com.trilead.ssh2.signature.ECDSASHA2Verify;
import com.trilead.ssh2.signature.Ed25519Verify;
import com.trilead.ssh2.signature.RSASHA1Verify;
import com.trilead.ssh2.signature.RSASHA256Verify;
import com.trilead.ssh2.signature.RSASHA512Verify;
import com.trilead.ssh2.transport.MessageHandler;
import com.trilead.ssh2.transport.TransportManager;
import java.io.IOException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Set;
import java.util.Vector;

public class AuthenticationManager
implements MessageHandler {
    TransportManager tm;
    Vector packets = new Vector();
    boolean connectionClosed = false;
    String banner;
    String[] remainingMethods = new String[0];
    boolean isPartialSuccess = false;
    boolean authenticated = false;
    boolean initDone = false;

    public AuthenticationManager(TransportManager tm) {
        this.tm = tm;
    }

    boolean methodPossible(String methName) {
        if (this.remainingMethods == null) {
            return false;
        }
        for (int i = 0; i < this.remainingMethods.length; ++i) {
            if (this.remainingMethods[i].compareTo(methName) != 0) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] deQueue() throws IOException {
        Vector vector = this.packets;
        synchronized (vector) {
            while (this.packets.size() == 0) {
                if (this.connectionClosed) {
                    throw new IOException("The connection is closed.", this.tm.getReasonClosedCause());
                }
                try {
                    this.packets.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            byte[] res = (byte[])this.packets.firstElement();
            this.packets.removeElementAt(0);
            return res;
        }
    }

    byte[] getNextMessage() throws IOException {
        byte[] msg;
        while ((msg = this.deQueue())[0] == 53) {
            PacketUserauthBanner sb = new PacketUserauthBanner(msg, 0, msg.length);
            this.banner = sb.getBanner();
        }
        return msg;
    }

    public String[] getRemainingMethods(String user2) throws IOException {
        this.initialize(user2);
        return this.remainingMethods;
    }

    public boolean getPartialSuccess() {
        return this.isPartialSuccess;
    }

    private boolean initialize(String user2) throws IOException {
        if (!this.initDone) {
            this.tm.registerMessageHandler(this, 0, 255);
            PacketServiceRequest sr = new PacketServiceRequest("ssh-userauth");
            this.tm.sendMessage(sr.getPayload());
            PacketUserauthRequestNone urn = new PacketUserauthRequestNone("ssh-connection", user2);
            this.tm.sendMessage(urn.getPayload());
            byte[] msg = this.getNextMessage();
            new PacketServiceAccept(msg, 0, msg.length);
            msg = this.getNextMessage();
            this.initDone = true;
            if (msg[0] == 52) {
                this.authenticated = true;
                this.tm.removeMessageHandler(this, 0, 255);
                return true;
            }
            if (msg[0] == 51) {
                PacketUserauthFailure puf = new PacketUserauthFailure(msg, 0, msg.length);
                this.remainingMethods = puf.getAuthThatCanContinue();
                this.isPartialSuccess = puf.isPartialSuccess();
                return false;
            }
            throw new IOException("Unexpected SSH message (type " + msg[0] + ")");
        }
        return this.authenticated;
    }

    public boolean authenticatePublicKey(String user2, char[] PEMPrivateKey, String password, SecureRandom rnd) throws IOException {
        KeyPair pair = PEMDecoder.decode(PEMPrivateKey, password);
        return this.authenticatePublicKey(user2, pair, rnd);
    }

    public boolean authenticatePublicKey(String user2, KeyPair pair, SecureRandom rnd) throws IOException {
        return this.authenticatePublicKey(user2, pair, rnd, null);
    }

    public boolean authenticatePublicKey(String user2, SignatureProxy signatureProxy) throws IOException {
        return this.authenticatePublicKey(user2, null, null, signatureProxy);
    }

    public boolean authenticatePublicKey(String user2, KeyPair pair, SecureRandom rnd, SignatureProxy signatureProxy) throws IOException {
        PrivateKey privateKey = null;
        PublicKey publicKey = null;
        if (pair != null) {
            privateKey = pair.getPrivate();
            publicKey = pair.getPublic();
        }
        if (signatureProxy != null) {
            publicKey = signatureProxy.getPublicKey();
        }
        try {
            this.initialize(user2);
            if (!this.methodPossible("publickey")) {
                throw new IOException("Authentication method publickey not supported by the server at this stage.");
            }
            if (publicKey instanceof DSAPublicKey) {
                DSASHA1Verify s = DSASHA1Verify.get();
                byte[] pk_enc = s.encodePublicKey(publicKey);
                byte[] msg = this.generatePublicKeyUserAuthenticationRequest(user2, "ssh-dss", pk_enc);
                byte[] ds_enc = signatureProxy != null ? signatureProxy.sign(msg, "SHA-1") : s.generateSignature(msg, privateKey, rnd);
                PacketUserauthRequestPublicKey ua = new PacketUserauthRequestPublicKey("ssh-connection", user2, "ssh-dss", pk_enc, ds_enc);
                this.tm.sendMessage(ua.getPayload());
            } else if (publicKey instanceof RSAPublicKey) {
                byte[] msg;
                byte[] rsa_sig_enc;
                String pk_algorithm;
                byte[] pk_enc = RSASHA1Verify.get().encodePublicKey(publicKey);
                Set<String> algsAccepted = this.tm.getExtensionInfo().getSignatureAlgorithmsAccepted();
                if (algsAccepted.contains(RSASHA512Verify.get().getKeyFormat())) {
                    RSASHA512Verify s = RSASHA512Verify.get();
                    pk_algorithm = s.getKeyFormat();
                    byte[] msg2 = this.generatePublicKeyUserAuthenticationRequest(user2, pk_algorithm, pk_enc);
                    rsa_sig_enc = signatureProxy != null ? signatureProxy.sign(msg2, "SHA-512") : s.generateSignature(msg2, privateKey, rnd);
                } else if (algsAccepted.contains("rsa-sha2-256")) {
                    pk_algorithm = "rsa-sha2-256";
                    msg = this.generatePublicKeyUserAuthenticationRequest(user2, pk_algorithm, pk_enc);
                    rsa_sig_enc = signatureProxy != null ? signatureProxy.sign(msg, "SHA-256") : RSASHA256Verify.get().generateSignature(msg, privateKey, rnd);
                } else {
                    pk_algorithm = "ssh-rsa";
                    msg = this.generatePublicKeyUserAuthenticationRequest(user2, pk_algorithm, pk_enc);
                    rsa_sig_enc = signatureProxy != null ? signatureProxy.sign(msg, "SHA-1") : RSASHA1Verify.get().generateSignature(msg, privateKey, rnd);
                }
                PacketUserauthRequestPublicKey ua = new PacketUserauthRequestPublicKey("ssh-connection", user2, pk_algorithm, pk_enc, rsa_sig_enc);
                this.tm.sendMessage(ua.getPayload());
            } else if (publicKey instanceof ECPublicKey) {
                ECPublicKey ecPublicKey = (ECPublicKey)publicKey;
                ECDSASHA2Verify verifier = ECDSASHA2Verify.getVerifierForKey(ecPublicKey);
                String algo = verifier.getKeyFormat();
                byte[] pk_enc = verifier.encodePublicKey(ecPublicKey);
                byte[] msg = this.generatePublicKeyUserAuthenticationRequest(user2, algo, pk_enc);
                byte[] ec_sig_enc = signatureProxy != null ? signatureProxy.sign(msg, ECDSASHA2Verify.getDigestAlgorithmForParams(ecPublicKey)) : verifier.generateSignature(msg, privateKey, rnd);
                PacketUserauthRequestPublicKey ua = new PacketUserauthRequestPublicKey("ssh-connection", user2, algo, pk_enc, ec_sig_enc);
                this.tm.sendMessage(ua.getPayload());
            } else if (publicKey instanceof Ed25519PublicKey) {
                byte[] ed_sig_enc;
                String algo = "ssh-ed25519";
                byte[] pk_enc = Ed25519Verify.get().encodePublicKey(publicKey);
                byte[] msg = this.generatePublicKeyUserAuthenticationRequest(user2, "ssh-ed25519", pk_enc);
                if (signatureProxy != null) {
                    ed_sig_enc = signatureProxy.sign(msg, "SHA-512");
                } else {
                    Ed25519PrivateKey pk = (Ed25519PrivateKey)privateKey;
                    ed_sig_enc = Ed25519Verify.get().generateSignature(msg, pk, rnd);
                }
                PacketUserauthRequestPublicKey ua = new PacketUserauthRequestPublicKey("ssh-connection", user2, "ssh-ed25519", pk_enc, ed_sig_enc);
                this.tm.sendMessage(ua.getPayload());
            } else {
                throw new IOException("Unknown public key type.");
            }
            byte[] ar = this.getNextMessage();
            return this.isAuthenticationSuccessful(ar);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.tm.close(e, false);
            throw new IOException("Publickey authentication failed.", e);
        }
    }

    public boolean authenticateNone(String user2) throws IOException {
        try {
            this.initialize(user2);
            return this.authenticated;
        }
        catch (IOException e) {
            this.tm.close(e, false);
            throw new IOException("None authentication failed.", e);
        }
    }

    public boolean authenticatePassword(String user2, String pass) throws IOException {
        try {
            this.initialize(user2);
            if (!this.methodPossible("password")) {
                throw new IOException("Authentication method password not supported by the server at this stage.");
            }
            PacketUserauthRequestPassword ua = new PacketUserauthRequestPassword("ssh-connection", user2, pass);
            this.tm.sendMessage(ua.getPayload());
            byte[] ar = this.getNextMessage();
            return this.isAuthenticationSuccessful(ar);
        }
        catch (IOException e) {
            this.tm.close(e, false);
            throw new IOException("Password authentication failed.", e);
        }
    }

    public boolean authenticateInteractive(String user2, String[] submethods, InteractiveCallback cb) throws IOException {
        try {
            byte[] ar;
            this.initialize(user2);
            if (!this.methodPossible("keyboard-interactive")) {
                throw new IOException("Authentication method keyboard-interactive not supported by the server at this stage.");
            }
            if (submethods == null) {
                submethods = new String[]{};
            }
            PacketUserauthRequestInteractive ua = new PacketUserauthRequestInteractive("ssh-connection", user2, submethods);
            this.tm.sendMessage(ua.getPayload());
            while ((ar = this.getNextMessage())[0] == 60) {
                String[] responses;
                PacketUserauthInfoRequest pui = new PacketUserauthInfoRequest(ar, 0, ar.length);
                try {
                    responses = cb.replyToChallenge(pui.getName(), pui.getInstruction(), pui.getNumPrompts(), pui.getPrompt(), pui.getEcho());
                }
                catch (Exception e) {
                    throw new IOException("Exception in callback.", e);
                }
                if (responses == null) {
                    throw new IOException("Your callback may not return NULL!");
                }
                PacketUserauthInfoResponse puir = new PacketUserauthInfoResponse(responses);
                this.tm.sendMessage(puir.getPayload());
            }
            return this.isAuthenticationSuccessful(ar);
        }
        catch (IOException e) {
            this.tm.close(e, false);
            throw new IOException("Keyboard-interactive authentication failed.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleMessage(byte[] msg, int msglen) throws IOException {
        Vector vector = this.packets;
        synchronized (vector) {
            if (msg == null) {
                this.connectionClosed = true;
            } else {
                byte[] tmp = new byte[msglen];
                System.arraycopy(msg, 0, tmp, 0, msglen);
                this.packets.addElement(tmp);
            }
            this.packets.notifyAll();
            if (this.packets.size() > 5) {
                this.connectionClosed = true;
                throw new IOException("Error, peer is flooding us with authentication packets.");
            }
        }
    }

    private boolean isAuthenticationSuccessful(byte[] ar) throws IOException {
        if (ar[0] == 52) {
            this.authenticated = true;
            this.tm.removeMessageHandler(this, 0, 255);
            return true;
        }
        if (ar[0] == 51) {
            PacketUserauthFailure puf = new PacketUserauthFailure(ar, 0, ar.length);
            this.remainingMethods = puf.getAuthThatCanContinue();
            this.isPartialSuccess = puf.isPartialSuccess();
            return false;
        }
        throw new IOException("Unexpected SSH message (type " + ar[0] + ")");
    }

    private byte[] generatePublicKeyUserAuthenticationRequest(String user2, String algorithm, byte[] publicKeyEncoded) {
        TypesWriter tw = new TypesWriter();
        byte[] H = this.tm.getSessionIdentifier();
        tw.writeString(H, 0, H.length);
        tw.writeByte(50);
        tw.writeString(user2);
        tw.writeString("ssh-connection");
        tw.writeString("publickey");
        tw.writeBoolean(true);
        tw.writeString(algorithm);
        tw.writeString(publicKeyEncoded, 0, publicKeyEncoded.length);
        return tw.getBytes();
    }
}

