/*
 * Decompiled with CFR 0.152.
 */
package scray.cassandra.util;

import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.TableMetadata;
import com.twitter.util.Try$;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.yaml.snakeyaml.Yaml;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scray.cassandra.util.CassandraUtils$;
import scray.querying.description.TableIdentifier;
import scray.querying.sync.AbstractRow;
import scray.querying.sync.Column;
import scray.querying.sync.Table;

public final class CassandraUtils$
implements LazyLogging,
Serializable {
    public static final CassandraUtils$ MODULE$;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new CassandraUtils$();
    }

    private Logger logger$lzycompute() {
        CassandraUtils$ cassandraUtils$ = this;
        synchronized (cassandraUtils$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public KeyspaceMetadata getKeyspaceMetadata(Session session, String keyspace) {
        return session.getCluster().getMetadata().getKeyspace(Metadata.quote((String)keyspace));
    }

    public TableMetadata getTableMetadata(String cf, KeyspaceMetadata km) {
        return km.getTable(Metadata.quote((String)cf));
    }

    public TableMetadata getTableMetadata(TableIdentifier ti, Session session, Option<KeyspaceMetadata> km) {
        Option<KeyspaceMetadata> option;
        block4: {
            KeyspaceMetadata keyspaceMetadata;
            block3: {
                block2: {
                    KeyspaceMetadata ksm;
                    option = km;
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    keyspaceMetadata = ksm = (KeyspaceMetadata)some.x();
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                keyspaceMetadata = this.getKeyspaceMetadata(session, ti.dbId());
            }
            KeyspaceMetadata kspaceMeta = keyspaceMetadata;
            return kspaceMeta.getTable(Metadata.quote((String)ti.tableId()));
        }
        throw new MatchError(option);
    }

    public Option<KeyspaceMetadata> getTableMetadata$default$3() {
        return None$.MODULE$;
    }

    public ResultSet writeTablePropertyToCassandra(TableIdentifier ti, Session session, String property, String value) {
        String yaml = this.createYaml(property, value, this.getTablePropertiesFromCassandra(ti, session));
        String cql = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ALTER TABLE ", ".", " WITH comment='", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ti.dbId(), ti.tableId(), yaml}));
        return session.execute(cql);
    }

    public String createYaml(String property, String value, Option<Map<String, String>> currentMap) {
        Option<Map<String, String>> option;
        block4: {
            Object object;
            block3: {
                block2: {
                    option = currentMap;
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    Map properties = (Map)some.x();
                    object = properties.put(property, value);
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                HashMap<String, String> properties = new HashMap<String, String>();
                properties.put(property, value);
                object = properties;
            }
            String map = object;
            return this.escapeQuotes$1(new Yaml().dump((Object)map));
        }
        throw new MatchError(option);
    }

    public Option<Map<String, String>> createYaml$default$3() {
        return None$.MODULE$;
    }

    public Option<Map<String, String>> getTablePropertiesFromCassandra(TableIdentifier ti, Session session) {
        TableMetadata tableMeta = this.getTableMetadata(ti, session, this.getTableMetadata$default$3());
        Option currentYaml = Option$.MODULE$.apply((Object)tableMeta.getOptions().getComment());
        Yaml yaml = new Yaml();
        return currentYaml.flatMap((Function1)new Serializable(yaml){
            public static final long serialVersionUID = 0L;
            public final Yaml yaml$1;

            public final Option<Map<String, String>> apply(String content) {
                return Try$.MODULE$.apply((Function0)new Serializable(this, content){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.getTablePropertiesFromCassandra.1 $outer;
                    private final String content$1;

                    public final Option<Map<String, String>> apply() {
                        return Option$.MODULE$.apply((Object)((Map)this.$outer.yaml$1.load(this.content$1)));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.content$1 = content$1;
                    }
                }).toOption().flatten(Predef$.MODULE$.$conforms());
            }
            {
                this.yaml$1 = yaml$1;
            }
        });
    }

    public Option<String> getTablePropertyFromCassandra(TableIdentifier ti, Session session, String property) {
        return this.getTablePropertiesFromCassandra(ti, session).flatMap((Function1)new Serializable(property){
            public static final long serialVersionUID = 0L;
            private final String property$1;

            public final Option<String> apply(Map<String, String> map) {
                return Option$.MODULE$.apply((Object)map.get(this.property$1));
            }
            {
                this.property$1 = property$1;
            }
        });
    }

    public Option<Row> getNewestRow(Iterator<Row> rows, String columnName) {
        Ordering comp = (Ordering)Predef$.MODULE$.implicitly((Object)Ordering.Long$.MODULE$);
        return this.getComptRow(rows, (Function2<Object, Object, Object>)new Serializable(comp){
            public static final long serialVersionUID = 0L;
            private final Ordering comp$1;

            public final boolean apply(long x, long y) {
                return this.apply$mcZJJ$sp(x, y);
            }

            public boolean apply$mcZJJ$sp(long x, long y) {
                return this.comp$1.gt((Object)BoxesRunTime.boxToLong((long)x), (Object)BoxesRunTime.boxToLong((long)y));
            }
            {
                this.comp$1 = comp$1;
            }
        }, columnName);
    }

    public Option<Row> getOldestRow(Iterator<Row> rows, String columnName) {
        Ordering comp = (Ordering)Predef$.MODULE$.implicitly((Object)Ordering.Long$.MODULE$);
        return this.getComptRow(rows, (Function2<Object, Object, Object>)new Serializable(comp){
            public static final long serialVersionUID = 0L;
            private final Ordering comp$3;

            public final boolean apply(long x, long y) {
                return this.apply$mcZJJ$sp(x, y);
            }

            public boolean apply$mcZJJ$sp(long x, long y) {
                return this.comp$3.lt((Object)BoxesRunTime.boxToLong((long)x), (Object)BoxesRunTime.boxToLong((long)y));
            }
            {
                this.comp$3 = comp$3;
            }
        }, columnName);
    }

    public Option<Row> getComptRow(Iterator<Row> rows, Function2<Object, Object, Object> comp, String columnName) {
        return rows.hasNext() ? new Some((Object)this.accNewestRow$1(rows.next(), rows, comp, columnName)) : None$.MODULE$;
    }

    public <T extends AbstractRow> Option<String> createTableStatement(Table<T> table) {
        BoxedUnit boxedUnit;
        String createStatement = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CREATE TABLE IF NOT EXISTS ", " ("})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder().append((Object)table.keySpace()).append((Object)".").append((Object)table.tableName()).toString()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{table.columns().foldLeft((Object)"", (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String acc, Column next) {
                return new StringBuilder().append((Object)acc).append((Object)next.name()).append((Object)" ").append((Object)next.getDBType()).append((Object)", ").toString();
            }
        })}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PRIMARY KEY ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{table.columns().primaryKey()}))).toString();
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Create table String: ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{createStatement})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return new Some((Object)createStatement);
    }

    public <T extends AbstractRow> Option<String> createKeyspaceCreationStatement(Table<T> table, String replicationSettings) {
        return new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CREATE KEYSPACE IF NOT EXISTS ", " WITH REPLICATION = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{table.keySpace(), replicationSettings})));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private final String escapeQuotes$1(String str) {
        return str.replaceAll("'", "''");
    }

    private final Row accNewestRow$1(Row prevRow, Iterator nextRows, Function2 comp$2, String columnName$1) {
        BoxedUnit boxedUnit;
        while (nextRows.hasNext()) {
            Row max;
            BoxedUnit boxedUnit2;
            Row localRow = (Row)nextRows.next();
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Work with row ", " and ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{prevRow, localRow})));
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            prevRow = max = comp$2.apply$mcZJJ$sp(prevRow.getLong(columnName$1), localRow.getLong(columnName$1)) ? prevRow : localRow;
        }
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Return newest row ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{prevRow})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return prevRow;
    }

    private CassandraUtils$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
    }
}

