/*
 * Decompiled with CFR 0.152.
 */
package scray.cassandra.tools.types;

import com.datastax.driver.core.DataType;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.runtime.BoxedUnit;
import scray.cassandra.tools.types.ScrayColumnTypes;

public final class CassandraColumnTypeMapper$
implements LazyLogging {
    public static final CassandraColumnTypeMapper$ MODULE$;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new CassandraColumnTypeMapper$();
    }

    private Logger logger$lzycompute() {
        CassandraColumnTypeMapper$ cassandraColumnTypeMapper$ = this;
        synchronized (cassandraColumnTypeMapper$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public Option<ScrayColumnTypes.ScrayColumnType> findScrayType(String columnName, DataType casType) {
        Some some;
        DataType.Name name = casType.getName();
        if (DataType.Name.TEXT.equals(name)) {
            some = new Some((Object)new ScrayColumnTypes.String(columnName));
        } else if (DataType.Name.VARCHAR.equals(name)) {
            some = new Some((Object)new ScrayColumnTypes.String(columnName));
        } else if (DataType.Name.ASCII.equals(name)) {
            some = new Some((Object)new ScrayColumnTypes.String(columnName));
        } else if (DataType.Name.BIGINT.equals(name)) {
            some = new Some((Object)new ScrayColumnTypes.Long(columnName));
        } else if (DataType.Name.INT.equals(name)) {
            some = new Some((Object)new ScrayColumnTypes.Integer(columnName));
        } else if (DataType.Name.BOOLEAN.equals(name)) {
            some = new Some((Object)new ScrayColumnTypes.Boolean(columnName));
        } else if (DataType.Name.DOUBLE.equals(name)) {
            some = new Some((Object)new ScrayColumnTypes.Double(columnName));
        } else {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No scray column type for ", " found."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            some = None$.MODULE$;
        }
        return some;
    }

    private CassandraColumnTypeMapper$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
    }
}

