/*
 * Decompiled with CFR 0.152.
 */
package scray.cassandra.sync;

import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.Insert;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scray.querying.sync.DbSession;
import scray.querying.sync.StatementExecutionError;

@ScalaSignature(bytes="\u0006\u0001\u001d4A!\u0001\u0002\u0001\u0013\t\u00112)Y:tC:$'/\u0019#c'\u0016\u001c8/[8o\u0015\t\u0019A!\u0001\u0003ts:\u001c'BA\u0003\u0007\u0003%\u0019\u0017m]:b]\u0012\u0014\u0018MC\u0001\b\u0003\u0015\u00198M]1z\u0007\u0001\u00192\u0001\u0001\u0006'!\u0015Yq\"E\u000f$\u001b\u0005a!BA\u0002\u000e\u0015\tqa!\u0001\u0005rk\u0016\u0014\u00180\u001b8h\u0013\t\u0001BBA\u0005EEN+7o]5p]B\u0011!cG\u0007\u0002')\u0011A#F\u0001\u0005G>\u0014XM\u0003\u0002\u0017/\u00051AM]5wKJT!\u0001G\r\u0002\u0011\u0011\fG/Y:uCbT\u0011AG\u0001\u0004G>l\u0017B\u0001\u000f\u0014\u0005%\u0019F/\u0019;f[\u0016tG\u000f\u0005\u0002\u001fC5\tqD\u0003\u0002!'\u0005a\u0011/^3ss\n,\u0018\u000e\u001c3fe&\u0011!e\b\u0002\u0007\u0013:\u001cXM\u001d;\u0011\u0005I!\u0013BA\u0013\u0014\u0005%\u0011Vm];miN+G\u000f\u0005\u0002(Y5\t\u0001F\u0003\u0002*U\u0005a1oY1mC2|wmZ5oO*\u00111&G\u0001\tif\u0004Xm]1gK&\u0011Q\u0006\u000b\u0002\f\u0019\u0006T\u0018\u0010T8hO&tw\r\u0003\u00050\u0001\t\u0015\r\u0011\"\u00011\u0003A\u0019\u0017m]:b]\u0012\u0014\u0018mU3tg&|g.F\u00012!\t\u0011\"'\u0003\u00024'\t91+Z:tS>t\u0007\u0002C\u001b\u0001\u0005\u0003\u0005\u000b\u0011B\u0019\u0002#\r\f7o]1oIJ\f7+Z:tS>t\u0007\u0005C\u00038\u0001\u0011\u0005\u0001(\u0001\u0004=S:LGO\u0010\u000b\u0003sm\u0002\"A\u000f\u0001\u000e\u0003\tAQa\f\u001cA\u0002EBQa\u000e\u0001\u0005\u0002u\"\"!\u000f \t\u000b}b\u0004\u0019\u0001!\u0002\t!|7\u000f\u001e\t\u0003\u0003\u001es!AQ#\u000e\u0003\rS\u0011\u0001R\u0001\u0006g\u000e\fG.Y\u0005\u0003\r\u000e\u000ba\u0001\u0015:fI\u00164\u0017B\u0001%J\u0005\u0019\u0019FO]5oO*\u0011ai\u0011\u0005\u0006\u0017\u0002!\t\u0005T\u0001\bKb,7-\u001e;f)\ti5\u000bE\u0002O#\u000ej\u0011a\u0014\u0006\u0003!\u000e\u000bA!\u001e;jY&\u0011!k\u0014\u0002\u0004)JL\b\"\u0002+K\u0001\u0004\u0001\u0015!C:uCR,W.\u001a8u\u0011\u0015Y\u0005\u0001\"\u0001W)\tiu\u000bC\u0003U+\u0002\u0007\u0011\u0003C\u0003Z\u0001\u0011\u0005!,\u0001\u0004j]N,'\u000f\u001e\u000b\u0003\u001bnCQ\u0001\u0016-A\u0002uAQa\u0013\u0001\u0005\u0002u#\"!\u00140\t\u000bQc\u0006\u0019A0\u0011\u0005I\u0001\u0017BA1\u0014\u0005=\u0019\u0016.\u001c9mKN#\u0018\r^3nK:$\b\"B2\u0001\t\u0003!\u0017A\u00049sS:$8\u000b^1uK6,g\u000e\u001e\u000b\u0003\u0001\u0016DQA\u001a2A\u0002E\t\u0011a\u001d")
public class CassandraDbSession
extends DbSession<Statement, Insert, ResultSet>
implements LazyLogging {
    private final Session cassandraSession;
    private final Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        CassandraDbSession cassandraDbSession = this;
        synchronized (cassandraDbSession) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public Session cassandraSession() {
        return this.cassandraSession;
    }

    public Try<ResultSet> execute(String statement) {
        Object object;
        try {
            ResultSet result = this.cassandraSession().execute(statement);
            object = result.wasApplied() ? new Success((Object)result) : new Failure((Throwable)new StatementExecutionError(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"It was not possible to execute statement: ", ". Condition was false"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{statement}))));
        }
        catch (Exception exception) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error while executing statement ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{statement}))).append((Object)exception).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            object = new Failure((Throwable)exception);
        }
        return object;
    }

    public Try<ResultSet> execute(Statement statement) {
        Object object;
        try {
            ResultSet result = this.cassandraSession().execute(statement);
            object = result.wasApplied() ? new Success((Object)result) : new Failure((Throwable)new StatementExecutionError(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"It was not possible to execute statement: ", ". Condition was false"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{statement}))));
        }
        catch (Exception exception) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error while executing statement ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{statement}))).append((Object)exception).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            object = new Failure((Throwable)exception);
        }
        return object;
    }

    public Try<ResultSet> insert(Insert statement) {
        Object object;
        try {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug(new StringBuilder().append((Object)"Insert ").append((Object)statement).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            ResultSet result = this.cassandraSession().execute((Statement)statement);
            object = result.wasApplied() ? new Success((Object)result) : new Failure((Throwable)new StatementExecutionError(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"It was not possible to execute statement: ", ". Condition was false"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{statement}))));
        }
        catch (Exception exception) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error while executing statement ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{statement}))).append((Object)exception).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            object = new Failure((Throwable)exception);
        }
        return object;
    }

    public Try<ResultSet> execute(SimpleStatement statement) {
        Object object;
        try {
            ResultSet result = this.cassandraSession().execute((Statement)statement);
            object = result.wasApplied() ? new Success((Object)result) : new Failure((Throwable)new StatementExecutionError(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"It was not possible to execute statement: ", ". Error: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{statement, result.getExecutionInfo()}))));
        }
        catch (Exception exception) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error while executing statement ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{statement}))).append((Object)exception).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            object = new Failure((Throwable)exception);
        }
        return object;
    }

    public String printStatement(Statement s) {
        String string;
        Statement statement = s;
        if (statement instanceof BatchStatement) {
            BatchStatement batchStatement = (BatchStatement)statement;
            string = new StringBuilder().append((Object)"It is currently not possible to execute : ").append((Object)batchStatement.getStatements()).toString();
        } else {
            string = new StringBuilder().append((Object)"It is currently not possible to execute : ").append((Object)s).toString();
        }
        return string;
    }

    public CassandraDbSession(Session cassandraSession) {
        this.cassandraSession = cassandraSession;
        super(((Host)cassandraSession.getCluster().getMetadata().getAllHosts().iterator().next()).getAddress().toString());
        LazyLogging.class.$init$((LazyLogging)this);
    }

    public CassandraDbSession(String host) {
        this(Cluster.builder().addContactPoint(host).build().connect());
    }
}

