/*
 * Decompiled with CFR 0.152.
 */
package scray.cassandra.automation;

import com.datastax.driver.core.ColumnMetadata;
import com.datastax.driver.core.TableMetadata;
import com.twitter.util.FuturePool;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import com.websudos.phantom.CassandraPrimitive;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Buffer$;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import scray.cassandra.CassandraQueryableSource;
import scray.cassandra.CassandraTableNonexistingException;
import scray.cassandra.automation.RowStoreFactory$;
import scray.cassandra.extractors.CassandraExtractor;
import scray.cassandra.extractors.DomainToCQLQueryMapping;
import scray.cassandra.rows.GenericCassandraRowStoreMapper$;
import scray.cassandra.sync.CassandraDbSession;
import scray.cassandra.util.CassandraUtils$;
import scray.querying.description.Column;
import scray.querying.description.ColumnConfiguration;
import scray.querying.description.ManuallyIndexConfiguration;
import scray.querying.description.TableIdentifier;
import scray.querying.queries.DomainQuery;
import scray.querying.source.Splitter;
import scray.querying.sync.DbSession;

public final class RowStoreFactory$
implements LazyLogging {
    public static final RowStoreFactory$ MODULE$;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new RowStoreFactory$();
    }

    private Logger logger$lzycompute() {
        RowStoreFactory$ rowStoreFactory$ = this;
        synchronized (rowStoreFactory$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public <Q extends DomainQuery> Tuple2<Option<CassandraQueryableSource<Q>>, List<Tuple2<String, CassandraPrimitive<?>>>> getRowStore(TableIdentifier ti, DbSession<?, ?, ?> session, Map<String, CassandraPrimitive<?>> typeMap, FuturePool futurePool) {
        DbSession<?, ?, ?> dbSession = session;
        if (dbSession instanceof CassandraDbSession) {
            CassandraDbSession cassandraDbSession = (CassandraDbSession)dbSession;
            CassandraExtractor cassExtractor = new CassandraExtractor(cassandraDbSession.cassandraSession(), ti, futurePool);
            Option tableMetaOpt = Option$.MODULE$.apply((Object)CassandraUtils$.MODULE$.getTableMetadata(ti, cassandraDbSession.cassandraSession(), CassandraUtils$.MODULE$.getTableMetadata$default$3()));
            Tuple2 tuple2 = (Tuple2)tableMetaOpt.map((Function1)new Serializable(ti, typeMap, futurePool, cassExtractor, cassandraDbSession){
                public static final long serialVersionUID = 0L;
                public final TableIdentifier ti$1;
                public final Map typeMap$1;
                private final FuturePool futurePool$1;
                public final CassandraExtractor cassExtractor$1;
                public final CassandraDbSession x2$1;

                public final Tuple2<Some<CassandraQueryableSource<Q>>, List<Tuple2<String, CassandraPrimitive<Object>>>> apply(TableMetadata tableMeta) {
                    BoxedUnit boxedUnit;
                    if (RowStoreFactory$.MODULE$.logger().underlying().isDebugEnabled()) {
                        RowStoreFactory$.MODULE$.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Fetching column information for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableMeta.getName()})));
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    List metaInfo = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(tableMeta.getColumns()).asScala()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.getRowStore.1 $outer;

                        public final Tuple2<String, CassandraPrimitive<Object>> apply(ColumnMetadata colMeta) {
                            return new Tuple2((Object)colMeta.getName(), this.$outer.typeMap$1.get((Object)colMeta.getType().getName().toString()).get());
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, Buffer$.MODULE$.canBuildFrom())).toList();
                    Set<Column> allColumns = this.cassExtractor$1.getColumns();
                    Set<Column> rowKeys = this.cassExtractor$1.getRowKeyColumns();
                    Set<Column> clusterKeys = this.cassExtractor$1.getClusteringKeyColumns();
                    return new Tuple2((Object)new Some(new CassandraQueryableSource<Q>(this.ti$1, rowKeys, clusterKeys, allColumns, (Set<ColumnConfiguration>)((Set)allColumns.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.getRowStore.1 $outer;

                        public final ColumnConfiguration apply(Column col) {
                            return this.$outer.cassExtractor$1.getColumnConfiguration(this.$outer.x2$1, this.$outer.ti$1.dbId(), this.$outer.ti$1.tableId(), new Column(col.columnName(), this.$outer.ti$1), (Option<ManuallyIndexConfiguration<? extends DomainQuery, ? extends DomainQuery, ?, ?, ? extends DomainQuery>>)None$.MODULE$, (Map<Column, Splitter<?>>)((Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, Set$.MODULE$.canBuildFrom())), this.x2$1.cassandraSession(), new DomainToCQLQueryMapping<Q, S>(), this.futurePool$1, GenericCassandraRowStoreMapper$.MODULE$.cassandraRowToScrayRowMapper(this.ti$1, this.typeMap$1))), (Object)metaInfo);
                }
                {
                    this.ti$1 = ti$1;
                    this.typeMap$1 = typeMap$1;
                    this.futurePool$1 = futurePool$1;
                    this.cassExtractor$1 = cassExtractor$1;
                    this.x2$1 = x2$1;
                }
            }).getOrElse((Function0)new Serializable(ti){
                public static final long serialVersionUID = 0L;
                private final TableIdentifier ti$1;

                public final Nothing$ apply() {
                    throw new CassandraTableNonexistingException(this.ti$1.toString());
                }
                {
                    this.ti$1 = ti$1;
                }
            });
            return tuple2;
        }
        throw new RuntimeException("Row-Store generator has been called without a Cassandra Session. This is a bug. Please report.");
    }

    private RowStoreFactory$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
    }
}

