/*
 * Decompiled with CFR 0.152.
 */
package scray.cassandra.sync;

import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.Insert;
import com.typesafe.scalalogging.slf4j.LazyLogging;
import com.typesafe.scalalogging.slf4j.Logger;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scray.querying.sync.DbSession;
import scray.querying.sync.StatementExecutionError;

@ScalaSignature(bytes="\u0006\u0001\u00154A!\u0001\u0002\u0001\u0013\t\u00112)Y:tC:$'/\u0019#c'\u0016\u001c8/[8o\u0015\t\u0019A!\u0001\u0003ts:\u001c'BA\u0003\u0007\u0003%\u0019\u0017m]:b]\u0012\u0014\u0018MC\u0001\b\u0003\u0015\u00198M]1z\u0007\u0001\u00192\u0001\u0001\u0006'!\u0015Yq\"E\u000f$\u001b\u0005a!BA\u0002\u000e\u0015\tqa!\u0001\u0005rk\u0016\u0014\u00180\u001b8h\u0013\t\u0001BBA\u0005EEN+7o]5p]B\u0011!cG\u0007\u0002')\u0011A#F\u0001\u0005G>\u0014XM\u0003\u0002\u0017/\u00051AM]5wKJT!\u0001G\r\u0002\u0011\u0011\fG/Y:uCbT\u0011AG\u0001\u0004G>l\u0017B\u0001\u000f\u0014\u0005%\u0019F/\u0019;f[\u0016tG\u000f\u0005\u0002\u001fC5\tqD\u0003\u0002!'\u0005a\u0011/^3ss\n,\u0018\u000e\u001c3fe&\u0011!e\b\u0002\u0007\u0013:\u001cXM\u001d;\u0011\u0005I!\u0013BA\u0013\u0014\u0005%\u0011Vm];miN+G\u000f\u0005\u0002(]5\t\u0001F\u0003\u0002*U\u0005)1\u000f\u001c45U*\u00111\u0006L\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u0003[e\t\u0001\u0002^=qKN\fg-Z\u0005\u0003_!\u00121\u0002T1{s2{wmZ5oO\"A\u0011\u0007\u0001BC\u0002\u0013\u0005!'\u0001\tdCN\u001c\u0018M\u001c3sCN+7o]5p]V\t1\u0007\u0005\u0002\u0013i%\u0011Qg\u0005\u0002\b'\u0016\u001c8/[8o\u0011!9\u0004A!A!\u0002\u0013\u0019\u0014!E2bgN\fg\u000e\u001a:b'\u0016\u001c8/[8oA!)\u0011\b\u0001C\u0001u\u00051A(\u001b8jiz\"\"aO\u001f\u0011\u0005q\u0002Q\"\u0001\u0002\t\u000bEB\u0004\u0019A\u001a\t\u000b}\u0002A\u0011\t!\u0002\u000f\u0015DXmY;uKR\u0011\u0011)\u0013\t\u0004\u0005\u001e\u001bS\"A\"\u000b\u0005\u0011+\u0015\u0001B;uS2T\u0011AR\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0011\u000e\u00131\u0001\u0016:z\u0011\u0015Qe\b1\u0001L\u0003%\u0019H/\u0019;f[\u0016tG\u000f\u0005\u0002M!:\u0011QJT\u0007\u0002\u000b&\u0011q*R\u0001\u0007!J,G-\u001a4\n\u0005E\u0013&AB*ue&twM\u0003\u0002P\u000b\")q\b\u0001C\u0001)R\u0011\u0011)\u0016\u0005\u0006\u0015N\u0003\r!\u0005\u0005\u0006/\u0002!\t\u0001W\u0001\u0007S:\u001cXM\u001d;\u0015\u0005\u0005K\u0006\"\u0002&W\u0001\u0004i\u0002\"B \u0001\t\u0003YFCA!]\u0011\u0015Q%\f1\u0001^!\t\u0011b,\u0003\u0002`'\ty1+[7qY\u0016\u001cF/\u0019;f[\u0016tG\u000fC\u0003b\u0001\u0011\u0005!-\u0001\bqe&tGo\u0015;bi\u0016lWM\u001c;\u0015\u0005-\u001b\u0007\"\u00023a\u0001\u0004\t\u0012!A:")
public class CassandraDbSession
extends DbSession<Statement, Insert, ResultSet>
implements LazyLogging {
    private final Session cassandraSession;
    private final Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        CassandraDbSession cassandraDbSession = this;
        synchronized (cassandraDbSession) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public Session cassandraSession() {
        return this.cassandraSession;
    }

    public Try<ResultSet> execute(String statement) {
        Object object;
        try {
            ResultSet result = this.cassandraSession().execute(statement);
            object = result.wasApplied() ? new Success((Object)result) : new Failure((Throwable)new StatementExecutionError(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"It was not possible to execute statement: ", ". Condition was false"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{statement}))));
        }
        catch (Exception exception) {
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error while executing statement ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{statement}))).append((Object)exception).toString());
            }
            object = new Failure((Throwable)exception);
        }
        return object;
    }

    public Try<ResultSet> execute(Statement statement) {
        Object object;
        try {
            ResultSet result = this.cassandraSession().execute(statement);
            object = result.wasApplied() ? new Success((Object)result) : new Failure((Throwable)new StatementExecutionError(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"It was not possible to execute statement: ", ". Condition was false"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{statement}))));
        }
        catch (Exception exception) {
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error while executing statement ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{statement}))).append((Object)exception).toString());
            }
            object = new Failure((Throwable)exception);
        }
        return object;
    }

    public Try<ResultSet> insert(Insert statement) {
        Object object;
        try {
            ResultSet result = this.cassandraSession().execute((Statement)statement);
            object = result.wasApplied() ? new Success((Object)result) : new Failure((Throwable)new StatementExecutionError(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"It was not possible to execute statement: ", ". Condition was false"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{statement}))));
        }
        catch (Exception exception) {
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error while executing statement ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{statement}))).append((Object)exception).toString());
            }
            object = new Failure((Throwable)exception);
        }
        return object;
    }

    public Try<ResultSet> execute(SimpleStatement statement) {
        Object object;
        try {
            ResultSet result = this.cassandraSession().execute((Statement)statement);
            object = result.wasApplied() ? new Success((Object)result) : new Failure((Throwable)new StatementExecutionError(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"It was not possible to execute statement: ", ". Error: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{statement, result.getExecutionInfo()}))));
        }
        catch (Exception exception) {
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error while executing statement ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{statement}))).append((Object)exception).toString());
            }
            object = new Failure((Throwable)exception);
        }
        return object;
    }

    public String printStatement(Statement s) {
        String string;
        Statement statement = s;
        if (statement instanceof BatchStatement) {
            BatchStatement batchStatement = (BatchStatement)statement;
            string = new StringBuilder().append((Object)"It is currently not possible to execute : ").append((Object)batchStatement.getStatements()).toString();
        } else {
            string = new StringBuilder().append((Object)"It is currently not possible to execute : ").append((Object)s).toString();
        }
        return string;
    }

    public CassandraDbSession(Session cassandraSession) {
        this.cassandraSession = cassandraSession;
        super(((Host)cassandraSession.getCluster().getMetadata().getAllHosts().iterator().next()).getAddress().toString());
        LazyLogging.class.$init$((LazyLogging)this);
    }
}

