/*
 * Decompiled with CFR 0.152.
 */
package scray.cassandra.extractors;

import com.typesafe.scalalogging.slf4j.LazyLogging;
import com.typesafe.scalalogging.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scray.cassandra.extractors.DomainToJSONLuceneQueryMapper$;
import scray.querying.description.Column;
import scray.querying.description.ColumnOrdering;
import scray.querying.description.TableIdentifier;
import scray.querying.description.internal.Bound;
import scray.querying.description.internal.Domain;
import scray.querying.description.internal.RangeValueDomain;
import scray.querying.description.internal.SingleValueDomain;
import scray.querying.queries.DomainQuery;

public final class DomainToJSONLuceneQueryMapper$
implements LazyLogging {
    public static final DomainToJSONLuceneQueryMapper$ MODULE$;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new DomainToJSONLuceneQueryMapper$();
    }

    private Logger logger$lzycompute() {
        DomainToJSONLuceneQueryMapper$ domainToJSONLuceneQueryMapper$ = this;
        synchronized (domainToJSONLuceneQueryMapper$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    private String convertSingleValueDomain(SingleValueDomain<?> vdomain) {
        String string;
        if (vdomain.isNull()) {
            string = "";
        } else if (vdomain.isWildcard()) {
            String search2;
            String search = vdomain.value().toString();
            if ((search.endsWith("*") || search.endsWith("?")) && search.length() > 1 && !(search2 = search.substring(0, search.length() - 1)).contains("*") && !search2.contains("?")) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" { type  : \"prefix\", field : \"", "\", value : \"", "\" } "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{vdomain.column().columnName(), search2}));
            }
            string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" { type  : \"wildcard\", field : \"", "\", value : \"", "\" } "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{vdomain.column().columnName(), vdomain.value()}));
        } else {
            string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" { type : \"match\", field : \"", "\", value : \"", "\" } "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{vdomain.column().columnName(), vdomain.value()}));
        }
        return string;
    }

    private String convertRangeValueDomain(RangeValueDomain<?> vdomain) {
        BoxedUnit boxedUnit;
        StringBuilder result = new StringBuilder();
        result.$plus$plus$eq("");
        if (vdomain.lowerBound().isDefined() || vdomain.upperBound().isDefined()) {
            result.$plus$plus$eq(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" { type : \"range\", field : \"", "\", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{vdomain.column().columnName()})));
            vdomain.lowerBound().map((Function1)new Serializable(vdomain, result){
                public static final long serialVersionUID = 0L;
                private final RangeValueDomain vdomain$1;
                public final StringBuilder result$1;

                public final Option<StringBuilder> apply(Bound<Object> bound) {
                    this.result$1.$plus$plus$eq(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" lower: \"", "\" , include_lower: \"", "\" "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{bound.value(), BoxesRunTime.boxToBoolean((boolean)bound.inclusive())})));
                    return this.vdomain$1.upperBound().map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.convertRangeValueDomain.1 $outer;

                        public final StringBuilder apply(Bound<Object> x$1) {
                            return this.$outer.result$1.$plus$plus$eq(",");
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                {
                    this.vdomain$1 = vdomain$1;
                    this.result$1 = result$1;
                }
            });
            vdomain.upperBound().map((Function1)new Serializable(result){
                public static final long serialVersionUID = 0L;
                private final StringBuilder result$1;

                public final StringBuilder apply(Bound<Object> bound) {
                    return this.result$1.$plus$plus$eq(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" upper: \"", "\" , include_upper: \"", "\" "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{bound.value(), BoxesRunTime.boxToBoolean((boolean)bound.inclusive())})));
                }
                {
                    this.result$1 = result$1;
                }
            });
            boxedUnit = result.$plus$plus$eq(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" } "})).s((Seq)Nil$.MODULE$));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return result.toString();
    }

    public String scray$cassandra$extractors$DomainToJSONLuceneQueryMapper$$domainToQueryString(Domain<?> domain) {
        Domain<?> domain2;
        block4: {
            String string;
            block3: {
                block2: {
                    domain2 = domain;
                    if (!(domain2 instanceof SingleValueDomain)) break block2;
                    SingleValueDomain singleValueDomain = (SingleValueDomain)domain2;
                    string = this.convertSingleValueDomain(singleValueDomain);
                    break block3;
                }
                if (!(domain2 instanceof RangeValueDomain)) break block4;
                RangeValueDomain rangeValueDomain = (RangeValueDomain)domain2;
                string = this.convertRangeValueDomain(rangeValueDomain);
            }
            return string;
        }
        throw new MatchError(domain2);
    }

    private String sortIndex(Option<ColumnOrdering<?>> optOrdering, List<Domain<?>> domains) {
        return (String)optOrdering.map((Function1)new Serializable(domains){
            public static final long serialVersionUID = 0L;
            private final List domains$1;

            public final String apply(ColumnOrdering<?> ordering) {
                return (String)this.domains$1.find((Function1)new Serializable(this, ordering){
                    public static final long serialVersionUID = 0L;
                    private final ColumnOrdering ordering$1;

                    public final boolean apply(Domain<?> x) {
                        Column column = x.column();
                        Column column2 = this.ordering$1.column();
                        return !(column != null ? !column.equals(column2) : column2 != null);
                    }
                    {
                        this.ordering$1 = ordering$1;
                    }
                }).map((Function1)new Serializable(this, ordering){
                    public static final long serialVersionUID = 0L;
                    private final ColumnOrdering ordering$1;

                    public final String apply(Domain<?> x$2) {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{", sort : { fields : [ { field : \"", "\" , reverse : ", " } ] } "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.ordering$1.column().columnName(), BoxesRunTime.boxToBoolean((boolean)this.ordering$1.descending())}));
                    }
                    {
                        this.ordering$1 = ordering$1;
                    }
                }).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "";
                    }
                });
            }
            {
                this.domains$1 = domains$1;
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        });
    }

    public Option<String> getLuceneColumnsQueryMapping(DomainQuery query, List<Domain<?>> domains, TableIdentifier ti) {
        None$ none$;
        StringBuilder result = new StringBuilder();
        List validDomains = (List)((TraversableLike)((TraversableLike)domains.filter((Function1)new Serializable(ti){
            public static final long serialVersionUID = 0L;
            private final TableIdentifier ti$1;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean apply(Domain<?> dom) {
                String string = dom.column().table().dbId();
                String string2 = this.ti$1.dbId();
                if (string == null) {
                    if (string2 != null) {
                        return false;
                    }
                } else if (!string.equals(string2)) return false;
                String string3 = dom.column().table().tableId();
                String string4 = this.ti$1.tableId();
                if (string3 == null) {
                    if (string4 != null) {
                        return false;
                    }
                } else if (!string3.equals(string4)) return false;
                String string5 = dom.column().table().dbSystem();
                String string6 = this.ti$1.dbSystem();
                if (string5 == null) {
                    if (string6 == null) return true;
                    return false;
                } else {
                    if (!string5.equals(string6)) return false;
                    return true;
                }
            }
            {
                this.ti$1 = ti$1;
            }
        })).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Domain<?> x$3) {
                return DomainToJSONLuceneQueryMapper$.MODULE$.scray$cassandra$extractors$DomainToJSONLuceneQueryMapper$$domainToQueryString(x$3);
            }
        }, List$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$4) {
                String string = x$4;
                String string2 = "";
                return string != null ? !string.equals(string2) : string2 != null;
            }
        });
        if (validDomains.size() > 0) {
            StringBuilder stringBuilder;
            result.$plus$plus$eq(" lucene='{ filter : ");
            if (validDomains.size() > 1) {
                result.$plus$plus$eq("{ type: \"boolean\", must :[");
                result.$plus$plus$eq(validDomains.mkString(" , "));
                stringBuilder = result.$plus$plus$eq("]}");
            } else {
                stringBuilder = result.$plus$plus$eq((String)validDomains.head());
            }
            result.$plus$plus$eq(this.sortIndex(query.getOrdering(), domains));
            result.$plus$plus$eq(" }' ");
            none$ = new Some((Object)result.toString());
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private DomainToJSONLuceneQueryMapper$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
    }
}

