/*
 * Decompiled with CFR 0.152.
 */
package scray.cassandra.extractors;

import com.datastax.driver.core.ColumnMetadata;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.TableMetadata;
import com.twitter.util.FuturePool;
import com.typesafe.scalalogging.slf4j.LazyLogging;
import com.typesafe.scalalogging.slf4j.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple5;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.convert.package$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scray.cassandra.CassandraQueryableSource;
import scray.cassandra.extractors.CassandraExtractor$;
import scray.cassandra.extractors.DomainToCQLQueryMapping;
import scray.cassandra.sync.CassandraDbSession;
import scray.cassandra.sync.CassandraJobInfo;
import scray.cassandra.sync.CassandraJobInfo$;
import scray.cassandra.sync.OnlineBatchSyncCassandra;
import scray.cassandra.util.CassandraUtils$;
import scray.querying.Registry$;
import scray.querying.description.AutoIndexConfiguration;
import scray.querying.description.Column;
import scray.querying.description.ColumnConfiguration;
import scray.querying.description.IndexConfiguration;
import scray.querying.description.ManuallyIndexConfiguration;
import scray.querying.description.QueryspaceConfiguration;
import scray.querying.description.Row;
import scray.querying.description.TableConfiguration;
import scray.querying.description.TableIdentifier;
import scray.querying.description.VersioningConfiguration;
import scray.querying.queries.DomainQuery;
import scray.querying.source.Splitter;
import scray.querying.source.indexing.IndexConfig;
import scray.querying.source.store.QueryableStoreSource;
import scray.querying.storeabstraction.StoreExtractor;
import scray.querying.sync.DbSession;

@ScalaSignature(bytes="\u0006\u0001\u0011\u001dc\u0001B\u0001\u0003\u0001%\u0011!cQ1tg\u0006tGM]1FqR\u0014\u0018m\u0019;pe*\u00111\u0001B\u0001\u000bKb$(/Y2u_J\u001c(BA\u0003\u0007\u0003%\u0019\u0017m]:b]\u0012\u0014\u0018MC\u0001\b\u0003\u0015\u00198M]1z\u0007\u0001)\"AC\u0010\u0014\t\u0001Y\u0011c\u000b\t\u0003\u0019=i\u0011!\u0004\u0006\u0002\u001d\u0005)1oY1mC&\u0011\u0001#\u0004\u0002\u0007\u0003:L(+\u001a4\u0011\u0007I9\u0012$D\u0001\u0014\u0015\t!R#\u0001\tti>\u0014X-\u00192tiJ\f7\r^5p]*\u0011aCB\u0001\tcV,'/_5oO&\u0011\u0001d\u0005\u0002\u000f'R|'/Z#yiJ\f7\r^8s!\rQ2$H\u0007\u0002\t%\u0011A\u0004\u0002\u0002\u0019\u0007\u0006\u001c8/\u00198ee\u0006\fV/\u001a:zC\ndWmU8ve\u000e,\u0007C\u0001\u0010 \u0019\u0001!Q\u0001\t\u0001C\u0002\u0005\u0012\u0011!U\t\u0003E\u0015\u0002\"\u0001D\u0012\n\u0005\u0011j!a\u0002(pi\"Lgn\u001a\t\u0003M%j\u0011a\n\u0006\u0003QU\tq!];fe&,7/\u0003\u0002+O\tYAi\\7bS:\fV/\u001a:z!\taS'D\u0001.\u0015\tqs&A\u0003tY\u001a$$N\u0003\u00021c\u0005a1oY1mC2|wmZ5oO*\u0011!gM\u0001\tif\u0004Xm]1gK*\tA'A\u0002d_6L!AN\u0017\u0003\u00171\u000b'0\u001f'pO\u001eLgn\u001a\u0005\tq\u0001\u0011\t\u0011)A\u0005s\u000591/Z:tS>t\u0007C\u0001\u001eB\u001b\u0005Y$B\u0001\u001f>\u0003\u0011\u0019wN]3\u000b\u0005yz\u0014A\u00023sSZ,'O\u0003\u0002Ag\u0005AA-\u0019;bgR\f\u00070\u0003\u0002Cw\t91+Z:tS>t\u0007\u0002\u0003#\u0001\u0005\u0003\u0005\u000b\u0011B#\u0002\u000bQ\f'\r\\3\u0011\u0005\u0019KU\"A$\u000b\u0005!+\u0012a\u00033fg\u000e\u0014\u0018\u000e\u001d;j_:L!AS$\u0003\u001fQ\u000b'\r\\3JI\u0016tG/\u001b4jKJD\u0001\u0002\u0014\u0001\u0003\u0002\u0003\u0006I!T\u0001\u000bMV$XO]3Q_>d\u0007C\u0001(T\u001b\u0005y%B\u0001)R\u0003\u0011)H/\u001b7\u000b\u0005I\u001b\u0014a\u0002;xSR$XM]\u0005\u0003)>\u0013!BR;ukJ,\u0007k\\8m\u0011\u00151\u0006\u0001\"\u0001X\u0003\u0019a\u0014N\\5u}Q!\u0001LW.]!\rI\u0006!H\u0007\u0002\u0005!)\u0001(\u0016a\u0001s!)A)\u0016a\u0001\u000b\")A*\u0016a\u0001\u001b\")a\f\u0001C\u0005?\u0006\u0001r-\u001a;UC\ndW-T3uC\u0012\u000bG/\u0019\u000b\u0004A\u000ed\u0007C\u0001\u001eb\u0013\t\u00117HA\u0007UC\ndW-T3uC\u0012\fG/\u0019\u0005\bIv\u0003\n\u00111\u0001f\u0003!YW-_:qC\u000e,\u0007C\u00014j\u001d\taq-\u0003\u0002i\u001b\u00051\u0001K]3eK\u001aL!A[6\u0003\rM#(/\u001b8h\u0015\tAW\u0002C\u0004n;B\u0005\t\u0019A3\u0002\u0013Q\f'\r\\3oC6,\u0007\"B8\u0001\t\u0013\u0001\u0018!E4fi\u000e{G.^7ogB\u0013\u0018N^1uKR\u0011\u0011o\u001e\t\u0004MJ$\u0018BA:l\u0005\r\u0019V\r\u001e\t\u0003\rVL!A^$\u0003\r\r{G.^7o\u0011\u0015Ah\u000e1\u0001a\u0003\t!X\u000eC\u0003{\u0001\u0011%10\u0001\u0010hKR\u001cE.^:uKJLgnZ&fs\u000e{G.^7ogB\u0013\u0018N^1uKR\u0011\u0011\u000f \u0005\u0006qf\u0004\r\u0001\u0019\u0005\u0006}\u0002!Ia`\u0001\u0018O\u0016$(k\\<LKf\u001cu\u000e\\;n]N\u0004&/\u001b<bi\u0016$2!]A\u0001\u0011\u0015AX\u00101\u0001a\u0011\u001d\t)\u0001\u0001C!\u0003\u000f\t!bZ3u\u0007>dW/\u001c8t+\u0005\t\bbBA\u0006\u0001\u0011\u0005\u0013qA\u0001\u0018O\u0016$8\t\\;ti\u0016\u0014\u0018N\\4LKf\u001cu\u000e\\;n]NDq!a\u0004\u0001\t\u0003\n9!\u0001\thKR\u0014vn^&fs\u000e{G.^7og\"9\u00111\u0003\u0001\u0005\u0002\u0005\u001d\u0011aD4fiZ\u000bG.^3D_2,XN\\:\t\u000f\u0005]\u0001\u0001\"\u0011\u0002\u001a\u0005yq-\u001a;Rk\u0016\u0014\u00180T1qa&tw\r\u0006\u0004\u0002\u001c\u0005\u0005\u0012Q\u0005\t\u0006\u0019\u0005uQ%Z\u0005\u0004\u0003?i!!\u0003$v]\u000e$\u0018n\u001c82\u0011\u001d\t\u0019#!\u0006A\u0002e\tQa\u001d;pe\u0016D\u0001\"a\n\u0002\u0016\u0001\u0007\u0011\u0011F\u0001\ni\u0006\u0014G.\u001a(b[\u0016\u0004B\u0001DA\u0016K&\u0019\u0011QF\u0007\u0003\r=\u0003H/[8o\u0011\u001d\t\t\u0004\u0001C\u0001\u0003g\t1bZ3u\t\n\u001b\u0016p\u001d;f[V\tQ\rC\u0004\u00028\u0001!\t%a\r\u0002%\u001d,G\u000fR3gCVdG\u000f\u0012\"TsN$X-\u001c\u0005\b\u0003w\u0001A\u0011IA\u001f\u0003I9W\r\u001e+bE2,\u0017\nZ3oi&4\u0017.\u001a:\u0015\u000f\u0015\u000by$!\u0011\u0002D!9\u00111EA\u001d\u0001\u0004I\u0002\u0002CA\u0014\u0003s\u0001\r!!\u000b\t\u0011\u0005\u0015\u0013\u0011\ba\u0001\u0003S\t\u0001\u0002\u001a2TsN$X-\u001c\u0005\b\u0003\u0013\u0002A\u0011AA&\u0003-9W\r^'fi\u0006$\u0017\r^1\u0015\u0005\u00055\u0003c\u0001\u001e\u0002P%\u0019\u0011\u0011K\u001e\u0003!-+\u0017p\u001d9bG\u0016lU\r^1eCR\f\u0007bBA+\u0001\u0011%\u0011qK\u0001 O\u0016$8i\u001c7v[:\u001c\u0015m]:b]\u0012\u0014\u0018\rT;dK:,\u0017J\u001c3fq\u0016$G\u0003CA-\u0003c\n9(a\u001f\u0011\u000b1\tY#a\u00171\t\u0005u\u0013Q\r\t\u0006\r\u0006}\u00131M\u0005\u0004\u0003C:%AF!vi>Le\u000eZ3y\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0011\u0007y\t)\u0007\u0002\u0007\u0002h\u0005M\u0013\u0011!A\u0001\u0006\u0003\tIGA\u0002`II\n2AIA6!\ra\u0011QN\u0005\u0004\u0003_j!aA!os\"A\u00111OA*\u0001\u0004\t)(A\u0003u[>\u0003H\u000f\u0005\u0003\r\u0003W\u0001\u0007bBA=\u0003'\u0002\r\u0001^\u0001\u0007G>dW/\u001c8\t\u0011\u0005u\u00141\u000ba\u0001\u0003\u007f\n\u0011b\u001d9mSR$XM]:\u0011\r\u0019\f\t\t^AC\u0013\r\t\u0019i\u001b\u0002\u0004\u001b\u0006\u0004\b\u0007BAD\u0003+\u0003b!!#\u0002\u0010\u0006MUBAAF\u0015\r\ti)F\u0001\u0007g>,(oY3\n\t\u0005E\u00151\u0012\u0002\t'Bd\u0017\u000e\u001e;feB\u0019a$!&\u0005\u0019\u0005]\u00151PA\u0001\u0002\u0003\u0015\t!!\u001b\u0003\u0007}#\u0013\u0007C\u0004\u0002\u001c\u0002!\t!!(\u0002?\rDWmY6D_2,XN\\\"bgN\fg\u000e\u001a:b\u0003V$x.\u00138eKb,G\r\u0006\u0007\u0002 \u0006]\u0016\u0011\\An\u0003;\fy\u000eE\u0004\r\u0003C\u000b)+a+\n\u0007\u0005\rVB\u0001\u0004UkBdWM\r\t\u0004\u0019\u0005\u001d\u0016bAAU\u001b\t9!i\\8mK\u0006t\u0007#\u0002\u0007\u0002,\u00055\u0006\u0007BAX\u0003g\u0003RARA0\u0003c\u00032AHAZ\t1\t),!'\u0002\u0002\u0003\u0005)\u0011AA5\u0005\ryFe\u000e\u0005\bq\u0005e\u0005\u0019AA]a!\tY,!3\u0002P\u0006U\u0007CCA_\u0003\u0007\f9-!4\u0002T6\u0011\u0011q\u0018\u0006\u0004\u0003\u0003,\u0012\u0001B:z]\u000eLA!!2\u0002@\nIAIY*fgNLwN\u001c\t\u0004=\u0005%G\u0001DAf\u0003o\u000b\t\u0011!A\u0003\u0002\u0005%$aA0%gA\u0019a$a4\u0005\u0019\u0005E\u0017qWA\u0001\u0002\u0003\u0015\t!!\u001b\u0003\u0007}#C\u0007E\u0002\u001f\u0003+$A\"a6\u00028\u0006\u0005\t\u0011!B\u0001\u0003S\u00121a\u0018\u00136\u0011\u0019!\u0017\u0011\u0014a\u0001K\"9\u0011qEAM\u0001\u0004)\u0007bBA=\u00033\u0003\r\u0001\u001e\u0005\t\u0003{\nI\n1\u0001\u0002bB1a-!!u\u0003G\u0004D!!:\u0002jB1\u0011\u0011RAH\u0003O\u00042AHAu\t1\tY/a8\u0002\u0002\u0003\u0005)\u0011AA5\u0005\ryFE\u000e\u0005\b\u0003_\u0004A\u0011IAy\u0003Y9W\r^\"pYVlgnQ8oM&<WO]1uS>tGCDAz\u0003s\u0014\tB!\u0006\u0003\u0018\te!Q\t\t\u0004\r\u0006U\u0018bAA|\u000f\n\u00192i\u001c7v[:\u001cuN\u001c4jOV\u0014\u0018\r^5p]\"9\u0001(!<A\u0002\u0005m\b\u0007CA\u007f\u0005\u0003\u00119A!\u0004\u0011\u0015\u0005u\u00161YA\u0000\u0005\u000b\u0011Y\u0001E\u0002\u001f\u0005\u0003!ABa\u0001\u0002z\u0006\u0005\t\u0011!B\u0001\u0003S\u00121a\u0018\u00139!\rq\"q\u0001\u0003\r\u0005\u0013\tI0!A\u0001\u0002\u000b\u0005\u0011\u0011\u000e\u0002\u0004?\u0012J\u0004c\u0001\u0010\u0003\u000e\u0011a!qBA}\u0003\u0003\u0005\tQ!\u0001\u0002j\t!q\fJ\u00191\u0011\u001d\u0011\u0019\"!<A\u0002\u0015\fa\u0001\u001a2OC6,\u0007B\u0002#\u0002n\u0002\u0007Q\rC\u0004\u0002z\u00055\b\u0019\u0001;\t\u0011\tm\u0011Q\u001ea\u0001\u0005;\tQ!\u001b8eKb\u0004R\u0001DA\u0016\u0005?\u0001DB!\t\u0003*\t=\"Q\u0007B\u001e\u0005\u0003\u0002RB\u0012B\u0012\u0005O\u0011iCa\r\u0003:\t}\u0012b\u0001B\u0013\u000f\nQR*\u00198vC2d\u00170\u00138eKb\u001cuN\u001c4jOV\u0014\u0018\r^5p]B\u0019aD!\u000b\u0005\u0019\t-\"\u0011DA\u0001\u0002\u0003\u0015\t!!\u001b\u0003\t}#\u0013'\r\t\u0004=\t=B\u0001\u0004B\u0019\u00053\t\t\u0011!A\u0003\u0002\u0005%$\u0001B0%cI\u00022A\bB\u001b\t1\u00119D!\u0007\u0002\u0002\u0003\u0005)\u0011AA5\u0005\u0011yF%M\u001a\u0011\u0007y\u0011Y\u0004\u0002\u0007\u0003>\te\u0011\u0011!A\u0001\u0006\u0003\tIG\u0001\u0003`IE\"\u0004c\u0001\u0010\u0003B\u0011a!1\tB\r\u0003\u0003\u0005\tQ!\u0001\u0002j\t!q\fJ\u00196\u0011!\ti(!<A\u0002\t\u001d\u0003C\u00024\u0002\u0002R\u0014I\u0005\r\u0003\u0003L\t=\u0003CBAE\u0003\u001f\u0013i\u0005E\u0002\u001f\u0005\u001f\"AB!\u0015\u0003F\u0005\u0005\t\u0011!B\u0001\u0003S\u0012Aa\u0018\u00132m!9!Q\u000b\u0001\u0005B\t]\u0013AH2sK\u0006$X-T1ok\u0006d\u0017J\u001c3fq\u000e{gNZ5hkJ\fG/[8o)9\u0011IF! \u0003\u0000\t\r%Q\u0012BH\u0005_\u0004R\u0001DA\u0016\u00057\u0002DB!\u0018\u0003b\t\u001d$Q\u000eB:\u0005s\u0002RB\u0012B\u0012\u0005?\u0012)Ga\u001b\u0003r\t]\u0004c\u0001\u0010\u0003b\u0011a!1\rB*\u0003\u0003\u0005\tQ!\u0001\u0002j\t!q\f\n\u001a9!\rq\"q\r\u0003\r\u0005S\u0012\u0019&!A\u0001\u0002\u000b\u0005\u0011\u0011\u000e\u0002\u0005?\u0012\u0012\u0014\bE\u0002\u001f\u0005[\"ABa\u001c\u0003T\u0005\u0005\t\u0011!B\u0001\u0003S\u0012Aa\u0018\u00134aA\u0019aDa\u001d\u0005\u0019\tU$1KA\u0001\u0002\u0003\u0015\t!!\u001b\u0003\t}#3'\r\t\u0004=\teD\u0001\u0004B>\u0005'\n\t\u0011!A\u0003\u0002\u0005%$\u0001B0%gIBq!!\u001f\u0003T\u0001\u0007A\u000fC\u0004\u0003\u0002\nM\u0003\u0019A3\u0002\u001dE,XM]=ta\u0006\u001cWMT1nK\"A!Q\u0011B*\u0001\u0004\u00119)A\u0004wKJ\u001c\u0018n\u001c8\u0011\u00071\u0011I)C\u0002\u0003\f6\u00111!\u00138u\u0011\u001d\t\u0019Ca\u0015A\u0002eA\u0001B!%\u0003T\u0001\u0007!1S\u0001\bS:$W\r_3ta\u0019\u0011)J!'\u00038B9a-!!\u0003\u0018\nU\u0006c\u0001\u0010\u0003\u001a\u0012a!1\u0014BH\u0003\u0003\u0005\tQ!\u0001\u0003\u001e\n!q\fJ\u00198#\r\u0011#q\u0014\t\u0007\u0019\u0005\u0005&\u0011U31\t\t\r&q\u0016\t\u0007\u0005K\u0013IK!,\u000e\u0005\t\u001d&\u0002BA\u0012\u0003\u0017KAAa+\u0003(\n!\u0012+^3ss\u0006\u0014G.Z*u_J,7k\\;sG\u0016\u00042A\bBX\t-\u0011\tLa-\u0002\u0002\u0003\u0005)\u0011A\u0011\u0003\t}#\u0013\u0007\u000f\u0003\r\u00057\u0013y)!A\u0002\u0002\u000b\u0005!Q\u0014\t\u0004=\t]F\u0001\u0004B]\u0005\u001f\u000b\t\u0011!A\u0003\u0002\tm&\u0001B0%ce\n2A\tB_!1a!q\u0018BbK\n='1\u001cBw\u0013\r\u0011\t-\u0004\u0002\u0007)V\u0004H.Z\u001b1\t\t\u0015'\u0011\u001a\t\u0007\u0005K\u0013IKa2\u0011\u0007y\u0011I\rB\u0006\u0003L\n5\u0017\u0011!A\u0001\u0006\u0003\t#\u0001B0%eA\"AB!/\u0003\u0010\u0006\u0005\u0019\u0011!B\u0001\u0005w\u0003BA!5\u0003X6\u0011!1\u001b\u0006\u0005\u0005+\fY)\u0001\u0005j]\u0012,\u00070\u001b8h\u0013\u0011\u0011INa5\u0003\u0017%sG-\u001a=D_:4\u0017n\u001a\t\u0006\u0019\u0005-\"Q\u001c\u0019\u0007\u0005?\u0014\u0019O!;\u0011\u000f1\tiB!9\u0003hB\u0019aDa9\u0005\u0019\t\u0015(QZA\u0001\u0002\u0003\u0015\t!!\u001b\u0003\t}##'\r\t\u0004=\t%H\u0001\u0004Bv\u0005\u001b\f\t\u0011!A\u0003\u0002\u0005%$\u0001B0%eI\u00022A\u001a:f\u0011!\u0011\tPa\u0015A\u0002\tM\u0018aB7baB,'o\u001d\u0019\u0005\u0005k\u0014I\u0010E\u0004g\u0003\u0003\u00139pa\u0003\u0011\u0007y\u0011I\u0010\u0002\u0007\u0003|\n=\u0018\u0011!A\u0001\u0006\u0003\u0011iP\u0001\u0003`II\u001a\u0014c\u0001\u0012\u0003\u0000B\"1\u0011AB\u0003!\u0019\u0011)K!+\u0004\u0004A\u0019ad!\u0002\u0005\u0019\r\u001d1\u0011BA\u0001\u0002\u0003\u0015\t!!\u001b\u0003\t}##\u0007\u000e\u0003\r\u0005w\u0014y/!A\u0002\u0002\u000b\u0005!Q \t\n\u0019\r51\u0011CA\u0015\u0007CI1aa\u0004\u000e\u0005\u0019!V\u000f\u001d7fgA\"11CB\f!\u001da\u0011QDB\u000b\u00077\u00012AHB\f\t1\u0019IBa<\u0002\u0002\u0003\u0005)\u0011AA5\u0005\u0011yFEM\u001b\u0011\u0007\u0019\u001bi\"C\u0002\u0004 \u001d\u00131AU8x!\u0015a\u00111FB\u0012a\u0019\u0019)c!\f\u00044A9aia\n\u0004,\rE\u0012bAB\u0015\u000f\n9b+\u001a:tS>t\u0017N\\4D_:4\u0017nZ;sCRLwN\u001c\t\u0004=\r5B\u0001DB\u0018\u0005_\f\t\u0011!A\u0003\u0002\u0005%$\u0001B0%eY\u00022AHB\u001a\t1\u0019)Da<\u0002\u0002\u0003\u0005)\u0011AA5\u0005\u0011yFEM\u001c\t\u000f\re\u0002\u0001\"\u0003\u0004<\u0005ir-\u001a;UC\ndWmQ8oM&<WO]1uS>tg)\u001e8di&|g.\u0006\u0005\u0004>\r\u001d31JB))!\u0019yd!\u0016\u0004Z\ru\u0003#\u0003$\u0004B\r\u00153\u0011JB(\u0013\r\u0019\u0019e\u0012\u0002\u0013)\u0006\u0014G.Z\"p]\u001aLw-\u001e:bi&|g\u000eE\u0002\u001f\u0007\u000f\"a\u0001IB\u001c\u0005\u0004\t\u0003c\u0001\u0010\u0004L\u001191QJB\u001c\u0005\u0004\t#!A&\u0011\u0007y\u0019\t\u0006\u0002\u0005\u0004T\r]\"\u0019AA5\u0005\u00051\u0006bBB,\u0007o\u0001\r!R\u0001\u0003i&Dqaa\u0017\u00048\u0001\u0007Q-A\u0003ta\u0006\u001cW\r\u0003\u0005\u0003\u0006\u000e]\u0002\u0019\u0001BD\u0011\u001d\u0019\t\u0007\u0001C\u0005\u0007G\n!dZ3u-\u0016\u00148/[8oS:<7i\u001c8gS\u001e,(/\u0019;j_:,ba!\u001a\u0004n\rEDCBB4\u0007g\u001a9\bE\u0003\r\u0003W\u0019I\u0007E\u0004G\u0007O\u0019Yga\u001c\u0011\u0007y\u0019i\u0007\u0002\u0004!\u0007?\u0012\r!\t\t\u0004=\rEDaBB'\u0007?\u0012\r!\t\u0005\b\u0007k\u001ay\u00061\u0001f\u0003\u001dQwN\u0019(b[\u0016D\u0001b!\u001f\u0004`\u0001\u000711P\u0001\ne><X*\u00199qKJ\u0004Da! \u0004\u0002B9A\"!\b\u0004\u0000\rm\u0001c\u0001\u0010\u0004\u0002\u0012a11QB<\u0003\u0003\u0005\tQ!\u0001\u0002j\t!q\f\n\u001b3\u0011\u001d\u00199\t\u0001C!\u0007\u0013\u000bQcZ3u)\u0006\u0014G.Z\"p]\u001aLw-\u001e:bi&|g\u000e\u0006\u0003\u0004\f\u000e\u0005\u0006\u0007CBG\u0007#\u001b9j!(\u0011\u0013\u0019\u001b\tea$\u0004\u0016\u000em\u0005c\u0001\u0010\u0004\u0012\u0012Y11SBC\u0003\u0003\u0005\tQ!\u0001\"\u0005\u0011yF\u0005\u000e\u001b\u0011\u0007y\u00199\nB\u0006\u0004\u001a\u000e\u0015\u0015\u0011!A\u0001\u0006\u0003\t#\u0001B0%iU\u00022AHBO\t1\u0019yj!\"\u0002\u0002\u0003\u0005)\u0011AA5\u0005\u0011yF\u0005\u000e\u001c\t\u0011\re4Q\u0011a\u0001\u0007G\u0003Da!*\u0004*B9A\"!\b\u0004(\u000em\u0001c\u0001\u0010\u0004*\u0012a11VBQ\u0003\u0003\u0005\tQ!\u0001\u0002j\t!q\f\n\u001b4\u0011%\u0019y\u000bAI\u0001\n\u0013\u0019\t,\u0001\u000ehKR$\u0016M\u00197f\u001b\u0016$\u0018\rR1uC\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u00044*\u001aQm!.,\u0005\r]\u0006\u0003BB]\u0007\u0007l!aa/\u000b\t\ru6qX\u0001\nk:\u001c\u0007.Z2lK\u0012T1a!1\u000e\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0007\u000b\u001cYLA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011b!3\u0001#\u0003%Ia!-\u00025\u001d,G\u000fV1cY\u0016lU\r^1ECR\fG\u0005Z3gCVdG\u000f\n\u001a\b\u000f\r5'\u0001#\u0001\u0004P\u0006\u00112)Y:tC:$'/Y#yiJ\f7\r^8s!\rI6\u0011\u001b\u0004\u0007\u0003\tA\taa5\u0014\u0007\rE7\u0002C\u0004W\u0007#$\taa6\u0015\u0005\r=\u0007\u0002CBn\u0007#$\ta!8\u0002\u0019\u001d,G/\u0012=ue\u0006\u001cGo\u001c:\u0016\t\r}7Q\u001d\u000b\r\u0007C\u001cIo!<\u0004p\u0012\u001dA\u0011\u0002\t\u00053\u0002\u0019\u0019\u000fE\u0002\u001f\u0007K$qaa:\u0004Z\n\u0007\u0011EA\u0001S\u0011!\t\u0019c!7A\u0002\r-\b\u0003\u0002\u000e\u001c\u0007GD\u0001\"a\n\u0004Z\u0002\u0007\u0011\u0011\u0006\u0005\t\u0007c\u001cI\u000e1\u0001\u0004t\u0006Aa/\u001a:tS>t7\u000fE\u0003\r\u0003W\u0019)\u0010\r\u0004\u0004x\u000emH1\u0001\t\b\r\u000e\u001d2\u0011 C\u0001!\rq21 \u0003\r\u0007{\u001cy0!A\u0001\u0002\u000b\u0005\u0011\u0011\u000e\u0002\u0005?\u0012\"t\u0007\u0003\u0005\u0004r\u000ee\u0007\u0019ABz!\rqB1\u0001\u0003\r\t\u000b\u0019y0!A\u0001\u0002\u000b\u0005\u0011\u0011\u000e\u0002\u0005?\u0012\"\u0004\b\u0003\u0005\u0002F\re\u0007\u0019AA\u0015\u0011\u0019a5\u0011\u001ca\u0001\u001b\"QAQBBi\u0005\u0004%\t!a\r\u0002\u000b\u0011\u0013u,\u0013#\t\u0011\u0011E1\u0011\u001bQ\u0001\n\u0015\fa\u0001\u0012\"`\u0013\u0012\u0003\u0003B\u0003C\u000b\u0007#\u0014\r\u0011\"\u0001\u00024\u0005\u0011B*V\"F\u001d\u0016{6i\u0014'V\u001b:{f*Q'F\u0011!!Ib!5!\u0002\u0013)\u0017a\u0005'V\u0007\u0016sUiX\"P\u0019Vkej\u0018(B\u001b\u0016\u0003\u0003B\u0003C\u000f\u0007#\u0014\r\u0011\"\u0001\u00024\u0005yB*V\"F\u001d\u0016{\u0016J\u0014#F1~\u001b6\tS#N\u0003~{\u0005\u000bV%P\u001d~s\u0015)T#\t\u0011\u0011\u00052\u0011\u001bQ\u0001\n\u0015\f\u0001\u0005T+D\u000b:+u,\u0013(E\u000bb{6k\u0011%F\u001b\u0006{v\n\u0015+J\u001f:{f*Q'FA!YAQEBi\u0011\u000b\u0007I\u0011\u0001C\u0014\u00031yW\u000f^3s!\u0006$H/\u001a:o+\t!I\u0003\u0005\u0003\u0005,\u0011]RB\u0001C\u0017\u0015\u0011!y\u0003\"\r\u0002\u000bI,w-\u001a=\u000b\u0007A#\u0019D\u0003\u0002\u00056\u0005!!.\u0019<b\u0013\u0011!I\u0004\"\f\u0003\u000fA\u000bG\u000f^3s]\"YAQHBi\u0011\u0003\u0005\u000b\u0015\u0002C\u0015\u00035yW\u000f^3s!\u0006$H/\u001a:oA!YA\u0011IBi\u0011\u000b\u0007I\u0011\u0001C\u0014\u00031IgN\\3s!\u0006$H/\u001a:o\u0011-!)e!5\t\u0002\u0003\u0006K\u0001\"\u000b\u0002\u001b%tg.\u001a:QCR$XM\u001d8!\u0001")
public class CassandraExtractor<Q extends DomainQuery>
implements StoreExtractor<CassandraQueryableSource<Q>>,
LazyLogging {
    public final Session scray$cassandra$extractors$CassandraExtractor$$session;
    public final TableIdentifier scray$cassandra$extractors$CassandraExtractor$$table;
    public final FuturePool scray$cassandra$extractors$CassandraExtractor$$futurePool;
    private final Logger logger;
    private volatile boolean bitmap$0;

    public static Pattern innerPattern() {
        return CassandraExtractor$.MODULE$.innerPattern();
    }

    public static Pattern outerPattern() {
        return CassandraExtractor$.MODULE$.outerPattern();
    }

    public static String LUCENE_INDEX_SCHEMA_OPTION_NAME() {
        return CassandraExtractor$.MODULE$.LUCENE_INDEX_SCHEMA_OPTION_NAME();
    }

    public static String LUCENE_COLUMN_NAME() {
        return CassandraExtractor$.MODULE$.LUCENE_COLUMN_NAME();
    }

    public static String DB_ID() {
        return CassandraExtractor$.MODULE$.DB_ID();
    }

    public static <R extends DomainQuery> CassandraExtractor<R> getExtractor(CassandraQueryableSource<R> cassandraQueryableSource, Option<String> option, Option<VersioningConfiguration<?, ?>> option2, Option<String> option3, FuturePool futurePool) {
        return CassandraExtractor$.MODULE$.getExtractor(cassandraQueryableSource, option, option2, option3, futurePool);
    }

    private Logger logger$lzycompute() {
        CassandraExtractor cassandraExtractor = this;
        synchronized (cassandraExtractor) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public Set<ColumnConfiguration> getColumnConfigurations(DbSession<?, ?, ?> session, String dbName, String table, QueryspaceConfiguration querySpace, Map<String, ManuallyIndexConfiguration<?, ?, ?, ?, ?>> indexes, Map<Column, Splitter<?>> splitters) {
        return StoreExtractor.class.getColumnConfigurations((StoreExtractor)this, session, (String)dbName, (String)table, (QueryspaceConfiguration)querySpace, indexes, splitters);
    }

    public TableMetadata scray$cassandra$extractors$CassandraExtractor$$getTableMetaData(String keyspace, String tablename) {
        return CassandraUtils$.MODULE$.getTableMetadata(new TableIdentifier("", this.scray$cassandra$extractors$CassandraExtractor$$table.dbId(), this.scray$cassandra$extractors$CassandraExtractor$$table.tableId()), this.scray$cassandra$extractors$CassandraExtractor$$session, CassandraUtils$.MODULE$.getTableMetadata$default$3());
    }

    private String getTableMetaData$default$1() {
        return this.scray$cassandra$extractors$CassandraExtractor$$table.dbId();
    }

    private String getTableMetaData$default$2() {
        return this.scray$cassandra$extractors$CassandraExtractor$$table.tableId();
    }

    public Set<Column> scray$cassandra$extractors$CassandraExtractor$$getColumnsPrivate(TableMetadata tm) {
        return ((TraversableOnce)((TraversableLike)package$.MODULE$.decorateAsScala().asScalaBufferConverter(tm.getColumns()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CassandraExtractor $outer;

            public final Column apply(ColumnMetadata col) {
                return new Column(col.getName(), this.$outer.scray$cassandra$extractors$CassandraExtractor$$table);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Buffer$.MODULE$.canBuildFrom())).toSet();
    }

    public Set<Column> scray$cassandra$extractors$CassandraExtractor$$getClusteringKeyColumnsPrivate(TableMetadata tm) {
        return ((TraversableOnce)((TraversableLike)package$.MODULE$.decorateAsScala().asScalaBufferConverter(tm.getClusteringColumns()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CassandraExtractor $outer;

            public final Column apply(ColumnMetadata col) {
                return new Column(col.getName(), this.$outer.scray$cassandra$extractors$CassandraExtractor$$table);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Buffer$.MODULE$.canBuildFrom())).toSet();
    }

    public Set<Column> scray$cassandra$extractors$CassandraExtractor$$getRowKeyColumnsPrivate(TableMetadata tm) {
        return ((TraversableOnce)((TraversableLike)package$.MODULE$.decorateAsScala().asScalaBufferConverter(tm.getPartitionKey()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CassandraExtractor $outer;

            public final Column apply(ColumnMetadata col) {
                return new Column(col.getName(), this.$outer.scray$cassandra$extractors$CassandraExtractor$$table);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Buffer$.MODULE$.canBuildFrom())).toSet();
    }

    public Set<Column> getColumns() {
        return this.scray$cassandra$extractors$CassandraExtractor$$getColumnsPrivate(this.scray$cassandra$extractors$CassandraExtractor$$getTableMetaData(this.getTableMetaData$default$1(), this.getTableMetaData$default$2()));
    }

    public Set<Column> getClusteringKeyColumns() {
        return this.scray$cassandra$extractors$CassandraExtractor$$getClusteringKeyColumnsPrivate(this.scray$cassandra$extractors$CassandraExtractor$$getTableMetaData(this.getTableMetaData$default$1(), this.getTableMetaData$default$2()));
    }

    public Set<Column> getRowKeyColumns() {
        return this.scray$cassandra$extractors$CassandraExtractor$$getRowKeyColumnsPrivate(this.scray$cassandra$extractors$CassandraExtractor$$getTableMetaData(this.getTableMetaData$default$1(), this.getTableMetaData$default$2()));
    }

    public Set<Column> getValueColumns() {
        return (Set)this.getColumns().$minus$minus(this.getClusteringKeyColumns()).$minus$minus(this.getRowKeyColumns());
    }

    public Function1<DomainQuery, String> getQueryMapping(CassandraQueryableSource<Q> store, Option<String> tableName) {
        return new DomainToCQLQueryMapping().getQueryMapping(store, tableName);
    }

    public String getDBSystem() {
        return this.scray$cassandra$extractors$CassandraExtractor$$table.dbSystem();
    }

    public String getDefaultDBSystem() {
        return CassandraExtractor$.MODULE$.DB_ID();
    }

    public TableIdentifier getTableIdentifier(CassandraQueryableSource<Q> store, Option<String> tableName, Option<String> dbSystem) {
        return (TableIdentifier)tableName.map((Function1)new Serializable(this, dbSystem){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CassandraExtractor $outer;
            private final Option dbSystem$1;

            public final TableIdentifier apply(String x$1) {
                return new TableIdentifier((String)this.dbSystem$1.getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$getTableIdentifier$1 $outer;

                    public final String apply() {
                        return this.$outer.scray$cassandra$extractors$CassandraExtractor$$anonfun$$$outer().getDefaultDBSystem();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }), this.$outer.scray$cassandra$extractors$CassandraExtractor$$table.dbId(), x$1);
            }

            public /* synthetic */ CassandraExtractor scray$cassandra$extractors$CassandraExtractor$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.dbSystem$1 = dbSystem$1;
            }
        }).getOrElse((Function0)new Serializable(this, dbSystem){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CassandraExtractor $outer;
            private final Option dbSystem$1;

            public final TableIdentifier apply() {
                return new TableIdentifier((String)this.dbSystem$1.getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$getTableIdentifier$2 $outer;

                    public final String apply() {
                        return this.$outer.scray$cassandra$extractors$CassandraExtractor$$anonfun$$$outer().getDefaultDBSystem();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }), this.$outer.scray$cassandra$extractors$CassandraExtractor$$table.dbId(), this.$outer.scray$cassandra$extractors$CassandraExtractor$$table.tableId());
            }

            public /* synthetic */ CassandraExtractor scray$cassandra$extractors$CassandraExtractor$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.dbSystem$1 = dbSystem$1;
            }
        });
    }

    public KeyspaceMetadata getMetadata() {
        return CassandraUtils$.MODULE$.getKeyspaceMetadata(this.scray$cassandra$extractors$CassandraExtractor$$session, this.scray$cassandra$extractors$CassandraExtractor$$table.dbId());
    }

    private Option<AutoIndexConfiguration<?>> getColumnCassandraLuceneIndexed(Option<TableMetadata> tmOpt, Column column, Map<Column, Splitter<?>> splitters) {
        Option cmOpt = tmOpt.flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Option<ColumnMetadata> apply(TableMetadata tm) {
                return Option$.MODULE$.apply((Object)tm.getColumn(Metadata.quote((String)CassandraExtractor$.MODULE$.LUCENE_COLUMN_NAME())));
            }
        });
        Option schemaOpt = cmOpt.flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Option<String> apply(ColumnMetadata cm) {
                return Option$.MODULE$.apply((Object)cm.getIndex()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(ColumnMetadata.IndexMetadata x$2) {
                        return x$2.getOption(CassandraExtractor$.MODULE$.LUCENE_INDEX_SCHEMA_OPTION_NAME());
                    }
                });
            }
        });
        return schemaOpt.flatMap((Function1)new Serializable(this, tmOpt, column, splitters, cmOpt){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CassandraExtractor $outer;
            private final Option tmOpt$1;
            public final Column column$1;
            private final Map splitters$1;
            private final Option cmOpt$1;

            public final Option<AutoIndexConfiguration<?>> apply(String schema) {
                None$ none$;
                Matcher outerMatcher;
                if (this.$outer.logger().underlying().isTraceEnabled()) {
                    this.$outer.logger().underlying().trace(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Lucene index schema is: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{schema})));
                }
                if ((outerMatcher = CassandraExtractor$.MODULE$.outerPattern().matcher(schema)).matches()) {
                    String fieldString = outerMatcher.group(1);
                    if (Predef$.MODULE$.refArrayOps((Object[])CassandraExtractor$.MODULE$.innerPattern().split(fieldString, -1)).find((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$getColumnCassandraLuceneIndexed$1 $outer;

                        public final boolean apply(String x$3) {
                            String string = x$3.trim();
                            String string2 = this.$outer.column$1.columnName();
                            return !(string != null ? !string.equals(string2) : string2 != null);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    }).isDefined()) {
                        ((ColumnMetadata)this.cmOpt$1.get()).getType();
                        if (this.splitters$1.get((Object)this.column$1).isDefined()) {
                            if (this.$outer.logger().underlying().isDebugEnabled()) {
                                this.$outer.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found Lucene-indexed column ", " for table ", " with splitting option"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.column$1.columnName(), ((TableMetadata)this.tmOpt$1.get()).getName()})));
                            }
                        } else if (this.$outer.logger().underlying().isDebugEnabled()) {
                            this.$outer.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found Lucene-indexed column ", " for table ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.column$1.columnName(), ((TableMetadata)this.tmOpt$1.get()).getName()})));
                        }
                        none$ = new Some((Object)new AutoIndexConfiguration(true, true, true, this.splitters$1.get((Object)this.column$1).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Function2<Tuple2<Object, Object>, Object, Iterator<Tuple2<Object, Object>>> apply(Splitter<?> x$4) {
                                return x$4.splitter();
                            }
                        })));
                    } else {
                        none$ = None$.MODULE$;
                    }
                } else {
                    none$ = None$.MODULE$;
                }
                return none$;
            }
            {
                void var5_5;
                void var4_4;
                void var3_3;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.tmOpt$1 = tmOpt$1;
                this.column$1 = var3_3;
                this.splitters$1 = var4_4;
                this.cmOpt$1 = var5_5;
            }
        });
    }

    public Tuple2<Object, Option<AutoIndexConfiguration<?>>> checkColumnCassandraAutoIndexed(DbSession<?, ?, ?> session, String keyspace, String tableName, Column column, Map<Column, Splitter<?>> splitters) {
        None$ none$;
        DbSession<?, ?, ?> dbSession = session;
        if (dbSession instanceof CassandraDbSession) {
            CassandraDbSession cassandraDbSession = (CassandraDbSession)dbSession;
            none$ = Option$.MODULE$.apply((Object)CassandraUtils$.MODULE$.getKeyspaceMetadata(cassandraDbSession.cassandraSession(), keyspace));
        } else {
            none$ = None$.MODULE$;
        }
        None$ metadata = none$;
        Option tm = metadata.flatMap((Function1)new Serializable(this, tableName){
            public static final long serialVersionUID = 0L;
            private final String tableName$1;

            public final Option<TableMetadata> apply(KeyspaceMetadata ksmeta) {
                return Option$.MODULE$.apply((Object)CassandraUtils$.MODULE$.getTableMetadata(this.tableName$1, ksmeta));
            }
            {
                this.tableName$1 = tableName$1;
            }
        });
        boolean autoIndex = metadata.flatMap((Function1)new Serializable(this, column, tm){
            public static final long serialVersionUID = 0L;
            public final Column column$2;
            private final Option tm$1;

            public final Option<ColumnMetadata.IndexMetadata> apply(KeyspaceMetadata x$5) {
                Option cm = this.tm$1.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$6 $outer;

                    public final ColumnMetadata apply(TableMetadata x$6) {
                        return x$6.getColumn(Metadata.quote((String)this.$outer.column$2.columnName()));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                return cm.flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Option<ColumnMetadata.IndexMetadata> apply(ColumnMetadata colmeta) {
                        return Option$.MODULE$.apply((Object)colmeta.getIndex());
                    }
                });
            }
            {
                void var3_3;
                this.column$2 = column$2;
                this.tm$1 = var3_3;
            }
        }).isDefined();
        Option<AutoIndexConfiguration<?>> autoIndexConfig = this.getColumnCassandraLuceneIndexed((Option<TableMetadata>)tm, column, splitters);
        return autoIndexConfig.isDefined() ? new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), autoIndexConfig) : new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)autoIndex), (Object)None$.MODULE$);
    }

    public ColumnConfiguration getColumnConfiguration(DbSession<?, ?, ?> session, String dbName, String table, Column column, Option<ManuallyIndexConfiguration<?, ?, ?, ?, ?>> index, Map<Column, Splitter<?>> splitters) {
        Option<ManuallyIndexConfiguration<?, ?, ?, ?, ?>> option;
        block4: {
            None$ none$;
            block3: {
                block2: {
                    option = index;
                    None$ none$2 = None$.MODULE$;
                    Option<ManuallyIndexConfiguration<?, ?, ?, ?, ?>> option2 = option;
                    if (none$2 != null ? !none$2.equals(option2) : option2 != null) break block2;
                    Tuple2<Object, Option<AutoIndexConfiguration<?>>> autoIndex = this.checkColumnCassandraAutoIndexed(session, dbName, table, column, splitters);
                    none$ = autoIndex._1$mcZ$sp() ? new Some((Object)new IndexConfiguration(true, (Option)None$.MODULE$, BoxesRunTime.unboxToBoolean((Object)((Option)autoIndex._2()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(AutoIndexConfiguration<?> x$7) {
                            return x$7.isRangeIndex();
                        }
                    }).getOrElse((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply() {
                            return this.apply$mcZ$sp();
                        }

                        public boolean apply$mcZ$sp() {
                            return false;
                        }
                    })), false, BoxesRunTime.unboxToBoolean((Object)((Option)autoIndex._2()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(AutoIndexConfiguration<?> x$8) {
                            return x$8.isRangeIndex();
                        }
                    }).getOrElse((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply() {
                            return this.apply$mcZ$sp();
                        }

                        public boolean apply$mcZ$sp() {
                            return false;
                        }
                    })), (Option)autoIndex._2())) : None$.MODULE$;
                    break block3;
                }
                if (!(option instanceof Some)) break block4;
                Some some = (Some)option;
                ManuallyIndexConfiguration idx = (ManuallyIndexConfiguration)some.x();
                none$ = new Some((Object)new IndexConfiguration(true, (Option)new Some((Object)idx), true, true, true, (Option)None$.MODULE$));
            }
            None$ indexConfig = none$;
            return new ColumnConfiguration(column, (Option)indexConfig);
        }
        throw new MatchError(option);
    }

    public Option<ManuallyIndexConfiguration<?, ?, ?, ?, ?>> createManualIndexConfiguration(Column column, String queryspaceName, int version, CassandraQueryableSource<Q> store, Map<? extends Tuple2<QueryableStoreSource<? extends DomainQuery>, String>, Tuple5<QueryableStoreSource<? extends DomainQuery>, String, IndexConfig, Option<Function1<?, ?>>, Set<String>>> indexes, Map<? extends QueryableStoreSource<?>, Tuple3<Function1<?, Row>, Option<String>, Option<VersioningConfiguration<?, ?>>>> mappers) {
        return this.internalManualIndexConfig$1(indexes, column, queryspaceName, version, store, mappers);
    }

    public <Q extends DomainQuery, K extends DomainQuery, V> TableConfiguration<Q, K, V> scray$cassandra$extractors$CassandraExtractor$$getTableConfigurationFunction(TableIdentifier ti, String space, int version) {
        return (TableConfiguration)Registry$.MODULE$.getQuerySpaceTable(space, version, ti).get();
    }

    private <Q extends DomainQuery, K extends DomainQuery> Option<VersioningConfiguration<Q, K>> getVersioningConfiguration(String jobName, Function1<?, Row> rowMapper) {
        CassandraDbSession cassSession = new CassandraDbSession(this.scray$cassandra$extractors$CassandraExtractor$$session);
        OnlineBatchSyncCassandra syncApiInstance = new OnlineBatchSyncCassandra(cassSession);
        CassandraJobInfo jobInfo = new CassandraJobInfo(jobName, CassandraJobInfo$.MODULE$.$lessinit$greater$default$2(), CassandraJobInfo$.MODULE$.$lessinit$greater$default$3(), CassandraJobInfo$.MODULE$.$lessinit$greater$default$4(), CassandraJobInfo$.MODULE$.$lessinit$greater$default$5());
        Serializable latestComplete = new Serializable(this, syncApiInstance, jobInfo){
            public static final long serialVersionUID = 0L;
            private final OnlineBatchSyncCassandra syncApiInstance$1;
            private final CassandraJobInfo jobInfo$1;

            public final Option<TableIdentifier> apply() {
                return this.syncApiInstance$1.getBatchVersion(this.jobInfo$1);
            }
            {
                void var3_3;
                this.syncApiInstance$1 = syncApiInstance$1;
                this.jobInfo$1 = var3_3;
            }
        };
        Serializable runtimeVersion = new Serializable(this, syncApiInstance, jobInfo){
            public static final long serialVersionUID = 0L;
            private final OnlineBatchSyncCassandra syncApiInstance$1;
            private final CassandraJobInfo jobInfo$1;

            public final Option<TableIdentifier> apply() {
                return this.syncApiInstance$1.getOnlineVersion(this.jobInfo$1);
            }
            {
                void var3_3;
                this.syncApiInstance$1 = syncApiInstance$1;
                this.jobInfo$1 = var3_3;
            }
        };
        Option tableToReadOpt = ((Option)runtimeVersion.apply()).orElse((Function0)new Serializable(this, (Function0)latestComplete){
            public static final long serialVersionUID = 0L;
            private final Function0 latestComplete$1;

            public final Option<TableIdentifier> apply() {
                return ((Option)this.latestComplete$1.apply()).orElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final None$ apply() {
                        return None$.MODULE$;
                    }
                });
            }
            {
                this.latestComplete$1 = latestComplete$1;
            }
        });
        return tableToReadOpt.map((Function1)new Serializable(this, rowMapper, cassSession, (Function0)latestComplete, (Function0)runtimeVersion){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CassandraExtractor $outer;
            private final Function1 rowMapper$1;
            public final CassandraDbSession cassSession$1;
            private final Function0 latestComplete$1;
            private final Function0 runtimeVersion$1;

            public final VersioningConfiguration<Q, K> apply(TableIdentifier tableToRead) {
                TableMetadata tableMeta = this.$outer.scray$cassandra$extractors$CassandraExtractor$$getTableMetaData(tableToRead.dbId(), tableToRead.tableId());
                Set<Column> allColumns = this.$outer.scray$cassandra$extractors$CassandraExtractor$$getColumnsPrivate(tableMeta);
                CassandraQueryableSource<Q> cassQuerySource = new CassandraQueryableSource<Q>(tableToRead, this.$outer.scray$cassandra$extractors$CassandraExtractor$$getRowKeyColumnsPrivate(tableMeta), this.$outer.scray$cassandra$extractors$CassandraExtractor$$getClusteringKeyColumnsPrivate(tableMeta), allColumns, (Set<ColumnConfiguration>)((Set)allColumns.map((Function1)new Serializable(this, tableToRead){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$getVersioningConfiguration$1 $outer;
                    private final TableIdentifier tableToRead$1;

                    public final ColumnConfiguration apply(Column col) {
                        return this.$outer.scray$cassandra$extractors$CassandraExtractor$$anonfun$$$outer().getColumnConfiguration(this.$outer.cassSession$1, this.tableToRead$1.dbId(), this.tableToRead$1.tableId(), new Column(col.columnName(), this.tableToRead$1), (Option<ManuallyIndexConfiguration<?, ?, ?, ?, ?>>)None$.MODULE$, (Map<Column, Splitter<?>>)((Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.tableToRead$1 = tableToRead$1;
                    }
                }, Set$.MODULE$.canBuildFrom())), this.$outer.scray$cassandra$extractors$CassandraExtractor$$session, new DomainToCQLQueryMapping<Q, S>(), this.$outer.scray$cassandra$extractors$CassandraExtractor$$futurePool, (Function1<com.datastax.driver.core.Row, Row>)this.rowMapper$1);
                return new VersioningConfiguration(this.latestComplete$1, this.runtimeVersion$1, (Option)new Some(cassQuerySource), (Option)new Some(cassQuerySource));
            }

            public /* synthetic */ CassandraExtractor scray$cassandra$extractors$CassandraExtractor$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                void var5_5;
                void var4_4;
                void var3_3;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.rowMapper$1 = rowMapper$1;
                this.cassSession$1 = var3_3;
                this.latestComplete$1 = var4_4;
                this.runtimeVersion$1 = var5_5;
            }
        });
    }

    public TableConfiguration<? extends DomainQuery, ? extends DomainQuery, ?> getTableConfiguration(Function1<?, Row> rowMapper) {
        None$ none$;
        Set<Column> allColumns = this.getColumns();
        Set<Column> rowKeys = this.getRowKeyColumns();
        Set<Column> clusterKeys = this.getClusteringKeyColumns();
        Option versioningConfig = this.getVersioningConfiguration(this.scray$cassandra$extractors$CassandraExtractor$$table.tableId(), rowMapper);
        if (versioningConfig.isDefined()) {
            none$ = None$.MODULE$;
        } else {
            CassandraDbSession cassSession = new CassandraDbSession(this.scray$cassandra$extractors$CassandraExtractor$$session);
            none$ = new Some(new CassandraQueryableSource(this.scray$cassandra$extractors$CassandraExtractor$$table, rowKeys, clusterKeys, allColumns, (Set<ColumnConfiguration>)((Set)allColumns.map((Function1)new Serializable(this, cassSession){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ CassandraExtractor $outer;
                private final CassandraDbSession cassSession$2;

                public final ColumnConfiguration apply(Column col) {
                    return this.$outer.getColumnConfiguration(this.cassSession$2, this.$outer.scray$cassandra$extractors$CassandraExtractor$$table.dbId(), this.$outer.scray$cassandra$extractors$CassandraExtractor$$table.tableId(), new Column(col.columnName(), this.$outer.scray$cassandra$extractors$CassandraExtractor$$table), (Option<ManuallyIndexConfiguration<?, ?, ?, ?, ?>>)None$.MODULE$, (Map<Column, Splitter<?>>)((Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.cassSession$2 = cassSession$2;
                }
            }, Set$.MODULE$.canBuildFrom())), this.scray$cassandra$extractors$CassandraExtractor$$session, new DomainToCQLQueryMapping(), this.scray$cassandra$extractors$CassandraExtractor$$futurePool, rowMapper));
        }
        None$ cassQuerySource = none$;
        return new TableConfiguration(this.scray$cassandra$extractors$CassandraExtractor$$table, versioningConfig, rowKeys, clusterKeys, allColumns, rowMapper, (Function1)cassQuerySource.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Function1<DomainQuery, Q> apply(CassandraQueryableSource<Q> x$11) {
                return x$11.mappingFunction();
            }
        }).getOrElse((Function0)new Serializable(this, versioningConfig){
            public static final long serialVersionUID = 0L;
            private final Option versioningConfig$1;

            public final Function1<DomainQuery, Q> apply() {
                return (Function1)this.versioningConfig$1.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Function1<DomainQuery, String> apply(VersioningConfiguration<Q, Q> x$12) {
                        return ((CassandraQueryableSource)((Object)x$12.queryableStore().get())).mappingFunction();
                    }
                }).orNull(Predef$.MODULE$.conforms());
            }
            {
                this.versioningConfig$1 = versioningConfig$1;
            }
        }), (Option)cassQuerySource, (Option)cassQuerySource, (List)Nil$.MODULE$);
    }

    public final Tuple2 scray$cassandra$extractors$CassandraExtractor$$internalStores$1(Map intmappers, CassandraQueryableSource indexStore, CassandraQueryableSource store$2) {
        return new Tuple2(intmappers.get((Object)indexStore).get(), intmappers.get((Object)store$2).get());
    }

    private final Option internalManualIndexConfig$1(Map indexes2, Column column$3, String queryspaceName$1, int version$1, CassandraQueryableSource store$2, Map mappers$1) {
        return indexes2.get((Object)new Tuple2((Object)store$2, (Object)column$3.columnName())).map((Function1)new Serializable(this, column$3, queryspaceName$1, version$1, store$2, mappers$1){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CassandraExtractor $outer;
            private final Column column$3;
            public final String queryspaceName$1;
            public final int version$1;
            private final CassandraQueryableSource store$2;
            private final Map mappers$1;

            public final ManuallyIndexConfiguration<DomainQuery, DomainQuery, Object, Object, DomainQuery> apply(F index) {
                QueryableStoreSource queryableStoreSource = (QueryableStoreSource)index._1();
                if (queryableStoreSource instanceof CassandraQueryableSource) {
                    CassandraQueryableSource cassandraQueryableSource = (CassandraQueryableSource)queryableStoreSource;
                    Tuple2 tuple2 = this.$outer.scray$cassandra$extractors$CassandraExtractor$$internalStores$1(this.mappers$1, cassandraQueryableSource, this.store$2);
                    if (tuple2 != null) {
                        Tuple2 tuple22;
                        Tuple3 indexstoreinfo = (Tuple3)tuple2._1();
                        Tuple3 storeinfo = (Tuple3)tuple2._2();
                        Tuple2 tuple23 = tuple22 = new Tuple2((Object)indexstoreinfo, (Object)storeinfo);
                        Tuple3 indexstoreinfo2 = (Tuple3)tuple23._1();
                        Tuple3 storeinfo2 = (Tuple3)tuple23._2();
                        Some dbSystem = new Some((Object)this.column$3.table().dbSystem());
                        CassandraExtractor<R> indexExtractor = CassandraExtractor$.MODULE$.getExtractor(cassandraQueryableSource, (Option<String>)((Option)indexstoreinfo2._2()), (Option)indexstoreinfo2._3(), (Option<String>)dbSystem, this.$outer.scray$cassandra$extractors$CassandraExtractor$$futurePool);
                        TableIdentifier mainDataTableTI = this.$outer.getTableIdentifier(this.store$2, (Option<String>)None$.MODULE$, (Option<String>)dbSystem);
                        ManuallyIndexConfiguration manuallyIndexConfiguration = new ManuallyIndexConfiguration((Function0)new Serializable(this, mainDataTableTI){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$internalManualIndexConfig$1$1 $outer;
                            private final TableIdentifier mainDataTableTI$1;

                            public final TableConfiguration<DomainQuery, DomainQuery, Object> apply() {
                                return this.$outer.scray$cassandra$extractors$CassandraExtractor$$anonfun$$$outer().scray$cassandra$extractors$CassandraExtractor$$getTableConfigurationFunction(this.mainDataTableTI$1, this.$outer.queryspaceName$1, this.$outer.version$1);
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.mainDataTableTI$1 = mainDataTableTI$1;
                            }
                        }, (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$internalManualIndexConfig$1$1 $outer;
                            private final Tuple3 indexstoreinfo$1;
                            private final Some dbSystem$2;
                            private final CassandraExtractor indexExtractor$1;
                            private final CassandraQueryableSource x2$1;

                            public final TableConfiguration<DomainQuery, DomainQuery, Object> apply() {
                                return this.$outer.scray$cassandra$extractors$CassandraExtractor$$anonfun$$$outer().scray$cassandra$extractors$CassandraExtractor$$getTableConfigurationFunction(this.$outer.scray$cassandra$extractors$CassandraExtractor$$anonfun$$convertedSource$1(this.indexExtractor$1, this.indexstoreinfo$1, this.dbSystem$2, this.x2$1), this.$outer.queryspaceName$1, this.$outer.version$1);
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.indexstoreinfo$1 = indexstoreinfo$1;
                                this.dbSystem$2 = dbSystem$2;
                                this.indexExtractor$1 = indexExtractor$1;
                                this.x2$1 = x2$1;
                            }
                        }, (Option)index._4(), (Set)((SetLike)index._5()).map((Function1)new Serializable(this, mainDataTableTI){
                            public static final long serialVersionUID = 0L;
                            private final TableIdentifier mainDataTableTI$1;

                            public final Column apply(String x$10) {
                                return new Column(x$10, this.mainDataTableTI$1);
                            }
                            {
                                this.mainDataTableTI$1 = mainDataTableTI$1;
                            }
                        }, Set$.MODULE$.canBuildFrom()), (IndexConfig)index._3());
                        return manuallyIndexConfiguration;
                    }
                    throw new MatchError((Object)tuple2);
                }
                throw new RuntimeException("Using stores different from CassandraQueryableSource not supported");
            }

            public /* synthetic */ CassandraExtractor scray$cassandra$extractors$CassandraExtractor$$anonfun$$$outer() {
                return this.$outer;
            }

            public final TableIdentifier scray$cassandra$extractors$CassandraExtractor$$anonfun$$convertedSource$1(CassandraExtractor extractor, Tuple3 indexstoreinfo$1, Some dbSystem$2, CassandraQueryableSource x2$1) {
                return extractor.getTableIdentifier(x2$1, (Option<String>)((Option)indexstoreinfo$1._2()), (Option<String>)dbSystem$2);
            }
            {
                void var6_6;
                void var5_5;
                void var3_3;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.column$3 = column$3;
                this.queryspaceName$1 = var3_3;
                this.version$1 = version$1;
                this.store$2 = var5_5;
                this.mappers$1 = var6_6;
            }
        });
    }

    public CassandraExtractor(Session session, TableIdentifier table, FuturePool futurePool) {
        this.scray$cassandra$extractors$CassandraExtractor$$session = session;
        this.scray$cassandra$extractors$CassandraExtractor$$table = table;
        this.scray$cassandra$extractors$CassandraExtractor$$futurePool = futurePool;
        StoreExtractor.class.$init$((StoreExtractor)this);
        LazyLogging.class.$init$((LazyLogging)this);
    }
}

