/*
 * Decompiled with CFR 0.152.
 */
package scalus.uplc.eval;

import java.io.Serializable;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.immutable.List;
import scala.math.BigInt;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ModuleSerializationProxy;
import scalus.builtin.ByteString;
import scalus.builtin.Data;
import scalus.builtin.Data$B$;
import scalus.builtin.Data$Constr$;
import scalus.builtin.Data$I$;
import scalus.builtin.Data$List$;
import scalus.builtin.Data$Map$;
import scalus.uplc.Constant;
import scalus.uplc.Constant$ByteString$;
import scalus.uplc.Constant$Data$;
import scalus.uplc.Constant$Integer$;
import scalus.uplc.Constant$List$;
import scalus.uplc.Constant$Pair$;
import scalus.uplc.Constant$String$;
import scalus.uplc.Constant$Unit$;
import scalus.uplc.DefaultUni;
import scalus.uplc.eval.CekValue;
import scalus.uplc.eval.CekValue$VCon$;

public final class MemoryUsage$
implements Serializable {
    public static final MemoryUsage$ MODULE$ = new MemoryUsage$();

    private MemoryUsage$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(MemoryUsage$.class);
    }

    /*
     * WARNING - void declaration
     */
    public long integerLog2(BigInt i) {
        byte[] byArray;
        if (BoxesRunTime.equals((Object)i, (Object)BoxesRunTime.boxToInteger((int)0))) {
            return 0L;
        }
        byte[] bytes = i.toByteArray();
        Object object = Predef$.MODULE$.byteArrayOps(bytes);
        if (BoxesRunTime.unboxToByte((Object)ArrayOps$.MODULE$.head$extension(object)) == 0) {
            Object object2 = Predef$.MODULE$.byteArrayOps(bytes);
            byArray = (byte[])ArrayOps$.MODULE$.tail$extension(object2);
        } else {
            void var3_2;
            byArray = var3_2;
        }
        void bytes2 = byArray;
        Object object3 = Predef$.MODULE$.byteArrayOps((byte[])bytes2);
        Option option = ArrayOps$.MODULE$.headOption$extension(object3);
        if (None$.MODULE$.equals(option)) {
            throw new IllegalStateException("empty number?");
        }
        if (option instanceof Some) {
            byte u = BoxesRunTime.unboxToByte((Object)((Some)option).value());
            int unsigned = Byte.toUnsignedInt(u);
            int log2 = 31 - Integer.numberOfLeadingZeros(unsigned);
            long r = (long)log2 + (long)(8 * (((void)bytes2).length - 1));
            return r;
        }
        throw new MatchError((Object)option);
    }

    public long memoryUsageInteger(BigInt i) {
        if (BoxesRunTime.equals((Object)i, (Object)BoxesRunTime.boxToInteger((int)0))) {
            return 1L;
        }
        int ceilLog2 = i.abs().bitLength() - 1;
        return Int$.MODULE$.int2long(ceilLog2 / 64 + 1);
    }

    public long memoryUsageInteger2(BigInt i) {
        if (BoxesRunTime.equals((Object)i, (Object)BoxesRunTime.boxToInteger((int)0))) {
            return 1L;
        }
        return this.integerLog2(i.abs()) / 64L + 1L;
    }

    public long memoryUsageByteString(ByteString bs) {
        return Int$.MODULE$.int2long((bs.length() - 1) / 8 + 1);
    }

    public long memoryUsageString(String s) {
        return Int$.MODULE$.int2long(s.length());
    }

    public long memoryUsageData(Data d) {
        long l;
        long nodeMem = 4L;
        Data data = d;
        if (data instanceof Data.I) {
            BigInt bigInt;
            Data.I i = Data$I$.MODULE$.unapply((Data.I)data);
            BigInt i2 = bigInt = i._1();
            l = this.memoryUsageInteger(i2);
        } else if (data instanceof Data.B) {
            ByteString byteString;
            Data.B b = Data$B$.MODULE$.unapply((Data.B)data);
            ByteString bs = byteString = b._1();
            l = this.memoryUsageByteString(bs);
        } else if (data instanceof Data.Constr) {
            List<Data> list;
            Data.Constr constr = Data$Constr$.MODULE$.unapply((Data.Constr)data);
            long l2 = constr._1();
            List<Data> l3 = list = constr._2();
            l = this.sumList(l3);
        } else if (data instanceof Data.Map) {
            List<Tuple2<Data, Data>> list;
            Data.Map map = Data$Map$.MODULE$.unapply((Data.Map)data);
            List<Tuple2<Data, Data>> l4 = list = map._1();
            long acc = 0L;
            for (Tuple2 t : l4) {
                acc += this.memoryUsageData((Data)t._1()) + this.memoryUsageData((Data)t._2());
            }
            l = acc;
        } else if (data instanceof Data.List) {
            List<Data> list;
            Data.List list2 = Data$List$.MODULE$.unapply((Data.List)data);
            List<Data> l5 = list = list2._1();
            l = this.sumList(l5);
        } else {
            throw new MatchError((Object)data);
        }
        long usage = l;
        return nodeMem + usage;
    }

    private long sumList(List<Data> l) {
        LongRef acc = LongRef.create((long)0L);
        l.foreach((Function1 & Serializable)d -> {
            this.sumList$$anonfun$1(acc, (Data)d);
            return BoxedUnit.UNIT;
        });
        return acc.elem;
    }

    public long memoryUsage(CekValue a) {
        CekValue cekValue = a;
        if (cekValue instanceof CekValue.VCon) {
            Constant constant;
            CekValue.VCon vCon = CekValue$VCon$.MODULE$.unapply((CekValue.VCon)cekValue);
            Constant constant2 = constant = vCon._1();
            return this.memoryUsage(constant2);
        }
        return 1L;
    }

    public long memoryUsage(Constant a) {
        Constant constant = a;
        if (constant instanceof Constant.Integer) {
            BigInt bigInt;
            Constant.Integer integer = Constant$Integer$.MODULE$.unapply((Constant.Integer)constant);
            BigInt i = bigInt = integer._1();
            return this.memoryUsageInteger(i);
        }
        if (constant instanceof Constant.ByteString) {
            ByteString byteString;
            Constant.ByteString byteString2 = Constant$ByteString$.MODULE$.unapply((Constant.ByteString)constant);
            ByteString bs = byteString = byteString2._1();
            return this.memoryUsageByteString(bs);
        }
        if (constant instanceof Constant.String) {
            String string;
            Constant.String string2 = Constant$String$.MODULE$.unapply((Constant.String)constant);
            String s = string = string2._1();
            return this.memoryUsageString(s);
        }
        if (Constant$Unit$.MODULE$.equals(constant)) {
            return 1L;
        }
        if (constant instanceof Constant.Bool) {
            return 1L;
        }
        if (constant instanceof Constant.Data) {
            Data data;
            Constant.Data data2 = Constant$Data$.MODULE$.unapply((Constant.Data)constant);
            Data d2 = data = data2._1();
            return this.memoryUsageData(d2);
        }
        if (constant instanceof Constant.List) {
            Constant.List list = Constant$List$.MODULE$.unapply((Constant.List)constant);
            DefaultUni defaultUni = list._1();
            List<Constant> list2 = list._2();
            DefaultUni tpe = defaultUni;
            List<Constant> l = list2;
            LongRef acc = LongRef.create((long)0L);
            l.foreach((Function1 & Serializable)d -> {
                this.memoryUsage$$anonfun$1(acc, (Constant)d);
                return BoxedUnit.UNIT;
            });
            return acc.elem;
        }
        if (constant instanceof Constant.Pair) {
            Constant.Pair pair = Constant$Pair$.MODULE$.unapply((Constant.Pair)constant);
            Constant constant2 = pair._1();
            Constant constant3 = pair._2();
            Constant a2 = constant2;
            Constant b = constant3;
            return 1L + this.memoryUsage(a2) + this.memoryUsage(b);
        }
        throw new MatchError((Object)constant);
    }

    private final /* synthetic */ void sumList$$anonfun$1(LongRef acc$1, Data d) {
        long l;
        acc$1.elem = l = acc$1.elem + this.memoryUsageData(d);
    }

    private final /* synthetic */ void memoryUsage$$anonfun$1(LongRef acc$2, Constant d) {
        long l;
        acc$2.elem = l = acc$2.elem + this.memoryUsage(d);
    }
}

